package juuluuApp.daoUitl.count.hibernate;

import java.awt.Color;
import java.awt.Font;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import juuluuApp.daoUitl.count.CountTimeUtil;

import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartFrame;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.servlet.ServletUtilities;
import org.jfree.chart.title.LegendTitle;
import org.jfree.chart.title.TextTitle;

import org.jfree.data.time.Day;
import org.jfree.data.time.Hour;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.ui.RectangleInsets;

public class MonthDaysTimeLineReportUtil {
	
	
	
    public JFreeChart dayLineCharCreate(String charTitle,String xTitle,String yTitle,List<TimeLineBean> lineBeanList) {  
        // TODO Auto-generated method stub  
    	 TimeSeriesCollection timeseriescollection = new TimeSeriesCollection();
    	 
    	 for(int j=0;j<lineBeanList.size();j++){
    		 TimeLineBean tb= lineBeanList.get(j);
    		 List<TimeLineValueBean> valueList=tb.getValueList();
    		 TimeSeries timeseries = new TimeSeries(tb.getLineTile(),Day.class);
    		 //时间序列图  
    	    	for(int i=0;i<valueList.size();i++){
    	    		TimeLineValueBean lineValueBean=valueList.get(i);
    	                	            
    	         //   Day d=new Day();
    	          //  CountTimeUtil ct=  CountTimeUtil.getInstance();
    	       //  java.util.Vector<java.util.Date> dayList=  ct.getUpDayList_currentDay2(30);
    	         
    	         	//for(int k=0;k<dayList.size();k++){
    	         		java.util.Date dayTime=lineValueBean.getDate();
    	         		Double value=lineValueBean.getValue();
    	         		System.out.println("set time line value Day:"+dayTime.getDate()+" v:"+value);
    	         			String vtype=lineValueBean.getValueViewType();
    	         				if(vtype!=null&&vtype.equals(lineValueBean.ValueViewType_double)){
    	         					timeseries.add(new Day(dayTime), value);
    	         				}else if(vtype!=null&&vtype.equals(lineValueBean.ValueViewType_long)){
    	         					timeseries.add(new Day(dayTime), value.longValue());
    	         				
    	         					
    	         				}else if(vtype!=null&&vtype.equals(lineValueBean.ValueViewType_int)){
    	         					timeseries.add(new Day(dayTime), value.intValue());
    	         				
    	         					
    	         				}
    	         	
    	         	//}
    	         	
    	          
    	    	}//end for
    	    	  timeseriescollection.addSeries(timeseries);  
    	 }
       
   

            
       
        
           // timeseriescollection.addSeries(timeseries1);  
            timeseriescollection.setDomainIsPointsInTime(true); //domain轴上的刻度点代表的是时间点而不是时间段  
           JFreeChart jfreechart = ChartFactory
        		   .createTimeSeriesChart(charTitle,  
        				   xTitle,  
        				   yTitle,  
                  timeseriescollection,  
                  true,  
                  true,  
                  false);  
                  jfreechart.setBackgroundPaint(Color.white);  
                  TextTitle textTitle = jfreechart.getTitle();  
                textTitle.setFont(new Font("宋体", Font.BOLD, 20));  
                LegendTitle legend = jfreechart.getLegend();  
                if (legend != null) {  
                    legend.setItemFont(new Font("宋体", Font.BOLD, 20));  
                }  
                  XYPlot xyplot = (XYPlot)jfreechart.getPlot(); //获得 plot : XYPlot!!  
                  ValueAxis domainAxis=xyplot.getDomainAxis();  
                  domainAxis.setTickLabelFont(new Font("宋体",Font.BOLD,20));//设置x轴坐标上的字体  
                  domainAxis.setLabelFont(new Font("宋体",Font.BOLD,20));//设置x轴坐标上的标题的字体  
                  ValueAxis rangeAxis=xyplot.getRangeAxis();  
                  rangeAxis.setTickLabelFont(new Font("宋体",Font.BOLD,20));//设置y轴坐标上的字体  
                  rangeAxis.setLabelFont(new Font("宋体",Font.BOLD,20));//设置y轴坐标上的标题的字体  
                  xyplot.setBackgroundPaint(Color.lightGray);  
                  xyplot.setDomainGridlinePaint(Color.white);  
                  xyplot.setRangeGridlinePaint(Color.white);  
                  xyplot.setAxisOffset(new RectangleInsets(5D, 5D, 5D, 5D));  
                  xyplot.setDomainCrosshairVisible(true);  
                  xyplot.setRangeCrosshairVisible(true);  
                 // ChartFrame  frame=new ChartFrame ("折线图 ",jfreechart,true);  
                //  frame.pack();  
                //  frame.setVisible(true);  
                  
                  return jfreechart;
    }  
    
    public void showByJFrame(JFreeChart jfreechart){
    	ChartFrame  frame=new ChartFrame ("折线图 ",jfreechart,true);  
       frame.pack();  
       frame.setVisible(true);  
    }
    
    public void saveToLocalJPG(JFreeChart jfreechart){
   	 // ChartFrame  frame=new ChartFrame ("折线图 ",jfreechart,true);  
       //  frame.pack();  
       //  frame.setVisible(true);  
   }
    
    public String saveToWebSessionlJPG(int width,int height,JFreeChart jfreechart,HttpServletRequest request) throws IOException{
      	 // ChartFrame  frame=new ChartFrame ("折线图 ",jfreechart,true);  
    	request.getSession();
    	  String filename = ServletUtilities.saveChartAsPNG(jfreechart, width, height, null, request.getSession());  
    	  return filename;
          //  frame.pack();  
          //  frame.setVisible(true);  
      }
    
    public static void main(String argvs[]){
    	MonthDaysTimeLineReportUtil ru=new MonthDaysTimeLineReportUtil();
    	String charTitle="TimeLine Chart";String xTitle="X";String yTitle="Y";
    	List<TimeLineBean> lineBeanList=new ArrayList<TimeLineBean>();
    	
    	
    	TimeLineBean lb1=new TimeLineBean();
    	
    	//line 1
    	
    	lb1.setLineTile("2013-1-11 Line 1 report");
    	//set datalist
    		List<TimeLineValueBean> valueList=new ArrayList<TimeLineValueBean> ();
    		
    		//24hour
    		CountTimeUtil timeUtil=CountTimeUtil.getInstance();
    		int jiange=1;
    		java.util.Vector<Date> dList=timeUtil.getDay24Hours_today2(jiange);
    		
    		for(int i=0;i<dList.size();i++){
    			Date date=dList.get(i);
    			TimeLineValueBean vb=new TimeLineValueBean();
    			vb.setDate(date);
    			vb.setValue(Math.random()*1000); 
    			valueList.add(vb);
    		}
    		
    		lb1.setValueList(valueList);
    		
    		TimeLineBean timeLineBean=new TimeLineBean();
    		
    		//add to time line
    		lineBeanList.add(lb1);
    	
    	JFreeChart jfreechart=ru.dayLineCharCreate( charTitle, xTitle, yTitle, lineBeanList);
    	
    	ru.showByJFrame(jfreechart);
    }
}
