package juuluuApp.daoUitl.count;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;

import util.TimeUtil;
import util.TimeZoneUtil;

public class CountTimeUtil {
	private TimeZoneUtil timzoneUtil;
	private static TimeUtil timeutil;
	private static CountTimeUtil instance;

	public static CountTimeUtil getInstance(){
		if(instance==null){
			instance=new CountTimeUtil ();
			return instance;
		}else{
			return instance ;
		}
	}
	private CountTimeUtil(){
		//取上海时间
		this.timzoneUtil=new TimeZoneUtil();
		  this.timeutil=TimeUtil.getInstance();
	}
	
	public Vector<Date>  getDay24Hours_yestoday2(int jiange){
		util.TimeCreateBean tb=util.TimeCreateBean.getInstance();
		long timeInput=tb.getYestodatyStartTime();
		long timeTemp=timeInput;
		Vector vlist=new Vector();
		int max=24/jiange;
		for(int i=0;i<max;i++){
			vlist.add(new Date(timeTemp));
			Date upDayTime=	getNextHours(timeTemp,jiange);
			timeTemp=upDayTime.getTime();
			
		}
		
		return vlist;
	}
	
	public Vector<Date>  getDay24Hours_today2(int jiange){
		util.TimeCreateBean tb=util.TimeCreateBean.getInstance();
		long timeInput=tb.getToDayStartTime();
		long timeTemp=timeInput;
		Vector vlist=new Vector();
		int max=24/jiange;
		for(int i=0;i<max;i++){
			vlist.add(new Date(timeTemp));
			Date upDayTime=	getNextHours(timeTemp,jiange);
			timeTemp=upDayTime.getTime();
			//vlist.add(upDayTime);
		}
		
		return vlist;
	}
	
	public Vector<Date>  getDay24Hours2(long timeInput,int jiange){
		//util.TimeCreateBean tb=util.TimeCreateBean.getInstance();
		int max=24/jiange;
		long timeTemp=timeInput;
		Vector vlist=new Vector();
		for(int i=0;i<max;i++){
			vlist.add(new Date(timeTemp));
			Date upDayTime=	getNextHours(timeTemp,jiange);
			timeTemp=upDayTime.getTime();
			//vlist.add(upDayTime);
		}
		
		return vlist;
	}
	
	
	public Vector<Long>  getDay24Hours_yestoday(int jiange){
		util.TimeCreateBean tb=util.TimeCreateBean.getInstance();
		long timeInput=tb.getYestodatyStartTime();
		long timeTemp=timeInput;
		Vector vlist=new Vector();
		int max=24/jiange;
		for(int i=0;i<max;i++){
			vlist.add(timeTemp);
			Date upDayTime=	getNextHours(timeTemp,jiange);
			timeTemp=upDayTime.getTime();
		//	vlist.add(upDayTime);
		}
		
		return vlist;
	}
	
	public Vector<Long>  getDay24Hours_today(int jiange){
		util.TimeCreateBean tb=util.TimeCreateBean.getInstance();
		long timeInput=tb.getToDayStartTime();
		long timeTemp=timeInput;
		Vector vlist=new Vector();
		int max=24/jiange;
		for(int i=0;i<max;i++){
			vlist.add(timeTemp);
			Date upDayTime=	getNextHours(timeTemp,jiange);
			timeTemp=upDayTime.getTime();
			//vlist.add(upDayTime);
		}
		
		return vlist;
	}
	
	public Vector<Long>  getDay24Hours(long timeInput,int jiange){
		//util.TimeCreateBean tb=util.TimeCreateBean.getInstance();
		int max=24/jiange;
		long timeTemp=timeInput;
		Vector vlist=new Vector();
		for(int i=0;i<max;i++){
			vlist.add(timeTemp);
			Date upDayTime=	getNextHours(timeTemp,jiange);
			timeTemp=upDayTime.getTime();
			//vlist.add(upDayTime);
		}
		
		return vlist;
	}
	

	//24hour per day
	public Date getNextHours(long timeInput,int JianGe){
		Calendar cal=	this.timzoneUtil.getCalendar();
		
		
		Date date=new Date(timeInput);
		
		System.out.println("当前 hour："+date.getHours());
		cal.setTime(date);
		
		Date timezeone=cal.getTime();
		//加一天
		int dateYsS=timezeone.getHours()+JianGe;
		System.out.println("next hour:"+dateYsS);
		cal.set(cal.HOUR_OF_DAY, dateYsS);
		//cal.set(cal.HOUR_OF_DAY, 0);
		//cal.set(Calendar.PM, 0);
		//cal.set(Calendar.MINUTE, 0);
		//cal.set(Calendar.SECOND, 0);
		//cal.set(Calendar.MILLISECOND, 0);
		//昨天
		Date tomorlDay=cal.getTime();
		return tomorlDay;
	}
	public Date getUpHours(long timeInput,int JianGe){
		Calendar cal=	this.timzoneUtil.getCalendar();
		
		
		Date date=new Date(timeInput);
		
		System.out.println("当前日期："+date.getHours());
		cal.setTime(date);
		
		Date timezeone=cal.getTime();
		//加一天
		int dateYsS=timezeone.getHours()-JianGe;
		System.out.println("昨天日期："+dateYsS);
		cal.set(cal.HOUR_OF_DAY, dateYsS);
		//cal.set(cal.HOUR_OF_DAY, 0);
		//cal.set(Calendar.PM, 0);
		//cal.set(Calendar.MINUTE, 0);
		//cal.set(Calendar.SECOND, 0);
		//cal.set(Calendar.MILLISECOND, 0);
		//昨天
		Date tomorlDay=cal.getTime();
		return tomorlDay;
	}
	//last 30day
	public Vector<Long> getUpDayList_currentDay(int max){
		long timeInput=System.currentTimeMillis();
			return	getUpDayList(timeInput,max);
	
	}
	public Vector<Long>  getUpDayList(long timeInput,int max){
		util.TimeCreateBean tb=util.TimeCreateBean.getInstance();
		long timeTemp=timeInput;
		Vector vlist=new Vector();
		for(int i=0;i<max;i++){
			vlist.add(timeTemp);
			Date upDayTime=	tb.getUpOneDaty(timeTemp);
			timeTemp=upDayTime.getTime();
			
		}
		
		return vlist;
	}
	
	public Vector<Date> getUpDayList_currentDay2(int max){
		long timeInput=System.currentTimeMillis();
			return	getUpDayList2(timeInput,max);
	
	}
	public Vector<Date>  getUpDayList2(long timeInput,int max){
		util.TimeCreateBean tb=util.TimeCreateBean.getInstance();
		long timeTemp=timeInput;
		Vector vlist=new Vector();
		for(int i=0;i<max;i++){
			Date item=new Date(timeTemp);
			vlist.add(item);
			Date upDayTime=	tb.getUpOneDaty(timeTemp);
			timeTemp=upDayTime.getTime();
			//vlist.add(upDayTime);
		}
		
		return vlist;
	}
	
	public Vector<Date>  getMonth_DayList2_current(){
		long timeInput=System.currentTimeMillis();
	
		return getMonth_DayList2(timeInput);
	}
	
	public Vector<Date>  getMonth_DayList2(long timeInput){
		util.TimeCreateBean tb=util.TimeCreateBean.getInstance();
	
		Vector vlist=new Vector();
		
		
		Date date=new Date(timeInput);
		int daysize=getMonthLastDay(date.getYear(),date.getMonth());
			
		long timeTemp;
        timeTemp = tb.getMonthFisrtdatyEndTime(timeInput);
		
		for(int i=0;i<daysize;i++){
			Date item=new Date(timeTemp);
			//System.out.println("######## All:"+daysize+" day:"+item.getDate()+" xing qi:"+item.getDay());
			vlist.add(item);
			//next day
			Date upDayTime=	tb.getNextDate(timeTemp);				
			
			timeTemp=upDayTime.getTime();
		}
		
		return vlist;
	}
	
	/**
	 * 取得当月天数
	 * */
	public static int getCurrentMonthLastDay()
	{
		Calendar a = Calendar.getInstance();
		a.set(Calendar.DATE, 1);//把日期设置为当月第一天
		a.roll(Calendar.DATE, -1);//日期回滚一天，也就是最后一天
		int maxDate = a.get(Calendar.DATE);
		return maxDate;
	}

	/**
	 * 得到指定月的天数
	 * */
	public static int getMonthLastDay(int year, int month)
	{
		Calendar a = Calendar.getInstance();
		a.set(Calendar.YEAR, year);
		a.set(Calendar.MONTH, month - 1);
		a.set(Calendar.DATE, 1);//把日期设置为当月第一天
		a.roll(Calendar.DATE, -1);//日期回滚一天，也就是最后一天
		int maxDate = a.get(Calendar.DATE);
		return maxDate;
	}

	//返回当前年月日
	public String getNowDate()
	{
		Date date = new Date();
		String nowDate = new SimpleDateFormat("yyyy年MM月dd日").format(date);
		return nowDate;
	}

	//返回当前年份
	public 	int getYear()
	{
		Date date = new Date();
		String year = new SimpleDateFormat("yyyy").format(date);
		return Integer.parseInt(year);
	}

	//返回当前月份
	public 	int getMonth()
	{
		Date date = new Date();
		String month = new SimpleDateFormat("MM").format(date);
		return Integer.parseInt(month);
	}

	//判断闰年
	public boolean isLeap(int year)
	{
		if (((year % 100 == 0) && year % 400 == 0) || ((year % 100 != 0) && year % 4 == 0))
			return true;
		else
			return false;
	}

	//返回当月天数
	public int getDays(int year, int month)
	{
		int days;
		int FebDay = 28;
		if (isLeap(year))
			FebDay = 29;
		switch (month)
		{
			case 1:
			case 3:
			case 5:
			case 7:
			case 8:
			case 10:
			case 12:
				days = 31;
				break;
			case 4:
			case 6:
			case 9:
			case 11:
				days = 30;
				break;
			case 2:
				days = FebDay;
				break;
			default:
				days = 0;
				break;
		}
		return days;
	}

	//返回当月星期天数
	public 	int getSundays(int year, int month)
	{
		int sundays = 0;
		SimpleDateFormat sdf = new SimpleDateFormat("EEEE");
		Calendar setDate = Calendar.getInstance();
		//从第一天开始
		int day;
		for (day = 1; day <= getDays(year, month); day++)
		{
			setDate.set(Calendar.DATE, day);
			String str = sdf.format(setDate.getTime());
			if (str.equals("星期日"))
			{
				sundays++;
			}
		}
		return sundays;
	}



	/**
	 * @param args
	 */
	public static void main(String[] args) {
		// TODO Auto-generated method stub
		CountTimeUtil cu=new CountTimeUtil();
		//cu.getUpDayList_currentDay(30);
		int jiange=1;
		//cu.getDay24Hours_today( jiange);
		Date du=new Date(System.currentTimeMillis());
		//System.out.println("本月有" + cu.getDays(du.getYear(), du.getMonth()) + "天");
		//System.out.println("本月有"+cu.getCurrentMonthLastDay()+ "天");
	//	System.out.println("本月有" + cu.getSundays(du.getYear(), du.getMonth()) + "个星期天");
		
		System.out.print(cu.getMonth_DayList2_current());

	}

}
