package juuluuApp.appPermission.core;

import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import net.juluu.app.security.core.PortalUserLoginConfig;

import org.apache.struts.action.ActionForward;


import com.juuluu.kgcore.base.CompleeManageBean;
import com.juuluu.kgcore.base.SystemUserLogin;
import com.juuluu.kgcore.dao.Member;
import com.juuluu.kgcore.dao.Membergrounp;
import com.juuluu.kgcore.dao.Menu;
import com.juuluu.kgcore.entryService.MemberEntryService;

import juuluuApp.session.base.SessionValidaty;

public class JuuluuAppPermissionCheckUtil {

    private static JuuluuAppPermissionCheckUtil instance;

    private JuuluuAppPermissionCheckUtil() {
    }

    public static JuuluuAppPermissionCheckUtil getInstance() {
        if (instance == null) {
            instance = new JuuluuAppPermissionCheckUtil();
        }
        return instance;
    }

    //硬编码权限测试
    //超级管理员级用户操作 方法审核
    public ActionForward checkSuperAdminAction(HttpServletRequest request, HttpServletResponse response) {
        com.juuluu.kgcore.base.SystemUserLogin ulogin = SessionValidaty.getInstance()
                .getSystemUserLoginSession(request);
        if (ulogin == null) {
            ActionForward af = new ActionForward();
            af.setRedirect(false);
            request.setAttribute("info", "非法操作，无此权限，请注册或登录系统.error,please login in!");
            af.setPath("/admin/login.jsp");
            return af;
        }
        if (ulogin.isBsuerAdmin() == false) {
            ActionForward af = new ActionForward();
            af.setRedirect(false);
            request.setAttribute("info", "错误，权限不足，不能执行该操作，请以超级管理员登录");
            af.setPath("/admin/login.jsp");
            return af;
        }
        return null;

    }

    /**
     * @param args
     */
    public static void main(String[] args) {
        // TODO Auto-generated method stub
    }

    /**
     *
     * @param request
     * @param myUserGrounpList 授权用户组访问列表
     * @return 授权用户组访问列表 ，常见值： complee customer superAdmin
     */
    public ActionForward methodCheckUserGrounpPermission(HttpServletRequest request, PortalUserLoginConfig potalUserLoginConfig) {
        //授权访问用户列表
        //"niMing","customper","complee","superAdmin"
        //是否通过授权访问
        boolean isPassedCheck = false;
        ActionForward errorCheckActionForward = null;
        //
        List<String> userGrounpList = potalUserLoginConfig.getSupportUserGrounpList();
        for (int k = 0; k < userGrounpList.size(); k++) {
            String methoGrounpName = userGrounpList.get(k);
            if (methoGrounpName.equals("niMing")) {
                System.out.println("授权匿名访问：" + methoGrounpName);
                isPassedCheck = true;
                break;
            }
        }//end for
        //允许匿名访问
        if (isPassedCheck == true) {
            return errorCheckActionForward;
        }
        //要求登录
        SystemUserLogin userLogin = SessionValidaty.getInstance().getSystemUserLoginSession(request);
        if (userLogin == null) {
            errorCheckActionForward = new ActionForward();
            request.setAttribute("info", "非授权访问，或登录超时，请登录系统！");
            System.out.println("未登录用户，进入用户portal登录页面：" + potalUserLoginConfig.getUserLoginJspPath());
            errorCheckActionForward.setPath(potalUserLoginConfig.getUserLoginJspPath());
            //System.out.println("显示："+"/cmsDt/"+tmp+"/index.jsp");
            return errorCheckActionForward;
        }
        //测试是否允许用户访问，方法的授权用户组是否包含用户的用户组
        List<Membergrounp> userMemberGrounpList = userLogin.getGrounpLIst();
        for (int i = 0; i < userMemberGrounpList.size(); i++) {

            Membergrounp g = userMemberGrounpList.get(i);
            String mygronpName = g.getGroupname();
            //登录用户全员组，是在在的控制器方法的授权访问表中
            for (int k = 0; k < userGrounpList.size(); k++) {
                String methoGrounpName = userGrounpList.get(k);
                if (mygronpName.equals(methoGrounpName)) {
                    System.out.println("授权访问：" + methoGrounpName);
                    isPassedCheck = true;
                    break;
                }
            }//end for
            if (isPassedCheck == true) {
                break;
            }

        }//end for

        //授权访问不通过，
        if (isPassedCheck == false) {
            errorCheckActionForward = new ActionForward();
            request.setAttribute("info", "非授权访问，或登录超时，请登录系统！");

            System.out.println("已登录用户非授权操作，进入用户portal登录页面：" + potalUserLoginConfig.getUserLoginJspPath());

            errorCheckActionForward.setPath(potalUserLoginConfig.getUserLoginJspPath());

        }
        return errorCheckActionForward;
        //授权访问通过，继续执行程序代码
    }

    //通用用户登录模块
    public ActionForward userLoginChceckComment(HttpServletRequest request, String loginInpuJsp, String loginSucessTargetJsp) {
        final String name = request.getParameter("userName");

        final String password = request.getParameter("password");
        if (name == null || name.equals("") == true) {

            request.setAttribute("info", "用户名没填写!");
            ActionForward af = new ActionForward();
            af.setRedirect(false);
            af.setPath(loginInpuJsp);
            return af;
        } else if (password == null || password.equals("") == true) {

            request.setAttribute("info", "密码没填写!");
            final String target = "Admin_userloginjsp";
            ActionForward af = new ActionForward();
            af.setRedirect(false);
            af.setPath(loginInpuJsp);
            return af;
        }
        //设置菜单到Session			

        SystemUserLogin userSystemlogined = null;

        final CompleeManageBean userbean = CompleeManageBean.getInstance();			//取超级用户菜单		

        //验证用户登录			

        userSystemlogined = userbean.logincheck(name, password);

        if (userSystemlogined.getUser() == null) {

            ///用户名或密码错误，返回登临界面	
            //错误类型，用户名不存在，
            final MemberEntryService mb = MemberEntryService.getInstance();
            if (mb.getByUserLoginName(name) == null) {
                if (name == null || name.equals("") == true) {
                    request.setAttribute("info", "登录失败，用户名没填写!");
                } else {
                    request.setAttribute("info", "登录失败，用户" + name + "不存在！");
                }

            } else {
                if (password == null || password.equals("") == true) {
                    request.setAttribute("info", "登录失败，密码没填写！");
                } else {
                    request.setAttribute("info", "登录失败，密码错误！");
                }

            }//end else

            request.setAttribute("info", "登录失败，用户名或密码错误！");
            request.setAttribute("userName", name);
            request.setAttribute("password", password);
            //密码错误
            final String target = "Admin_userloginjsp";
            ActionForward af = new ActionForward();
            af.setRedirect(false);
            af.setPath(loginInpuJsp);
            return af;

            // 成功登录 保存用户信息 userSystemlogined.getUser()!=null
        } else {

            //初始化管理数据			

            //默认显示文件，组的显示文件	
            //转到用户管理中心		
            //将会员信息设置到系统会话环境				
            SessionValidaty session = SessionValidaty.getInstance();
            session.setSystemUserLoginSession(request, userSystemlogined);
            //保存登录信息到会话变量中
            session.setMemberSession(request, userSystemlogined.getUser());

            SessionValidaty sessionBean = SessionValidaty.getInstance();


            ActionForward af = new ActionForward();
            af.setRedirect(false);
            af.setPath(loginSucessTargetJsp);
            return af;

        }	//end if
    }//end method

    public ActionForward methodCheckUserGrounpPermission(HttpServletRequest request, PortalUserLoginConfig potalUserLoginConfig, String[] myUserGrounpNameListYes) {
        //授权访问用户列表
        //"niMing","customper","complee","superAdmin"
        //是否通过授权访问
        boolean isPassedCheck = false;
        ActionForward errorCheckActionForward = null;
        //
        for (int k = 0; k < myUserGrounpNameListYes.length; k++) {
            String methoGrounpName = myUserGrounpNameListYes[k];
            if (methoGrounpName.equals("niMing")) {
                System.out.println("授权匿名访问：" + methoGrounpName);
                isPassedCheck = true;
                break;
            }
        }//end for
        //允许匿名访问
        if (isPassedCheck == true) {
            return errorCheckActionForward;
        }
        //要求登录
        SystemUserLogin userLogin = SessionValidaty.getInstance().getSystemUserLoginSession(request);
        if (userLogin == null) {
            errorCheckActionForward = new ActionForward();
            request.setAttribute("info", "非授权访问，未登录认证，或超时，请登录系统！");
            errorCheckActionForward.setPath(potalUserLoginConfig.getUserLoginJspPath());
            //System.out.println("显示："+"/cmsDt/"+tmp+"/index.jsp");
            return errorCheckActionForward;
        }
        //测试是否允许用户访问，方法的授权用户组是否包含用户的用户组
        List<Membergrounp> userMemberGrounpList = userLogin.getGrounpLIst();
        for (int i = 0; i < userMemberGrounpList.size(); i++) {

            Membergrounp g = userMemberGrounpList.get(i);
            String mygronpName = g.getGroupname();
            //登录用户全员组，是在在的控制器方法的授权访问表中
            for (int k = 0; k < myUserGrounpNameListYes.length; k++) {
                String methoGrounpName = myUserGrounpNameListYes[k];
                if (mygronpName.equals(methoGrounpName)) {
                    System.out.println("授权访问：" + methoGrounpName);
                    isPassedCheck = true;
                    break;
                }
            }//end for
            if (isPassedCheck == true) {
                break;
            }

        }//end for

        //授权访问不通过，
        if (isPassedCheck == false) {
            errorCheckActionForward = new ActionForward();
            request.setAttribute("info", "非授权访问，或登录超时，一个请确认您拥有足够的权限！");
            errorCheckActionForward.setPath(potalUserLoginConfig.getUserLoginJspPath());

        }
        return errorCheckActionForward;
        //授权访问通过，继续执行程序代码
    }

    public boolean isLogined(HttpServletRequest request) {
        //授权访问用户列表
        //"niMing","customper","complee","superAdmin"
        //是否通过授权访问

        //要求登录
        SystemUserLogin userLogin = SessionValidaty.getInstance().getSystemUserLoginSession(request);
        if (userLogin == null) {
            return false;
        } else {
            return true;
        }


        //授权访问通过，继续执行程序代码
    }

    public ActionForward toLoginPage(HttpServletRequest request, PortalUserLoginConfig potalUserLoginConfig) {
        //授权访问用户列表
        //"niMing","customper","complee","superAdmin"
        //是否通过授权访问
        boolean isPassedCheck = false;
        ActionForward errorCheckActionForward = null;

        //要求登录
        SystemUserLogin userLogin = SessionValidaty.getInstance().getSystemUserLoginSession(request);

        errorCheckActionForward = new ActionForward();
        request.setAttribute("info", "非授权访问，未登录认证，或超时，请登录系统！");
        errorCheckActionForward.setPath(potalUserLoginConfig.getUserLoginJspPath());
        //System.out.println("显示："+"/cmsDt/"+tmp+"/index.jsp");
        return errorCheckActionForward;



    }
    //会员组软编码权限测试

    public ActionForward methodGrounpDbPermissionCheck(
            HttpServletRequest request, PortalUserLoginConfig potalUserLoginConfig, String permissionKey) {
        util.DaoService.getIntrance().startHibernate();
        //是否通过授权访问
        boolean isPassedCheck = false;
        ActionForward errorCheckActionForward = null;
        //要求登录
        SystemUserLogin userLogin = SessionValidaty.getInstance().getSystemUserLoginSession(request);
        if (userLogin == null) {
            errorCheckActionForward = new ActionForward();
            request.setAttribute("info", "非授权访问，未登录认证，或超时，请登录系统！");
            errorCheckActionForward.setPath(potalUserLoginConfig.getUserLoginJspPath());
            //System.out.println("显示："+"/cmsDt/"+tmp+"/index.jsp");
            return errorCheckActionForward;
        }

        Member sysUser = userLogin.getUser();


        EnableConfigPermissionCheckUtil pu = new EnableConfigPermissionCheckUtil();


        //boolean passed=pu.check(userLogined, "CMS.Editor.ArticleAction.$AddArticle");
        //System.out.println("CMS.Editor.ArticleAction.$AddArticle"+ passed);
        String passedStrReturn = pu.check_struts1_memberGrounp(sysUser, permissionKey);

        //pase return msg
        String msg = "";
        CheckMsgBean cb = parseReturnCheckMsg(passedStrReturn, permissionKey);
        isPassedCheck = cb.isBpassed();
        msg = cb.getCheckMsg();
        request.setAttribute("CheckMsgBean", cb);

        System.out.println("check grounp permission:" + permissionKey + passedStrReturn + "passed:" + isPassedCheck + " msgType:" + cb.getCheckSystemMsg());


        //允许匿名访问
        if (isPassedCheck == true) {
            return errorCheckActionForward;
        }

        //授权访问不通过，
        if (isPassedCheck == false) {
            errorCheckActionForward = new ActionForward();
            request.setAttribute("info", msg);
            errorCheckActionForward.setPath(potalUserLoginConfig.getUserLoginJspPath());

        }
        return errorCheckActionForward;
        //授权访问通过，继续执行程序代码
    }
    //会员软编码权限测试

    public CheckMsgBean parseReturnCheckMsg(String passedStrReturn, String permissionKey) {
        String msg = "非授权访问，或登录超时，请确认您拥有足够的权限！";
        boolean isPassedCheck = false;
        EnableConfigPermissionCheckUtil pu = new EnableConfigPermissionCheckUtil();

        if (passedStrReturn != null && passedStrReturn.equals(pu.Type_Check_Pass)) {
            System.out.println("OK");
            msg = "通过权限审核,会员可执行该操作!";
            isPassedCheck = true;
        } else if (passedStrReturn != null && passedStrReturn.equals(pu.Type_Check_ExcitNotPermission)) {
            System.out.println("Type_Check_ExcitNotPermission:" + permissionKey);
            isPassedCheck = false;
            msg = "该权限配置不存在!";
        } else if (passedStrReturn != null && passedStrReturn.equals(pu.Type_Check_NotPass)) {
            System.out.println("Type_Check_NotPass:" + permissionKey);
            msg = "错误,您该操作权限,请以相应会员登录,或与管理员联系开通相关权限!";
            isPassedCheck = false;
        } else if (passedStrReturn != null && passedStrReturn.equals(pu.Type_Check_NotSet)) {
            System.out.println("Type_Check_NotSet:" + permissionKey);
            msg = "错误,您无权执行该操作,您所在的会员组或会员未分配该权限!";
            isPassedCheck = false;
        } else if (passedStrReturn != null && passedStrReturn.equals(pu.Type_Check_ErrorInput)) {
            System.out.println("Type_Check_ErrorInput:" + permissionKey);
            msg = "错误,您无权执行该操作,您录入的数据可能有误!";
        } else {
            isPassedCheck = false;
            msg = "错误,您无权执行该操作!如有问题,请与管理员联系!";
        }
        CheckMsgBean checkBean = new CheckMsgBean();
        checkBean.setCheckMsg(msg);
        checkBean.setCheckSystemMsg(passedStrReturn);
        checkBean.setBpassed(isPassedCheck);

        return checkBean;
    }

    public ActionForward methodmemberDbPermissionCheck(
            HttpServletRequest request, PortalUserLoginConfig potalUserLoginConfig, String permissionKey) {
        //是否通过授权访问
        boolean isPassedCheck = false;
        ActionForward errorCheckActionForward = null;
        //要求登录
        SystemUserLogin userLogin = SessionValidaty.getInstance().getSystemUserLoginSession(request);
        if (userLogin == null) {
            errorCheckActionForward = new ActionForward();
            request.setAttribute("info", "非授权访问，未登录认证，或超时，请登录系统！");
            errorCheckActionForward.setPath(potalUserLoginConfig.getUserLoginJspPath());
            //System.out.println("显示："+"/cmsDt/"+tmp+"/index.jsp");
            return errorCheckActionForward;
        }

        Member sysUser = userLogin.getUser();


        EnableConfigPermissionCheckUtil pu = new EnableConfigPermissionCheckUtil();


        //boolean passed=pu.check(userLogined, "CMS.Editor.ArticleAction.$AddArticle");
        //System.out.println("CMS.Editor.ArticleAction.$AddArticle"+ passed);
        String passedStrReturn = pu.check_struts1member(sysUser, permissionKey);

        //pase return msg
        String msg = "";
        CheckMsgBean cb = parseReturnCheckMsg(passedStrReturn, permissionKey);
        isPassedCheck = cb.isBpassed();
        msg = cb.getCheckMsg();
        request.setAttribute("CheckMsgBean", cb);

        System.out.println("check member permission:" + permissionKey + passedStrReturn + "passed:" + isPassedCheck + " msgType:" + cb.getCheckSystemMsg());


        System.out.println("check permission:" + permissionKey + passedStrReturn);


        //授权访问不通过，
        if (isPassedCheck == false) {
            errorCheckActionForward = new ActionForward();
            request.setAttribute("info", "非授权访问，或登录超时，一个请确认您拥有足够的权限！");
            errorCheckActionForward.setPath(potalUserLoginConfig.getUserLoginJspPath());

        }
        return errorCheckActionForward;
        //授权访问通过，继续执行程序代码
    }

    public ActionForward methodmemberAndGronpDbPermissionCheck(
            HttpServletRequest request, PortalUserLoginConfig potalUserLoginConfig, String permissionKey) {
        //是否通过授权访问
        boolean isPassedCheck = false;
        ActionForward errorCheckActionForward = null;
        //要求登录
        SystemUserLogin userLogin = SessionValidaty.getInstance().getSystemUserLoginSession(request);
        if (userLogin == null) {
            errorCheckActionForward = new ActionForward();
            request.setAttribute("info", "非授权访问，未登录认证，或超时，请登录系统！");
            errorCheckActionForward.setPath(potalUserLoginConfig.getUserLoginJspPath());
            //System.out.println("显示："+"/cmsDt/"+tmp+"/index.jsp");
            return errorCheckActionForward;
        }

        Member sysUser = userLogin.getUser();


        EnableConfigPermissionCheckUtil pu = new EnableConfigPermissionCheckUtil();


        //boolean passed=pu.check(userLogined, "CMS.Editor.ArticleAction.$AddArticle");
        //System.out.println("CMS.Editor.ArticleAction.$AddArticle"+ passed);
        String passedStrReturn = pu.checks(sysUser, permissionKey);


        //pase return msg
        String msg = "";
        CheckMsgBean cb = parseReturnCheckMsg(passedStrReturn, permissionKey);
        isPassedCheck = cb.isBpassed();
        msg = cb.getCheckMsg();
        request.setAttribute("CheckMsgBean", cb);

        System.out.println("check  member and grounp permission:" + permissionKey + passedStrReturn + "passed:" + isPassedCheck + " msgType:" + cb.getCheckSystemMsg());


        System.out.println("check  permission:" + permissionKey + passedStrReturn);


        //授权访问不通过，
        if (isPassedCheck == false) {
            errorCheckActionForward = new ActionForward();
            request.setAttribute("info", "非授权访问，或登录超时，一个请确认您拥有足够的权限！");
            errorCheckActionForward.setPath(potalUserLoginConfig.getUserLoginJspPath());

        }
        return errorCheckActionForward;
        //授权访问通过，继续执行程序代码
    }
    //会员组编码权限测试

    public ActionForward methodmemberAndGronpDbPermission_CodeDoubleCheck(HttpServletRequest request, PortalUserLoginConfig potalUserLoginConfig, String[] myUserGrounpNameListYes) {
        //授权访问用户列表
        //"niMing","customper","complee","superAdmin"
        //是否通过授权访问
        boolean isPassedCheck = false;
        ActionForward errorCheckActionForward = null;
        //
        for (int k = 0; k < myUserGrounpNameListYes.length; k++) {
            String methoGrounpName = myUserGrounpNameListYes[k];
            if (methoGrounpName.equals("niMing")) {
                System.out.println("授权匿名访问：" + methoGrounpName);
                isPassedCheck = true;
                break;
            }
        }//end for
        //允许匿名访问
        if (isPassedCheck == true) {
            return errorCheckActionForward;
        }
        //要求登录
        SystemUserLogin userLogin = SessionValidaty.getInstance().getSystemUserLoginSession(request);
        if (userLogin == null) {
            errorCheckActionForward = new ActionForward();
            request.setAttribute("info", "非授权访问，未登录认证，或超时，请登录系统！");
            errorCheckActionForward.setPath(potalUserLoginConfig.getUserLoginJspPath());
            //System.out.println("显示："+"/cmsDt/"+tmp+"/index.jsp");
            return errorCheckActionForward;
        }
        //测试是否允许用户访问，方法的授权用户组是否包含用户的用户组
        List<Membergrounp> userMemberGrounpList = userLogin.getGrounpLIst();
        for (int i = 0; i < userMemberGrounpList.size(); i++) {

            Membergrounp g = userMemberGrounpList.get(i);
            String mygronpName = g.getGroupname();
            //登录用户全员组，是在在的控制器方法的授权访问表中
            for (int k = 0; k < myUserGrounpNameListYes.length; k++) {
                String methoGrounpName = myUserGrounpNameListYes[k];
                if (mygronpName.equals(methoGrounpName)) {
                    System.out.println("授权访问：" + methoGrounpName);
                    isPassedCheck = true;
                    break;
                }
            }//end for
            if (isPassedCheck == true) {
                break;
            }

        }//end for

        //授权访问不通过，
        if (isPassedCheck == false) {
            errorCheckActionForward = new ActionForward();
            request.setAttribute("info", "非授权访问，或登录超时，一个请确认您拥有足够的权限！");
            errorCheckActionForward.setPath(potalUserLoginConfig.getUserLoginJspPath());

        }
        return errorCheckActionForward;
        //授权访问通过，继续执行程序代码
    }

    //会员组编码权限测试
    public ActionForward methodGronpDbPermission_codeDoubleCheck(HttpServletRequest request, PortalUserLoginConfig potalUserLoginConfig, String[] myUserGrounpNameListYes) {
        //授权访问用户列表
        //"niMing","customper","complee","superAdmin"
        //是否通过授权访问
        boolean isPassedCheck = false;
        ActionForward errorCheckActionForward = null;
        //
        for (int k = 0; k < myUserGrounpNameListYes.length; k++) {
            String methoGrounpName = myUserGrounpNameListYes[k];
            if (methoGrounpName.equals("niMing")) {
                System.out.println("授权匿名访问：" + methoGrounpName);
                isPassedCheck = true;
                break;
            }
        }//end for
        //允许匿名访问
        if (isPassedCheck == true) {
            return errorCheckActionForward;
        }
        //要求登录
        SystemUserLogin userLogin = SessionValidaty.getInstance().getSystemUserLoginSession(request);
        if (userLogin == null) {
            errorCheckActionForward = new ActionForward();
            request.setAttribute("info", "非授权访问，未登录认证，或超时，请登录系统！");
            errorCheckActionForward.setPath(potalUserLoginConfig.getUserLoginJspPath());
            //System.out.println("显示："+"/cmsDt/"+tmp+"/index.jsp");
            return errorCheckActionForward;
        }
        //测试是否允许用户访问，方法的授权用户组是否包含用户的用户组
        List<Membergrounp> userMemberGrounpList = userLogin.getGrounpLIst();
        for (int i = 0; i < userMemberGrounpList.size(); i++) {

            Membergrounp g = userMemberGrounpList.get(i);
            String mygronpName = g.getGroupname();
            //登录用户全员组，是在在的控制器方法的授权访问表中
            for (int k = 0; k < myUserGrounpNameListYes.length; k++) {
                String methoGrounpName = myUserGrounpNameListYes[k];
                if (mygronpName.equals(methoGrounpName)) {
                    System.out.println("授权访问：" + methoGrounpName);
                    isPassedCheck = true;
                    break;
                }
            }//end for
            if (isPassedCheck == true) {
                break;
            }

        }//end for

        //授权访问不通过，
        if (isPassedCheck == false) {
            errorCheckActionForward = new ActionForward();
            request.setAttribute("info", "非授权访问，或登录超时，一个请确认您拥有足够的权限！");
            errorCheckActionForward.setPath(potalUserLoginConfig.getUserLoginJspPath());

        }
        return errorCheckActionForward;
        //授权访问通过，继续执行程序代码
    }

    public ActionForward methodmemberDbPermission_codeDoubleCheck(HttpServletRequest request, PortalUserLoginConfig potalUserLoginConfig, String[] myUserGrounpNameListYes) {
        //授权访问用户列表
        //"niMing","customper","complee","superAdmin"
        //是否通过授权访问
        boolean isPassedCheck = false;
        ActionForward errorCheckActionForward = null;
        //
        for (int k = 0; k < myUserGrounpNameListYes.length; k++) {
            String methoGrounpName = myUserGrounpNameListYes[k];
            if (methoGrounpName.equals("niMing")) {
                System.out.println("授权匿名访问：" + methoGrounpName);
                isPassedCheck = true;
                break;
            }
        }//end for
        //允许匿名访问
        if (isPassedCheck == true) {
            return errorCheckActionForward;
        }
        //要求登录
        SystemUserLogin userLogin = SessionValidaty.getInstance().getSystemUserLoginSession(request);
        if (userLogin == null) {
            errorCheckActionForward = new ActionForward();
            request.setAttribute("info", "非授权访问，未登录认证，或超时，请登录系统！");
            errorCheckActionForward.setPath(potalUserLoginConfig.getUserLoginJspPath());
            //System.out.println("显示："+"/cmsDt/"+tmp+"/index.jsp");
            return errorCheckActionForward;
        }
        //测试是否允许用户访问，方法的授权用户组是否包含用户的用户组
        List<Membergrounp> userMemberGrounpList = userLogin.getGrounpLIst();
        for (int i = 0; i < userMemberGrounpList.size(); i++) {

            Membergrounp g = userMemberGrounpList.get(i);
            String mygronpName = g.getGroupname();
            //登录用户全员组，是在在的控制器方法的授权访问表中
            for (int k = 0; k < myUserGrounpNameListYes.length; k++) {
                String methoGrounpName = myUserGrounpNameListYes[k];
                if (mygronpName.equals(methoGrounpName)) {
                    System.out.println("授权访问：" + methoGrounpName);
                    isPassedCheck = true;
                    break;
                }
            }//end for
            if (isPassedCheck == true) {
                break;
            }

        }//end for

        //授权访问不通过，
        if (isPassedCheck == false) {
            errorCheckActionForward = new ActionForward();
            request.setAttribute("info", "非授权访问，或登录超时，一个请确认您拥有足够的权限！");
            errorCheckActionForward.setPath(potalUserLoginConfig.getUserLoginJspPath());

        }
        return errorCheckActionForward;
        //授权访问通过，继续执行程序代码
    }
}
