package juuluuApp.appPermission.core;

import com.juuluu.kgcore.dao.Member;
import com.juuluu.kgcore.dao.Membergrounp;
import dao.AppPermission;
import dao.AppPermissionMemberGrounpLink;
import dao.AppPermissionMemberLink;
import org.apache.struts.action.ActionForward;

import service.entryService.AppPermissionEntryService;
import service.entryService.AppPermissionMemberGrounpLinkEntryService;
import service.entryService.AppPermissionMemberLinkEntryService;
import java.util.List;
public class EnableConfigPermissionCheckUtil {
	
	
	public static String Type_Check_ExcitNotPermission="NotExcit";
	public static  String Type_Check_NotPass="NotPass";
	public static  String Type_Check_Pass="Pass";
	//
	public static  String Type_Check_NotSet="NotSet";
	public static  String Type_Check_ErrorInput="ErrorInput";
	
	public boolean check(Member userLogined,String permissionKey){
		String v=checks(userLogined,permissionKey);
		if(v.equals(Type_Check_Pass)){
			return true;
		}else{
			return false;
		}
		
	}
	
	public String checks(Member userLogined,String permissionKey){
		if(userLogined==null){
			return Type_Check_ErrorInput;
		}
		
		String value=check_struts1member(userLogined,permissionKey);
				
		
		if(value.equals(Type_Check_Pass)){
			return Type_Check_Pass;
		}
		
		if(value.equals(Type_Check_NotPass)){
			return Type_Check_NotPass;
		}

		value=check_struts1_memberGrounp(userLogined,permissionKey);
		if(value.equals(Type_Check_Pass)){
			return Type_Check_Pass;
		}
		return value;
		
	
	}
	
	public String check_struts1_memberGrounp(Member userLogined,String permissionKey){
		//excit
		AppPermission permission=AppPermissionEntryService.getInstance()
				.getPermissionBySystemKey(permissionKey);
		if(permission==null){
			return Type_Check_ExcitNotPermission;
		}
		
		AppPermissionMemberGrounpLink glink=null;
		
		AppPermissionMemberGrounpLinkEntryService gldao=AppPermissionMemberGrounpLinkEntryService.getInstance()
				;
		
		PermissionUserGrounpUtil gutil=PermissionUserGrounpUtil.getInstance()
				;
		//List<Membergrounp> glist= gutil.getGrounpList();
		
		List<com.juuluu.kgcore.dao.Membergrounp> userGlist=gutil
				.getMembergrounpListByMemberId(userLogined.getUserid());
		
		boolean ishasePermission=false;
		for(int i=0;i<userGlist.size();i++){
			
			com.juuluu.kgcore.dao.Membergrounp ug=userGlist.get(i);
			
			//check id
			int memberGrounpId0=ug.getGrounpid();
			
			glink=	 gldao.getPermissionByGrounpIdSystemKey(
					memberGrounpId0, permissionKey);
			
			if(glink!=null){
				ishasePermission=true;
				break;
			}
			
			//check gname
			if(glink==null){
				
				glink=	 gldao.getPermissionByGrounpNameSystemKey
						(ug.getGroupname(), permissionKey);

				if(glink!=null){
					ishasePermission=true;
					break;
				}
			}
			
		}//end for
		
		
		
		if(ishasePermission==true){
			if(glink.getBpassed()!=null&&glink.getBpassed()==true){
				return Type_Check_Pass;
			}else{
				return Type_Check_NotPass;
			}
			
		}else{
			return	Type_Check_NotSet;
		}
	
	}
	
	public String check_struts1member(Member userLogined,String permissionKey){
		
		
		//excit
		AppPermission permission=AppPermissionEntryService.getInstance()
				.getPermissionBySystemKey(permissionKey);
		if(permission==null){
			return Type_Check_ExcitNotPermission;
		}
		
		AppPermissionMemberLink glink=null;
		
		AppPermissionMemberLinkEntryService gldao=AppPermissionMemberLinkEntryService.getInstance()
				;
		
		PermissionUserGrounpUtil gutil=PermissionUserGrounpUtil.getInstance()
				;
					
			glink=	 gldao.getListAllByUserIdPersmissionSystemKey
					(userLogined.getUserid(), permissionKey);
			
			
			
			//check gname
			if(glink==null){
				
				glink=	 gldao.getPermissionByUserNameSystemKey
						(userLogined.getUserName(), permissionKey);

				
			}
			
		
		
			if(glink==null){
				return	Type_Check_NotSet;
			}
		
			if(glink.getBpassed()!=null&&glink.getBpassed()==true){
				return Type_Check_Pass;
			}else{
				return Type_Check_NotPass;
			}
			
		
	}
	
	public static void main(String argvs[]){
		
		
		util.DaoService.getIntrance().startHibernate();
		
		EnableConfigPermissionCheckUtil pu=new EnableConfigPermissionCheckUtil();
		
		Member userLogined=new Member();
		userLogined.setUserid(0);
		userLogined.setUserName("juuluu");
		boolean passed=pu.check(userLogined, "CMS.Editor.ArticleAction.$AddArticle");
		String passedStr=pu.checks(userLogined, "CMS.Editor.ArticleAction.$AddArticle");
		
	System.out.println("CMS.Editor.ArticleAction.$AddArticle"+ passed);
	
	System.out.println("CMS.Editor.ArticleAction.$AddArticle"+ passedStr);
	
	}


}
