package filter;

import java.io.IOException;

import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.site.viewbean.UserBeanInfo;

/**
 * 处理用户网站资源请求，
 * 默认访问控制：
 * 	//会员是否为空，
	//是否允许匿名访问
	//是否按会员组访问
	//是否按会员点数访问
	//是否按会员货币访问
	//是否按会员级别访问
	//其它访问控制实现
	 * 
	 * 资料：response.sendRedirect(pagename); 
会通知IE进行跳转，也就是地址栏会发生变化 
request.getRequestDispatcher( "url ").forward(request,response); 
只在服务器上跳转，IE并不知道这个事情 
 *
 */
public class SaftePermissionFilterParseBean {
private static SaftePermissionFilterParseBean instance;
public static SaftePermissionFilterParseBean getInstance() {
	if(instance==null){
		instance=new SaftePermissionFilterParseBean();
		return instance;
	}else{
		return instance;
	}
	

}

/**
 * 处理用户网站资源请求，
 * 默认访问控制：
 * 	//会员是否为空，
	//是否允许匿名访问
	//是否按会员组访问
	//是否按会员点数访问
	//是否按会员货币访问
	//是否按会员级别访问
	//其它访问控制实现
	 * 可自定义自己的访问控制规则
 */
public void doFilter(dao.Resource urlPathResouce,UserBeanInfo userSite,ServletRequest request, ServletResponse response) throws IOException, ServletException {
HttpServletResponse responseHttp=(HttpServletResponse)response;
	//请求访问控制是否为空，默认通过
	if(urlPathResouce==null||urlPathResouce.equals("")==true){
		return ;
	}else{
		System.out.println("访问规则ID:"+urlPathResouce.getId());
		System.out.println("访问规则：\n是否允许匿名访问:"+urlPathResouce.getBuseByAnonymous());
		System.out.println("是否按点数:"+urlPathResouce.getBuseByDoc());
		System.out.println("是否按会员组:"+urlPathResouce.getBuseByMemberGrounp());
		System.out.println("是否按货币数:"+urlPathResouce.getBuseByMoney());
		
	}
	
	
		if(userSite!=null){
			
			//会员是否为空，
			//是否允许匿名访问,
			if(urlPathResouce.getBuseByAnonymous()!=null&&urlPathResouce.getBuseByAnonymous()==true){
				//通过请求
				return ;
				//未设置是否允许匿名访问时，默认通过
			}else if(urlPathResouce.getBuseByAnonymous()==null){
				return ;
			//不允许匿名用户访问该资源	
			}else if(urlPathResouce.getBuseByAnonymous()!=null&&urlPathResouce.getBuseByAnonymous()==false){
				//转用用户注册页，通知权限不够，同时提供用户注册表单，
				//在服务器端重定向,用户登录页面
				request.getRequestDispatcher("/system/noPermissionNoAynouslogin.jsp").forward(request,response); 
				return ;
			}
			////是否按会员组访问
			if(urlPathResouce.getBuseByMemberGrounp()!=null&&urlPathResouce.getBuseByMemberGrounp()){
				//其它会员组访问，默认两级，管理员组，会员组
				//匿名用户组访问控制
				 if(userSite.getUserType()==UserBeanInfo.UserType_RegUser){
					//网站管理员组
			     }else if(userSite.getUserType()==UserBeanInfo.UserType_Admin){
					
			     }else{
			    	 request.getRequestDispatcher("/system/noPermissionLowMembergrounp.jsp").forward(request,response);
			    	 return;
			     }
			}
			//是否按会员点数访问
			if(urlPathResouce.getBuseByDoc()!=null&&urlPathResouce.getBuseByDoc()){
				float memey=userSite.getMember().getMoney();
				
				double d=urlPathResouce.getMoneyPerUse();
				if(memey>d){
					//通过
					return ;
				}else{
					//提示金额不够
					request.getRequestDispatcher("/system/notPermissonNotDoc.jsp").forward(request,response); 
					return ;
				}
			
		
			}
			//是否按会员货币访问
			if(urlPathResouce.getBuseByMoney()!=null&&urlPathResouce.getBuseByMoney()){
				//在服务器端重定向,用户登录页面
				short pointUser=userSite.getMember().getPoint();
				int doc=urlPathResouce.getDocPerUse();
				if(pointUser>doc){
					//通过
					return ;
				}else{
					//提示点数不够
					request.getRequestDispatcher("/system/moneyPayNotError.jsp").forward(request,response); 
						return ;
				}
				
			}
			//是否按会员级别访问
			//其它访问控制实现
		
			//否注册会员
			
			//是否允许匿名访问
		}else if(userSite==null){
			//是否允许匿名访问
			if(urlPathResouce.getBuseByAnonymous()!=null&&urlPathResouce.getBuseByAnonymous()){
				//通过请求
				return ;
			}else{
				//要求会员注册
			}
		}
		
		
		

	

}
	/**
	 * @param args
	 */
	public static void main(String[] args) {
		// TODO Auto-generated method stub

	}

	

}
