package filter;

import java.io.IOException;
import java.util.List;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


import org.hibernate.SessionFactory;

import com.site.viewbean.UserBeanInfo;


import dao.Resoucelist;
import dao.Resoucelist;

import service.entryService.ResoucelistEntryService;
import service.entryService.ResourceEntryService;

/**
 * 用户操作网站时的权限和安全管理器
 * Servlet implementation class for Servlet: EncodeFilter
 *
 */
 public class PermissionFilter extends javax.servlet.http.HttpServlet implements javax.servlet.Filter {
   static final long serialVersionUID = 1L;
   
    /* (non-Java-doc)
	 * @see javax.servlet.http.HttpServlet#HttpServlet()
	 */
	public PermissionFilter() {
		super();
	}
/**
 * 对用户请求资源进行权限，安全的过滤
 * 功能：获取用户请求资源，分析资源路径，获取注册用户，
 * 根据资源路径访问要求的货币数，点数，会员组，判断是否通过用户请求，
 * 如果资源可匿名访问，直接通过，如果要求会员组，用户未注册，转到注册页，
 * 如果会员组级别不够，则
 */

	public void doFilter(ServletRequest request, ServletResponse response,
			FilterChain chain) throws IOException, ServletException {
		// TODO Auto-generated method stub
		HttpServletRequest httprequest=(HttpServletRequest)request;
		HttpServletResponse httpresponse=(HttpServletResponse)response;
		System.out.println("权限安全管理过滤器");
		System.out.println("query String:"+httprequest.getQueryString());
		System.out.println("url:"+httprequest.getRequestURL().toString());
	
		System.out.println("remote Host:"+httprequest.getRemoteHost());
		String urlRequest=httprequest.getRequestURL().toString();
		//URL参数
		String queryString=httprequest.getQueryString();
		if(queryString!=null&&queryString.equals("")==false){
			urlRequest=urlRequest+"?"+queryString;
		}
	
		 
		 //放行hibernate管理工具
		 if(urlRequest.indexOf("/tool/formConfig.jsp")!=-1){
				//下一过滤器		
				//chain.doFilter(request, response);
				 httprequest.getRequestDispatcher("/tool/formConfig.jsp").forward(httprequest, httpresponse);
				 return ;
		 }else if(urlRequest.indexOf("/tool/vieHibernate.jsp")!=-1){
				//下一过滤器		
				//chain.doFilter(request, response);
				 httprequest.getRequestDispatcher("/tool/vieHibernate.jsp").forward(httprequest, httpresponse);
				 return ;		
		 }else if(urlRequest.indexOf("/tool/loginHibernate.jsp")!=-1){
			
			 httprequest.getRequestDispatcher("/tool/loginHibernate.jsp").forward(httprequest, httpresponse);
			 return ;	
		 }else if(urlRequest.indexOf("/tool/hibernate.jsp")!=-1){
			
			 httprequest.getRequestDispatcher("/tool/hibernate.jsp").forward(httprequest, httpresponse);
			 return ;
		 }else if(urlRequest.indexOf("/tool/startApp.jsp")!=-1){
			
			 httprequest.getRequestDispatcher("/tool/startApp.jsp").forward(httprequest, httpresponse);
			 return ;
			 
		 }

		//获取请求资源路径 
		//测试hibernate是否正常启动
		//测试hibernate启动是否成功
		 SessionFactory sessionFactory=	null;
		  try {
			   
				sessionFactory=	 (SessionFactory) new InitialContext()
							.lookup("zsbacmsSessionFactory");
			
			  if(sessionFactory==null){				  
				  System.out.println("\nhibernate 未正常启动!");
					//hibernate 未成功启动，转到hibernate管理平台
						 httprequest.getRequestDispatcher("/tool/hibernate.jsp").forward(httprequest, httpresponse);
		
			  }else{
				
					String targetLogin="";
					String targetManage = "shopindexjsp";
					// 判断是否匿名用户 保存用户信息的session 变量
					HttpServletRequest requestHttp=(HttpServletRequest)request;
					mall.validaty.SessionValidaty sessionBean = mall.validaty.SessionValidaty
					.getInstance();
					UserBeanInfo userSite = sessionBean.getUserBeanInfoSession(requestHttp);
					
					//判断是否匿名用户 保存用户信息的session 变量		
					if(userSite==null){			
						userSite=new com.site.viewbean.UserBeanInfo();	
					userSite.setUserType(UserBeanInfo.UserType_Anonymous);			
					
					//将匿名用户保存到会话(session)中
					sessionBean.setUserBeanInfoSession(requestHttp, userSite);
					//访问用户
					
					}
					//对请求进行分析，过滤，跳转
					SaftePermissionFilterParseBean filterBean=SaftePermissionFilterParseBean.getInstance();
					
				//System.out.println("通过请求："+urlRequest);
					//下一过滤器		
				if(response.isCommitted()==false){
					chain.doFilter(request, response);
				}
										
			  }
			  
			  //异常处理
			} catch (NamingException e) {
				
				//数据库中间件启动失败
				if(sessionFactory==null){
					e.printStackTrace();
					System.out.println("\n IllegalStateException 异常 hibernate 未正常启动!");
					//设置项目安装路径
					 dao.SystemConfigApp configApp=new dao.SystemConfigApp();
					
					// configApp.setAppContext("/zsbacms");
					 request.setAttribute("SystemErrorInfo", e.getMessage());
					 httprequest.getSession(true).getServletContext().setAttribute("SystemConfigApp", configApp);
					 if(response.isCommitted()==false){
					//hibernate 未成功启动，转到hibernate管理平台
						 httprequest.getRequestDispatcher("/tool/hibernate.jsp").forward(httprequest, httpresponse);
						//httpresponse.flushBuffer();
						 //退出过虑器
						return ;
					 }
				}else{
					e.printStackTrace();
				}
		
					
			//throw new IllegalStateException(
					//	"Could not locate SessionFactory in JNDI");
			}catch(IOException e ){
				throw e;
			}catch(ServletException e){
				throw e;
			}
			catch(Exception e){
				e.printStackTrace();
				
			}
			


		
		
	}

	
	public void init(FilterConfig arg0) throws ServletException {
		// TODO Auto-generated method stub
		
	}   	

	}   	  	    
