package filter;

import java.io.IOException;

import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * 实现多个网站选择，类似apache WEB服务器功能，网站配置在tomcat等支持的数据库中。
 * 根据域名选择网站,进入目标网站
 */
 public class MoreSiteJumpFilter extends javax.servlet.http.HttpServlet implements javax.servlet.Filter {
   static final long serialVersionUID = 1L;
   
    /* (non-Java-doc)
	 * @see javax.servlet.http.HttpServlet#HttpServlet()
	 */
	public MoreSiteJumpFilter() {
		super();
	}

	@Override
	public void doFilter(ServletRequest request, ServletResponse response,
			FilterChain chain) throws IOException, ServletException {
		// TODO Auto-generated method stub
		
		HttpServletRequest httprequest=(HttpServletRequest)request;
		HttpServletResponse httpresponse=(HttpServletResponse)response;

        System.out.println("多网站访问控制过滤器");
        //解析网站真实地址
        //分析请求路径，获取网站列表，获取目标网站数据，返回
        //实现多站管理功能，类似虚拟主机管理
		System.out.println("query String:"+httprequest.getQueryString());
		System.out.println("url:"+httprequest.getRequestURL().toString());
		System.out.println("remote Host:"+httprequest.getRemoteHost());
		System.out.println("服务器端口 :"+httprequest.getRemoteHost());
		
		chain.doFilter(request, response);
		
		
		
	}

	@Override
	public void init(FilterConfig arg0) throws ServletException {
		// TODO Auto-generated method stub
		
	}   	

	}   	  	    
