package filter;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;

import com.site.viewbean.UserBeanInfo;



/**
 * 根据用户所在会员组信息，处理用户的系统请求
 * 对用户的权限配置进行分析，查看用户是否有权获取系统资源
 * 
 * @author Administrator
 *
 */
public class MemberGrounpPermissionFilterBean {
	private static MemberGrounpPermissionFilterBean instance;
	public static MemberGrounpPermissionFilterBean getInstance() {
		if(instance==null){
			instance=new MemberGrounpPermissionFilterBean();
			return instance;
		}else{
			return instance;
		}
		

	}
	/**
	 * 根据用户所属的会员组，分析用户请求是合法，仅当该资源路径存在于该用户的会员组时才为合法，
	 * @param urlPathResouce
	 * @param userSite
	 * @param request
	 * @param response
	 * @throws IOException
	 * @throws ServletException
	 */
	public void doFilter(dao.Resource urlPathResouce,UserBeanInfo userSite,ServletRequest request, ServletResponse response) throws IOException, ServletException {
		HttpServletResponse responseHttp=(HttpServletResponse)response;
		service.entryService.ResourceEntryService urlPathBean=service.entryService.ResourceEntryService.getInstance();
	boolean  b=	urlPathBean.checkRequestByMembergrounp(userSite,urlPathResouce);
	 if(b==true){
		 return ;
	 }else{
		 //无权限，非法操作
		 request.getRequestDispatcher("/system/noPermissionLowMembergrounp.jsp").forward(request,response);
    	 return;
	 }
	 }
	/**
	 * @param args
	 */
	public static void main(String[] args) {
		// TODO Auto-generated method stub

	}

}
