
 
package dao;

import java.util.List;
import javax.naming.InitialContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.LockMode;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Example;
import util.ObjectHome;
import java.util.List;


 /**
*功能：定义实体类基本操作：查询，添加，删除，修改
 * @author www.juuluu.org 逐龙juuluu
* tel:020-28983330 mobile:15975485229
 * email:wujavei@126.com  QQ:274390981
 * @see MallShopUser
 */
public class MallShopUserHome extends ObjectHome{

//<autoClassCode>



//comment

	private static final Log log = LogFactory.getLog(MallShopUserHome.class);

		//通过自创建方式使用session
		
	private final SessionFactory sessionFactory = getSessionFactory();
	
	//通过外部注入方式使用session
	
	private org.hibernate.Session sessionCurrent;
	
	public void setSessionCurrent(org.hibernate.Session sessionCurrent) {
		this.sessionCurrent = sessionCurrent;
	}
	
	public org.hibernate.Session getSessionCurrent() {
		return sessionCurrent;
	}
	
//del by validaty 

		//BatchDelete code 	
		
		//SaveAndGet 	
		
	//FindByClassName code 	 

	
	//Link code 	
	
	//BatchQuery code	//query code
public  MallShopUser getShopUserBySystemUserId( Long systemUserId0){
	log.debug("getting getShopUserBySystemUserId"); 
	try {
	 MallShopUser instances = (MallShopUser)this.sessionCurrent
	.createQuery("from dao.MallShopUser where systemUserId=:systemUserId0")
	.setParameter("systemUserId0", systemUserId0)
	.uniqueResult();
	if (instances == null) {
	log.debug("get successful, no instance found");
	} else {
	log.debug("get successful, instance found");
	}return instances;
	} catch (RuntimeException re) {
	log.error("get failed", re);
	throw re;}}
//query code
public List< MallShopUser> getListLikeByUserName( String userName0){
	log.debug("getting getListLikeByUserName"); 
	try {
	List< MallShopUser> instances =this.sessionCurrent
	.createQuery("from dao.MallShopUser where userName=:userName0")
	.setParameter("userName0", userName0)
	.list();
	if (instances == null) {
	log.debug("get successful, no instance found");
	} else {
	log.debug("get successful, instance found");
	}return instances;
	} catch (RuntimeException re) {
	log.error("get failed", re);
	throw re;}}
//query code
public List< MallShopUser> getListLikeByTel( Integer userTypeId0){
	log.debug("getting getListLikeByTel"); 
	try {
	List< MallShopUser> instances =this.sessionCurrent
	.createQuery("from dao.MallShopUser where userTypeId=:userTypeId0")
	.setParameter("userTypeId0", userTypeId0)
	.list();
	if (instances == null) {
	log.debug("get successful, no instance found");
	} else {
	log.debug("get successful, instance found");
	}return instances;
	} catch (RuntimeException re) {
	log.error("get failed", re);
	throw re;}}
//query code
public List< MallShopUser> getListByUserTypeId( Integer userTypeId0){
	log.debug("getting getListByUserTypeId"); 
	try {
	List< MallShopUser> instances =this.sessionCurrent
	.createQuery("from dao.MallShopUser where userTypeId=:userTypeId0 order by createTime desc")
	.setParameter("userTypeId0", userTypeId0)
	.list();
	if (instances == null) {
	log.debug("get successful, no instance found");
	} else {
	log.debug("get successful, instance found");
	}return instances;
	} catch (RuntimeException re) {
	log.error("get failed", re);
	throw re;}}
//query code
public List< MallShopUser> getListBySmallCatId( Integer smallCatId0){
	log.debug("getting getListBySmallCatId"); 
	try {
	List< MallShopUser> instances =this.sessionCurrent
	.createQuery("from dao.MallShopUser where smallCatId=:smallCatId0 order by createTime desc")
	.setParameter("smallCatId0", smallCatId0)
	.list();
	if (instances == null) {
	log.debug("get successful, no instance found");
	} else {
	log.debug("get successful, instance found");
	}return instances;
	} catch (RuntimeException re) {
	log.error("get failed", re);
	throw re;}}
//query code
public List< MallShopUser> getListByLikeCompanyName( String companyName0 ,int  maxResult){
	log.debug("getting getListByLikeCompanyName"); 
	try {
	List< MallShopUser> instances =this.sessionCurrent
	.createQuery("from dao.MallShopUser where companyName like :companyName0 order by createTime desc")
	.setParameter("companyName0", "%"+companyName0+"%")
 
.setMaxResults(maxResult) 	.list();
	if (instances == null) {
	log.debug("get successful, no instance found");
	} else {
	log.debug("get successful, instance found");
	}return instances;
	} catch (RuntimeException re) {
	log.error("get failed", re);
	throw re;}}
//query code
public List< MallShopUser> getListByMidServerCatId( Integer servicecatId0){
	log.debug("getting getListByMidServerCatId"); 
	try {
	List< MallShopUser> instances =this.sessionCurrent
	.createQuery("from dao.MallShopUser where servicecatId=:servicecatId0 order by updateTime")
	.setParameter("servicecatId0", servicecatId0)
	.list();
	if (instances == null) {
	log.debug("get successful, no instance found");
	} else {
	log.debug("get successful, instance found");
	}return instances;
	} catch (RuntimeException re) {
	log.error("get failed", re);
	throw re;}}
//query code
public List< MallShopUser> getListByViPType( String vipUserLevel0){
	log.debug("getting getListByViPType"); 
	try {
	List< MallShopUser> instances =this.sessionCurrent
	.createQuery("from dao.MallShopUser where vipUserLevel=:vipUserLevel0 order by updateTime desc")
	.setParameter("vipUserLevel0", vipUserLevel0)
	.list();
	if (instances == null) {
	log.debug("get successful, no instance found");
	} else {
	log.debug("get successful, instance found");
	}return instances;
	} catch (RuntimeException re) {
	log.error("get failed", re);
	throw re;}}
//query code
public List< MallShopUser> getListByBcheckBpassed( Boolean bchecked0, Boolean bpassed1){
	log.debug("getting getListByBcheckBpassed"); 
	try {
	List< MallShopUser> instances =this.sessionCurrent
	.createQuery("from dao.MallShopUser where bchecked=:bchecked0 and bpassed=:bpassed1 order by updateTime desc")
	.setParameter("bchecked0", bchecked0)
	.setParameter("bpassed1", bpassed1)
	.list();
	if (instances == null) {
	log.debug("get successful, no instance found");
	} else {
	log.debug("get successful, instance found");
	}return instances;
	} catch (RuntimeException re) {
	log.error("get failed", re);
	throw re;}}
//query code
public List< MallShopUser> getListByBcheckBpassedTimeLong( Boolean bchecked0, Boolean bpassed1, Long createTimeLong2){
	log.debug("getting getListByBcheckBpassedTimeLong"); 
	try {
	List< MallShopUser> instances =this.sessionCurrent
	.createQuery("from dao.MallShopUser where bchecked=:bchecked0 and bpassed=:bpassed1 and createTimeLong>=:createTimeLong2 order by updateTime desc")
	.setParameter("bchecked0", bchecked0)
	.setParameter("bpassed1", bpassed1)
	.setParameter("createTimeLong2", createTimeLong2)
	.list();
	if (instances == null) {
	log.debug("get successful, no instance found");
	} else {
	log.debug("get successful, instance found");
	}return instances;
	} catch (RuntimeException re) {
	log.error("get failed", re);
	throw re;}}
//query code
public List< MallShopUser> getListByLikeCmpname( String companyName0){
	log.debug("getting getListByLikeCmpname"); 
	try {
	List< MallShopUser> instances =this.sessionCurrent
	.createQuery("from dao.MallShopUser where companyName=:companyName0 order by createTime desc")
	.setParameter("companyName0", "%"+companyName0+"%")
	.list();
	if (instances == null) {
	log.debug("get successful, no instance found");
	} else {
	log.debug("get successful, instance found");
	}return instances;
	} catch (RuntimeException re) {
	log.error("get failed", re);
	throw re;}}
//query code
public List< MallShopUser> getListByLikeuserName( String userName0){
	log.debug("getting getListByLikeuserName"); 
	try {
	List< MallShopUser> instances =this.sessionCurrent
	.createQuery("from dao.MallShopUser where userName like :userName0 order by createTime desc")
	.setParameter("userName0", "%"+userName0+"%")
	.list();
	if (instances == null) {
	log.debug("get successful, no instance found");
	} else {
	log.debug("get successful, instance found");
	}return instances;
	} catch (RuntimeException re) {
	log.error("get failed", re);
	throw re;}}
//query code
public List< MallShopUser> getListByLikeTel( String tel0){
	log.debug("getting getListByLikeTel"); 
	try {
	List< MallShopUser> instances =this.sessionCurrent
	.createQuery("from dao.MallShopUser where tel like :tel0 order by createTime desc")
	.setParameter("tel0", "%"+tel0+"%")
	.list();
	if (instances == null) {
	log.debug("get successful, no instance found");
	} else {
	log.debug("get successful, instance found");
	}return instances;
	} catch (RuntimeException re) {
	log.error("get failed", re);
	throw re;}}

	
	//BatchSelect code 		
	
	
	public List<Object> getList(){
			try {
				 List<Object> list =  this.sessionCurrent
						.createQuery("from dao.MallShopUser order by createTime  desc").list();
				if (list == null) {
					log.debug("get successful, no instance found");
				} else {
					log.debug("get successful, instance found");
				}
				return list;
			} catch (RuntimeException re) {
				log.error("get failed", re);
				throw re;
			}
		}

	public List<MallShopUser> getListAll(){
			try {
				 List<MallShopUser> list =  this.sessionCurrent
						.createQuery("from dao.MallShopUser order by createTime  desc").list();
				if (list == null) {
					log.debug("get successful, no instance found");
				} else {
					log.debug("get successful, instance found");
				}
				return list;
			} catch (RuntimeException re) {
				log.error("get failed", re);
				throw re;
			}
		}
	
	
//home code 




	protected SessionFactory getSessionFactory() {
		try {
			return (SessionFactory) new InitialContext()
					.lookup("zsbacmsSessionFactory");
		} catch (java.lang.Exception e) {
			log.error("Could not locate SessionFactory in JNDI", e);
			throw new IllegalStateException(
					"Could not locate SessionFactory in JNDI");
		}
	}
//class persist
	public void persist(MallShopUser instance) {
            
		log.debug("persisting MallShopUser instance");
		try {
			this.sessionCurrent.persist(instance);
			log.debug("persist successful");
		} catch (RuntimeException re) {
			log.error("persist failed", re);
			throw re;
		}
	}

	public void persist(Object transientInstance) {
            MallShopUser instance=(MallShopUser )transientInstance;
		log.debug("persisting MallShopUser instance");
		try {
			this.sessionCurrent.persist(instance);
			log.debug("persist successful");
		} catch (RuntimeException re) {
			log.error("persist failed", re);
			throw re;
		}
	}

	public void attachDirty(MallShopUser instance) {
		log.debug("attaching dirty MallShopUser instance");
		try {
			this.sessionCurrent.saveOrUpdate(instance);
			log.debug("attach successful");
		} catch (RuntimeException re) {
			log.error("attach failed", re);
			throw re;
		}
	}

	public void attachClean(MallShopUser instance) {
		log.debug("attaching clean MallShopUser instance");
		try {
			this.sessionCurrent.lock(instance, LockMode.NONE);
			log.debug("attach successful");
		} catch (RuntimeException re) {
			log.error("attach failed", re);
			throw re;
		}
	}
// class delete
	public void delete(MallShopUser persistentInstance) {

		log.debug("deleting MallShopUser instance");
		try {
			this.sessionCurrent.delete(persistentInstance);
			log.debug("delete successful");
		} catch (RuntimeException re) {
			log.error("delete failed", re);
			throw re;
		}
	}

	public void delete(Object transientInstance) {
MallShopUser persistentInstance=(MallShopUser)transientInstance;
		log.debug("deleting MallShopUser instance");
		try {
		if(transientInstance!=null){
		this.sessionCurrent.delete(persistentInstance);
			log.debug("delete successful");
	
		}
				} catch (RuntimeException re) {
			log.error("delete failed", re);
			throw re;
		}
	}

//class merge
	public MallShopUser merge(MallShopUser  transientInstance) {

		//System.out.println("##################update projet");
		log.debug("merging MallShopUser instance");
		try {
			MallShopUser result = (MallShopUser) this.sessionCurrent
					.merge(transientInstance);
			log.debug("merge successful");
			return result;
		} catch (RuntimeException re) {
			log.error("merge failed", re);
			throw re;
		}
	}

	public MallShopUser merge(Object transientInstance) {
MallShopUser persistentInstance=(MallShopUser)transientInstance;
	//	System.out.println("##################update projet");
		log.debug("merging MallShopUser instance");
		try {
			MallShopUser result = (MallShopUser) this.sessionCurrent
					.merge(persistentInstance);
			log.debug("merge successful");
			return result;
		} catch (RuntimeException re) {
			log.error("merge failed", re);
			throw re;
		}
	}



	//取全部列表数据,返回object类型

		public List<Object> getListByMaxResult(int maxresult ) {
			try {
				 List<Object> list =  this.sessionCurrent
						.createQuery("from dao.MallShopUser")
						.setMaxResults(maxresult)
						.list();
				if (list == null) {
					log.debug("get successful, no instance found");
				} else {
					log.debug("get successful, instance found");
				}
				return list;
			} catch (RuntimeException re) {
				log.error("get failed", re);
				throw re;
			}
		
	}
	public List findByExample(MallShopUser instance) {
		log.debug("finding MallShopUser instance by example");
		try {
			List results = this.sessionCurrent.createCriteria(
					"dao.MallShopUser").add(Example.create(instance)).list();
			log.debug("find by example successful, result size: "
					+ results.size());
			return results;
		} catch (RuntimeException re) {
			log.error("find by example failed", re);
			throw re;
		}
	}
	//boy id
	public  MallShopUser findById(long id) {
		log.debug("getting MallShopUser instance with id: " + id);
		try {
			MallShopUser instance = (MallShopUser) this.sessionCurrent
					.get("dao.MallShopUser", id);
			if (instance == null) {
				log.debug("get successful, no instance found");
			} else {
				log.debug("get successful, instance found");
			}
			return instance;
		} catch (RuntimeException re) {
			log.error("get failed", re);
			throw re;
		}
	}

	public void delete(long id) {
        MallShopUser persistentInstance=findById(id);
		log.debug("deleting MallShopUser instance");
		try {
		
		if(persistentInstance!=null){
		this.sessionCurrent.delete(persistentInstance);
			
			log.debug("delete successful");
	
		}
				} catch (RuntimeException re) {
			log.error("delete failed", re);
			throw re;
		}
	}
	
public List<MallShopUser> getList_qeury(String sqlCondation, int max,
		String orderByValidaty, String orderType) {
	// TODO Auto-generated method stub
	try {
		
		 String hql="from dao.MallShopUser as e  where "+sqlCondation					;
		 	if(orderByValidaty!=null){
		 		hql=hql+" order by "+ orderByValidaty;
		 	}
		 	if(orderType!=null){
		 		hql =hql+ " "+orderType;
		 	}
		 List<MallShopUser> list =null;
		 
		 if(max!=-1){
			 list =  this.sessionCurrent
				.createQuery(hql)				
				.setMaxResults(max)
				.list();
		 }else{
			 list =  this.sessionCurrent
				.createQuery(hql)			
				//.setMaxResults(max)
				.list();
		 }
		if (list == null) {
			log.debug("get successful, no instance found");
		} else {
			log.debug("get successful, instance found");
		}
		return list;
	} catch (RuntimeException re) {
		log.error("get failed", re);
		throw re;
	}
}

public List<MallShopUser> getListMax(int max, String orderByValidaty,
		String orderType) {
	// TODO Auto-generated method stub
	try {
		
		 String hql="from dao.MallShopUser as e  "					;
		 	if(orderByValidaty!=null){
		 		hql=hql+" order by "+ orderByValidaty;
		 	}
		 	if(orderType!=null){
		 		hql =hql+ " "+orderType;
		 	}
		 List<MallShopUser> list =null;
		 
		 if(max!=-1){
			 list =  this.sessionCurrent
				.createQuery(hql)				
				.setMaxResults(max)
				.list();
		 }else{
			 list =  this.sessionCurrent
				.createQuery(hql)			
				//.setMaxResults(max)
				.list();
		 }
		if (list == null) {
			log.debug("get successful, no instance found");
		} else {
			log.debug("get successful, instance found");
		}
		return list;
	} catch (RuntimeException re) {
		log.error("get failed", re);
		throw re;
	}
}

public List<MallShopUser> getList_qeury_Byvalidaty(String vName,
		Object vValue, String condation,int max, String orderBy, String orderType) {
	// TODO Auto-generated method stub
	try {
		 List<MallShopUser> list = null;
		 String hql="from dao.MallShopUser as e where "
					+vName+" "+condation + " :"+vName;
		 	if(orderBy!=null){
		 		hql=hql+" order by "+ orderBy;
		 	}
		 	if(orderType!=null){
		 		hql =hql+ " "+orderType;
		 	}
		 if(max!=-1){
			 list =  this.sessionCurrent
				.createQuery(hql)
				.setParameter(vName, vValue)
				.setMaxResults(max)
				.list();
		 }else{
			 list =  this.sessionCurrent
				.createQuery(hql)
				.setParameter(vName, vValue)
				//.setMaxResults(max)
				.list();
		 }
		 
		if (list == null) {
			log.debug("get successful, no instance found");
		} else {
			log.debug("get successful, instance found");
		}
		return list;
	} catch (RuntimeException re) {
		log.error("get failed", re);
		throw re;
	}
}	
 
	
//your code<@YOURCODE>



 public static void main(String argv[]){
            util.DaoService ds= util.DaoService.getIntrance();
	
	  		MallShopUserHome home=new MallShopUserHome();
	
	  	//通过创建数据库会话方式
	  	org.hibernate.Transaction tx2=ds.openSession().beginTransaction();
	  	home.setSessionCurrent(ds.openSession());
       	System.out.println(home.getListAll());	 	
	    tx2.commit();
 }	
 


//</autoClassCode>
 
 

public List<MallShopUser> getListLikeByUserName_ex(String userName0) {
	// TODO Auto-generated method stub
	log.debug("getting getListLikeByTel"); 
	try {
	List< MallShopUser> instances =this.sessionCurrent
	.createQuery("from dao.MallShopUser where userName like :tel0")
	.setParameter("tel0", "%"+userName0 +"%")
	.list();
	if (instances == null) {
	log.debug("get successful, no instance found");
	} else {
	log.debug("get successful, instance found");
	}return instances;
	} catch (RuntimeException re) {
	log.error("get failed", re);
	throw re;}
	
}

public List<MallShopUser> getListLikeByTel_ex(String tel0) {
	// TODO Auto-generated method stub
	log.debug("getting getListLikeByTel"); 
	try {
	List< MallShopUser> instances =this.sessionCurrent
	.createQuery("from dao.MallShopUser where tel like :tel0")
	.setParameter("tel0", "%"+tel0 +"%")
	.list();
	if (instances == null) {
	log.debug("get successful, no instance found");
	} else {
	log.debug("get successful, instance found");
	}return instances;
	} catch (RuntimeException re) {
	log.error("get failed", re);
	throw re;}
}

public List<MallShopUser> getListLikeBycmpName_ex(String userName0) {
	// TODO Auto-generated method stub
	// TODO Auto-generated method stub
	log.debug("getting getListLikeByTel"); 
	try {
	List< MallShopUser> instances =this.sessionCurrent
	.createQuery("from dao.MallShopUser where companyName like :tel0")
	.setParameter("tel0", "%"+userName0 +"%")
	.list();
	if (instances == null) {
	log.debug("get successful, no instance found");
	} else {
	log.debug("get successful, instance found");
	}return instances;
	} catch (RuntimeException re) {
	log.error("get failed", re);
	throw re;}
}

public List<MallShopUser> getListLikeBymobile_ex(String tel0) {
	// TODO Auto-generated method stub
	log.debug("getting getListLikeByTel"); 
	try {
	List< MallShopUser> instances =this.sessionCurrent
	.createQuery("from dao.MallShopUser where mobile like :tel0")
	.setParameter("tel0", "%"+tel0 +"%")
	.list();
	if (instances == null) {
	log.debug("get successful, no instance found");
	} else {
	log.debug("get successful, instance found");
	}return instances;
	} catch (RuntimeException re) {
	log.error("get failed", re);
	throw re;}
}

public List<MallShopUser> getListHit(int max) {
	// TODO Auto-generated method stub
	log.debug("getting getListLikeByTel"); 
	try {
	List< MallShopUser> instances =this.sessionCurrent
	.createQuery("from dao.MallShopUser  order by hit desc")
	.setMaxResults(max)
	.list();
	if (instances == null) {
	log.debug("get successful, no instance found");
	} else {
	log.debug("get successful, instance found");
	}return instances;
	} catch (RuntimeException re) {
	log.error("get failed", re);
	throw re;}
}

public List<MallShopUser> getListNewtop(int max) {
	// TODO Auto-generated method stub
	log.debug("getting getListLikeByTel"); 
	try {
	List< MallShopUser> instances =this.sessionCurrent
	.createQuery("from dao.MallShopUser    order by createTime desc")
	.setMaxResults(max)
	.list();
	if (instances == null) {
	log.debug("get successful, no instance found");
	} else {
	log.debug("get successful, instance found");
	}return instances;
	} catch (RuntimeException re) {
	log.error("get failed", re);
	throw re;}
}
//

public List<MallShopUser> getListCommandTop(int max) {
	// TODO Auto-generated method stub
	log.debug("getting getListLikeByTel"); 
	try {
	List< MallShopUser> instances =this.sessionCurrent
	.createQuery("from dao.MallShopUser where bcommand =:bcommand   order by updateTime desc")
	.setParameter("bcommand", true)
	.setMaxResults(max)
	.list();
	if (instances == null) {
	log.debug("get successful, no instance found");
	} else {
	log.debug("get successful, instance found");
	}return instances;
	} catch (RuntimeException re) {
	log.error("get failed", re);
	throw re;}
}

public List<MallShopUser> getTopCmdListByUserTypeId(Integer userTypeId0, int max) {
	// TODO Auto-generated method stub
	log.debug("getting getListLikeByTel"); 
	try {
	List< MallShopUser> instances =this.sessionCurrent
	
	.createQuery("from dao.MallShopUser where userTypeId=:userTypeId0  and bcommand =:bcommand order by updateTime desc")
	.setParameter("userTypeId0", userTypeId0)
	.setParameter("bcommand", true)
	.setMaxResults(max)
	.list();
	if (instances == null) {
	log.debug("get successful, no instance found");
	} else {
	log.debug("get successful, instance found");
	}return instances;
	} catch (RuntimeException re) {
	log.error("get failed", re);
	throw re;}
}

public List<MallShopUser> getTopCmdListBySmallCatId(Integer smallCatId0, int max) {
	// TODO Auto-generated method stub
	log.debug("getting getListLikeByTel"); 
	try {
	List< MallShopUser> instances =this.sessionCurrent
	.createQuery("from dao.MallShopUser where smallCatId=:smallCatId0  and bcommand =:bcommand order by createTime desc")
	.setParameter("smallCatId0", smallCatId0)
	.setParameter("bcommand", true)
	.setMaxResults(max)
	.list();
	if (instances == null) {
	log.debug("get successful, no instance found");
	} else {
	log.debug("get successful, instance found");
	}return instances;
	} catch (RuntimeException re) {
	log.error("get failed", re);
	throw re;}
}

public List<MallShopUser> getTopCmdListByMidServerCatId(Integer servicecatId0,
		int max) {
	// TODO Auto-generated method stub
	log.debug("getting getListLikeByTel"); 
	try {
	List< MallShopUser> instances =this.sessionCurrent
	.createQuery("from dao.MallShopUser where servicecatId=:servicecatId0  and bcommand =:bcommand   order by updateTime desc")
	.setParameter("bcommand", true)	
	.setParameter("servicecatId0", servicecatId0)
	.setMaxResults(max)
	.list();
	if (instances == null) {
	log.debug("get successful, no instance found");
	} else {
	log.debug("get successful, instance found");
	}return instances;
	} catch (RuntimeException re) {
	log.error("get failed", re);
	throw re;}
}	
 
	
}
