
package dao;

import java.util.List;

import util.DaoService;

import util.ObjectDao;

import util.ObjectHome;

import org.apache.commons.logging.Log;

import org.apache.commons.logging.LogFactory;


import dao.MallShopUser;

import dao.MallShopUserHome;

 /**
*功能：定义实体类基本操作事务抽象层：查询，添加，删除，修改
 * @author www.juuluu.org 逐龙juuluu
* tel:020-28983330 mobile:15975485229
 * email:wujavei@126.com  QQ:274390981
 * @see MallShopUser
*实现：java sdk 1.6 hibernate 3.0 struts 1.2.9	
 */
 

public class MallShopUserDao extends ObjectDao {

	//<autoClassCode>


	
		private static final org.apache.commons.logging.Log log = org.apache.commons.logging.LogFactory.getLog(MallShopUserHome.class);
	
	private ObjectHome objectHome=new MallShopUserHome();
	
	
	
	//BatchDelet  
	
	//del by validaty 
	
	//SaveAndGet 	
	
	//FindByClassName 	 
	
	//Link 	
	
	//BatchQuery 	//query code
public  MallShopUser getShopUserBySystemUserId( Long systemUserId0){
	DaoService ds=DaoService.getIntrance();
	org.hibernate.Session session=ds.openSession();
 	 org.hibernate.Transaction ts=session.beginTransaction();	MallShopUser 	queryData=null;

 	 try{

 	 MallShopUserHome home=(MallShopUserHome)getObjectHome();
	home.setSessionCurrent(session);
		queryData=home.getShopUserBySystemUserId( systemUserId0);
	 ts.commit();  
	  }catch(org.hibernate.AssertionFailure e){ 
	 e.printStackTrace();
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopUser.");
	 	log.error("dao error failed", e); 
	 	ts.rollback();
	 	}catch(java.lang.RuntimeException e){ 
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopUser."); 
	 	log.error("dao error failed", e);  
	 	e.printStackTrace();  
	 	ts.rollback();  
	 	}finally{  
	//关闭会话 
	ds.closeSession(); 
	 return queryData;  
	 }//end try
	 }//end
//query code
public List< MallShopUser> getListLikeByUserName( String userName0){
	DaoService ds=DaoService.getIntrance();
	org.hibernate.Session session=ds.openSession();
 	 org.hibernate.Transaction ts=session.beginTransaction();
	List< MallShopUser> 	queryData=null;

 	 try{

 	 MallShopUserHome home=(MallShopUserHome)getObjectHome();
	home.setSessionCurrent(session);
		queryData=home.getListLikeByUserName( userName0);
	 ts.commit();  
	  }catch(org.hibernate.AssertionFailure e){ 
	 e.printStackTrace();
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopUser.");
	 	log.error("dao error failed", e); 
	 	ts.rollback();
	 	}catch(java.lang.RuntimeException e){ 
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopUser."); 
	 	log.error("dao error failed", e);  
	 	e.printStackTrace();  
	 	ts.rollback();  
	 	}finally{  
	//关闭会话 
	ds.closeSession(); 
	 return queryData;  
	 }//end try
	 }//end
//query code
public List< MallShopUser> getListLikeByTel( Integer userTypeId0){
	DaoService ds=DaoService.getIntrance();
	org.hibernate.Session session=ds.openSession();
 	 org.hibernate.Transaction ts=session.beginTransaction();
	List< MallShopUser> 	queryData=null;

 	 try{

 	 MallShopUserHome home=(MallShopUserHome)getObjectHome();
	home.setSessionCurrent(session);
		queryData=home.getListLikeByTel( userTypeId0);
	 ts.commit();  
	  }catch(org.hibernate.AssertionFailure e){ 
	 e.printStackTrace();
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopUser.");
	 	log.error("dao error failed", e); 
	 	ts.rollback();
	 	}catch(java.lang.RuntimeException e){ 
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopUser."); 
	 	log.error("dao error failed", e);  
	 	e.printStackTrace();  
	 	ts.rollback();  
	 	}finally{  
	//关闭会话 
	ds.closeSession(); 
	 return queryData;  
	 }//end try
	 }//end
//query code
public List< MallShopUser> getListByUserTypeId( Integer userTypeId0){
	DaoService ds=DaoService.getIntrance();
	org.hibernate.Session session=ds.openSession();
 	 org.hibernate.Transaction ts=session.beginTransaction();
	List< MallShopUser> 	queryData=null;

 	 try{

 	 MallShopUserHome home=(MallShopUserHome)getObjectHome();
	home.setSessionCurrent(session);
		queryData=home.getListByUserTypeId( userTypeId0);
	 ts.commit();  
	  }catch(org.hibernate.AssertionFailure e){ 
	 e.printStackTrace();
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopUser.");
	 	log.error("dao error failed", e); 
	 	ts.rollback();
	 	}catch(java.lang.RuntimeException e){ 
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopUser."); 
	 	log.error("dao error failed", e);  
	 	e.printStackTrace();  
	 	ts.rollback();  
	 	}finally{  
	//关闭会话 
	ds.closeSession(); 
	 return queryData;  
	 }//end try
	 }//end
//query code
public List< MallShopUser> getListBySmallCatId( Integer smallCatId0){
	DaoService ds=DaoService.getIntrance();
	org.hibernate.Session session=ds.openSession();
 	 org.hibernate.Transaction ts=session.beginTransaction();
	List< MallShopUser> 	queryData=null;

 	 try{

 	 MallShopUserHome home=(MallShopUserHome)getObjectHome();
	home.setSessionCurrent(session);
		queryData=home.getListBySmallCatId( smallCatId0);
	 ts.commit();  
	  }catch(org.hibernate.AssertionFailure e){ 
	 e.printStackTrace();
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopUser.");
	 	log.error("dao error failed", e); 
	 	ts.rollback();
	 	}catch(java.lang.RuntimeException e){ 
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopUser."); 
	 	log.error("dao error failed", e);  
	 	e.printStackTrace();  
	 	ts.rollback();  
	 	}finally{  
	//关闭会话 
	ds.closeSession(); 
	 return queryData;  
	 }//end try
	 }//end
//query code
public List< MallShopUser> getListByLikeCompanyName( String companyName0 ,int  maxResult){
	DaoService ds=DaoService.getIntrance();
	org.hibernate.Session session=ds.openSession();
 	 org.hibernate.Transaction ts=session.beginTransaction();
	List< MallShopUser> 	queryData=null;

 	 try{

 	 MallShopUserHome home=(MallShopUserHome)getObjectHome();
	home.setSessionCurrent(session);
		queryData=home.getListByLikeCompanyName( companyName0 , maxResult);
	 ts.commit();  
	  }catch(org.hibernate.AssertionFailure e){ 
	 e.printStackTrace();
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopUser.");
	 	log.error("dao error failed", e); 
	 	ts.rollback();
	 	}catch(java.lang.RuntimeException e){ 
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopUser."); 
	 	log.error("dao error failed", e);  
	 	e.printStackTrace();  
	 	ts.rollback();  
	 	}finally{  
	//关闭会话 
	ds.closeSession(); 
	 return queryData;  
	 }//end try
	 }//end
//query code
public List< MallShopUser> getListByMidServerCatId( Integer servicecatId0){
	DaoService ds=DaoService.getIntrance();
	org.hibernate.Session session=ds.openSession();
 	 org.hibernate.Transaction ts=session.beginTransaction();
	List< MallShopUser> 	queryData=null;

 	 try{

 	 MallShopUserHome home=(MallShopUserHome)getObjectHome();
	home.setSessionCurrent(session);
		queryData=home.getListByMidServerCatId( servicecatId0);
	 ts.commit();  
	  }catch(org.hibernate.AssertionFailure e){ 
	 e.printStackTrace();
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopUser.");
	 	log.error("dao error failed", e); 
	 	ts.rollback();
	 	}catch(java.lang.RuntimeException e){ 
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopUser."); 
	 	log.error("dao error failed", e);  
	 	e.printStackTrace();  
	 	ts.rollback();  
	 	}finally{  
	//关闭会话 
	ds.closeSession(); 
	 return queryData;  
	 }//end try
	 }//end
//query code
public List< MallShopUser> getListByViPType( String vipUserLevel0){
	DaoService ds=DaoService.getIntrance();
	org.hibernate.Session session=ds.openSession();
 	 org.hibernate.Transaction ts=session.beginTransaction();
	List< MallShopUser> 	queryData=null;

 	 try{

 	 MallShopUserHome home=(MallShopUserHome)getObjectHome();
	home.setSessionCurrent(session);
		queryData=home.getListByViPType( vipUserLevel0);
	 ts.commit();  
	  }catch(org.hibernate.AssertionFailure e){ 
	 e.printStackTrace();
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopUser.");
	 	log.error("dao error failed", e); 
	 	ts.rollback();
	 	}catch(java.lang.RuntimeException e){ 
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopUser."); 
	 	log.error("dao error failed", e);  
	 	e.printStackTrace();  
	 	ts.rollback();  
	 	}finally{  
	//关闭会话 
	ds.closeSession(); 
	 return queryData;  
	 }//end try
	 }//end
//query code
public List< MallShopUser> getListByBcheckBpassed( Boolean bchecked0, Boolean bpassed1){
	DaoService ds=DaoService.getIntrance();
	org.hibernate.Session session=ds.openSession();
 	 org.hibernate.Transaction ts=session.beginTransaction();
	List< MallShopUser> 	queryData=null;

 	 try{

 	 MallShopUserHome home=(MallShopUserHome)getObjectHome();
	home.setSessionCurrent(session);
		queryData=home.getListByBcheckBpassed( bchecked0, bpassed1);
	 ts.commit();  
	  }catch(org.hibernate.AssertionFailure e){ 
	 e.printStackTrace();
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopUser.");
	 	log.error("dao error failed", e); 
	 	ts.rollback();
	 	}catch(java.lang.RuntimeException e){ 
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopUser."); 
	 	log.error("dao error failed", e);  
	 	e.printStackTrace();  
	 	ts.rollback();  
	 	}finally{  
	//关闭会话 
	ds.closeSession(); 
	 return queryData;  
	 }//end try
	 }//end
//query code
public List< MallShopUser> getListByBcheckBpassedTimeLong( Boolean bchecked0, Boolean bpassed1, Long createTimeLong2){
	DaoService ds=DaoService.getIntrance();
	org.hibernate.Session session=ds.openSession();
 	 org.hibernate.Transaction ts=session.beginTransaction();
	List< MallShopUser> 	queryData=null;

 	 try{

 	 MallShopUserHome home=(MallShopUserHome)getObjectHome();
	home.setSessionCurrent(session);
		queryData=home.getListByBcheckBpassedTimeLong( bchecked0, bpassed1, createTimeLong2);
	 ts.commit();  
	  }catch(org.hibernate.AssertionFailure e){ 
	 e.printStackTrace();
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopUser.");
	 	log.error("dao error failed", e); 
	 	ts.rollback();
	 	}catch(java.lang.RuntimeException e){ 
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopUser."); 
	 	log.error("dao error failed", e);  
	 	e.printStackTrace();  
	 	ts.rollback();  
	 	}finally{  
	//关闭会话 
	ds.closeSession(); 
	 return queryData;  
	 }//end try
	 }//end
//query code
public List< MallShopUser> getListByLikeCmpname( String companyName0){
	DaoService ds=DaoService.getIntrance();
	org.hibernate.Session session=ds.openSession();
 	 org.hibernate.Transaction ts=session.beginTransaction();
	List< MallShopUser> 	queryData=null;

 	 try{

 	 MallShopUserHome home=(MallShopUserHome)getObjectHome();
	home.setSessionCurrent(session);
		queryData=home.getListByLikeCmpname( companyName0);
	 ts.commit();  
	  }catch(org.hibernate.AssertionFailure e){ 
	 e.printStackTrace();
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopUser.");
	 	log.error("dao error failed", e); 
	 	ts.rollback();
	 	}catch(java.lang.RuntimeException e){ 
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopUser."); 
	 	log.error("dao error failed", e);  
	 	e.printStackTrace();  
	 	ts.rollback();  
	 	}finally{  
	//关闭会话 
	ds.closeSession(); 
	 return queryData;  
	 }//end try
	 }//end
//query code
public List< MallShopUser> getListByLikeuserName( String userName0){
	DaoService ds=DaoService.getIntrance();
	org.hibernate.Session session=ds.openSession();
 	 org.hibernate.Transaction ts=session.beginTransaction();
	List< MallShopUser> 	queryData=null;

 	 try{

 	 MallShopUserHome home=(MallShopUserHome)getObjectHome();
	home.setSessionCurrent(session);
		queryData=home.getListByLikeuserName( userName0);
	 ts.commit();  
	  }catch(org.hibernate.AssertionFailure e){ 
	 e.printStackTrace();
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopUser.");
	 	log.error("dao error failed", e); 
	 	ts.rollback();
	 	}catch(java.lang.RuntimeException e){ 
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopUser."); 
	 	log.error("dao error failed", e);  
	 	e.printStackTrace();  
	 	ts.rollback();  
	 	}finally{  
	//关闭会话 
	ds.closeSession(); 
	 return queryData;  
	 }//end try
	 }//end
//query code
public List< MallShopUser> getListByLikeTel( String tel0){
	DaoService ds=DaoService.getIntrance();
	org.hibernate.Session session=ds.openSession();
 	 org.hibernate.Transaction ts=session.beginTransaction();
	List< MallShopUser> 	queryData=null;

 	 try{

 	 MallShopUserHome home=(MallShopUserHome)getObjectHome();
	home.setSessionCurrent(session);
		queryData=home.getListByLikeTel( tel0);
	 ts.commit();  
	  }catch(org.hibernate.AssertionFailure e){ 
	 e.printStackTrace();
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopUser.");
	 	log.error("dao error failed", e); 
	 	ts.rollback();
	 	}catch(java.lang.RuntimeException e){ 
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopUser."); 
	 	log.error("dao error failed", e);  
	 	e.printStackTrace();  
	 	ts.rollback();  
	 	}finally{  
	//关闭会话 
	ds.closeSession(); 
	 return queryData;  
	 }//end try
	 }//end

	
	//BatchSelect  	
	
	
	
	//取全部数据
	
		public List<MallShopUser> getListAll(){
		
		List<MallShopUser> list=null;
		
		DaoService ds=DaoService.getIntrance();
org.hibernate.Session session=ds.openSession();
org.hibernate.Transaction ts=session.beginTransaction();
try{
	    	
		
		//设置数据库会话
		
		MallShopUserHome home=((MallShopUserHome)getObjectHome());
		
		home.setSessionCurrent(session);
		
		MallShopUserHome beanHome=(MallShopUserHome)getObjectHome();
		
		list=beanHome.getListAll();
		
			ts.commit();
			
			
}catch(org.hibernate.AssertionFailure e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopUser");
			log.error("dao error failed", e);
			//事务回滚
			ts.rollback();
		}catch(java.lang.RuntimeException e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopUser");
			log.error("dao error failed", e);
			//事务回滚
			ts.rollback();
		}finally{
	    		//关闭会话
	    		ds.closeSession();return list;
		}//end try

	}
	
	public List<Object> getList(){
	
	List<Object> list=null;
	
	DaoService ds=DaoService.getIntrance();
org.hibernate.Session session=ds.openSession();
org.hibernate.Transaction ts=session.beginTransaction();
try{
	    	
				//设置数据库会话
		MallShopUserHome home=((MallShopUserHome)getObjectHome());
		home.setSessionCurrent(session);
		list=getObjectHome().getList();
	ts.commit();
			
}catch(org.hibernate.AssertionFailure e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopUser");
			log.error("dao error failed", e);
			//事务回滚
			ts.rollback();
		}catch(java.lang.RuntimeException e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopUser");
			log.error("dao error failed", e);
			//事务回滚
			ts.rollback();
		}finally{
	    		//关闭会话
	    		ds.closeSession();return list;
		}//end try

	}
	
	
  public void update(Object object ){
	  DaoService ds=DaoService.getIntrance();
org.hibernate.Session session=ds.openSession();
org.hibernate.Transaction ts=session.beginTransaction();
try{
	    	
				//设置数据库会话
		MallShopUserHome home=((MallShopUserHome)getObjectHome());
		home.setSessionCurrent(session);
		getObjectHome().merge(   object) ;
		ts.commit();
			
}catch(org.hibernate.AssertionFailure e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopUser");
			log.error("dao error failed", e);
			//事务回滚
			ts.rollback();
		}catch(java.lang.RuntimeException e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopUser");
			log.error("dao error failed", e);
			//事务回滚
			ts.rollback();
		}finally{
	    		//关闭会话
	    		ds.closeSession();
		}//end try

	}
  public void update(MallShopUser  object ){
	  DaoService ds=DaoService.getIntrance();
org.hibernate.Session session=ds.openSession();
org.hibernate.Transaction ts=session.beginTransaction();
try{
	    	
				//设置数据库会话
		MallShopUserHome home=((MallShopUserHome)getObjectHome());
		home.setSessionCurrent(session);
		getObjectHome().merge(   object) ;
	ts.commit();
			
}catch(org.hibernate.AssertionFailure e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopUser");
			log.error("dao error failed", e);
			//事务回滚
			ts.rollback();
		}catch(java.lang.RuntimeException e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopUser");
			log.error("dao error failed", e);
			//事务回滚
			ts.rollback();
		}finally{
	    		//关闭会话
	    		ds.closeSession();
		}//end try

	}
	    public void add(MallShopUser object ){
	    DaoService ds=DaoService.getIntrance();
org.hibernate.Session session=ds.openSession();
org.hibernate.Transaction ts=session.beginTransaction();
try{
	    	
					//设置数据库会话
		MallShopUserHome home=((MallShopUserHome)getObjectHome());
		home.setSessionCurrent(session);
			getObjectHome().persist(object) ;
			
						//刷新hibernate缓存，保存最新对象
			session.flush();
			//将对象从session中逐出，即session的EntityEntries属性中逐出
			session.evict(object);
			//提交事务
			ts.commit();
			
}catch(org.hibernate.AssertionFailure e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopUser");
			log.error("dao error failed", e);
			//事务回滚
			ts.rollback();
		}catch(java.lang.RuntimeException e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopUser");
			log.error("dao error failed", e);
			//事务回滚
			ts.rollback();
		}finally{
	    		//关闭会话
	    		ds.closeSession();
		}//end try

		}
	    public void add(Object object ){
	    DaoService ds=DaoService.getIntrance();
org.hibernate.Session session=ds.openSession();
org.hibernate.Transaction ts=session.beginTransaction();
try{
	    	
					//设置数据库会话
		MallShopUserHome home=((MallShopUserHome)getObjectHome());
		home.setSessionCurrent(session);
			getObjectHome().persist(object) ;
			//刷新hibernate缓存，保存最新对象
			session.flush();
			//将对象从session中逐出，即session的EntityEntries属性中逐出
			session.evict(object);
			//提交事务
			
			ts.commit();
			
}catch(org.hibernate.AssertionFailure e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopUser");
			log.error("dao error failed", e);
			//事务回滚
			ts.rollback();
		}catch(java.lang.RuntimeException e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopUser");
			log.error("dao error failed", e);
			//事务回滚
			ts.rollback();
		}finally{
	    		//关闭会话
	    		ds.closeSession();
		}//end try

		}
  public void delete(MallShopUser  object ){
  DaoService ds=DaoService.getIntrance();
org.hibernate.Session session=ds.openSession();
org.hibernate.Transaction ts=session.beginTransaction();
try{
	    	
				//设置数据库会话
		MallShopUserHome home=((MallShopUserHome)getObjectHome());
		home.setSessionCurrent(session);
		getObjectHome().delete( object) ;
		ts.commit();
			
}catch(org.hibernate.AssertionFailure e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopUser");
			log.error("dao error failed", e);
			//事务回滚
			ts.rollback();
		}catch(java.lang.RuntimeException e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopUser");
			log.error("dao error failed", e);
			//事务回滚
			ts.rollback();
		}finally{
	    		//关闭会话
	    		ds.closeSession();
		}//end try

		
	}

  public void delete(Object object ){
  DaoService ds=DaoService.getIntrance();
org.hibernate.Session session=ds.openSession();
org.hibernate.Transaction ts=session.beginTransaction();
try{
	    	
				//设置数据库会话
		MallShopUserHome home=((MallShopUserHome)getObjectHome());
		home.setSessionCurrent(session);
		getObjectHome().delete( object) ;
		ts.commit();
		
}catch(org.hibernate.AssertionFailure e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopUser");
			log.error("dao error failed", e);
			//事务回滚
			ts.rollback();
		}catch(java.lang.RuntimeException e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopUser");
			log.error("dao error failed", e);
			//事务回滚
			ts.rollback();
		}finally{
	    		//关闭会话
	    		ds.closeSession();
		}//end try

	}
  	public MallShopUser merge(MallShopUser Instance) {
  	MallShopUser Instances=null;
  	DaoService ds=DaoService.getIntrance();
org.hibernate.Session session=ds.openSession();
org.hibernate.Transaction ts=session.beginTransaction();
try{
	    	
				//设置数据库会话
		MallShopUserHome home=((MallShopUserHome)getObjectHome());
		home.setSessionCurrent(session);
		Instances=((MallShopUserHome)getObjectHome()).merge(   Instance) ;
			//刷新hibernate缓存，保存最新对象
			session.flush();
			//将对象从session中逐出，即session的EntityEntries属性中逐出
			session.evict(Instance);
			//提交事务
			ts.commit();
			
}catch(org.hibernate.AssertionFailure e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopUser");
			log.error("dao error failed", e);
			//事务回滚
			ts.rollback();
		}catch(java.lang.RuntimeException e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopUser");
			log.error("dao error failed", e);
			//事务回滚
			ts.rollback();
		}finally{
	    		//关闭会话
	    		ds.closeSession();return Instances;
		}//end try

	}
	public Object merge(Object transientInstance) {
	DaoService ds=DaoService.getIntrance();
org.hibernate.Session session=ds.openSession();
org.hibernate.Transaction ts=session.beginTransaction();
try{
	    		
				//设置数据库会话
		MallShopUserHome home=((MallShopUserHome)getObjectHome());
		home.setSessionCurrent(session);
			
		transientInstance=getObjectHome().merge(   transientInstance) ;
		  	//刷新hibernate缓存，保存最新对象
			session.flush();
			//将对象从session中逐出，即session的EntityEntries属性中逐出
			session.evict(transientInstance);
			//提交事务
		  	ts.commit();
			}catch(org.hibernate.AssertionFailure e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopUser");
			log.error("dao error failed", e);
			//事务回滚
			ts.rollback();
		}catch(java.lang.RuntimeException e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopUser");
			log.error("dao error failed", e);
			//事务回滚
			ts.rollback();
		}finally{
	    		//关闭会话
	    		ds.closeSession();return transientInstance;
		}//end try
	}

		public void setObjectHome(ObjectHome objectHome) {
			this.objectHome = objectHome;
		}

		public ObjectHome getObjectHome() {
			return this.objectHome;
		} 
		
		//id删除对象
	    public void delete(long id){
	    DaoService ds=DaoService.getIntrance();
org.hibernate.Session session=ds.openSession();
org.hibernate.Transaction ts=session.beginTransaction();
try{
	    	
	    			//设置数据库会话
		MallShopUserHome home=((MallShopUserHome)getObjectHome());
		home.setSessionCurrent(session);	
	    		getObjectHome().delete(id) ;
	  	  	ts.commit();
			
}catch(org.hibernate.AssertionFailure e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopUser");
			log.error("dao error failed", e);
			//事务回滚
			ts.rollback();
		}catch(java.lang.RuntimeException e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopUser");
			log.error("dao error failed", e);
			//事务回滚
			ts.rollback();
		}finally{
	    		//关闭会话
	    		ds.closeSession();
		}//end try
	
	    		
	    	}
	    	//获取对象  
	  	 public  Object get(long id){
	  	 Object object =null;
	  	 DaoService ds=DaoService.getIntrance();
org.hibernate.Session session=ds.openSession();
org.hibernate.Transaction ts=session.beginTransaction();
try{
	    	
	  			//设置数据库会话
		MallShopUserHome home=((MallShopUserHome)getObjectHome());
		home.setSessionCurrent(session);		
	  		object =getObjectHome().findById(id);
	  	ts.commit();
		}catch(org.hibernate.AssertionFailure e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopUser");
			log.error("dao error failed", e);
			//事务回滚
			ts.rollback();
		}catch(java.lang.RuntimeException e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopUser");
			log.error("dao error failed", e);
			//事务回滚
			ts.rollback();
		}finally{
	    		//关闭会话
	    		ds.closeSession();
			return object;
		}
	  		}
		//保存并获取包含对象ID实体对象
		
	
 public List<MallShopUser> getListMax(int max, String orderByValidaty,
			String orderType) {
		// TODO Auto-generated method stub
		List<MallShopUser> list=null;
		
		DaoService ds=DaoService.getIntrance();
		org.hibernate.Session session=ds.openSession();
		org.hibernate.Transaction ts=session.beginTransaction();
		try{
	    	
		
		//设置数据库会话
		
		MallShopUserHome home=((MallShopUserHome)getObjectHome());
		
		home.setSessionCurrent(session);
		
		MallShopUserHome beanHome=(MallShopUserHome)getObjectHome();
		
		list=beanHome.getListMax( max,  orderByValidaty,
				 orderType);
		
			ts.commit();
			
			
}catch(org.hibernate.AssertionFailure e){
	e.printStackTrace();
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopUser");
			log.error("dao error failed", e);
			//事务回滚
			ts.rollback();
		}catch(java.lang.RuntimeException e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopUser");
			log.error("dao error failed", e);
			e.printStackTrace();
			//事务回滚
			ts.rollback();
		}finally{
	    		//关闭会话
	    		ds.closeSession();return list;
		}//end try
	}

	public List<MallShopUser> getList_qeury(String sqlCondation, int max,
			String orderBy, String orderType) {
		// TODO Auto-generated method stub
		// TODO Auto-generated method stub
		List<MallShopUser> list=null;
		
		DaoService ds=DaoService.getIntrance();
		org.hibernate.Session session=ds.openSession();
		org.hibernate.Transaction ts=session.beginTransaction();
		try{
	    	
		
		//设置数据库会话
		
		MallShopUserHome home=((MallShopUserHome)getObjectHome());
		
		home.setSessionCurrent(session);
		
		MallShopUserHome beanHome=(MallShopUserHome)getObjectHome();
		
		list=beanHome.getList_qeury( sqlCondation,  max,
				 orderBy,  orderType);
		
			ts.commit();
			
			
}catch(org.hibernate.AssertionFailure e){
	e.printStackTrace();
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopUser");
			log.error("dao error failed", e);
			//事务回滚
			ts.rollback();
		}catch(java.lang.RuntimeException e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopUser");
			log.error("dao error failed", e);
			e.printStackTrace();
			//事务回滚
			ts.rollback();
		}finally{
	    		//关闭会话
	    		ds.closeSession();return list;
		}//end try
	}

	public List<MallShopUser> getList_qeury_Byvalidaty(String vName,
			Object vValue, String condation,int max, String orderBy, String orderType) {
		// TODO Auto-generated method stub
		// TODO Auto-generated method stub
		List<MallShopUser> list=null;
		
		DaoService ds=DaoService.getIntrance();
		org.hibernate.Session session=ds.openSession();
		org.hibernate.Transaction ts=session.beginTransaction();
		try{
	    	
		
		//设置数据库会话
		
		MallShopUserHome home=((MallShopUserHome)getObjectHome());
		
		home.setSessionCurrent(session);
		
		MallShopUserHome beanHome=(MallShopUserHome)getObjectHome();
		
		list=beanHome.getList_qeury_Byvalidaty(  vName,
				 vValue, condation, max,  orderBy,  orderType);
		
			ts.commit();
			
			
}catch(org.hibernate.AssertionFailure e){
	e.printStackTrace();
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopUser");
			log.error("dao error failed", e);
			//事务回滚
			ts.rollback();
		}catch(java.lang.RuntimeException e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopUser");
			log.error("dao error failed", e);
			e.printStackTrace();
			//事务回滚
			ts.rollback();
		}finally{
	    		//关闭会话
	    		ds.closeSession();return list;
		}//end try
	}	

//your code<@YOURCODE>

 public static void main(String argv[]){
           util.DaoService.getIntrance();
	  		MallShopUserDao daoMallShopUserDao=new MallShopUserDao();
	  		MallShopUser oMallShopUserDao=new MallShopUser ();
	  		oMallShopUserDao=daoMallShopUserDao.merge(oMallShopUserDao);
	  	 }
	  	 


//</autoClassCode>	  
 
 public List<MallShopUser> getListLikeByUserName_ex(String userName0) {
		// TODO Auto-generated method stub
	 DaoService ds=DaoService.getIntrance();
		org.hibernate.Session session=ds.openSession();
	 	 org.hibernate.Transaction ts=session.beginTransaction();
	 	 MallShopUserHome home=(MallShopUserHome)getObjectHome();
		home.setSessionCurrent(session);	List< MallShopUser> 	Instance=home.getListLikeByUserName_ex( userName0);
		ts.commit(); 
		  ds.close();
		return Instance;
	}
	public List<MallShopUser> getListLikeByTel_ex(String tel0) {
		// TODO Auto-generated method stub
		DaoService ds=DaoService.getIntrance();
		org.hibernate.Session session=ds.openSession();
	 	 org.hibernate.Transaction ts=session.beginTransaction();
	 	 MallShopUserHome home=(MallShopUserHome)getObjectHome();
		home.setSessionCurrent(session);	List< MallShopUser> 	Instance=home.getListLikeByTel_ex( tel0);
		ts.commit(); 
		  ds.close();
		return Instance;
	}
	public List<MallShopUser> getListLikeBycmpName_ex(String userName0) {
		// TODO Auto-generated method stub
		DaoService ds=DaoService.getIntrance();
		org.hibernate.Session session=ds.openSession();
	 	 org.hibernate.Transaction ts=session.beginTransaction();
	 	 MallShopUserHome home=(MallShopUserHome)getObjectHome();
		home.setSessionCurrent(session);	List< MallShopUser> 	Instance=home.getListLikeBycmpName_ex( userName0);
		ts.commit(); 
		  ds.close();
		return Instance;
	}
	public List<MallShopUser> getListLikeBymobile_ex(String tel0) {
		// TODO Auto-generated method stub
		DaoService ds=DaoService.getIntrance();
		org.hibernate.Session session=ds.openSession();
	 	 org.hibernate.Transaction ts=session.beginTransaction();
	 	 MallShopUserHome home=(MallShopUserHome)getObjectHome();
		home.setSessionCurrent(session);	List< MallShopUser> 	Instance=home.getListLikeBymobile_ex( tel0);
		ts.commit(); 
		  ds.close();
		return Instance;
	}
	public List<MallShopUser> getListHit(int max) {
		// TODO Auto-generated method stub
		DaoService ds=DaoService.getIntrance();
		org.hibernate.Session session=ds.openSession();
	 	 org.hibernate.Transaction ts=session.beginTransaction();
	 	 MallShopUserHome home=(MallShopUserHome)getObjectHome();
		home.setSessionCurrent(session);	List< MallShopUser> 	Instance=home.getListHit( max);
		ts.commit(); 
		  ds.close();
		return Instance;
	}
	public List<MallShopUser> getListNewtop(int max) {
		// TODO Auto-generated method stub
		DaoService ds=DaoService.getIntrance();
		org.hibernate.Session session=ds.openSession();
	 	 org.hibernate.Transaction ts=session.beginTransaction();
	 	 MallShopUserHome home=(MallShopUserHome)getObjectHome();
		home.setSessionCurrent(session);	List< MallShopUser> 	Instance=home.getListNewtop( max);
		ts.commit(); 
		  ds.close();
		return Instance;
	}
	public List<MallShopUser> getListCommandTop(int max) {
		// TODO Auto-generated method stub
		DaoService ds=DaoService.getIntrance();
		org.hibernate.Session session=ds.openSession();
	 	 org.hibernate.Transaction ts=session.beginTransaction();
	 	 MallShopUserHome home=(MallShopUserHome)getObjectHome();
		home.setSessionCurrent(session);	List< MallShopUser> 	Instance=home.getListCommandTop( max);
		ts.commit(); 
		  ds.close();
		return Instance;
	}
	public List<MallShopUser> getTopCmdListByUserTypeId(Integer userTypeId0,
			int max) {
		// TODO Auto-generated method stub
		DaoService ds=DaoService.getIntrance();
		org.hibernate.Session session=ds.openSession();
	 	 org.hibernate.Transaction ts=session.beginTransaction();
	 	 MallShopUserHome home=(MallShopUserHome)getObjectHome();
		home.setSessionCurrent(session);	List< MallShopUser> 	Instance=home.getTopCmdListByUserTypeId( userTypeId0,max);
		ts.commit(); 
		  ds.close();
		return Instance;
	}
	public List<MallShopUser> getTopCmdListBySmallCatId(Integer smallCatId0,
			int max) {
		// TODO Auto-generated method stub
		DaoService ds=DaoService.getIntrance();
		org.hibernate.Session session=ds.openSession();
	 	 org.hibernate.Transaction ts=session.beginTransaction();
	 	 MallShopUserHome home=(MallShopUserHome)getObjectHome();
		home.setSessionCurrent(session);	List< MallShopUser> 	Instance=home.getTopCmdListBySmallCatId( smallCatId0,max);
		ts.commit(); 
		  ds.close();
		return Instance;
	}
	public List<MallShopUser> getTopCmdListByMidServerCatId(
			Integer servicecatId0, int max) {
		// TODO Auto-generated method stub
		DaoService ds=DaoService.getIntrance();
		org.hibernate.Session session=ds.openSession();
	 	 org.hibernate.Transaction ts=session.beginTransaction();
	 	 MallShopUserHome home=(MallShopUserHome)getObjectHome();
		home.setSessionCurrent(session);	List< MallShopUser> 	Instance=home.getTopCmdListByMidServerCatId( servicecatId0,max);
		ts.commit(); 
		  ds.close();
		return Instance;
	}
}
