
 
package dao;

import java.util.List;
import javax.naming.InitialContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.LockMode;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Example;

import util.DaoService;
import util.ObjectHome;
import java.util.List;


 /**
*功能：定义实体类基本操作：查询，添加，删除，修改
 * @author www.juuluu.org 逐龙juuluu
* tel:020-28983330 mobile:15975485229
 * email:wujavei@126.com  QQ:274390981
 * @see MallShopProduct
 */
public class MallShopProductHome extends ObjectHome{

//<autoClassCode>



//comment

	private static final Log log = LogFactory.getLog(MallShopProductHome.class);

		//通过自创建方式使用session
		
	private final SessionFactory sessionFactory = getSessionFactory();
	
	//通过外部注入方式使用session
	
	private org.hibernate.Session sessionCurrent;
	
	public void setSessionCurrent(org.hibernate.Session sessionCurrent) {
		this.sessionCurrent = sessionCurrent;
	}
	
	public org.hibernate.Session getSessionCurrent() {
		return sessionCurrent;
	}
	
//del by validaty 

		//BatchDelete code 	
		
		//SaveAndGet 		//createHomeSaveAndGet

	/*****
	用于获取刚保存的对象,包含对象ID 适合级联更新情况.
	****/

public MallShopProduct persistAndGet(MallShopProduct  transientInstance) {

	long persistid=System.currentTimeMillis();

	transientInstance.setPersistId(persistid);

	//System.out.println("##################update projet");

	log.debug("merging MallShopProduct instance");

	try {
	 this.sessionCurrent.merge(transientInstance);

	MallShopProduct result =findByPersistId(persistid);

	log.debug("merge successful");

	//System.out.println("MallShopProduct merge(MallShopProduct  transientInstance):");

	return result;

	} catch (RuntimeException re) {

	log.error("merge failed", re);

	throw re;}
}

	//findByPersistId()

public  MallShopProduct findByPersistId(long id) {

	log.debug("getting MallShopProduct instance with id: " + id);

	try {
MallShopProduct instance = (MallShopProduct) this.sessionCurrent

	.createQuery("from dao.MallShopProduct where persistId=:id")

		.setParameter("id", id)	.uniqueResult();

	if (instance == null) {

	log.debug("get successful, no instance found");

	} else {

	}return instance;

	} catch (RuntimeException re) {

	log.error("get failed", re);

		throw re;
}
}


		
	//FindByClassName code 	 
	//createHomeFindByClassNameForCheck
public MallShopProduct findByName(  String name){
	log.debug("getting MallShopProduct instance with MallShopProductName: " + name);
	try {
	MallShopProduct instance = (MallShopProduct) sessionFactory.openSession()
	.createQuery("from dao.MallShopProduct where name=:name")
	.setParameter("name", name)
	.uniqueResult();
	if (instance == null) {
	log.debug("get successful, no instance found");
	} else {
	log.debug("get successful, instance found");
	}return instance;
	} catch (RuntimeException re) {
	log.error("get failed", re);
	throw re;}}

	
	//Link code 	
	
	//BatchQuery code	//query code
public List< MallShopProduct> getListDianPuCommandIndex( Boolean bdianpuIndexCommand0, Long dianpuId1 ,int  maxResult){
	log.debug("getting getListDianPuCommandIndex"); 
	try {
	List< MallShopProduct> instances =this.sessionCurrent
	.createQuery("from dao.MallShopProduct where bdianpuIndexCommand=:bdianpuIndexCommand0 and dianpuId=:dianpuId1 order by updateTime")
	.setParameter("bdianpuIndexCommand0", bdianpuIndexCommand0)
	.setParameter("dianpuId1", dianpuId1)
 
.setMaxResults(maxResult) 	.list();
	if (instances == null) {
	log.debug("get successful, no instance found");
	} else {
	log.debug("get successful, instance found");
	}return instances;
	} catch (RuntimeException re) {
	log.error("get failed", re);
	throw re;}}
//query code
public List< MallShopProduct> getListShopProductcatId( Integer catId0){
	log.debug("getting getListShopProductcatId"); 
	try {
	List< MallShopProduct> instances =this.sessionCurrent
	.createQuery("from dao.MallShopProduct where catId=:catId0 order by addTime")
	.setParameter("catId0", catId0)
	.list();
	if (instances == null) {
	log.debug("get successful, no instance found");
	} else {
	log.debug("get successful, instance found");
	}return instances;
	} catch (RuntimeException re) {
	log.error("get failed", re);
	throw re;}}
//query code
public List< MallShopProduct> getIndexTopCommand( Boolean bindexCommand0 ,int  maxResult){
	log.debug("getting getIndexTopCommand"); 
	try {
	List< MallShopProduct> instances =this.sessionCurrent
	.createQuery("from dao.MallShopProduct where bindexCommand=:bindexCommand0 order by updateTime desc")
	.setParameter("bindexCommand0", bindexCommand0)
 
.setMaxResults(maxResult) 	.list();
	if (instances == null) {
	log.debug("get successful, no instance found");
	} else {
	log.debug("get successful, instance found");
	}return instances;
	} catch (RuntimeException re) {
	log.error("get failed", re);
	throw re;}}
//query code
public List< MallShopProduct> queryListByScSpiderjob( Boolean bspider0, Integer scSpiderjobId1){
	log.debug("getting queryListByScSpiderjob"); 
	try {
	List< MallShopProduct> instances =this.sessionCurrent
	.createQuery("from dao.MallShopProduct where bspider=:bspider0 and scSpiderjobId=:scSpiderjobId1")
	.setParameter("bspider0", bspider0)
	.setParameter("scSpiderjobId1", scSpiderjobId1)
	.list();
	if (instances == null) {
	log.debug("get successful, no instance found");
	} else {
	log.debug("get successful, instance found");
	}return instances;
	} catch (RuntimeException re) {
	log.error("get failed", re);
	throw re;}}
//query code
public  MallShopProduct queryArticeBySpiderInfo( Boolean bspider0, Integer scSpiderjobId1, Integer scSpiderarticleId2){
	log.debug("getting queryArticeBySpiderInfo"); 
	try {
	 MallShopProduct instances = (MallShopProduct)this.sessionCurrent
	.createQuery("from dao.MallShopProduct where bspider=:bspider0 and scSpiderjobId=:scSpiderjobId1 and scSpiderarticleId=:scSpiderarticleId2")
	.setParameter("bspider0", bspider0)
	.setParameter("scSpiderjobId1", scSpiderjobId1)
	.setParameter("scSpiderarticleId2", scSpiderarticleId2)
	.uniqueResult();
	if (instances == null) {
	log.debug("get successful, no instance found");
	} else {
	log.debug("get successful, instance found");
	}return instances;
	} catch (RuntimeException re) {
	log.error("get failed", re);
	throw re;}}
//query code
public List< MallShopProduct> getCatCommandList( Integer catId0, Boolean bcatCommandChanelPage1 ,int  maxResult){
	log.debug("getting getCatCommandList"); 
	try {
	List< MallShopProduct> instances =this.sessionCurrent
	.createQuery("from dao.MallShopProduct where catId=:catId0 and bcatCommandChanelPage=:bcatCommandChanelPage1")
	.setParameter("catId0", catId0)
	.setParameter("bcatCommandChanelPage1", bcatCommandChanelPage1)
 
.setMaxResults(maxResult) 	.list();
	if (instances == null) {
	log.debug("get successful, no instance found");
	} else {
	log.debug("get successful, instance found");
	}return instances;
	} catch (RuntimeException re) {
	log.error("get failed", re);
	throw re;}}
//query code
public List< MallShopProduct> getLIstByCatId_Site( Integer catId0){
	log.debug("getting getLIstByCatId_Site"); 
	try {
	List< MallShopProduct> instances =this.sessionCurrent
	.createQuery("from dao.MallShopProduct where catId=:catId0 order by addTime")
	.setParameter("catId0", catId0)
	.list();
	if (instances == null) {
	log.debug("get successful, no instance found");
	} else {
	log.debug("get successful, instance found");
	}return instances;
	} catch (RuntimeException re) {
	log.error("get failed", re);
	throw re;}}
//query code
public List< MallShopProduct> getLIstByDpCatId_DianPu( Integer dianpuCatId0){
	log.debug("getting getLIstByDpCatId_DianPu"); 
	try {
	List< MallShopProduct> instances =this.sessionCurrent
	.createQuery("from dao.MallShopProduct where dianpuCatId=:dianpuCatId0 order by addTime")
	.setParameter("dianpuCatId0", dianpuCatId0)
	.list();
	if (instances == null) {
	log.debug("get successful, no instance found");
	} else {
	log.debug("get successful, instance found");
	}return instances;
	} catch (RuntimeException re) {
	log.error("get failed", re);
	throw re;}}
//query code
public List< MallShopProduct> getNewsTopByCatId_dianPu( Integer dianpuCatId0 ,int  maxResult){
	log.debug("getting getNewsTopByCatId_dianPu"); 
	try {
	List< MallShopProduct> instances =this.sessionCurrent
	.createQuery("from dao.MallShopProduct where dianpuCatId=:dianpuCatId0 order by addTime")
	.setParameter("dianpuCatId0", dianpuCatId0)
 
.setMaxResults(maxResult) 	.list();
	if (instances == null) {
	log.debug("get successful, no instance found");
	} else {
	log.debug("get successful, instance found");
	}return instances;
	} catch (RuntimeException re) {
	log.error("get failed", re);
	throw re;}}
//query code
public List< MallShopProduct> getListHotTopByCatId_dianPu( Integer dianpuCatId0 ,int  maxResult){
	log.debug("getting getListHotTopByCatId_dianPu"); 
	try {
	List< MallShopProduct> instances =this.sessionCurrent
	.createQuery("from dao.MallShopProduct where dianpuCatId=:dianpuCatId0 order by hot")
	.setParameter("dianpuCatId0", dianpuCatId0)
 
.setMaxResults(maxResult) 	.list();
	if (instances == null) {
	log.debug("get successful, no instance found");
	} else {
	log.debug("get successful, instance found");
	}return instances;
	} catch (RuntimeException re) {
	log.error("get failed", re);
	throw re;}}
//query code
public List< MallShopProduct> getListCmdTopByCatId_dianPu( Integer dianpuCatId0, Boolean bdianpuIndexCommand1 ,int  maxResult){
	log.debug("getting getListCmdTopByCatId_dianPu"); 
	try {
	List< MallShopProduct> instances =this.sessionCurrent
	.createQuery("from dao.MallShopProduct where dianpuCatId=:dianpuCatId0 and bdianpuIndexCommand=:bdianpuIndexCommand1 order by updateTime")
	.setParameter("dianpuCatId0", dianpuCatId0)
	.setParameter("bdianpuIndexCommand1", bdianpuIndexCommand1)
 
.setMaxResults(maxResult) 	.list();
	if (instances == null) {
	log.debug("get successful, no instance found");
	} else {
	log.debug("get successful, instance found");
	}return instances;
	} catch (RuntimeException re) {
	log.error("get failed", re);
	throw re;}}
//query code
public List< MallShopProduct> getListByCatId_DianpuID( Integer dianpuCatId0){
	log.debug("getting getListByCatId_DianpuID"); 
	try {
	List< MallShopProduct> instances =this.sessionCurrent
	.createQuery("from dao.MallShopProduct where dianpuCatId=:dianpuCatId0 order by addTime")
	.setParameter("dianpuCatId0", dianpuCatId0)
	.list();
	if (instances == null) {
	log.debug("get successful, no instance found");
	} else {
	log.debug("get successful, instance found");
	}return instances;
	} catch (RuntimeException re) {
	log.error("get failed", re);
	throw re;}}
//query code
public List< MallShopProduct> getListNewTopByDianPuId( Long dianpuId0 ,int  maxResult){
	log.debug("getting getListNewTopByDianPuId"); 
	try {
	List< MallShopProduct> instances =this.sessionCurrent
	.createQuery("from dao.MallShopProduct where dianpuId=:dianpuId0")
	.setParameter("dianpuId0", dianpuId0)
 
.setMaxResults(maxResult) 	.list();
	if (instances == null) {
	log.debug("get successful, no instance found");
	} else {
	log.debug("get successful, instance found");
	}return instances;
	} catch (RuntimeException re) {
	log.error("get failed", re);
	throw re;}}
//query code
public List< MallShopProduct> getListHotTopByDianPuId( Long dianpuId0 ,int  maxResult){
	log.debug("getting getListHotTopByDianPuId"); 
	try {
	List< MallShopProduct> instances =this.sessionCurrent
	.createQuery("from dao.MallShopProduct where dianpuId=:dianpuId0")
	.setParameter("dianpuId0", dianpuId0)
 
.setMaxResults(maxResult) 	.list();
	if (instances == null) {
	log.debug("get successful, no instance found");
	} else {
	log.debug("get successful, instance found");
	}return instances;
	} catch (RuntimeException re) {
	log.error("get failed", re);
	throw re;}}
//query code
public List< MallShopProduct> getListCmdtTopByDianPuId( Long dianpuId0, Boolean bdianpuIndexCommand1 ,int  maxResult){
	log.debug("getting getListCmdtTopByDianPuId"); 
	try {
	List< MallShopProduct> instances =this.sessionCurrent
	.createQuery("from dao.MallShopProduct where dianpuId=:dianpuId0 and bdianpuIndexCommand=:bdianpuIndexCommand1")
	.setParameter("dianpuId0", dianpuId0)
	.setParameter("bdianpuIndexCommand1", bdianpuIndexCommand1)
 
.setMaxResults(maxResult) 	.list();
	if (instances == null) {
	log.debug("get successful, no instance found");
	} else {
	log.debug("get successful, instance found");
	}return instances;
	} catch (RuntimeException re) {
	log.error("get failed", re);
	throw re;}}
//query code
public List< MallShopProduct> getGiftListByDianPuId( Boolean bgiftZhengPin0, Long dianpuId1){
	log.debug("getting getGiftListByDianPuId"); 
	try {
	List< MallShopProduct> instances =this.sessionCurrent
	.createQuery("from dao.MallShopProduct where bgiftZhengPin=:bgiftZhengPin0 and dianpuId=:dianpuId1 order by addTime")
	.setParameter("bgiftZhengPin0", bgiftZhengPin0)
	.setParameter("dianpuId1", dianpuId1)
	.list();
	if (instances == null) {
	log.debug("get successful, no instance found");
	} else {
	log.debug("get successful, instance found");
	}return instances;
	} catch (RuntimeException re) {
	log.error("get failed", re);
	throw re;}}
//query code
public List< MallShopProduct> getGiftListZhengPing( Boolean bgiftZhengPin0 ,int  maxResult){
	log.debug("getting getGiftListZhengPing"); 
	try {
	List< MallShopProduct> instances =this.sessionCurrent
	.createQuery("from dao.MallShopProduct where bgiftZhengPin=:bgiftZhengPin0 order by addTime")
	.setParameter("bgiftZhengPin0", bgiftZhengPin0)
 
.setMaxResults(maxResult) 	.list();
	if (instances == null) {
	log.debug("get successful, no instance found");
	} else {
	log.debug("get successful, instance found");
	}return instances;
	} catch (RuntimeException re) {
	log.error("get failed", re);
	throw re;}}
//query code
public List< MallShopProduct> getChuXiaoListTop( Boolean bpromoctionQuXiao0 ,int  maxResult){
	log.debug("getting getChuXiaoListTop"); 
	try {
	List< MallShopProduct> instances =this.sessionCurrent
	.createQuery("from dao.MallShopProduct where bpromoctionQuXiao=:bpromoctionQuXiao0 order by addTime")
	.setParameter("bpromoctionQuXiao0", bpromoctionQuXiao0)
 
.setMaxResults(maxResult) 	.list();
	if (instances == null) {
	log.debug("get successful, no instance found");
	} else {
	log.debug("get successful, instance found");
	}return instances;
	} catch (RuntimeException re) {
	log.error("get failed", re);
	throw re;}}
//query code
public List< MallShopProduct> getMainYouFeiListTop( Boolean bfreeShipiingMianYunFei0 ,int  maxResult){
	log.debug("getting getMainYouFeiListTop"); 
	try {
	List< MallShopProduct> instances =this.sessionCurrent
	.createQuery("from dao.MallShopProduct where bfreeShipiingMianYunFei=:bfreeShipiingMianYunFei0 order by addTime")
	.setParameter("bfreeShipiingMianYunFei0", bfreeShipiingMianYunFei0)
 
.setMaxResults(maxResult) 	.list();
	if (instances == null) {
	log.debug("get successful, no instance found");
	} else {
	log.debug("get successful, instance found");
	}return instances;
	} catch (RuntimeException re) {
	log.error("get failed", re);
	throw re;}}
//query code
public List< MallShopProduct> getNewListTopBydianPuId( Long dianpuId0 ,int  maxResult){
	log.debug("getting getNewListTopBydianPuId"); 
	try {
	List< MallShopProduct> instances =this.sessionCurrent
	.createQuery("from dao.MallShopProduct where dianpuId=:dianpuId0 order by addTime")
	.setParameter("dianpuId0", dianpuId0)
 
.setMaxResults(maxResult) 	.list();
	if (instances == null) {
	log.debug("get successful, no instance found");
	} else {
	log.debug("get successful, instance found");
	}return instances;
	} catch (RuntimeException re) {
	log.error("get failed", re);
	throw re;}}
//query code
public List< MallShopProduct> geHotListTopBydianPuId( Long dianpuId0 ,int  maxResult){
	log.debug("getting geHotListTopBydianPuId"); 
	try {
	List< MallShopProduct> instances =this.sessionCurrent
	.createQuery("from dao.MallShopProduct where dianpuId=:dianpuId0 order by hot")
	.setParameter("dianpuId0", dianpuId0)
 
.setMaxResults(maxResult) 	.list();
	if (instances == null) {
	log.debug("get successful, no instance found");
	} else {
	log.debug("get successful, instance found");
	}return instances;
	} catch (RuntimeException re) {
	log.error("get failed", re);
	throw re;}}
//query code
public List< MallShopProduct> getListBGif_ZengPin( Boolean bgiftZhengPin0){
	log.debug("getting getListBGif_ZengPin"); 
	try {
	List< MallShopProduct> instances =this.sessionCurrent
	.createQuery("from dao.MallShopProduct where bgiftZhengPin=:bgiftZhengPin0 order by addTime")
	.setParameter("bgiftZhengPin0", bgiftZhengPin0)
	.list();
	if (instances == null) {
	log.debug("get successful, no instance found");
	} else {
	log.debug("get successful, instance found");
	}return instances;
	} catch (RuntimeException re) {
	log.error("get failed", re);
	throw re;}}
//query code
public List< MallShopProduct> getListBPromotion_ChuXiao( Boolean bpromoctionQuXiao0){
	log.debug("getting getListBPromotion_ChuXiao"); 
	try {
	List< MallShopProduct> instances =this.sessionCurrent
	.createQuery("from dao.MallShopProduct where bpromoctionQuXiao=:bpromoctionQuXiao0 order by addTime")
	.setParameter("bpromoctionQuXiao0", bpromoctionQuXiao0)
	.list();
	if (instances == null) {
	log.debug("get successful, no instance found");
	} else {
	log.debug("get successful, instance found");
	}return instances;
	} catch (RuntimeException re) {
	log.error("get failed", re);
	throw re;}}
//query code
public List< MallShopProduct> getListBFreeShipping_Mian_yunFei( Boolean bfreeShipiingMianYunFei0){
	log.debug("getting getListBFreeShipping_Mian_yunFei"); 
	try {
	List< MallShopProduct> instances =this.sessionCurrent
	.createQuery("from dao.MallShopProduct where bfreeShipiingMianYunFei=:bfreeShipiingMianYunFei0 order by addTime")
	.setParameter("bfreeShipiingMianYunFei0", bfreeShipiingMianYunFei0)
	.list();
	if (instances == null) {
	log.debug("get successful, no instance found");
	} else {
	log.debug("get successful, instance found");
	}return instances;
	} catch (RuntimeException re) {
	log.error("get failed", re);
	throw re;}}
//query code
public  MallShopProduct getProductByCatIdPinPaiIdBigIMGPath( Integer catId0, Integer pinPaiId1, String imgOnePath2){
	log.debug("getting getProductByCatIdPinPaiIdBigIMGPath"); 
	try {
	 MallShopProduct instances = (MallShopProduct)this.sessionCurrent
	.createQuery("from dao.MallShopProduct where catId=:catId0 and pinPaiId=:pinPaiId1 and imgOnePath=:imgOnePath2")
	.setParameter("catId0", catId0)
	.setParameter("pinPaiId1", pinPaiId1)
	.setParameter("imgOnePath2", imgOnePath2)
	.uniqueResult();
	if (instances == null) {
	log.debug("get successful, no instance found");
	} else {
	log.debug("get successful, instance found");
	}return instances;
	} catch (RuntimeException re) {
	log.error("get failed", re);
	throw re;}}
//query code
public List< MallShopProduct> getListByDpUserId( Long dianpuUserId0){
	log.debug("getting getListByDpUserId"); 
	try {
	List< MallShopProduct> instances =this.sessionCurrent
	.createQuery("from dao.MallShopProduct where dianpuUserId=:dianpuUserId0 order by addTime desc")
	.setParameter("dianpuUserId0", dianpuUserId0)
	.list();
	if (instances == null) {
	log.debug("get successful, no instance found");
	} else {
	log.debug("get successful, instance found");
	}return instances;
	} catch (RuntimeException re) {
	log.error("get failed", re);
	throw re;}}
//query code
public List< MallShopProduct> getListByDpId( Long dianpuId0){
	log.debug("getting getListByDpId"); 
	try {
	List< MallShopProduct> instances =this.sessionCurrent
	.createQuery("from dao.MallShopProduct where dianpuId=:dianpuId0 order by addTime desc")
	.setParameter("dianpuId0", dianpuId0)
	.list();
	if (instances == null) {
	log.debug("get successful, no instance found");
	} else {
	log.debug("get successful, instance found");
	}return instances;
	} catch (RuntimeException re) {
	log.error("get failed", re);
	throw re;}}
//query code
public List< MallShopProduct> getLisbByLikeProductName( String name0){
	log.debug("getting getLisbByLikeProductName"); 
	try {
	List< MallShopProduct> instances =this.sessionCurrent
	.createQuery("from dao.MallShopProduct where name like :name0 order by addTime desc")
	.setParameter("name0", "%"+name0+"%")
	.list();
	if (instances == null) {
	log.debug("get successful, no instance found");
	} else {
	log.debug("get successful, instance found");
	}return instances;
	} catch (RuntimeException re) {
	log.error("get failed", re);
	throw re;}}
//query code
public List< MallShopProduct> getListLikeBySalerUserName( String dianpuUserName0){
	log.debug("getting getListLikeBySalerUserName"); 
	try {
	List< MallShopProduct> instances =this.sessionCurrent
	.createQuery("from dao.MallShopProduct where dianpuUserName like :dianpuUserName0 order by addTime desc")
	.setParameter("dianpuUserName0", "%"+dianpuUserName0+"%")
	.list();
	if (instances == null) {
	log.debug("get successful, no instance found");
	} else {
	log.debug("get successful, instance found");
	}return instances;
	} catch (RuntimeException re) {
	log.error("get failed", re);
	throw re;}}
//query code
public List< MallShopProduct> getListLikeByCreditCtcTel( String creditContactUserPhone0){
	log.debug("getting getListLikeByCreditCtcTel"); 
	try {
	List< MallShopProduct> instances =this.sessionCurrent
	.createQuery("from dao.MallShopProduct where creditContactUserPhone like :creditContactUserPhone0 order by addTime desc")
	.setParameter("creditContactUserPhone0", "%"+creditContactUserPhone0+"%")
	.list();
	if (instances == null) {
	log.debug("get successful, no instance found");
	} else {
	log.debug("get successful, instance found");
	}return instances;
	} catch (RuntimeException re) {
	log.error("get failed", re);
	throw re;}}
//query code
public List< MallShopProduct> getListByPidIsNull( String piD0){
	log.debug("getting getListByPidIsNull"); 
	try {
	List< MallShopProduct> instances =this.sessionCurrent
	.createQuery("from dao.MallShopProduct where piD:piD0")
	.setParameter("piD0", piD0)
	.list();
	if (instances == null) {
	log.debug("get successful, no instance found");
	} else {
	log.debug("get successful, instance found");
	}return instances;
	} catch (RuntimeException re) {
	log.error("get failed", re);
	throw re;}}
//query code
public  MallShopProduct getProductByPidBianMa( String piD0){
	log.debug("getting getProductByPidBianMa"); 
	try {
	 MallShopProduct instances = (MallShopProduct)this.sessionCurrent
	.createQuery("from dao.MallShopProduct where piD=:piD0")
	.setParameter("piD0", piD0)
	.uniqueResult();
	if (instances == null) {
	log.debug("get successful, no instance found");
	} else {
	log.debug("get successful, instance found");
	}return instances;
	} catch (RuntimeException re) {
	log.error("get failed", re);
	throw re;}}
//query code
public List< MallShopProduct> getListLikeByCmpName( String creditCnCompanyName0 ,int  maxResult){
	log.debug("getting getListLikeByCmpName"); 
	try {
	List< MallShopProduct> instances =this.sessionCurrent
	.createQuery("from dao.MallShopProduct where creditCnCompanyName like :creditCnCompanyName0")
	.setParameter("creditCnCompanyName0", "%"+creditCnCompanyName0+"%")
 
.setMaxResults(maxResult) 	.list();
	if (instances == null) {
	log.debug("get successful, no instance found");
	} else {
	log.debug("get successful, instance found");
	}return instances;
	} catch (RuntimeException re) {
	log.error("get failed", re);
	throw re;}}
//query code
public List< MallShopProduct> getLisisPingZi( Boolean bpingZi0){
	log.debug("getting getLisisPingZi"); 
	try {
	List< MallShopProduct> instances =this.sessionCurrent
	.createQuery("from dao.MallShopProduct where bpingZi=:bpingZi0 order by addTime desc")
	.setParameter("bpingZi0", "%"+bpingZi0+"%")
	.list();
	if (instances == null) {
	log.debug("get successful, no instance found");
	} else {
	log.debug("get successful, instance found");
	}return instances;
	} catch (RuntimeException re) {
	log.error("get failed", re);
	throw re;}}
//query code
public List< MallShopProduct> getLisMyPingZiProduct( Long pingZiRenId0 ,int  maxResult){
	log.debug("getting getLisMyPingZiProduct"); 
	try {
	List< MallShopProduct> instances =this.sessionCurrent
	.createQuery("from dao.MallShopProduct where pingZiRenId=:pingZiRenId0 order by addTime desc")
	.setParameter("pingZiRenId0", "%"+pingZiRenId0+"%")
 
.setMaxResults(maxResult) 	.list();
	if (instances == null) {
	log.debug("get successful, no instance found");
	} else {
	log.debug("get successful, instance found");
	}return instances;
	} catch (RuntimeException re) {
	log.error("get failed", re);
	throw re;}}
//query code
public  MallShopProduct getProductByTiaoMa( String tiaomaID0){
	log.debug("getting getProductByTiaoMa"); 
	try {
	 MallShopProduct instances = (MallShopProduct)this.sessionCurrent
	.createQuery("from dao.MallShopProduct where tiaomaID=:tiaomaID0")
	.setParameter("tiaomaID0", tiaomaID0)
	.uniqueResult();
	if (instances == null) {
	log.debug("get successful, no instance found");
	} else {
	log.debug("get successful, instance found");
	}return instances;
	} catch (RuntimeException re) {
	log.error("get failed", re);
	throw re;}}

	
	//BatchSelect code 		
	
	
	public List<Object> getList(){
			try {
				 List<Object> list =  this.sessionCurrent
						.createQuery("from dao.MallShopProduct").list();
				if (list == null) {
					log.debug("get successful, no instance found");
				} else {
					log.debug("get successful, instance found");
				}
				return list;
			} catch (RuntimeException re) {
				log.error("get failed", re);
				throw re;
			}
		}

	public List<MallShopProduct> getListAll(){
			try {
				 List<MallShopProduct> list =  this.sessionCurrent
						.createQuery("from dao.MallShopProduct").list();
				if (list == null) {
					log.debug("get successful, no instance found");
				} else {
					log.debug("get successful, instance found");
				}
				return list;
			} catch (RuntimeException re) {
				log.error("get failed", re);
				throw re;
			}
		}
	
	
//home code 




	protected SessionFactory getSessionFactory() {
		try {
			return (SessionFactory) new InitialContext()
					.lookup("zsbacmsSessionFactory");
		} catch (java.lang.Exception e) {
			log.error("Could not locate SessionFactory in JNDI", e);
			throw new IllegalStateException(
					"Could not locate SessionFactory in JNDI");
		}
	}
//class persist
	public void persist(MallShopProduct instance) {
            
		log.debug("persisting MallShopProduct instance");
		try {
			this.sessionCurrent.persist(instance);
			log.debug("persist successful");
		} catch (RuntimeException re) {
			log.error("persist failed", re);
			throw re;
		}
	}

	public void persist(Object transientInstance) {
            MallShopProduct instance=(MallShopProduct )transientInstance;
		log.debug("persisting MallShopProduct instance");
		try {
			this.sessionCurrent.persist(instance);
			log.debug("persist successful");
		} catch (RuntimeException re) {
			log.error("persist failed", re);
			throw re;
		}
	}

	public void attachDirty(MallShopProduct instance) {
		log.debug("attaching dirty MallShopProduct instance");
		try {
			this.sessionCurrent.saveOrUpdate(instance);
			log.debug("attach successful");
		} catch (RuntimeException re) {
			log.error("attach failed", re);
			throw re;
		}
	}

	public void attachClean(MallShopProduct instance) {
		log.debug("attaching clean MallShopProduct instance");
		try {
			this.sessionCurrent.lock(instance, LockMode.NONE);
			log.debug("attach successful");
		} catch (RuntimeException re) {
			log.error("attach failed", re);
			throw re;
		}
	}
// class delete
	public void delete(MallShopProduct persistentInstance) {

		log.debug("deleting MallShopProduct instance");
		try {
			this.sessionCurrent.delete(persistentInstance);
			log.debug("delete successful");
		} catch (RuntimeException re) {
			log.error("delete failed", re);
			throw re;
		}
	}

	public void delete(Object transientInstance) {
MallShopProduct persistentInstance=(MallShopProduct)transientInstance;
		log.debug("deleting MallShopProduct instance");
		try {
		if(transientInstance!=null){
		this.sessionCurrent.delete(persistentInstance);
			log.debug("delete successful");
	
		}
				} catch (RuntimeException re) {
			log.error("delete failed", re);
			throw re;
		}
	}

//class merge
	public MallShopProduct merge(MallShopProduct  transientInstance) {

		//System.out.println("##################update projet");
		log.debug("merging MallShopProduct instance");
		try {
			MallShopProduct result = (MallShopProduct) this.sessionCurrent
					.merge(transientInstance);
			log.debug("merge successful");
			return result;
		} catch (RuntimeException re) {
			log.error("merge failed", re);
			throw re;
		}
	}

	public MallShopProduct merge(Object transientInstance) {
MallShopProduct persistentInstance=(MallShopProduct)transientInstance;
	//	System.out.println("##################update projet");
		log.debug("merging MallShopProduct instance");
		try {
			MallShopProduct result = (MallShopProduct) this.sessionCurrent
					.merge(persistentInstance);
			log.debug("merge successful");
			return result;
		} catch (RuntimeException re) {
			log.error("merge failed", re);
			throw re;
		}
	}



	//取全部列表数据,返回object类型

		public List<Object> getListByMaxResult(int maxresult ) {
			try {
				 List<Object> list =  this.sessionCurrent
						.createQuery("from dao.MallShopProduct")
						.setMaxResults(maxresult)
						.list();
				if (list == null) {
					log.debug("get successful, no instance found");
				} else {
					log.debug("get successful, instance found");
				}
				return list;
			} catch (RuntimeException re) {
				log.error("get failed", re);
				throw re;
			}
		
	}
	public List findByExample(MallShopProduct instance) {
		log.debug("finding MallShopProduct instance by example");
		try {
			List results = this.sessionCurrent.createCriteria(
					"dao.MallShopProduct").add(Example.create(instance)).list();
			log.debug("find by example successful, result size: "
					+ results.size());
			return results;
		} catch (RuntimeException re) {
			log.error("find by example failed", re);
			throw re;
		}
	}
	//boy id
	public  MallShopProduct findById(long id) {
		log.debug("getting MallShopProduct instance with id: " + id);
		try {
			MallShopProduct instance = (MallShopProduct) this.sessionCurrent
					.get("dao.MallShopProduct", id);
			if (instance == null) {
				log.debug("get successful, no instance found");
			} else {
				log.debug("get successful, instance found");
			}
			return instance;
		} catch (RuntimeException re) {
			log.error("get failed", re);
			throw re;
		}
	}

	public void delete(long id) {
        MallShopProduct persistentInstance=findById(id);
		log.debug("deleting MallShopProduct instance");
		try {
		
		if(persistentInstance!=null){
		this.sessionCurrent.delete(persistentInstance);
			
			log.debug("delete successful");
	
		}
				} catch (RuntimeException re) {
			log.error("delete failed", re);
			throw re;
		}
	}
	
public List<MallShopProduct> getList_qeury(String sqlCondation, int max,
		String orderByValidaty, String orderType) {
	// TODO Auto-generated method stub
	try {
		
		 String hql="from dao.MallShopProduct as e  where "+sqlCondation					;
		 	if(orderByValidaty!=null){
		 		hql=hql+" order by "+ orderByValidaty;
		 	}
		 	if(orderType!=null){
		 		hql =hql+ " "+orderType;
		 	}
		 List<MallShopProduct> list =null;
		 
		 if(max!=-1){
			 list =  this.sessionCurrent
				.createQuery(hql)				
				.setMaxResults(max)
				.list();
		 }else{
			 list =  this.sessionCurrent
				.createQuery(hql)			
				//.setMaxResults(max)
				.list();
		 }
		if (list == null) {
			log.debug("get successful, no instance found");
		} else {
			log.debug("get successful, instance found");
		}
		return list;
	} catch (RuntimeException re) {
		log.error("get failed", re);
		throw re;
	}
}

public List<MallShopProduct> getListMax(int max, String orderByValidaty,
		String orderType) {
	// TODO Auto-generated method stub
	try {
		
		 String hql="from dao.MallShopProduct as e  "					;
		 	if(orderByValidaty!=null){
		 		hql=hql+" order by "+ orderByValidaty;
		 	}
		 	if(orderType!=null){
		 		hql =hql+ " "+orderType;
		 	}
		 List<MallShopProduct> list =null;
		 
		 if(max!=-1){
			 list =  this.sessionCurrent
				.createQuery(hql)				
				.setMaxResults(max)
				.list();
		 }else{
			 list =  this.sessionCurrent
				.createQuery(hql)			
				//.setMaxResults(max)
				.list();
		 }
		if (list == null) {
			log.debug("get successful, no instance found");
		} else {
			log.debug("get successful, instance found");
		}
		return list;
	} catch (RuntimeException re) {
		log.error("get failed", re);
		throw re;
	}
}

public List<MallShopProduct> getList_qeury_Byvalidaty(String vName,
		Object vValue, String condation,int max, String orderBy, String orderType) {
	// TODO Auto-generated method stub
	try {
		 List<MallShopProduct> list = null;
		 String hql="from dao.MallShopProduct as e where "
					+vName+" "+condation + " :"+vName;
		 	if(orderBy!=null){
		 		hql=hql+" order by "+ orderBy;
		 	}
		 	if(orderType!=null){
		 		hql =hql+ " "+orderType;
		 	}
		 if(max!=-1){
			 list =  this.sessionCurrent
				.createQuery(hql)
				.setParameter(vName, vValue)
				.setMaxResults(max)
				.list();
		 }else{
			 list =  this.sessionCurrent
				.createQuery(hql)
				.setParameter(vName, vValue)
				//.setMaxResults(max)
				.list();
		 }
		 
		if (list == null) {
			log.debug("get successful, no instance found");
		} else {
			log.debug("get successful, instance found");
		}
		return list;
	} catch (RuntimeException re) {
		log.error("get failed", re);
		throw re;
	}
}	
 
	
//your code<@YOURCODE>



 public static void main(String argv[]){
            util.DaoService ds= util.DaoService.getIntrance();
	
	  		MallShopProductHome home=new MallShopProductHome();
	
	  	//通过创建数据库会话方式
	  	org.hibernate.Transaction tx2=ds.openSession().beginTransaction();
	  	home.setSessionCurrent(ds.openSession());
       	System.out.println(home.getListAll());	 	
	    tx2.commit();
 }	
 


//</autoClassCode>
 
 

 public List< MallShopProduct> getHostProductList( int  maxResult){
		
	 log.debug("getting geHotListTopBydianPuId"); 
		try {
		List< MallShopProduct> instances =this.sessionCurrent
		.createQuery("from dao.MallShopProduct order by hot desc")
		
	 
	.setMaxResults(maxResult) 	.list();
		if (instances == null) {
		log.debug("get successful, no instance found");
		} else {
		log.debug("get successful, instance found");
		}return instances;
		} catch (RuntimeException re) {
		log.error("get failed", re);
		throw re;}

	}

	public List< MallShopProduct> getNewProductLIst(int maxResult	){
		
		log.debug("getting geHotListTopBydianPuId"); 
		try {
		List< MallShopProduct> instances =this.sessionCurrent
		.createQuery("from dao.MallShopProduct   order by addTime desc")
			 
	.setMaxResults(maxResult) 	.list();
		if (instances == null) {
		log.debug("get successful, no instance found");
		} else {
		log.debug("get successful, instance found");
		}return instances;
		} catch (RuntimeException re) {
		log.error("get failed", re);
		throw re;}
	}
	
	//

	public List<MallShopProduct> searchListByProductNameKeywords( String key) {
		log.debug("getting geHotListTopBydianPuId"); 
		try {
		List< MallShopProduct> instances =this.sessionCurrent
		.createQuery("from dao.MallShopProduct where name like :key order by addTime desc")
		.setParameter("key", "%"+key+"%")
	 
			.list();
		if (instances == null) {
		log.debug("get successful, no instance found");
		} else {
		log.debug("get successful, instance found");
		}return instances;
		} catch (RuntimeException re) {
		log.error("get failed", re);
		throw re;}
	}
	
	
	public List< MallShopProduct> getListByPidIsNull_admin( ){
		log.debug("getting getListByPidIsNull"); 
		try {
		List< MallShopProduct> instances =this.sessionCurrent
		.createQuery("from dao.MallShopProduct where piD is null || piD=''")
		//.setParameter("piD0", piD0)
		.list();
		if (instances == null) {
		log.debug("get successful, no instance found");
		} else {
		log.debug("get successful, instance found");
		}return instances;
		} catch (RuntimeException re) {
			re.printStackTrace();
			
		log.error("get failed", re);
		throw re;
		}
		
	}

	public long minValidty(String validaty) {
		// TODO Auto-generated method stub
		log.debug("getting getListByPidIsNull"); 
		try {
			String hql="select min( e." +validaty +") from dao.MallShopProduct as e";
		Long r =(Long) this.sessionCurrent
		.createQuery(hql)
		//.setParameter("piD0", piD0)
		.uniqueResult();
		if (r == null) {
			r=0L;
			log.debug("get successful, no instance found");
		} else {
		log.debug("get successful, instance found");
		}
		return r;
		
		} catch (RuntimeException re) {
			re.printStackTrace();
			
		log.error("get failed", re);
		throw re;
		}
	}

	public long maxValidty(String validaty) {
		// TODO Auto-generated method stub
		// TODO Auto-generated method stub
				log.debug("getting getListByPidIsNull"); 
				try {
					String hql="select max( e." +validaty +" ) from dao.MallShopProduct as e";
				Long r =null;
				r=(	Long) this.sessionCurrent
				.createQuery(hql)
				.uniqueResult();
				//.setParameter("piD0", piD0)
			
				if (r == null) {
					r=0L;
					log.debug("get successful, no instance found");
				} else {
				log.debug("get successful, instance found");
				}
				return r;
				
				} catch (RuntimeException re) {
					re.printStackTrace();
					
				log.error("get failed", re);
				throw re;
				}
	}

	public long sumValidty(String validaty) {
		// TODO Auto-generated method stub
		log.debug("getting getListByPidIsNull"); 
		try {
			String hql="select sum( e." +validaty +") from dao.MallShopProduct as e ";
		Long r =(Long) this.sessionCurrent
		.createQuery(hql)
		//.setParameter("piD0", piD0)
		.uniqueResult();
		if (r == null) {
			r=0L;
			log.debug("get successful, no instance found");
		} else {
		log.debug("get successful, instance found");
		}
		return r;
		
		} catch (RuntimeException re) {
			re.printStackTrace();
			
		log.error("get failed", re);
		throw re;
		}
	}

	public Double avgValidty(String validaty) {
		// TODO Auto-generated method stub
		// TODO Auto-generated method stub
				log.debug("getting getListByPidIsNull"); 
				try {
					String hql="select avg( e." +validaty +" ) from dao.MallShopProduct as e";
				Double r =(Double) this.sessionCurrent
				.createQuery(hql)
				//.setParameter("piD0", piD0)
				.uniqueResult();
				if (r == null) {
					r=0.0;
					log.debug("get successful, no instance found");
				} else {
				log.debug("get successful, instance found");
				}
				return r;
				
				} catch (RuntimeException re) {
					re.printStackTrace();
					
				log.error("get failed", re);
				throw re;
				}
	}
	
	/**
	 public static void main(String argv[]){
         util.DaoService ds= util.DaoService.getIntrance();
         ds.startHibernate();
	  		MallShopProductHome home=new MallShopProductHome();
	
	  	//通过创建数据库会话方式
	  	org.hibernate.Transaction tx2=ds.openSession().beginTransaction();
	  	home.setSessionCurrent(ds.openSession());
    	System.out.println("max"+home.maxValidty("id")
    			+"min"+home.minValidty("id")
    			+"avg"+home.avgValidty("id")
    			+"sum"+home.sumValidty("id")
    			+"count"+home.countValidaty("id")
    			);	 	
	    tx2.commit();
	   
	}
	 **/
	public long countValidaty(String validaty) {
		// TODO Auto-generated method stub
		log.debug("getting getListByPidIsNull"); 
		try {
			String hql="select count( e." +validaty +") from dao.MallShopProduct as e ";
		Long r =(Long) this.sessionCurrent
		.createQuery(hql)
		//.setParameter("piD0", piD0)
		.uniqueResult();
		if (r == null) {
			r=0L;
			log.debug("get successful, no instance found");
		} else {
		log.debug("get successful, instance found");
		}
		return r;
		
		} catch (RuntimeException re) {
			re.printStackTrace();
			
		log.error("get failed", re);
		throw re;
		}
	}	
}
