
package dao;

import java.util.List;

import util.DaoService;

import util.ObjectDao;

import util.ObjectHome;

import org.apache.commons.logging.Log;

import org.apache.commons.logging.LogFactory;


import dao.MallShopProduct;

import dao.MallShopProductHome;

 /**
*功能：定义实体类基本操作事务抽象层：查询，添加，删除，修改
 * @author www.juuluu.org 逐龙juuluu
* tel:020-28983330 mobile:15975485229
 * email:wujavei@126.com  QQ:274390981
 * @see MallShopProduct
*实现：java sdk 1.6 hibernate 3.0 struts 1.2.9	
 */
 

public class MallShopProductDao extends ObjectDao {

	//<autoClassCode>


	
		private static final org.apache.commons.logging.Log log = org.apache.commons.logging.LogFactory.getLog(MallShopProductHome.class);
	
	private ObjectHome objectHome=new MallShopProductHome();
	
	
	
	//BatchDelet  
	
	//del by validaty 
	
	//SaveAndGet 	
public MallShopProduct persistAndGet(MallShopProduct transientInstance) {
	DaoService ds=DaoService.getIntrance();
	org.hibernate.Session session=ds.openSession();
 	 org.hibernate.Transaction ts=session.beginTransaction();
 	 MallShopProductHome home=(MallShopProductHome)getObjectHome();
 	home.setSessionCurrent(session);

 	 transientInstance=home.persistAndGet(   transientInstance) ;
	ts.commit(); 
	  ds.close();
	return transientInstance;
	}	

	
	//FindByClassName 	  
public boolean isExite(String name){
	if(findByName( name)==null){
	 return false;
		 }else{
	 return true;
	 }
	 }
	public MallShopProduct findByName(String name) {
	DaoService ds=DaoService.getIntrance();
	org.hibernate.Transaction ts=ds.beginTransaction();
	MallShopProductHome home=(MallShopProductHome)getObjectHome();
	MallShopProduct	Instance=home.findByName(name) ;
	ds.commitTransaction(ts);
	return Instance;
	}

	
	//Link 	
	
	//BatchQuery 	//query code
public List< MallShopProduct> getListDianPuCommandIndex( Boolean bdianpuIndexCommand0, Long dianpuId1 ,int  maxResult){
	DaoService ds=DaoService.getIntrance();
	org.hibernate.Session session=ds.openSession();
 	 org.hibernate.Transaction ts=session.beginTransaction();
	List< MallShopProduct> 	queryData=null;

 	 try{

 	 MallShopProductHome home=(MallShopProductHome)getObjectHome();
	home.setSessionCurrent(session);
		queryData=home.getListDianPuCommandIndex( bdianpuIndexCommand0, dianpuId1 , maxResult);
	 ts.commit();  
	  }catch(org.hibernate.AssertionFailure e){ 
	 e.printStackTrace();
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct.");
	 	log.error("dao error failed", e); 
	 	ts.rollback();
	 	}catch(java.lang.RuntimeException e){ 
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct."); 
	 	log.error("dao error failed", e);  
	 	e.printStackTrace();  
	 	ts.rollback();  
	 	}finally{  
	//关闭会话 
	ds.closeSession(); 
	 return queryData;  
	 }//end try
	 }//end
//query code
public List< MallShopProduct> getListShopProductcatId( Integer catId0){
	DaoService ds=DaoService.getIntrance();
	org.hibernate.Session session=ds.openSession();
 	 org.hibernate.Transaction ts=session.beginTransaction();
	List< MallShopProduct> 	queryData=null;

 	 try{

 	 MallShopProductHome home=(MallShopProductHome)getObjectHome();
	home.setSessionCurrent(session);
		queryData=home.getListShopProductcatId( catId0);
	 ts.commit();  
	  }catch(org.hibernate.AssertionFailure e){ 
	 e.printStackTrace();
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct.");
	 	log.error("dao error failed", e); 
	 	ts.rollback();
	 	}catch(java.lang.RuntimeException e){ 
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct."); 
	 	log.error("dao error failed", e);  
	 	e.printStackTrace();  
	 	ts.rollback();  
	 	}finally{  
	//关闭会话 
	ds.closeSession(); 
	 return queryData;  
	 }//end try
	 }//end
//query code
public List< MallShopProduct> getIndexTopCommand( Boolean bindexCommand0 ,int  maxResult){
	DaoService ds=DaoService.getIntrance();
	org.hibernate.Session session=ds.openSession();
 	 org.hibernate.Transaction ts=session.beginTransaction();
	List< MallShopProduct> 	queryData=null;

 	 try{

 	 MallShopProductHome home=(MallShopProductHome)getObjectHome();
	home.setSessionCurrent(session);
		queryData=home.getIndexTopCommand( bindexCommand0 , maxResult);
	 ts.commit();  
	  }catch(org.hibernate.AssertionFailure e){ 
	 e.printStackTrace();
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct.");
	 	log.error("dao error failed", e); 
	 	ts.rollback();
	 	}catch(java.lang.RuntimeException e){ 
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct."); 
	 	log.error("dao error failed", e);  
	 	e.printStackTrace();  
	 	ts.rollback();  
	 	}finally{  
	//关闭会话 
	ds.closeSession(); 
	 return queryData;  
	 }//end try
	 }//end
//query code
public List< MallShopProduct> queryListByScSpiderjob( Boolean bspider0, Integer scSpiderjobId1){
	DaoService ds=DaoService.getIntrance();
	org.hibernate.Session session=ds.openSession();
 	 org.hibernate.Transaction ts=session.beginTransaction();
	List< MallShopProduct> 	queryData=null;

 	 try{

 	 MallShopProductHome home=(MallShopProductHome)getObjectHome();
	home.setSessionCurrent(session);
		queryData=home.queryListByScSpiderjob( bspider0, scSpiderjobId1);
	 ts.commit();  
	  }catch(org.hibernate.AssertionFailure e){ 
	 e.printStackTrace();
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct.");
	 	log.error("dao error failed", e); 
	 	ts.rollback();
	 	}catch(java.lang.RuntimeException e){ 
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct."); 
	 	log.error("dao error failed", e);  
	 	e.printStackTrace();  
	 	ts.rollback();  
	 	}finally{  
	//关闭会话 
	ds.closeSession(); 
	 return queryData;  
	 }//end try
	 }//end
//query code
public  MallShopProduct queryArticeBySpiderInfo( Boolean bspider0, Integer scSpiderjobId1, Integer scSpiderarticleId2){
	DaoService ds=DaoService.getIntrance();
	org.hibernate.Session session=ds.openSession();
 	 org.hibernate.Transaction ts=session.beginTransaction();	MallShopProduct 	queryData=null;

 	 try{

 	 MallShopProductHome home=(MallShopProductHome)getObjectHome();
	home.setSessionCurrent(session);
		queryData=home.queryArticeBySpiderInfo( bspider0, scSpiderjobId1, scSpiderarticleId2);
	 ts.commit();  
	  }catch(org.hibernate.AssertionFailure e){ 
	 e.printStackTrace();
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct.");
	 	log.error("dao error failed", e); 
	 	ts.rollback();
	 	}catch(java.lang.RuntimeException e){ 
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct."); 
	 	log.error("dao error failed", e);  
	 	e.printStackTrace();  
	 	ts.rollback();  
	 	}finally{  
	//关闭会话 
	ds.closeSession(); 
	 return queryData;  
	 }//end try
	 }//end
//query code
public List< MallShopProduct> getCatCommandList( Integer catId0, Boolean bcatCommandChanelPage1 ,int  maxResult){
	DaoService ds=DaoService.getIntrance();
	org.hibernate.Session session=ds.openSession();
 	 org.hibernate.Transaction ts=session.beginTransaction();
	List< MallShopProduct> 	queryData=null;

 	 try{

 	 MallShopProductHome home=(MallShopProductHome)getObjectHome();
	home.setSessionCurrent(session);
		queryData=home.getCatCommandList( catId0, bcatCommandChanelPage1 , maxResult);
	 ts.commit();  
	  }catch(org.hibernate.AssertionFailure e){ 
	 e.printStackTrace();
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct.");
	 	log.error("dao error failed", e); 
	 	ts.rollback();
	 	}catch(java.lang.RuntimeException e){ 
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct."); 
	 	log.error("dao error failed", e);  
	 	e.printStackTrace();  
	 	ts.rollback();  
	 	}finally{  
	//关闭会话 
	ds.closeSession(); 
	 return queryData;  
	 }//end try
	 }//end
//query code
public List< MallShopProduct> getLIstByCatId_Site( Integer catId0){
	DaoService ds=DaoService.getIntrance();
	org.hibernate.Session session=ds.openSession();
 	 org.hibernate.Transaction ts=session.beginTransaction();
	List< MallShopProduct> 	queryData=null;

 	 try{

 	 MallShopProductHome home=(MallShopProductHome)getObjectHome();
	home.setSessionCurrent(session);
		queryData=home.getLIstByCatId_Site( catId0);
	 ts.commit();  
	  }catch(org.hibernate.AssertionFailure e){ 
	 e.printStackTrace();
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct.");
	 	log.error("dao error failed", e); 
	 	ts.rollback();
	 	}catch(java.lang.RuntimeException e){ 
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct."); 
	 	log.error("dao error failed", e);  
	 	e.printStackTrace();  
	 	ts.rollback();  
	 	}finally{  
	//关闭会话 
	ds.closeSession(); 
	 return queryData;  
	 }//end try
	 }//end
//query code
public List< MallShopProduct> getLIstByDpCatId_DianPu( Integer dianpuCatId0){
	DaoService ds=DaoService.getIntrance();
	org.hibernate.Session session=ds.openSession();
 	 org.hibernate.Transaction ts=session.beginTransaction();
	List< MallShopProduct> 	queryData=null;

 	 try{

 	 MallShopProductHome home=(MallShopProductHome)getObjectHome();
	home.setSessionCurrent(session);
		queryData=home.getLIstByDpCatId_DianPu( dianpuCatId0);
	 ts.commit();  
	  }catch(org.hibernate.AssertionFailure e){ 
	 e.printStackTrace();
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct.");
	 	log.error("dao error failed", e); 
	 	ts.rollback();
	 	}catch(java.lang.RuntimeException e){ 
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct."); 
	 	log.error("dao error failed", e);  
	 	e.printStackTrace();  
	 	ts.rollback();  
	 	}finally{  
	//关闭会话 
	ds.closeSession(); 
	 return queryData;  
	 }//end try
	 }//end
//query code
public List< MallShopProduct> getNewsTopByCatId_dianPu( Integer dianpuCatId0 ,int  maxResult){
	DaoService ds=DaoService.getIntrance();
	org.hibernate.Session session=ds.openSession();
 	 org.hibernate.Transaction ts=session.beginTransaction();
	List< MallShopProduct> 	queryData=null;

 	 try{

 	 MallShopProductHome home=(MallShopProductHome)getObjectHome();
	home.setSessionCurrent(session);
		queryData=home.getNewsTopByCatId_dianPu( dianpuCatId0 , maxResult);
	 ts.commit();  
	  }catch(org.hibernate.AssertionFailure e){ 
	 e.printStackTrace();
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct.");
	 	log.error("dao error failed", e); 
	 	ts.rollback();
	 	}catch(java.lang.RuntimeException e){ 
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct."); 
	 	log.error("dao error failed", e);  
	 	e.printStackTrace();  
	 	ts.rollback();  
	 	}finally{  
	//关闭会话 
	ds.closeSession(); 
	 return queryData;  
	 }//end try
	 }//end
//query code
public List< MallShopProduct> getListHotTopByCatId_dianPu( Integer dianpuCatId0 ,int  maxResult){
	DaoService ds=DaoService.getIntrance();
	org.hibernate.Session session=ds.openSession();
 	 org.hibernate.Transaction ts=session.beginTransaction();
	List< MallShopProduct> 	queryData=null;

 	 try{

 	 MallShopProductHome home=(MallShopProductHome)getObjectHome();
	home.setSessionCurrent(session);
		queryData=home.getListHotTopByCatId_dianPu( dianpuCatId0 , maxResult);
	 ts.commit();  
	  }catch(org.hibernate.AssertionFailure e){ 
	 e.printStackTrace();
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct.");
	 	log.error("dao error failed", e); 
	 	ts.rollback();
	 	}catch(java.lang.RuntimeException e){ 
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct."); 
	 	log.error("dao error failed", e);  
	 	e.printStackTrace();  
	 	ts.rollback();  
	 	}finally{  
	//关闭会话 
	ds.closeSession(); 
	 return queryData;  
	 }//end try
	 }//end
//query code
public List< MallShopProduct> getListCmdTopByCatId_dianPu( Integer dianpuCatId0, Boolean bdianpuIndexCommand1 ,int  maxResult){
	DaoService ds=DaoService.getIntrance();
	org.hibernate.Session session=ds.openSession();
 	 org.hibernate.Transaction ts=session.beginTransaction();
	List< MallShopProduct> 	queryData=null;

 	 try{

 	 MallShopProductHome home=(MallShopProductHome)getObjectHome();
	home.setSessionCurrent(session);
		queryData=home.getListCmdTopByCatId_dianPu( dianpuCatId0, bdianpuIndexCommand1 , maxResult);
	 ts.commit();  
	  }catch(org.hibernate.AssertionFailure e){ 
	 e.printStackTrace();
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct.");
	 	log.error("dao error failed", e); 
	 	ts.rollback();
	 	}catch(java.lang.RuntimeException e){ 
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct."); 
	 	log.error("dao error failed", e);  
	 	e.printStackTrace();  
	 	ts.rollback();  
	 	}finally{  
	//关闭会话 
	ds.closeSession(); 
	 return queryData;  
	 }//end try
	 }//end
//query code
public List< MallShopProduct> getListByCatId_DianpuID( Integer dianpuCatId0){
	DaoService ds=DaoService.getIntrance();
	org.hibernate.Session session=ds.openSession();
 	 org.hibernate.Transaction ts=session.beginTransaction();
	List< MallShopProduct> 	queryData=null;

 	 try{

 	 MallShopProductHome home=(MallShopProductHome)getObjectHome();
	home.setSessionCurrent(session);
		queryData=home.getListByCatId_DianpuID( dianpuCatId0);
	 ts.commit();  
	  }catch(org.hibernate.AssertionFailure e){ 
	 e.printStackTrace();
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct.");
	 	log.error("dao error failed", e); 
	 	ts.rollback();
	 	}catch(java.lang.RuntimeException e){ 
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct."); 
	 	log.error("dao error failed", e);  
	 	e.printStackTrace();  
	 	ts.rollback();  
	 	}finally{  
	//关闭会话 
	ds.closeSession(); 
	 return queryData;  
	 }//end try
	 }//end
//query code
public List< MallShopProduct> getListNewTopByDianPuId( Long dianpuId0 ,int  maxResult){
	DaoService ds=DaoService.getIntrance();
	org.hibernate.Session session=ds.openSession();
 	 org.hibernate.Transaction ts=session.beginTransaction();
	List< MallShopProduct> 	queryData=null;

 	 try{

 	 MallShopProductHome home=(MallShopProductHome)getObjectHome();
	home.setSessionCurrent(session);
		queryData=home.getListNewTopByDianPuId( dianpuId0 , maxResult);
	 ts.commit();  
	  }catch(org.hibernate.AssertionFailure e){ 
	 e.printStackTrace();
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct.");
	 	log.error("dao error failed", e); 
	 	ts.rollback();
	 	}catch(java.lang.RuntimeException e){ 
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct."); 
	 	log.error("dao error failed", e);  
	 	e.printStackTrace();  
	 	ts.rollback();  
	 	}finally{  
	//关闭会话 
	ds.closeSession(); 
	 return queryData;  
	 }//end try
	 }//end
//query code
public List< MallShopProduct> getListHotTopByDianPuId( Long dianpuId0 ,int  maxResult){
	DaoService ds=DaoService.getIntrance();
	org.hibernate.Session session=ds.openSession();
 	 org.hibernate.Transaction ts=session.beginTransaction();
	List< MallShopProduct> 	queryData=null;

 	 try{

 	 MallShopProductHome home=(MallShopProductHome)getObjectHome();
	home.setSessionCurrent(session);
		queryData=home.getListHotTopByDianPuId( dianpuId0 , maxResult);
	 ts.commit();  
	  }catch(org.hibernate.AssertionFailure e){ 
	 e.printStackTrace();
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct.");
	 	log.error("dao error failed", e); 
	 	ts.rollback();
	 	}catch(java.lang.RuntimeException e){ 
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct."); 
	 	log.error("dao error failed", e);  
	 	e.printStackTrace();  
	 	ts.rollback();  
	 	}finally{  
	//关闭会话 
	ds.closeSession(); 
	 return queryData;  
	 }//end try
	 }//end
//query code
public List< MallShopProduct> getListCmdtTopByDianPuId( Long dianpuId0, Boolean bdianpuIndexCommand1 ,int  maxResult){
	DaoService ds=DaoService.getIntrance();
	org.hibernate.Session session=ds.openSession();
 	 org.hibernate.Transaction ts=session.beginTransaction();
	List< MallShopProduct> 	queryData=null;

 	 try{

 	 MallShopProductHome home=(MallShopProductHome)getObjectHome();
	home.setSessionCurrent(session);
		queryData=home.getListCmdtTopByDianPuId( dianpuId0, bdianpuIndexCommand1 , maxResult);
	 ts.commit();  
	  }catch(org.hibernate.AssertionFailure e){ 
	 e.printStackTrace();
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct.");
	 	log.error("dao error failed", e); 
	 	ts.rollback();
	 	}catch(java.lang.RuntimeException e){ 
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct."); 
	 	log.error("dao error failed", e);  
	 	e.printStackTrace();  
	 	ts.rollback();  
	 	}finally{  
	//关闭会话 
	ds.closeSession(); 
	 return queryData;  
	 }//end try
	 }//end
//query code
public List< MallShopProduct> getGiftListByDianPuId( Boolean bgiftZhengPin0, Long dianpuId1){
	DaoService ds=DaoService.getIntrance();
	org.hibernate.Session session=ds.openSession();
 	 org.hibernate.Transaction ts=session.beginTransaction();
	List< MallShopProduct> 	queryData=null;

 	 try{

 	 MallShopProductHome home=(MallShopProductHome)getObjectHome();
	home.setSessionCurrent(session);
		queryData=home.getGiftListByDianPuId( bgiftZhengPin0, dianpuId1);
	 ts.commit();  
	  }catch(org.hibernate.AssertionFailure e){ 
	 e.printStackTrace();
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct.");
	 	log.error("dao error failed", e); 
	 	ts.rollback();
	 	}catch(java.lang.RuntimeException e){ 
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct."); 
	 	log.error("dao error failed", e);  
	 	e.printStackTrace();  
	 	ts.rollback();  
	 	}finally{  
	//关闭会话 
	ds.closeSession(); 
	 return queryData;  
	 }//end try
	 }//end
//query code
public List< MallShopProduct> getGiftListZhengPing( Boolean bgiftZhengPin0 ,int  maxResult){
	DaoService ds=DaoService.getIntrance();
	org.hibernate.Session session=ds.openSession();
 	 org.hibernate.Transaction ts=session.beginTransaction();
	List< MallShopProduct> 	queryData=null;

 	 try{

 	 MallShopProductHome home=(MallShopProductHome)getObjectHome();
	home.setSessionCurrent(session);
		queryData=home.getGiftListZhengPing( bgiftZhengPin0 , maxResult);
	 ts.commit();  
	  }catch(org.hibernate.AssertionFailure e){ 
	 e.printStackTrace();
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct.");
	 	log.error("dao error failed", e); 
	 	ts.rollback();
	 	}catch(java.lang.RuntimeException e){ 
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct."); 
	 	log.error("dao error failed", e);  
	 	e.printStackTrace();  
	 	ts.rollback();  
	 	}finally{  
	//关闭会话 
	ds.closeSession(); 
	 return queryData;  
	 }//end try
	 }//end
//query code
public List< MallShopProduct> getChuXiaoListTop( Boolean bpromoctionQuXiao0 ,int  maxResult){
	DaoService ds=DaoService.getIntrance();
	org.hibernate.Session session=ds.openSession();
 	 org.hibernate.Transaction ts=session.beginTransaction();
	List< MallShopProduct> 	queryData=null;

 	 try{

 	 MallShopProductHome home=(MallShopProductHome)getObjectHome();
	home.setSessionCurrent(session);
		queryData=home.getChuXiaoListTop( bpromoctionQuXiao0 , maxResult);
	 ts.commit();  
	  }catch(org.hibernate.AssertionFailure e){ 
	 e.printStackTrace();
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct.");
	 	log.error("dao error failed", e); 
	 	ts.rollback();
	 	}catch(java.lang.RuntimeException e){ 
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct."); 
	 	log.error("dao error failed", e);  
	 	e.printStackTrace();  
	 	ts.rollback();  
	 	}finally{  
	//关闭会话 
	ds.closeSession(); 
	 return queryData;  
	 }//end try
	 }//end
//query code
public List< MallShopProduct> getMainYouFeiListTop( Boolean bfreeShipiingMianYunFei0 ,int  maxResult){
	DaoService ds=DaoService.getIntrance();
	org.hibernate.Session session=ds.openSession();
 	 org.hibernate.Transaction ts=session.beginTransaction();
	List< MallShopProduct> 	queryData=null;

 	 try{

 	 MallShopProductHome home=(MallShopProductHome)getObjectHome();
	home.setSessionCurrent(session);
		queryData=home.getMainYouFeiListTop( bfreeShipiingMianYunFei0 , maxResult);
	 ts.commit();  
	  }catch(org.hibernate.AssertionFailure e){ 
	 e.printStackTrace();
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct.");
	 	log.error("dao error failed", e); 
	 	ts.rollback();
	 	}catch(java.lang.RuntimeException e){ 
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct."); 
	 	log.error("dao error failed", e);  
	 	e.printStackTrace();  
	 	ts.rollback();  
	 	}finally{  
	//关闭会话 
	ds.closeSession(); 
	 return queryData;  
	 }//end try
	 }//end
//query code
public List< MallShopProduct> getNewListTopBydianPuId( Long dianpuId0 ,int  maxResult){
	DaoService ds=DaoService.getIntrance();
	org.hibernate.Session session=ds.openSession();
 	 org.hibernate.Transaction ts=session.beginTransaction();
	List< MallShopProduct> 	queryData=null;

 	 try{

 	 MallShopProductHome home=(MallShopProductHome)getObjectHome();
	home.setSessionCurrent(session);
		queryData=home.getNewListTopBydianPuId( dianpuId0 , maxResult);
	 ts.commit();  
	  }catch(org.hibernate.AssertionFailure e){ 
	 e.printStackTrace();
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct.");
	 	log.error("dao error failed", e); 
	 	ts.rollback();
	 	}catch(java.lang.RuntimeException e){ 
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct."); 
	 	log.error("dao error failed", e);  
	 	e.printStackTrace();  
	 	ts.rollback();  
	 	}finally{  
	//关闭会话 
	ds.closeSession(); 
	 return queryData;  
	 }//end try
	 }//end
//query code
public List< MallShopProduct> geHotListTopBydianPuId( Long dianpuId0 ,int  maxResult){
	DaoService ds=DaoService.getIntrance();
	org.hibernate.Session session=ds.openSession();
 	 org.hibernate.Transaction ts=session.beginTransaction();
	List< MallShopProduct> 	queryData=null;

 	 try{

 	 MallShopProductHome home=(MallShopProductHome)getObjectHome();
	home.setSessionCurrent(session);
		queryData=home.geHotListTopBydianPuId( dianpuId0 , maxResult);
	 ts.commit();  
	  }catch(org.hibernate.AssertionFailure e){ 
	 e.printStackTrace();
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct.");
	 	log.error("dao error failed", e); 
	 	ts.rollback();
	 	}catch(java.lang.RuntimeException e){ 
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct."); 
	 	log.error("dao error failed", e);  
	 	e.printStackTrace();  
	 	ts.rollback();  
	 	}finally{  
	//关闭会话 
	ds.closeSession(); 
	 return queryData;  
	 }//end try
	 }//end
//query code
public List< MallShopProduct> getListBGif_ZengPin( Boolean bgiftZhengPin0){
	DaoService ds=DaoService.getIntrance();
	org.hibernate.Session session=ds.openSession();
 	 org.hibernate.Transaction ts=session.beginTransaction();
	List< MallShopProduct> 	queryData=null;

 	 try{

 	 MallShopProductHome home=(MallShopProductHome)getObjectHome();
	home.setSessionCurrent(session);
		queryData=home.getListBGif_ZengPin( bgiftZhengPin0);
	 ts.commit();  
	  }catch(org.hibernate.AssertionFailure e){ 
	 e.printStackTrace();
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct.");
	 	log.error("dao error failed", e); 
	 	ts.rollback();
	 	}catch(java.lang.RuntimeException e){ 
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct."); 
	 	log.error("dao error failed", e);  
	 	e.printStackTrace();  
	 	ts.rollback();  
	 	}finally{  
	//关闭会话 
	ds.closeSession(); 
	 return queryData;  
	 }//end try
	 }//end
//query code
public List< MallShopProduct> getListBPromotion_ChuXiao( Boolean bpromoctionQuXiao0){
	DaoService ds=DaoService.getIntrance();
	org.hibernate.Session session=ds.openSession();
 	 org.hibernate.Transaction ts=session.beginTransaction();
	List< MallShopProduct> 	queryData=null;

 	 try{

 	 MallShopProductHome home=(MallShopProductHome)getObjectHome();
	home.setSessionCurrent(session);
		queryData=home.getListBPromotion_ChuXiao( bpromoctionQuXiao0);
	 ts.commit();  
	  }catch(org.hibernate.AssertionFailure e){ 
	 e.printStackTrace();
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct.");
	 	log.error("dao error failed", e); 
	 	ts.rollback();
	 	}catch(java.lang.RuntimeException e){ 
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct."); 
	 	log.error("dao error failed", e);  
	 	e.printStackTrace();  
	 	ts.rollback();  
	 	}finally{  
	//关闭会话 
	ds.closeSession(); 
	 return queryData;  
	 }//end try
	 }//end
//query code
public List< MallShopProduct> getListBFreeShipping_Mian_yunFei( Boolean bfreeShipiingMianYunFei0){
	DaoService ds=DaoService.getIntrance();
	org.hibernate.Session session=ds.openSession();
 	 org.hibernate.Transaction ts=session.beginTransaction();
	List< MallShopProduct> 	queryData=null;

 	 try{

 	 MallShopProductHome home=(MallShopProductHome)getObjectHome();
	home.setSessionCurrent(session);
		queryData=home.getListBFreeShipping_Mian_yunFei( bfreeShipiingMianYunFei0);
	 ts.commit();  
	  }catch(org.hibernate.AssertionFailure e){ 
	 e.printStackTrace();
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct.");
	 	log.error("dao error failed", e); 
	 	ts.rollback();
	 	}catch(java.lang.RuntimeException e){ 
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct."); 
	 	log.error("dao error failed", e);  
	 	e.printStackTrace();  
	 	ts.rollback();  
	 	}finally{  
	//关闭会话 
	ds.closeSession(); 
	 return queryData;  
	 }//end try
	 }//end
//query code
public  MallShopProduct getProductByCatIdPinPaiIdBigIMGPath( Integer catId0, Integer pinPaiId1, String imgOnePath2){
	DaoService ds=DaoService.getIntrance();
	org.hibernate.Session session=ds.openSession();
 	 org.hibernate.Transaction ts=session.beginTransaction();	MallShopProduct 	queryData=null;

 	 try{

 	 MallShopProductHome home=(MallShopProductHome)getObjectHome();
	home.setSessionCurrent(session);
		queryData=home.getProductByCatIdPinPaiIdBigIMGPath( catId0, pinPaiId1, imgOnePath2);
	 ts.commit();  
	  }catch(org.hibernate.AssertionFailure e){ 
	 e.printStackTrace();
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct.");
	 	log.error("dao error failed", e); 
	 	ts.rollback();
	 	}catch(java.lang.RuntimeException e){ 
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct."); 
	 	log.error("dao error failed", e);  
	 	e.printStackTrace();  
	 	ts.rollback();  
	 	}finally{  
	//关闭会话 
	ds.closeSession(); 
	 return queryData;  
	 }//end try
	 }//end
//query code
public List< MallShopProduct> getListByDpUserId( Long dianpuUserId0){
	DaoService ds=DaoService.getIntrance();
	org.hibernate.Session session=ds.openSession();
 	 org.hibernate.Transaction ts=session.beginTransaction();
	List< MallShopProduct> 	queryData=null;

 	 try{

 	 MallShopProductHome home=(MallShopProductHome)getObjectHome();
	home.setSessionCurrent(session);
		queryData=home.getListByDpUserId( dianpuUserId0);
	 ts.commit();  
	  }catch(org.hibernate.AssertionFailure e){ 
	 e.printStackTrace();
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct.");
	 	log.error("dao error failed", e); 
	 	ts.rollback();
	 	}catch(java.lang.RuntimeException e){ 
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct."); 
	 	log.error("dao error failed", e);  
	 	e.printStackTrace();  
	 	ts.rollback();  
	 	}finally{  
	//关闭会话 
	ds.closeSession(); 
	 return queryData;  
	 }//end try
	 }//end
//query code
public List< MallShopProduct> getListByDpId( Long dianpuId0){
	DaoService ds=DaoService.getIntrance();
	org.hibernate.Session session=ds.openSession();
 	 org.hibernate.Transaction ts=session.beginTransaction();
	List< MallShopProduct> 	queryData=null;

 	 try{

 	 MallShopProductHome home=(MallShopProductHome)getObjectHome();
	home.setSessionCurrent(session);
		queryData=home.getListByDpId( dianpuId0);
	 ts.commit();  
	  }catch(org.hibernate.AssertionFailure e){ 
	 e.printStackTrace();
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct.");
	 	log.error("dao error failed", e); 
	 	ts.rollback();
	 	}catch(java.lang.RuntimeException e){ 
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct."); 
	 	log.error("dao error failed", e);  
	 	e.printStackTrace();  
	 	ts.rollback();  
	 	}finally{  
	//关闭会话 
	ds.closeSession(); 
	 return queryData;  
	 }//end try
	 }//end
//query code
public List< MallShopProduct> getLisbByLikeProductName( String name0){
	DaoService ds=DaoService.getIntrance();
	org.hibernate.Session session=ds.openSession();
 	 org.hibernate.Transaction ts=session.beginTransaction();
	List< MallShopProduct> 	queryData=null;

 	 try{

 	 MallShopProductHome home=(MallShopProductHome)getObjectHome();
	home.setSessionCurrent(session);
		queryData=home.getLisbByLikeProductName( name0);
	 ts.commit();  
	  }catch(org.hibernate.AssertionFailure e){ 
	 e.printStackTrace();
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct.");
	 	log.error("dao error failed", e); 
	 	ts.rollback();
	 	}catch(java.lang.RuntimeException e){ 
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct."); 
	 	log.error("dao error failed", e);  
	 	e.printStackTrace();  
	 	ts.rollback();  
	 	}finally{  
	//关闭会话 
	ds.closeSession(); 
	 return queryData;  
	 }//end try
	 }//end
//query code
public List< MallShopProduct> getListLikeBySalerUserName( String dianpuUserName0){
	DaoService ds=DaoService.getIntrance();
	org.hibernate.Session session=ds.openSession();
 	 org.hibernate.Transaction ts=session.beginTransaction();
	List< MallShopProduct> 	queryData=null;

 	 try{

 	 MallShopProductHome home=(MallShopProductHome)getObjectHome();
	home.setSessionCurrent(session);
		queryData=home.getListLikeBySalerUserName( dianpuUserName0);
	 ts.commit();  
	  }catch(org.hibernate.AssertionFailure e){ 
	 e.printStackTrace();
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct.");
	 	log.error("dao error failed", e); 
	 	ts.rollback();
	 	}catch(java.lang.RuntimeException e){ 
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct."); 
	 	log.error("dao error failed", e);  
	 	e.printStackTrace();  
	 	ts.rollback();  
	 	}finally{  
	//关闭会话 
	ds.closeSession(); 
	 return queryData;  
	 }//end try
	 }//end
//query code
public List< MallShopProduct> getListLikeByCreditCtcTel( String creditContactUserPhone0){
	DaoService ds=DaoService.getIntrance();
	org.hibernate.Session session=ds.openSession();
 	 org.hibernate.Transaction ts=session.beginTransaction();
	List< MallShopProduct> 	queryData=null;

 	 try{

 	 MallShopProductHome home=(MallShopProductHome)getObjectHome();
	home.setSessionCurrent(session);
		queryData=home.getListLikeByCreditCtcTel( creditContactUserPhone0);
	 ts.commit();  
	  }catch(org.hibernate.AssertionFailure e){ 
	 e.printStackTrace();
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct.");
	 	log.error("dao error failed", e); 
	 	ts.rollback();
	 	}catch(java.lang.RuntimeException e){ 
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct."); 
	 	log.error("dao error failed", e);  
	 	e.printStackTrace();  
	 	ts.rollback();  
	 	}finally{  
	//关闭会话 
	ds.closeSession(); 
	 return queryData;  
	 }//end try
	 }//end
//query code
public List< MallShopProduct> getListByPidIsNull( String piD0){
	DaoService ds=DaoService.getIntrance();
	org.hibernate.Session session=ds.openSession();
 	 org.hibernate.Transaction ts=session.beginTransaction();
	List< MallShopProduct> 	queryData=null;

 	 try{

 	 MallShopProductHome home=(MallShopProductHome)getObjectHome();
	home.setSessionCurrent(session);
		queryData=home.getListByPidIsNull( piD0);
	 ts.commit();  
	  }catch(org.hibernate.AssertionFailure e){ 
	 e.printStackTrace();
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct.");
	 	log.error("dao error failed", e); 
	 	ts.rollback();
	 	}catch(java.lang.RuntimeException e){ 
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct."); 
	 	log.error("dao error failed", e);  
	 	e.printStackTrace();  
	 	ts.rollback();  
	 	}finally{  
	//关闭会话 
	ds.closeSession(); 
	 return queryData;  
	 }//end try
	 }//end
//query code
public  MallShopProduct getProductByPidBianMa( String piD0){
	DaoService ds=DaoService.getIntrance();
	org.hibernate.Session session=ds.openSession();
 	 org.hibernate.Transaction ts=session.beginTransaction();	MallShopProduct 	queryData=null;

 	 try{

 	 MallShopProductHome home=(MallShopProductHome)getObjectHome();
	home.setSessionCurrent(session);
		queryData=home.getProductByPidBianMa( piD0);
	 ts.commit();  
	  }catch(org.hibernate.AssertionFailure e){ 
	 e.printStackTrace();
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct.");
	 	log.error("dao error failed", e); 
	 	ts.rollback();
	 	}catch(java.lang.RuntimeException e){ 
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct."); 
	 	log.error("dao error failed", e);  
	 	e.printStackTrace();  
	 	ts.rollback();  
	 	}finally{  
	//关闭会话 
	ds.closeSession(); 
	 return queryData;  
	 }//end try
	 }//end
//query code
public List< MallShopProduct> getListLikeByCmpName( String creditCnCompanyName0 ,int  maxResult){
	DaoService ds=DaoService.getIntrance();
	org.hibernate.Session session=ds.openSession();
 	 org.hibernate.Transaction ts=session.beginTransaction();
	List< MallShopProduct> 	queryData=null;

 	 try{

 	 MallShopProductHome home=(MallShopProductHome)getObjectHome();
	home.setSessionCurrent(session);
		queryData=home.getListLikeByCmpName( creditCnCompanyName0 , maxResult);
	 ts.commit();  
	  }catch(org.hibernate.AssertionFailure e){ 
	 e.printStackTrace();
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct.");
	 	log.error("dao error failed", e); 
	 	ts.rollback();
	 	}catch(java.lang.RuntimeException e){ 
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct."); 
	 	log.error("dao error failed", e);  
	 	e.printStackTrace();  
	 	ts.rollback();  
	 	}finally{  
	//关闭会话 
	ds.closeSession(); 
	 return queryData;  
	 }//end try
	 }//end
//query code
public List< MallShopProduct> getLisisPingZi( Boolean bpingZi0){
	DaoService ds=DaoService.getIntrance();
	org.hibernate.Session session=ds.openSession();
 	 org.hibernate.Transaction ts=session.beginTransaction();
	List< MallShopProduct> 	queryData=null;

 	 try{

 	 MallShopProductHome home=(MallShopProductHome)getObjectHome();
	home.setSessionCurrent(session);
		queryData=home.getLisisPingZi( bpingZi0);
	 ts.commit();  
	  }catch(org.hibernate.AssertionFailure e){ 
	 e.printStackTrace();
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct.");
	 	log.error("dao error failed", e); 
	 	ts.rollback();
	 	}catch(java.lang.RuntimeException e){ 
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct."); 
	 	log.error("dao error failed", e);  
	 	e.printStackTrace();  
	 	ts.rollback();  
	 	}finally{  
	//关闭会话 
	ds.closeSession(); 
	 return queryData;  
	 }//end try
	 }//end
//query code
public List< MallShopProduct> getLisMyPingZiProduct( Long pingZiRenId0 ,int  maxResult){
	DaoService ds=DaoService.getIntrance();
	org.hibernate.Session session=ds.openSession();
 	 org.hibernate.Transaction ts=session.beginTransaction();
	List< MallShopProduct> 	queryData=null;

 	 try{

 	 MallShopProductHome home=(MallShopProductHome)getObjectHome();
	home.setSessionCurrent(session);
		queryData=home.getLisMyPingZiProduct( pingZiRenId0 , maxResult);
	 ts.commit();  
	  }catch(org.hibernate.AssertionFailure e){ 
	 e.printStackTrace();
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct.");
	 	log.error("dao error failed", e); 
	 	ts.rollback();
	 	}catch(java.lang.RuntimeException e){ 
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct."); 
	 	log.error("dao error failed", e);  
	 	e.printStackTrace();  
	 	ts.rollback();  
	 	}finally{  
	//关闭会话 
	ds.closeSession(); 
	 return queryData;  
	 }//end try
	 }//end
//query code
public  MallShopProduct getProductByTiaoMa( String tiaomaID0){
	DaoService ds=DaoService.getIntrance();
	org.hibernate.Session session=ds.openSession();
 	 org.hibernate.Transaction ts=session.beginTransaction();	MallShopProduct 	queryData=null;

 	 try{

 	 MallShopProductHome home=(MallShopProductHome)getObjectHome();
	home.setSessionCurrent(session);
		queryData=home.getProductByTiaoMa( tiaomaID0);
	 ts.commit();  
	  }catch(org.hibernate.AssertionFailure e){ 
	 e.printStackTrace();
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct.");
	 	log.error("dao error failed", e); 
	 	ts.rollback();
	 	}catch(java.lang.RuntimeException e){ 
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct."); 
	 	log.error("dao error failed", e);  
	 	e.printStackTrace();  
	 	ts.rollback();  
	 	}finally{  
	//关闭会话 
	ds.closeSession(); 
	 return queryData;  
	 }//end try
	 }//end

	
	//BatchSelect  	
	
	
	
	//取全部数据
	
		public List<MallShopProduct> getListAll(){
		
		List<MallShopProduct> list=null;
		
		DaoService ds=DaoService.getIntrance();
org.hibernate.Session session=ds.openSession();
org.hibernate.Transaction ts=session.beginTransaction();
try{
	    	
		
		//设置数据库会话
		
		MallShopProductHome home=((MallShopProductHome)getObjectHome());
		
		home.setSessionCurrent(session);
		
		MallShopProductHome beanHome=(MallShopProductHome)getObjectHome();
		
		list=beanHome.getListAll();
		
			ts.commit();
			
			
}catch(org.hibernate.AssertionFailure e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct");
			log.error("dao error failed", e);
			//事务回滚
			ts.rollback();
		}catch(java.lang.RuntimeException e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct");
			log.error("dao error failed", e);
			//事务回滚
			ts.rollback();
		}finally{
	    		//关闭会话
	    		ds.closeSession();return list;
		}//end try

	}
	
	public List<Object> getList(){
	
	List<Object> list=null;
	
	DaoService ds=DaoService.getIntrance();
org.hibernate.Session session=ds.openSession();
org.hibernate.Transaction ts=session.beginTransaction();
try{
	    	
				//设置数据库会话
		MallShopProductHome home=((MallShopProductHome)getObjectHome());
		home.setSessionCurrent(session);
		list=getObjectHome().getList();
	ts.commit();
			
}catch(org.hibernate.AssertionFailure e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct");
			log.error("dao error failed", e);
			//事务回滚
			ts.rollback();
		}catch(java.lang.RuntimeException e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct");
			log.error("dao error failed", e);
			//事务回滚
			ts.rollback();
		}finally{
	    		//关闭会话
	    		ds.closeSession();return list;
		}//end try

	}
	
	
  public void update(Object object ){
	  DaoService ds=DaoService.getIntrance();
org.hibernate.Session session=ds.openSession();
org.hibernate.Transaction ts=session.beginTransaction();
try{
	    	
				//设置数据库会话
		MallShopProductHome home=((MallShopProductHome)getObjectHome());
		home.setSessionCurrent(session);
		getObjectHome().merge(   object) ;
		ts.commit();
			
}catch(org.hibernate.AssertionFailure e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct");
			log.error("dao error failed", e);
			//事务回滚
			ts.rollback();
		}catch(java.lang.RuntimeException e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct");
			log.error("dao error failed", e);
			//事务回滚
			ts.rollback();
		}finally{
	    		//关闭会话
	    		ds.closeSession();
		}//end try

	}
  public void update(MallShopProduct  object ){
	  DaoService ds=DaoService.getIntrance();
org.hibernate.Session session=ds.openSession();
org.hibernate.Transaction ts=session.beginTransaction();
try{
	    	
				//设置数据库会话
		MallShopProductHome home=((MallShopProductHome)getObjectHome());
		home.setSessionCurrent(session);
		getObjectHome().merge(   object) ;
	ts.commit();
			
}catch(org.hibernate.AssertionFailure e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct");
			log.error("dao error failed", e);
			//事务回滚
			ts.rollback();
		}catch(java.lang.RuntimeException e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct");
			log.error("dao error failed", e);
			//事务回滚
			ts.rollback();
		}finally{
	    		//关闭会话
	    		ds.closeSession();
		}//end try

	}
	    public void add(MallShopProduct object ){
	    DaoService ds=DaoService.getIntrance();
org.hibernate.Session session=ds.openSession();
org.hibernate.Transaction ts=session.beginTransaction();
try{
	    	
					//设置数据库会话
		MallShopProductHome home=((MallShopProductHome)getObjectHome());
		home.setSessionCurrent(session);
			getObjectHome().persist(object) ;
			
						//刷新hibernate缓存，保存最新对象
			session.flush();
			//将对象从session中逐出，即session的EntityEntries属性中逐出
			session.evict(object);
			//提交事务
			ts.commit();
			
}catch(org.hibernate.AssertionFailure e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct");
			log.error("dao error failed", e);
			//事务回滚
			ts.rollback();
		}catch(java.lang.RuntimeException e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct");
			log.error("dao error failed", e);
			//事务回滚
			ts.rollback();
		}finally{
	    		//关闭会话
	    		ds.closeSession();
		}//end try

		}
	    public void add(Object object ){
	    DaoService ds=DaoService.getIntrance();
org.hibernate.Session session=ds.openSession();
org.hibernate.Transaction ts=session.beginTransaction();
try{
	    	
					//设置数据库会话
		MallShopProductHome home=((MallShopProductHome)getObjectHome());
		home.setSessionCurrent(session);
			getObjectHome().persist(object) ;
			//刷新hibernate缓存，保存最新对象
			session.flush();
			//将对象从session中逐出，即session的EntityEntries属性中逐出
			session.evict(object);
			//提交事务
			
			ts.commit();
			
}catch(org.hibernate.AssertionFailure e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct");
			log.error("dao error failed", e);
			//事务回滚
			ts.rollback();
		}catch(java.lang.RuntimeException e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct");
			log.error("dao error failed", e);
			//事务回滚
			ts.rollback();
		}finally{
	    		//关闭会话
	    		ds.closeSession();
		}//end try

		}
  public void delete(MallShopProduct  object ){
  DaoService ds=DaoService.getIntrance();
org.hibernate.Session session=ds.openSession();
org.hibernate.Transaction ts=session.beginTransaction();
try{
	    	
				//设置数据库会话
		MallShopProductHome home=((MallShopProductHome)getObjectHome());
		home.setSessionCurrent(session);
		getObjectHome().delete( object) ;
		ts.commit();
			
}catch(org.hibernate.AssertionFailure e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct");
			log.error("dao error failed", e);
			//事务回滚
			ts.rollback();
		}catch(java.lang.RuntimeException e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct");
			log.error("dao error failed", e);
			//事务回滚
			ts.rollback();
		}finally{
	    		//关闭会话
	    		ds.closeSession();
		}//end try

		
	}

  public void delete(Object object ){
  DaoService ds=DaoService.getIntrance();
org.hibernate.Session session=ds.openSession();
org.hibernate.Transaction ts=session.beginTransaction();
try{
	    	
				//设置数据库会话
		MallShopProductHome home=((MallShopProductHome)getObjectHome());
		home.setSessionCurrent(session);
		getObjectHome().delete( object) ;
		ts.commit();
		
}catch(org.hibernate.AssertionFailure e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct");
			log.error("dao error failed", e);
			//事务回滚
			ts.rollback();
		}catch(java.lang.RuntimeException e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct");
			log.error("dao error failed", e);
			//事务回滚
			ts.rollback();
		}finally{
	    		//关闭会话
	    		ds.closeSession();
		}//end try

	}
  	public MallShopProduct merge(MallShopProduct Instance) {
  	MallShopProduct Instances=null;
  	DaoService ds=DaoService.getIntrance();
org.hibernate.Session session=ds.openSession();
org.hibernate.Transaction ts=session.beginTransaction();
try{
	    	
				//设置数据库会话
		MallShopProductHome home=((MallShopProductHome)getObjectHome());
		home.setSessionCurrent(session);
		Instances=((MallShopProductHome)getObjectHome()).merge(   Instance) ;
			//刷新hibernate缓存，保存最新对象
			session.flush();
			//将对象从session中逐出，即session的EntityEntries属性中逐出
			session.evict(Instance);
			//提交事务
			ts.commit();
			
}catch(org.hibernate.AssertionFailure e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct");
			log.error("dao error failed", e);
			//事务回滚
			ts.rollback();
		}catch(java.lang.RuntimeException e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct");
			log.error("dao error failed", e);
			//事务回滚
			ts.rollback();
		}finally{
	    		//关闭会话
	    		ds.closeSession();return Instances;
		}//end try

	}
	public Object merge(Object transientInstance) {
	DaoService ds=DaoService.getIntrance();
org.hibernate.Session session=ds.openSession();
org.hibernate.Transaction ts=session.beginTransaction();
try{
	    		
				//设置数据库会话
		MallShopProductHome home=((MallShopProductHome)getObjectHome());
		home.setSessionCurrent(session);
			
		transientInstance=getObjectHome().merge(   transientInstance) ;
		  	//刷新hibernate缓存，保存最新对象
			session.flush();
			//将对象从session中逐出，即session的EntityEntries属性中逐出
			session.evict(transientInstance);
			//提交事务
		  	ts.commit();
			}catch(org.hibernate.AssertionFailure e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct");
			log.error("dao error failed", e);
			//事务回滚
			ts.rollback();
		}catch(java.lang.RuntimeException e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct");
			log.error("dao error failed", e);
			//事务回滚
			ts.rollback();
		}finally{
	    		//关闭会话
	    		ds.closeSession();return transientInstance;
		}//end try
	}

		public void setObjectHome(ObjectHome objectHome) {
			this.objectHome = objectHome;
		}

		public ObjectHome getObjectHome() {
			return this.objectHome;
		} 
		
		//id删除对象
	    public void delete(long id){
	    DaoService ds=DaoService.getIntrance();
org.hibernate.Session session=ds.openSession();
org.hibernate.Transaction ts=session.beginTransaction();
try{
	    	
	    			//设置数据库会话
		MallShopProductHome home=((MallShopProductHome)getObjectHome());
		home.setSessionCurrent(session);	
	    		getObjectHome().delete(id) ;
	  	  	ts.commit();
			
}catch(org.hibernate.AssertionFailure e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct");
			log.error("dao error failed", e);
			//事务回滚
			ts.rollback();
		}catch(java.lang.RuntimeException e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct");
			log.error("dao error failed", e);
			//事务回滚
			ts.rollback();
		}finally{
	    		//关闭会话
	    		ds.closeSession();
		}//end try
	
	    		
	    	}
	    	//获取对象  
	  	 public  Object get(long id){
	  	 Object object =null;
	  	 DaoService ds=DaoService.getIntrance();
org.hibernate.Session session=ds.openSession();
org.hibernate.Transaction ts=session.beginTransaction();
try{
	    	
	  			//设置数据库会话
		MallShopProductHome home=((MallShopProductHome)getObjectHome());
		home.setSessionCurrent(session);		
	  		object =getObjectHome().findById(id);
	  	ts.commit();
		}catch(org.hibernate.AssertionFailure e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct");
			log.error("dao error failed", e);
			//事务回滚
			ts.rollback();
		}catch(java.lang.RuntimeException e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct");
			log.error("dao error failed", e);
			//事务回滚
			ts.rollback();
		}finally{
	    		//关闭会话
	    		ds.closeSession();
			return object;
		}
	  		}
		//保存并获取包含对象ID实体对象
		
	
 public List<MallShopProduct> getListMax(int max, String orderByValidaty,
			String orderType) {
		// TODO Auto-generated method stub
		List<MallShopProduct> list=null;
		
		DaoService ds=DaoService.getIntrance();
		org.hibernate.Session session=ds.openSession();
		org.hibernate.Transaction ts=session.beginTransaction();
		try{
	    	
		
		//设置数据库会话
		
		MallShopProductHome home=((MallShopProductHome)getObjectHome());
		
		home.setSessionCurrent(session);
		
		MallShopProductHome beanHome=(MallShopProductHome)getObjectHome();
		
		list=beanHome.getListMax( max,  orderByValidaty,
				 orderType);
		
			ts.commit();
			
			
}catch(org.hibernate.AssertionFailure e){
	e.printStackTrace();
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct");
			log.error("dao error failed", e);
			//事务回滚
			ts.rollback();
		}catch(java.lang.RuntimeException e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct");
			log.error("dao error failed", e);
			e.printStackTrace();
			//事务回滚
			ts.rollback();
		}finally{
	    		//关闭会话
	    		ds.closeSession();return list;
		}//end try
	}

	public List<MallShopProduct> getList_qeury(String sqlCondation, int max,
			String orderBy, String orderType) {
		// TODO Auto-generated method stub
		// TODO Auto-generated method stub
		List<MallShopProduct> list=null;
		
		DaoService ds=DaoService.getIntrance();
		org.hibernate.Session session=ds.openSession();
		org.hibernate.Transaction ts=session.beginTransaction();
		try{
	    	
		
		//设置数据库会话
		
		MallShopProductHome home=((MallShopProductHome)getObjectHome());
		
		home.setSessionCurrent(session);
		
		MallShopProductHome beanHome=(MallShopProductHome)getObjectHome();
		
		list=beanHome.getList_qeury( sqlCondation,  max,
				 orderBy,  orderType);
		
			ts.commit();
			
			
}catch(org.hibernate.AssertionFailure e){
	e.printStackTrace();
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct");
			log.error("dao error failed", e);
			//事务回滚
			ts.rollback();
		}catch(java.lang.RuntimeException e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct");
			log.error("dao error failed", e);
			e.printStackTrace();
			//事务回滚
			ts.rollback();
		}finally{
	    		//关闭会话
	    		ds.closeSession();return list;
		}//end try
	}

	public List<MallShopProduct> getList_qeury_Byvalidaty(String vName,
			Object vValue, String condation,int max, String orderBy, String orderType) {
		// TODO Auto-generated method stub
		// TODO Auto-generated method stub
		List<MallShopProduct> list=null;
		
		DaoService ds=DaoService.getIntrance();
		org.hibernate.Session session=ds.openSession();
		org.hibernate.Transaction ts=session.beginTransaction();
		try{
	    	
		
		//设置数据库会话
		
		MallShopProductHome home=((MallShopProductHome)getObjectHome());
		
		home.setSessionCurrent(session);
		
		MallShopProductHome beanHome=(MallShopProductHome)getObjectHome();
		
		list=beanHome.getList_qeury_Byvalidaty(  vName,
				 vValue, condation, max,  orderBy,  orderType);
		
			ts.commit();
			
			
}catch(org.hibernate.AssertionFailure e){
	e.printStackTrace();
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct");
			log.error("dao error failed", e);
			//事务回滚
			ts.rollback();
		}catch(java.lang.RuntimeException e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopProduct");
			log.error("dao error failed", e);
			e.printStackTrace();
			//事务回滚
			ts.rollback();
		}finally{
	    		//关闭会话
	    		ds.closeSession();return list;
		}//end try
	}	

//your code<@YOURCODE>

 public static void main(String argv[]){
           util.DaoService.getIntrance();
	  		MallShopProductDao daoMallShopProductDao=new MallShopProductDao();
	  		MallShopProduct oMallShopProductDao=new MallShopProduct ();
	  		oMallShopProductDao=daoMallShopProductDao.merge(oMallShopProductDao);
	  	 }
	  	 


//</autoClassCode>	
 
 public List< MallShopProduct> getHostProductList( int  maxResult){
		
	 DaoService ds=DaoService.getIntrance();
		org.hibernate.Session session=ds.openSession();
	 	 org.hibernate.Transaction ts=session.beginTransaction();
	 	 MallShopProductHome home=(MallShopProductHome)getObjectHome();
		home.setSessionCurrent(session);	
		List< MallShopProduct> 	Instance=home.getHostProductList(  maxResult);
		ts.commit(); 
		  ds.close();
		return Instance;

	}

	public List< MallShopProduct> getNewProductLIst(int maxResult	){
		
		DaoService ds=DaoService.getIntrance();
		org.hibernate.Session session=ds.openSession();
	 	 org.hibernate.Transaction ts=session.beginTransaction();
	 	 MallShopProductHome home=(MallShopProductHome)getObjectHome();
		home.setSessionCurrent(session);
		List< MallShopProduct> 	Instance=home.getNewProductLIst( maxResult);
		ts.commit(); 
		  ds.close();
		return Instance;
	}
//getListByPidIsNull_admin
	
	public List<MallShopProduct> getListByPidIsNull_admin( ) {
		// TODO Auto-generated method stub
		DaoService ds=DaoService.getIntrance();
		org.hibernate.Session session=ds.openSession();
	 	 org.hibernate.Transaction ts=session.beginTransaction();
	 	 MallShopProductHome home=(MallShopProductHome)getObjectHome();
		home.setSessionCurrent(session);	
		List< MallShopProduct> 	Instance=home.getListByPidIsNull_admin();//( key);
		ts.commit(); 
		  ds.close();
		return Instance;
	}
	public List<MallShopProduct> searchListByProductNameKeywords( String key) {
		// TODO Auto-generated method stub
		DaoService ds=DaoService.getIntrance();
		org.hibernate.Session session=ds.openSession();
	 	 org.hibernate.Transaction ts=session.beginTransaction();
	 	 MallShopProductHome home=(MallShopProductHome)getObjectHome();
		home.setSessionCurrent(session);	
		List< MallShopProduct> 	Instance=home.searchListByProductNameKeywords( key);
		ts.commit(); 
		  ds.closeSession();
		return Instance;
	}

	//count

	public long minValidty(String validaty) {
		// TODO Auto-generated method stub
	
			
		long r=0;
			
			DaoService ds=DaoService.getIntrance();
		org.hibernate.Session session=ds.openSession();
		org.hibernate.Transaction ts=session.beginTransaction();
		try{
			    	
						//设置数据库会话
				MallShopProductHome home=((MallShopProductHome)getObjectHome());
				home.setSessionCurrent(session);
				 r=home.minValidty(validaty);
			ts.commit();
					
		}catch(org.hibernate.AssertionFailure e){
					System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误!");
					log.error("dao error failed", e);
					e.printStackTrace();
					//事务回滚
					ts.rollback();
				}catch(java.lang.RuntimeException e){
					System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误!");
					log.error("dao error failed", e);
					e.printStackTrace();
					//事务回滚
					ts.rollback();
				}finally{
			    		//关闭会话
			    		ds.closeSession();
			    		return r;
				}//end try

			
	}


	public long maxValidty(String validaty) {
		// TODO Auto-generated method stub
		long r=0;
		
		DaoService ds=DaoService.getIntrance();
	org.hibernate.Session session=ds.openSession();
	org.hibernate.Transaction ts=session.beginTransaction();
	try{
		    	
					//设置数据库会话
			MallShopProductHome home=((MallShopProductHome)getObjectHome());
			home.setSessionCurrent(session);
			 r=home.maxValidty(validaty);
		ts.commit();
				
	}catch(org.hibernate.AssertionFailure e){
				System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误!");
				log.error("dao error failed", e);
				e.printStackTrace();
				//事务回滚
				ts.rollback();
			}catch(java.lang.RuntimeException e){
				System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误!");
				log.error("dao error failed", e);
				e.printStackTrace();
				//事务回滚
				ts.rollback();
			}finally{
		    		//关闭会话
		    		ds.closeSession();
		    		return r;
			}//end try
	}


	public long sumValidty(String validaty) {
		// TODO Auto-generated method stub
	long r=0;
		
		DaoService ds=DaoService.getIntrance();
	org.hibernate.Session session=ds.openSession();
	org.hibernate.Transaction ts=session.beginTransaction();
	try{
		    	
					//设置数据库会话
			MallShopProductHome home=((MallShopProductHome)getObjectHome());
			home.setSessionCurrent(session);
			 r=home.sumValidty(validaty);
		ts.commit();
				
	}catch(org.hibernate.AssertionFailure e){
				System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误!");
				log.error("dao error failed", e);
				e.printStackTrace();
				//事务回滚
				ts.rollback();
			}catch(java.lang.RuntimeException e){
				System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误!");
				log.error("dao error failed", e);
				e.printStackTrace();
				//事务回滚
				ts.rollback();
			}finally{
		    		//关闭会话
		    		ds.closeSession();
		    		return r;
			}//end try
	}


	public Double avgValidty(String validaty) {
		// TODO Auto-generated method stub
		Double r=0.0;
		
		DaoService ds=DaoService.getIntrance();
	org.hibernate.Session session=ds.openSession();
	org.hibernate.Transaction ts=session.beginTransaction();
	try{
		    	
					//设置数据库会话
			MallShopProductHome home=((MallShopProductHome)getObjectHome());
			home.setSessionCurrent(session);
			 r=home.avgValidty(validaty);
		ts.commit();
				
	}catch(org.hibernate.AssertionFailure e){
				System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误!");
				log.error("dao error failed", e);
				e.printStackTrace();
				//事务回滚
				ts.rollback();
			}catch(java.lang.RuntimeException e){
				System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误!");
				log.error("dao error failed", e);
				e.printStackTrace();
				//事务回滚
				ts.rollback();
			}finally{
		    		//关闭会话
		    		ds.closeSession();
		    		return r;
			}//end try
	}

	public long countValidaty(String validaty) {
		// TODO Auto-generated method stub
long r=0;
		
		DaoService ds=DaoService.getIntrance();
	org.hibernate.Session session=ds.openSession();
	org.hibernate.Transaction ts=session.beginTransaction();
	try{
		    	
					//设置数据库会话
			MallShopProductHome home=((MallShopProductHome)getObjectHome());
			home.setSessionCurrent(session);
			 r=home.countValidaty(validaty);
		ts.commit();
				
	}catch(org.hibernate.AssertionFailure e){
				System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误!");
				log.error("dao error failed", e);
				e.printStackTrace();
				//事务回滚
				ts.rollback();
			}catch(java.lang.RuntimeException e){
				System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误!");
				log.error("dao error failed", e);
				e.printStackTrace();
				//事务回滚
				ts.rollback();
			}finally{
		    		//关闭会话
		    		ds.closeSession();
		    		return r;
			}//end try
	}
 
}
