
 
package dao;

import java.util.List;
import javax.naming.InitialContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.LockMode;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Example;
import util.ObjectHome;
import java.util.List;


 /**
*功能：定义实体类基本操作：查询，添加，删除，修改
 * @author www.juuluu.org 逐龙juuluu
* tel:020-28983330 mobile:15975485229
 * email:wujavei@126.com  QQ:274390981
 * @see MallShopOrder
 */
public class MallShopOrderHome extends ObjectHome{

//<autoClassCode>



//comment

	private static final Log log = LogFactory.getLog(MallShopOrderHome.class);

		//通过自创建方式使用session
		
	private final SessionFactory sessionFactory = getSessionFactory();
	
	//通过外部注入方式使用session
	
	private org.hibernate.Session sessionCurrent;
	
	public void setSessionCurrent(org.hibernate.Session sessionCurrent) {
		this.sessionCurrent = sessionCurrent;
	}
	
	public org.hibernate.Session getSessionCurrent() {
		return sessionCurrent;
	}
	
//del by validaty 

		//BatchDelete code 	
		
		//SaveAndGet 	
		
	//FindByClassName code 	 

	
	//Link code 	
	
	//BatchQuery code	//query code
public List< MallShopOrder> getAllListByShopUsreId( Long dianpuUserId0){
	log.debug("getting getAllListByShopUsreId"); 
	try {
	List< MallShopOrder> instances =this.sessionCurrent
	.createQuery("from dao.MallShopOrder where dianpuUserId=:dianpuUserId0 order by oderTime desc")
	.setParameter("dianpuUserId0", dianpuUserId0)
	.list();
	if (instances == null) {
	log.debug("get successful, no instance found");
	} else {
	log.debug("get successful, instance found");
	}return instances;
	} catch (RuntimeException re) {
	log.error("get failed", re);
	throw re;}}
//query code
public  MallShopOrder getOrferByOrderId( String orderID0){
	log.debug("getting getOrferByOrderId"); 
	try {
	 MallShopOrder instances = (MallShopOrder)this.sessionCurrent
	.createQuery("from dao.MallShopOrder where orderID=:orderID0")
	.setParameter("orderID0", orderID0)
	.uniqueResult();
	if (instances == null) {
	log.debug("get successful, no instance found");
	} else {
	log.debug("get successful, instance found");
	}return instances;
	} catch (RuntimeException re) {
	log.error("get failed", re);
	throw re;}}
//query code
public List< MallShopOrder> getListAllByBuyerId( Long userId0){
	log.debug("getting getListAllByBuyerId"); 
	try {
	List< MallShopOrder> instances =this.sessionCurrent
	.createQuery("from dao.MallShopOrder where userId=:userId0 order by oderTime desc")
	.setParameter("userId0", userId0)
	.list();
	if (instances == null) {
	log.debug("get successful, no instance found");
	} else {
	log.debug("get successful, instance found");
	}return instances;
	} catch (RuntimeException re) {
	log.error("get failed", re);
	throw re;}}
//query code
public List< MallShopOrder> getListBPayByBuyerId( Long userId0, Boolean payed1){
	log.debug("getting getListBPayByBuyerId"); 
	try {
	List< MallShopOrder> instances =this.sessionCurrent
	.createQuery("from dao.MallShopOrder where userId=:userId0 and payed=:payed1 order by oderTime desc")
	.setParameter("userId0", userId0)
	.setParameter("payed1", payed1)
	.list();
	if (instances == null) {
	log.debug("get successful, no instance found");
	} else {
	log.debug("get successful, instance found");
	}return instances;
	} catch (RuntimeException re) {
	log.error("get failed", re);
	throw re;}}
//query code
public List< MallShopOrder> getNotShipOrderListPayed( Long dianpuUserId0, Boolean payed1, String sendState2){
	log.debug("getting getNotShipOrderListPayed"); 
	try {
	List< MallShopOrder> instances =this.sessionCurrent
	.createQuery("from dao.MallShopOrder where dianpuUserId=:dianpuUserId0 and payed=:payed1 and sendState=:sendState2 order by oderTime desc")
	.setParameter("dianpuUserId0", dianpuUserId0)
	.setParameter("payed1", payed1)
	.setParameter("sendState2", sendState2)
	.list();
	if (instances == null) {
	log.debug("get successful, no instance found");
	} else {
	log.debug("get successful, instance found");
	}return instances;
	} catch (RuntimeException re) {
	log.error("get failed", re);
	throw re;}}
//query code
public List< MallShopOrder> getListNewOrderBySalerId( Long dianpuUserId0, Boolean payed1){
	log.debug("getting getListNewOrderBySalerId"); 
	try {
	List< MallShopOrder> instances =this.sessionCurrent
	.createQuery("from dao.MallShopOrder where dianpuUserId=:dianpuUserId0 and payed=:payed1")
	.setParameter("dianpuUserId0", dianpuUserId0)
	.setParameter("payed1", payed1)
	.list();
	if (instances == null) {
	log.debug("get successful, no instance found");
	} else {
	log.debug("get successful, instance found");
	}return instances;
	} catch (RuntimeException re) {
	log.error("get failed", re);
	throw re;}}
//query code
public List< MallShopOrder> getListThreePayedOrderBySalerId( Boolean payed0, String paymentState1, Long dianpuUserId2){
	log.debug("getting getListThreePayedOrderBySalerId"); 
	try {
	List< MallShopOrder> instances =this.sessionCurrent
	.createQuery("from dao.MallShopOrder where payed=:payed0 and paymentState=:paymentState1 and dianpuUserId=:dianpuUserId2")
	.setParameter("payed0", payed0)
	.setParameter("paymentState1", paymentState1)
	.setParameter("dianpuUserId2", dianpuUserId2)
	.list();
	if (instances == null) {
	log.debug("get successful, no instance found");
	} else {
	log.debug("get successful, instance found");
	}return instances;
	} catch (RuntimeException re) {
	log.error("get failed", re);
	throw re;}}

	
	//BatchSelect code 		
	
	
	public List<Object> getList(){
			try {
				 List<Object> list =  this.sessionCurrent
						.createQuery("from dao.MallShopOrder").list();
				if (list == null) {
					log.debug("get successful, no instance found");
				} else {
					log.debug("get successful, instance found");
				}
				return list;
			} catch (RuntimeException re) {
				log.error("get failed", re);
				throw re;
			}
		}

	public List<MallShopOrder> getListAll(){
			try {
				 List<MallShopOrder> list =  this.sessionCurrent
						.createQuery("from dao.MallShopOrder").list();
				if (list == null) {
					log.debug("get successful, no instance found");
				} else {
					log.debug("get successful, instance found");
				}
				return list;
			} catch (RuntimeException re) {
				log.error("get failed", re);
				throw re;
			}
		}
	
	
//home code 




	protected SessionFactory getSessionFactory() {
		try {
			return (SessionFactory) new InitialContext()
					.lookup("zsbacmsSessionFactory");
		} catch (java.lang.Exception e) {
			log.error("Could not locate SessionFactory in JNDI", e);
			throw new IllegalStateException(
					"Could not locate SessionFactory in JNDI");
		}
	}
//class persist
	public void persist(MallShopOrder instance) {
            
		log.debug("persisting MallShopOrder instance");
		try {
			this.sessionCurrent.persist(instance);
			log.debug("persist successful");
		} catch (RuntimeException re) {
			log.error("persist failed", re);
			throw re;
		}
	}

	public void persist(Object transientInstance) {
            MallShopOrder instance=(MallShopOrder )transientInstance;
		log.debug("persisting MallShopOrder instance");
		try {
			this.sessionCurrent.persist(instance);
			log.debug("persist successful");
		} catch (RuntimeException re) {
			log.error("persist failed", re);
			throw re;
		}
	}

	public void attachDirty(MallShopOrder instance) {
		log.debug("attaching dirty MallShopOrder instance");
		try {
			this.sessionCurrent.saveOrUpdate(instance);
			log.debug("attach successful");
		} catch (RuntimeException re) {
			log.error("attach failed", re);
			throw re;
		}
	}

	public void attachClean(MallShopOrder instance) {
		log.debug("attaching clean MallShopOrder instance");
		try {
			this.sessionCurrent.lock(instance, LockMode.NONE);
			log.debug("attach successful");
		} catch (RuntimeException re) {
			log.error("attach failed", re);
			throw re;
		}
	}
// class delete
	public void delete(MallShopOrder persistentInstance) {

		log.debug("deleting MallShopOrder instance");
		try {
			this.sessionCurrent.delete(persistentInstance);
			log.debug("delete successful");
		} catch (RuntimeException re) {
			log.error("delete failed", re);
			throw re;
		}
	}

	public void delete(Object transientInstance) {
MallShopOrder persistentInstance=(MallShopOrder)transientInstance;
		log.debug("deleting MallShopOrder instance");
		try {
		if(transientInstance!=null){
		this.sessionCurrent.delete(persistentInstance);
			log.debug("delete successful");
	
		}
				} catch (RuntimeException re) {
			log.error("delete failed", re);
			throw re;
		}
	}

//class merge
	public MallShopOrder merge(MallShopOrder  transientInstance) {

		//System.out.println("##################update projet");
		log.debug("merging MallShopOrder instance");
		try {
			MallShopOrder result = (MallShopOrder) this.sessionCurrent
					.merge(transientInstance);
			log.debug("merge successful");
			return result;
		} catch (RuntimeException re) {
			log.error("merge failed", re);
			throw re;
		}
	}

	public MallShopOrder merge(Object transientInstance) {
MallShopOrder persistentInstance=(MallShopOrder)transientInstance;
	//	System.out.println("##################update projet");
		log.debug("merging MallShopOrder instance");
		try {
			MallShopOrder result = (MallShopOrder) this.sessionCurrent
					.merge(persistentInstance);
			log.debug("merge successful");
			return result;
		} catch (RuntimeException re) {
			log.error("merge failed", re);
			throw re;
		}
	}



	//取全部列表数据,返回object类型

		public List<Object> getListByMaxResult(int maxresult ) {
			try {
				 List<Object> list =  this.sessionCurrent
						.createQuery("from dao.MallShopOrder")
						.setMaxResults(maxresult)
						.list();
				if (list == null) {
					log.debug("get successful, no instance found");
				} else {
					log.debug("get successful, instance found");
				}
				return list;
			} catch (RuntimeException re) {
				log.error("get failed", re);
				throw re;
			}
		
	}
	public List findByExample(MallShopOrder instance) {
		log.debug("finding MallShopOrder instance by example");
		try {
			List results = this.sessionCurrent.createCriteria(
					"dao.MallShopOrder").add(Example.create(instance)).list();
			log.debug("find by example successful, result size: "
					+ results.size());
			return results;
		} catch (RuntimeException re) {
			log.error("find by example failed", re);
			throw re;
		}
	}
	//boy id
	public  MallShopOrder findById(long id) {
		log.debug("getting MallShopOrder instance with id: " + id);
		try {
			MallShopOrder instance = (MallShopOrder) this.sessionCurrent
					.get("dao.MallShopOrder", id);
			if (instance == null) {
				log.debug("get successful, no instance found");
			} else {
				log.debug("get successful, instance found");
			}
			return instance;
		} catch (RuntimeException re) {
			log.error("get failed", re);
			throw re;
		}
	}

	public void delete(long id) {
        MallShopOrder persistentInstance=findById(id);
		log.debug("deleting MallShopOrder instance");
		try {
		
		if(persistentInstance!=null){
		this.sessionCurrent.delete(persistentInstance);
			
			log.debug("delete successful");
	
		}
				} catch (RuntimeException re) {
			log.error("delete failed", re);
			throw re;
		}
	}
//your code<@YOURCODE>

 public static void main(String argv[]){
            util.DaoService ds= util.DaoService.getIntrance();
	
	  		MallShopOrderHome home=new MallShopOrderHome();
	
	  	//通过创建数据库会话方式
	  	org.hibernate.Transaction tx2=ds.openSession().beginTransaction();
	  	home.setSessionCurrent(ds.openSession());
       	System.out.println(home.getListAll());	 	
	    tx2.commit();
 }	
 


//</autoClassCode>
	
}
