
package dao;

import java.util.List;

import util.DaoService;

import util.ObjectDao;

import util.ObjectHome;

import org.apache.commons.logging.Log;

import org.apache.commons.logging.LogFactory;


import dao.MallShopOrder;

import dao.MallShopOrderHome;

 /**
*功能：定义实体类基本操作事务抽象层：查询，添加，删除，修改
 * @author www.juuluu.org 逐龙juuluu
* tel:020-28983330 mobile:15975485229
 * email:wujavei@126.com  QQ:274390981
 * @see MallShopOrder
*实现：java sdk 1.6 hibernate 3.0 struts 1.2.9	
 */
 

public class MallShopOrderDao extends ObjectDao {

	//<autoClassCode>


	
		private static final org.apache.commons.logging.Log log = org.apache.commons.logging.LogFactory.getLog(MallShopOrderHome.class);
	
	private ObjectHome objectHome=new MallShopOrderHome();
	
	
	
	//BatchDelet  
	
	//del by validaty 
	
	//SaveAndGet 	
	
	//FindByClassName 	 
	
	//Link 	
	
	//BatchQuery 	//query code
public List< MallShopOrder> getAllListByShopUsreId( Long dianpuUserId0){
	DaoService ds=DaoService.getIntrance();
	org.hibernate.Session session=ds.openSession();
 	 org.hibernate.Transaction ts=session.beginTransaction();
 	 MallShopOrderHome home=(MallShopOrderHome)getObjectHome();
	home.setSessionCurrent(session);	List< MallShopOrder> 	Instance=home.getAllListByShopUsreId( dianpuUserId0);
	ts.commit(); 
	  ds.close();
	return Instance;
}
//query code
public  MallShopOrder getOrferByOrderId( String orderID0){
	DaoService ds=DaoService.getIntrance();
	org.hibernate.Session session=ds.openSession();
 	 org.hibernate.Transaction ts=session.beginTransaction();
 	 MallShopOrderHome home=(MallShopOrderHome)getObjectHome();
	home.setSessionCurrent(session);	MallShopOrder 	Instance=home.getOrferByOrderId( orderID0);
	ts.commit(); 
	  ds.close();
	return Instance;
}
//query code
public List< MallShopOrder> getListAllByBuyerId( Long userId0){
	DaoService ds=DaoService.getIntrance();
	org.hibernate.Session session=ds.openSession();
 	 org.hibernate.Transaction ts=session.beginTransaction();
 	 MallShopOrderHome home=(MallShopOrderHome)getObjectHome();
	home.setSessionCurrent(session);	List< MallShopOrder> 	Instance=home.getListAllByBuyerId( userId0);
	ts.commit(); 
	  ds.close();
	return Instance;
}
//query code
public List< MallShopOrder> getListBPayByBuyerId( Long userId0, Boolean payed1){
	DaoService ds=DaoService.getIntrance();
	org.hibernate.Session session=ds.openSession();
 	 org.hibernate.Transaction ts=session.beginTransaction();
 	 MallShopOrderHome home=(MallShopOrderHome)getObjectHome();
	home.setSessionCurrent(session);	List< MallShopOrder> 	Instance=home.getListBPayByBuyerId( userId0, payed1);
	ts.commit(); 
	  ds.close();
	return Instance;
}
//query code
public List< MallShopOrder> getNotShipOrderListPayed( Long dianpuUserId0, Boolean payed1, String sendState2){
	DaoService ds=DaoService.getIntrance();
	org.hibernate.Session session=ds.openSession();
 	 org.hibernate.Transaction ts=session.beginTransaction();
 	 MallShopOrderHome home=(MallShopOrderHome)getObjectHome();
	home.setSessionCurrent(session);	List< MallShopOrder> 	Instance=home.getNotShipOrderListPayed( dianpuUserId0, payed1, sendState2);
	ts.commit(); 
	  ds.close();
	return Instance;
}
//query code
public List< MallShopOrder> getListNewOrderBySalerId( Long dianpuUserId0, Boolean payed1){
	DaoService ds=DaoService.getIntrance();
	org.hibernate.Session session=ds.openSession();
 	 org.hibernate.Transaction ts=session.beginTransaction();
 	 MallShopOrderHome home=(MallShopOrderHome)getObjectHome();
	home.setSessionCurrent(session);	List< MallShopOrder> 	Instance=home.getListNewOrderBySalerId( dianpuUserId0, payed1);
	ts.commit(); 
	  ds.close();
	return Instance;
}
//query code
public List< MallShopOrder> getListThreePayedOrderBySalerId( Boolean payed0, String paymentState1, Long dianpuUserId2){
	DaoService ds=DaoService.getIntrance();
	org.hibernate.Session session=ds.openSession();
 	 org.hibernate.Transaction ts=session.beginTransaction();
 	 MallShopOrderHome home=(MallShopOrderHome)getObjectHome();
	home.setSessionCurrent(session);	List< MallShopOrder> 	Instance=home.getListThreePayedOrderBySalerId( payed0, paymentState1, dianpuUserId2);
	ts.commit(); 
	  ds.close();
	return Instance;
}

	
	//BatchSelect  	
	
	
	
	//取全部数据
	
		public List<MallShopOrder> getListAll(){
		
		List<MallShopOrder> list=null;
		
		DaoService ds=DaoService.getIntrance();
org.hibernate.Session session=ds.openSession();
org.hibernate.Transaction ts=session.beginTransaction();
try{
	    	
		
		//设置数据库会话
		
		MallShopOrderHome home=((MallShopOrderHome)getObjectHome());
		
		home.setSessionCurrent(session);
		
		MallShopOrderHome beanHome=(MallShopOrderHome)getObjectHome();
		
		list=beanHome.getListAll();
		
			ts.commit();
			
			
}catch(org.hibernate.AssertionFailure e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误!");
			log.error("dao error failed", e);
			//事务回滚
			ts.rollback();
		}catch(java.lang.RuntimeException e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误!");
			log.error("dao error failed", e);
			//事务回滚
			ts.rollback();
		}finally{
	    		//关闭会话
	    		ds.closeSession();return list;
		}//end try

	}
	
	public List<Object> getList(){
	
	List<Object> list=null;
	
	DaoService ds=DaoService.getIntrance();
org.hibernate.Session session=ds.openSession();
org.hibernate.Transaction ts=session.beginTransaction();
try{
	    	
				//设置数据库会话
		MallShopOrderHome home=((MallShopOrderHome)getObjectHome());
		home.setSessionCurrent(session);
		list=getObjectHome().getList();
	ts.commit();
			
}catch(org.hibernate.AssertionFailure e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误!");
			log.error("dao error failed", e);
			//事务回滚
			ts.rollback();
		}catch(java.lang.RuntimeException e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误!");
			log.error("dao error failed", e);
			//事务回滚
			ts.rollback();
		}finally{
	    		//关闭会话
	    		ds.closeSession();return list;
		}//end try

	}
	
	
  public void update(Object object ){
	  DaoService ds=DaoService.getIntrance();
org.hibernate.Session session=ds.openSession();
org.hibernate.Transaction ts=session.beginTransaction();
try{
	    	
				//设置数据库会话
		MallShopOrderHome home=((MallShopOrderHome)getObjectHome());
		home.setSessionCurrent(session);
		getObjectHome().merge(   object) ;
		ts.commit();
			
}catch(org.hibernate.AssertionFailure e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误!");
			log.error("dao error failed", e);
			//事务回滚
			ts.rollback();
		}catch(java.lang.RuntimeException e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误!");
			log.error("dao error failed", e);
			//事务回滚
			ts.rollback();
		}finally{
	    		//关闭会话
	    		ds.closeSession();
		}//end try

	}
  public void update(MallShopOrder  object ){
	  DaoService ds=DaoService.getIntrance();
org.hibernate.Session session=ds.openSession();
org.hibernate.Transaction ts=session.beginTransaction();
try{
	    	
				//设置数据库会话
		MallShopOrderHome home=((MallShopOrderHome)getObjectHome());
		home.setSessionCurrent(session);
		getObjectHome().merge(   object) ;
	ts.commit();
			
}catch(org.hibernate.AssertionFailure e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误!");
			log.error("dao error failed", e);
			//事务回滚
			ts.rollback();
		}catch(java.lang.RuntimeException e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误!");
			log.error("dao error failed", e);
			//事务回滚
			ts.rollback();
		}finally{
	    		//关闭会话
	    		ds.closeSession();
		}//end try

	}
	    public void add(MallShopOrder object ){
	    DaoService ds=DaoService.getIntrance();
org.hibernate.Session session=ds.openSession();
org.hibernate.Transaction ts=session.beginTransaction();
try{
	    	
					//设置数据库会话
		MallShopOrderHome home=((MallShopOrderHome)getObjectHome());
		home.setSessionCurrent(session);
			getObjectHome().persist(object) ;
			
						//刷新hibernate缓存，保存最新对象
			session.flush();
			//将对象从session中逐出，即session的EntityEntries属性中逐出
			session.evict(object);
			//提交事务
			ts.commit();
			
}catch(org.hibernate.AssertionFailure e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误!");
			log.error("dao error failed", e);
			//事务回滚
			ts.rollback();
		}catch(java.lang.RuntimeException e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误!");
			log.error("dao error failed", e);
			//事务回滚
			ts.rollback();
		}finally{
	    		//关闭会话
	    		ds.closeSession();
		}//end try

		}
	    public void add(Object object ){
	    DaoService ds=DaoService.getIntrance();
org.hibernate.Session session=ds.openSession();
org.hibernate.Transaction ts=session.beginTransaction();
try{
	    	
					//设置数据库会话
		MallShopOrderHome home=((MallShopOrderHome)getObjectHome());
		home.setSessionCurrent(session);
			getObjectHome().persist(object) ;
			//刷新hibernate缓存，保存最新对象
			session.flush();
			//将对象从session中逐出，即session的EntityEntries属性中逐出
			session.evict(object);
			//提交事务
			
			ts.commit();
			
}catch(org.hibernate.AssertionFailure e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误!");
			log.error("dao error failed", e);
			//事务回滚
			ts.rollback();
		}catch(java.lang.RuntimeException e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误!");
			log.error("dao error failed", e);
			//事务回滚
			ts.rollback();
		}finally{
	    		//关闭会话
	    		ds.closeSession();
		}//end try

		}
  public void delete(MallShopOrder  object ){
  DaoService ds=DaoService.getIntrance();
org.hibernate.Session session=ds.openSession();
org.hibernate.Transaction ts=session.beginTransaction();
try{
	    	
				//设置数据库会话
		MallShopOrderHome home=((MallShopOrderHome)getObjectHome());
		home.setSessionCurrent(session);
		getObjectHome().delete( object) ;
		ts.commit();
			
}catch(org.hibernate.AssertionFailure e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误!");
			log.error("dao error failed", e);
			//事务回滚
			ts.rollback();
		}catch(java.lang.RuntimeException e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误!");
			log.error("dao error failed", e);
			//事务回滚
			ts.rollback();
		}finally{
	    		//关闭会话
	    		ds.closeSession();
		}//end try

		
	}

  public void delete(Object object ){
  DaoService ds=DaoService.getIntrance();
org.hibernate.Session session=ds.openSession();
org.hibernate.Transaction ts=session.beginTransaction();
try{
	    	
				//设置数据库会话
		MallShopOrderHome home=((MallShopOrderHome)getObjectHome());
		home.setSessionCurrent(session);
		getObjectHome().delete( object) ;
		ts.commit();
		
}catch(org.hibernate.AssertionFailure e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误!");
			log.error("dao error failed", e);
			//事务回滚
			ts.rollback();
		}catch(java.lang.RuntimeException e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误!");
			log.error("dao error failed", e);
			//事务回滚
			ts.rollback();
		}finally{
	    		//关闭会话
	    		ds.closeSession();
		}//end try

	}
  	public MallShopOrder merge(MallShopOrder Instance) {
  	MallShopOrder Instances=null;
  	DaoService ds=DaoService.getIntrance();
org.hibernate.Session session=ds.openSession();
org.hibernate.Transaction ts=session.beginTransaction();
try{
	    	
				//设置数据库会话
		MallShopOrderHome home=((MallShopOrderHome)getObjectHome());
		home.setSessionCurrent(session);
		Instances=((MallShopOrderHome)getObjectHome()).merge(   Instance) ;
			//刷新hibernate缓存，保存最新对象
			session.flush();
			//将对象从session中逐出，即session的EntityEntries属性中逐出
			session.evict(Instance);
			//提交事务
			ts.commit();
			
}catch(org.hibernate.AssertionFailure e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误!");
			log.error("dao error failed", e);
			//事务回滚
			ts.rollback();
		}catch(java.lang.RuntimeException e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误!");
			log.error("dao error failed", e);
			//事务回滚
			ts.rollback();
		}finally{
	    		//关闭会话
	    		ds.closeSession();return Instances;
		}//end try

	}
	public Object merge(Object transientInstance) {
	DaoService ds=DaoService.getIntrance();
org.hibernate.Session session=ds.openSession();
org.hibernate.Transaction ts=session.beginTransaction();
try{
	    		
				//设置数据库会话
		MallShopOrderHome home=((MallShopOrderHome)getObjectHome());
		home.setSessionCurrent(session);
			
		transientInstance=getObjectHome().merge(   transientInstance) ;
		  	//刷新hibernate缓存，保存最新对象
			session.flush();
			//将对象从session中逐出，即session的EntityEntries属性中逐出
			session.evict(transientInstance);
			//提交事务
		  	ts.commit();
			}catch(org.hibernate.AssertionFailure e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误!");
			log.error("dao error failed", e);
			//事务回滚
			ts.rollback();
		}catch(java.lang.RuntimeException e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误!");
			log.error("dao error failed", e);
			//事务回滚
			ts.rollback();
		}finally{
	    		//关闭会话
	    		ds.closeSession();return transientInstance;
		}//end try
	}

		public void setObjectHome(ObjectHome objectHome) {
			this.objectHome = objectHome;
		}

		public ObjectHome getObjectHome() {
			return this.objectHome;
		} 
		
		//id删除对象
	    public void delete(long id){
	    DaoService ds=DaoService.getIntrance();
org.hibernate.Session session=ds.openSession();
org.hibernate.Transaction ts=session.beginTransaction();
try{
	    	
	    			//设置数据库会话
		MallShopOrderHome home=((MallShopOrderHome)getObjectHome());
		home.setSessionCurrent(session);	
	    		getObjectHome().delete(id) ;
	  	  	ts.commit();
			
}catch(org.hibernate.AssertionFailure e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误!");
			log.error("dao error failed", e);
			//事务回滚
			ts.rollback();
		}catch(java.lang.RuntimeException e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误!");
			log.error("dao error failed", e);
			//事务回滚
			ts.rollback();
		}finally{
	    		//关闭会话
	    		ds.closeSession();
		}//end try
	
	    		
	    	}
	    	//获取对象  
	  	 public  Object get(long id){
	  	 Object object =null;
	  	 DaoService ds=DaoService.getIntrance();
org.hibernate.Session session=ds.openSession();
org.hibernate.Transaction ts=session.beginTransaction();
try{
	    	
	  			//设置数据库会话
		MallShopOrderHome home=((MallShopOrderHome)getObjectHome());
		home.setSessionCurrent(session);		
	  		object =getObjectHome().findById(id);
	  	ts.commit();
		}catch(org.hibernate.AssertionFailure e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误!");
			log.error("dao error failed", e);
			//事务回滚
			ts.rollback();
		}catch(java.lang.RuntimeException e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误!");
			log.error("dao error failed", e);
			//事务回滚
			ts.rollback();
		}finally{
	    		//关闭会话
	    		ds.closeSession();
			return object;
		}
	  		}
		//保存并获取包含对象ID实体对象

//your code<@YOURCODE>

 public static void main(String argv[]){
           util.DaoService.getIntrance();
	  		MallShopOrderDao daoMallShopOrderDao=new MallShopOrderDao();
	  		MallShopOrder oMallShopOrderDao=new MallShopOrder ();
	  		oMallShopOrderDao=daoMallShopOrderDao.merge(oMallShopOrderDao);
	  	 }
	  	 


//</autoClassCode>	  	 
}
