
package dao;

import java.util.List;

import util.DaoService;

import util.ObjectDao;

import util.ObjectHome;

import org.apache.commons.logging.Log;

import org.apache.commons.logging.LogFactory;


import dao.MallShopMallArticle;

import dao.MallShopMallArticleHome;

 /**
*功能：定义实体类基本操作事务抽象层：查询，添加，删除，修改
 * @author www.juuluu.org 逐龙juuluu
* tel:020-28983330 mobile:15975485229
 * email:wujavei@126.com  QQ:274390981
 * @see MallShopMallArticle
*实现：java sdk 1.6 hibernate 3.0 struts 1.2.9	
 */
 

public class MallShopMallArticleDao extends ObjectDao {

	//<autoClassCode>


	
		private static final org.apache.commons.logging.Log log = org.apache.commons.logging.LogFactory.getLog(MallShopMallArticleHome.class);
	
	private ObjectHome objectHome=new MallShopMallArticleHome();
	
	
	
	//BatchDelet  
	
	//del by validaty 		//删除数据 
		public void delAllByDpCmsCatId(Integer catId) {
			  DaoService ds=DaoService.getIntrance();
			  org.hibernate.Session session=ds.openSession();
			  org.hibernate.Transaction ts=session.beginTransaction();
			  try{
			  	    	
			  				//设置数据库会话
			  		MallShopMallArticleHome home=((MallShopMallArticleHome)getObjectHome());
			  		home.setSessionCurrent(session);
			  		home.delAllByDpCmsCatId( catId);	
			  		ts.commit();
			  			
			  }catch(org.hibernate.AssertionFailure e){
			  			System.out.println("删除操作错误!");
			  			log.error("dao error failed", e);
			  			//事务回滚
			  			ts.rollback();
			  		}catch(java.lang.RuntimeException e){
			  			System.out.println("删除操作错误!");
			  			log.error("dao error failed", e);
			  			//事务回滚
			  			ts.rollback();
			  		}finally{
			  	    		//关闭会话
			  	    		ds.closeSession();
			  		}//end try
	
			 }//end class

	
	//SaveAndGet 	
	
	//FindByClassName 	 
	
	//Link 	
	
	//BatchQuery 	//query code
public List< MallShopMallArticle> getListByDpId( Long dianpuId0 ,int  maxResult){
	DaoService ds=DaoService.getIntrance();
	org.hibernate.Session session=ds.openSession();
 	 org.hibernate.Transaction ts=session.beginTransaction();
	List< MallShopMallArticle> 	queryData=null;

 	 try{

 	 MallShopMallArticleHome home=(MallShopMallArticleHome)getObjectHome();
	home.setSessionCurrent(session);
		queryData=home.getListByDpId( dianpuId0 , maxResult);
	 ts.commit();  
	  }catch(org.hibernate.AssertionFailure e){ 
	 e.printStackTrace();
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopMallArticle.");
	 	log.error("dao error failed", e); 
	 	ts.rollback();
	 	}catch(java.lang.RuntimeException e){ 
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopMallArticle."); 
	 	log.error("dao error failed", e);  
	 	e.printStackTrace();  
	 	ts.rollback();  
	 	}finally{  
	//关闭会话 
	ds.closeSession(); 
	 return queryData;  
	 }//end try
	 }//end
//query code
public List< MallShopMallArticle> getListByDpCmsCatId( Integer catId0 ,int  maxResult){
	DaoService ds=DaoService.getIntrance();
	org.hibernate.Session session=ds.openSession();
 	 org.hibernate.Transaction ts=session.beginTransaction();
	List< MallShopMallArticle> 	queryData=null;

 	 try{

 	 MallShopMallArticleHome home=(MallShopMallArticleHome)getObjectHome();
	home.setSessionCurrent(session);
		queryData=home.getListByDpCmsCatId( catId0 , maxResult);
	 ts.commit();  
	  }catch(org.hibernate.AssertionFailure e){ 
	 e.printStackTrace();
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopMallArticle.");
	 	log.error("dao error failed", e); 
	 	ts.rollback();
	 	}catch(java.lang.RuntimeException e){ 
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopMallArticle."); 
	 	log.error("dao error failed", e);  
	 	e.printStackTrace();  
	 	ts.rollback();  
	 	}finally{  
	//关闭会话 
	ds.closeSession(); 
	 return queryData;  
	 }//end try
	 }//end
//query code
public List< MallShopMallArticle> getTopNewListByDpId( Long dianpuId0 ,int  maxResult){
	DaoService ds=DaoService.getIntrance();
	org.hibernate.Session session=ds.openSession();
 	 org.hibernate.Transaction ts=session.beginTransaction();
	List< MallShopMallArticle> 	queryData=null;

 	 try{

 	 MallShopMallArticleHome home=(MallShopMallArticleHome)getObjectHome();
	home.setSessionCurrent(session);
		queryData=home.getTopNewListByDpId( dianpuId0 , maxResult);
	 ts.commit();  
	  }catch(org.hibernate.AssertionFailure e){ 
	 e.printStackTrace();
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopMallArticle.");
	 	log.error("dao error failed", e); 
	 	ts.rollback();
	 	}catch(java.lang.RuntimeException e){ 
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopMallArticle."); 
	 	log.error("dao error failed", e);  
	 	e.printStackTrace();  
	 	ts.rollback();  
	 	}finally{  
	//关闭会话 
	ds.closeSession(); 
	 return queryData;  
	 }//end try
	 }//end
//query code
public  MallShopMallArticle getByDpIdTitleEnCatName( Long dianpuId0, String title1, String catNameEn2){
	DaoService ds=DaoService.getIntrance();
	org.hibernate.Session session=ds.openSession();
 	 org.hibernate.Transaction ts=session.beginTransaction();	MallShopMallArticle 	queryData=null;

 	 try{

 	 MallShopMallArticleHome home=(MallShopMallArticleHome)getObjectHome();
	home.setSessionCurrent(session);
		queryData=home.getByDpIdTitleEnCatName( dianpuId0, title1, catNameEn2);
	 ts.commit();  
	  }catch(org.hibernate.AssertionFailure e){ 
	 e.printStackTrace();
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopMallArticle.");
	 	log.error("dao error failed", e); 
	 	ts.rollback();
	 	}catch(java.lang.RuntimeException e){ 
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopMallArticle."); 
	 	log.error("dao error failed", e);  
	 	e.printStackTrace();  
	 	ts.rollback();  
	 	}finally{  
	//关闭会话 
	ds.closeSession(); 
	 return queryData;  
	 }//end try
	 }//end
//query code
public  MallShopMallArticle getByDpIdTitleCNCatName( Long dianpuId0, String title1, String catNameCn2){
	DaoService ds=DaoService.getIntrance();
	org.hibernate.Session session=ds.openSession();
 	 org.hibernate.Transaction ts=session.beginTransaction();	MallShopMallArticle 	queryData=null;

 	 try{

 	 MallShopMallArticleHome home=(MallShopMallArticleHome)getObjectHome();
	home.setSessionCurrent(session);
		queryData=home.getByDpIdTitleCNCatName( dianpuId0, title1, catNameCn2);
	 ts.commit();  
	  }catch(org.hibernate.AssertionFailure e){ 
	 e.printStackTrace();
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopMallArticle.");
	 	log.error("dao error failed", e); 
	 	ts.rollback();
	 	}catch(java.lang.RuntimeException e){ 
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopMallArticle."); 
	 	log.error("dao error failed", e);  
	 	e.printStackTrace();  
	 	ts.rollback();  
	 	}finally{  
	//关闭会话 
	ds.closeSession(); 
	 return queryData;  
	 }//end try
	 }//end
//query code
public  MallShopMallArticle getArticleByDpIdEnCatNameSysKey( Long dianpuId0, String catNameEn1, String systemTag2){
	DaoService ds=DaoService.getIntrance();
	org.hibernate.Session session=ds.openSession();
 	 org.hibernate.Transaction ts=session.beginTransaction();	MallShopMallArticle 	queryData=null;

 	 try{

 	 MallShopMallArticleHome home=(MallShopMallArticleHome)getObjectHome();
	home.setSessionCurrent(session);
		queryData=home.getArticleByDpIdEnCatNameSysKey( dianpuId0, catNameEn1, systemTag2);
	 ts.commit();  
	  }catch(org.hibernate.AssertionFailure e){ 
	 e.printStackTrace();
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopMallArticle.");
	 	log.error("dao error failed", e); 
	 	ts.rollback();
	 	}catch(java.lang.RuntimeException e){ 
	 	System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopMallArticle."); 
	 	log.error("dao error failed", e);  
	 	e.printStackTrace();  
	 	ts.rollback();  
	 	}finally{  
	//关闭会话 
	ds.closeSession(); 
	 return queryData;  
	 }//end try
	 }//end

	
	//BatchSelect  	
	
	
	
	//取全部数据
	
		public List<MallShopMallArticle> getListAll(){
		
		List<MallShopMallArticle> list=null;
		
		DaoService ds=DaoService.getIntrance();
org.hibernate.Session session=ds.openSession();
org.hibernate.Transaction ts=session.beginTransaction();
try{
	    	
		
		//设置数据库会话
		
		MallShopMallArticleHome home=((MallShopMallArticleHome)getObjectHome());
		
		home.setSessionCurrent(session);
		
		MallShopMallArticleHome beanHome=(MallShopMallArticleHome)getObjectHome();
		
		list=beanHome.getListAll();
		
			ts.commit();
			
			
}catch(org.hibernate.AssertionFailure e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopMallArticle");
			log.error("dao error failed", e);
			e.printStackTrace();
			//事务回滚
			ts.rollback();
		}catch(java.lang.RuntimeException e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopMallArticle");
			log.error("dao error failed", e);
			e.printStackTrace();
			//事务回滚
			ts.rollback();
		}finally{
	    		//关闭会话
	    		ds.closeSession();return list;
		}//end try

	}
	
	public List<Object> getList(){
	
	List<Object> list=null;
	
	DaoService ds=DaoService.getIntrance();
org.hibernate.Session session=ds.openSession();
org.hibernate.Transaction ts=session.beginTransaction();
try{
	    	
				//设置数据库会话
		MallShopMallArticleHome home=((MallShopMallArticleHome)getObjectHome());
		home.setSessionCurrent(session);
		list=getObjectHome().getList();
	ts.commit();
			
}catch(org.hibernate.AssertionFailure e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopMallArticle");
			log.error("dao error failed", e);
			e.printStackTrace();
			//事务回滚
			ts.rollback();
		}catch(java.lang.RuntimeException e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopMallArticle");
			log.error("dao error failed", e);
			e.printStackTrace();
			//事务回滚
			ts.rollback();
		}finally{
	    		//关闭会话
	    		ds.closeSession();return list;
		}//end try

	}
	
	
  public void update(Object object ){
	  DaoService ds=DaoService.getIntrance();
org.hibernate.Session session=ds.openSession();
org.hibernate.Transaction ts=session.beginTransaction();
try{
	    	
				//设置数据库会话
		MallShopMallArticleHome home=((MallShopMallArticleHome)getObjectHome());
		home.setSessionCurrent(session);
		getObjectHome().merge(   object) ;
		ts.commit();
			
}catch(org.hibernate.AssertionFailure e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopMallArticle");
			log.error("dao error failed", e);
			e.printStackTrace();
			//事务回滚
			ts.rollback();
		}catch(java.lang.RuntimeException e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopMallArticle");
			log.error("dao error failed", e);
			e.printStackTrace();
			//事务回滚
			ts.rollback();
		}finally{
	    		//关闭会话
	    		ds.closeSession();
		}//end try

	}
  public void update(MallShopMallArticle  object ){
	  DaoService ds=DaoService.getIntrance();
org.hibernate.Session session=ds.openSession();
org.hibernate.Transaction ts=session.beginTransaction();
try{
	    	
				//设置数据库会话
		MallShopMallArticleHome home=((MallShopMallArticleHome)getObjectHome());
		home.setSessionCurrent(session);
		getObjectHome().merge(   object) ;
	ts.commit();
			
}catch(org.hibernate.AssertionFailure e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopMallArticle");
			log.error("dao error failed", e);
			e.printStackTrace();
			//事务回滚
			ts.rollback();
		}catch(java.lang.RuntimeException e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopMallArticle");
			log.error("dao error failed", e);
			e.printStackTrace();
			//事务回滚
			ts.rollback();
		}finally{
	    		//关闭会话
	    		ds.closeSession();
		}//end try

	}
	    public void add(MallShopMallArticle object ){
	    DaoService ds=DaoService.getIntrance();
org.hibernate.Session session=ds.openSession();
org.hibernate.Transaction ts=session.beginTransaction();
try{
	    	
					//设置数据库会话
		MallShopMallArticleHome home=((MallShopMallArticleHome)getObjectHome());
		home.setSessionCurrent(session);
			getObjectHome().persist(object) ;
			
						//刷新hibernate缓存，保存最新对象
			session.flush();
			//将对象从session中逐出，即session的EntityEntries属性中逐出
			session.evict(object);
			//提交事务
			ts.commit();
			
}catch(org.hibernate.AssertionFailure e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopMallArticle");
			log.error("dao error failed", e);
			e.printStackTrace();
			//事务回滚
			ts.rollback();
		}catch(java.lang.RuntimeException e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopMallArticle");
			log.error("dao error failed", e);
			e.printStackTrace();
			//事务回滚
			ts.rollback();
		}finally{
	    		//关闭会话
	    		ds.closeSession();
		}//end try

		}
	    public void add(Object object ){
	    DaoService ds=DaoService.getIntrance();
org.hibernate.Session session=ds.openSession();
org.hibernate.Transaction ts=session.beginTransaction();
try{
	    	
					//设置数据库会话
		MallShopMallArticleHome home=((MallShopMallArticleHome)getObjectHome());
		home.setSessionCurrent(session);
			getObjectHome().persist(object) ;
			//刷新hibernate缓存，保存最新对象
			session.flush();
			//将对象从session中逐出，即session的EntityEntries属性中逐出
			session.evict(object);
			//提交事务
			
			ts.commit();
			
}catch(org.hibernate.AssertionFailure e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopMallArticle");
			log.error("dao error failed", e);
			e.printStackTrace();
			//事务回滚
			ts.rollback();
		}catch(java.lang.RuntimeException e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopMallArticle");
			log.error("dao error failed", e);
			e.printStackTrace();
			//事务回滚
			ts.rollback();
		}finally{
	    		//关闭会话
	    		ds.closeSession();
		}//end try

		}
  public void delete(MallShopMallArticle  object ){
  DaoService ds=DaoService.getIntrance();
org.hibernate.Session session=ds.openSession();
org.hibernate.Transaction ts=session.beginTransaction();
try{
	    	
				//设置数据库会话
		MallShopMallArticleHome home=((MallShopMallArticleHome)getObjectHome());
		home.setSessionCurrent(session);
		getObjectHome().delete( object) ;
		ts.commit();
			
}catch(org.hibernate.AssertionFailure e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopMallArticle");
			log.error("dao error failed", e);
			e.printStackTrace();
			//事务回滚
			ts.rollback();
		}catch(java.lang.RuntimeException e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopMallArticle");
			log.error("dao error failed", e);
			e.printStackTrace();
			//事务回滚
			ts.rollback();
		}finally{
	    		//关闭会话
	    		ds.closeSession();
		}//end try

		
	}

  public void delete(Object object ){
  DaoService ds=DaoService.getIntrance();
org.hibernate.Session session=ds.openSession();
org.hibernate.Transaction ts=session.beginTransaction();
try{
	    	
				//设置数据库会话
		MallShopMallArticleHome home=((MallShopMallArticleHome)getObjectHome());
		home.setSessionCurrent(session);
		getObjectHome().delete( object) ;
		ts.commit();
		
}catch(org.hibernate.AssertionFailure e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopMallArticle");
			log.error("dao error failed", e);
			e.printStackTrace();
			//事务回滚
			ts.rollback();
		}catch(java.lang.RuntimeException e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopMallArticle");
			log.error("dao error failed", e);
			e.printStackTrace();
			//事务回滚
			ts.rollback();
		}finally{
	    		//关闭会话
	    		ds.closeSession();
		}//end try

	}
  	public MallShopMallArticle merge(MallShopMallArticle Instance) {
  	MallShopMallArticle Instances=null;
  	DaoService ds=DaoService.getIntrance();
org.hibernate.Session session=ds.openSession();
org.hibernate.Transaction ts=session.beginTransaction();
try{
	    	
				//设置数据库会话
		MallShopMallArticleHome home=((MallShopMallArticleHome)getObjectHome());
		home.setSessionCurrent(session);
		Instances=((MallShopMallArticleHome)getObjectHome()).merge(   Instance) ;
			//刷新hibernate缓存，保存最新对象
			session.flush();
			//将对象从session中逐出，即session的EntityEntries属性中逐出
			session.evict(Instance);
			//提交事务
			ts.commit();
			
}catch(org.hibernate.AssertionFailure e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopMallArticle");
			log.error("dao error failed", e);
			e.printStackTrace();
			//事务回滚
			ts.rollback();
		}catch(java.lang.RuntimeException e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopMallArticle");
			log.error("dao error failed", e);
			e.printStackTrace();
			//事务回滚
			ts.rollback();
		}finally{
	    		//关闭会话
	    		ds.closeSession();return Instances;
		}//end try

	}
	public Object merge(Object transientInstance) {
	DaoService ds=DaoService.getIntrance();
org.hibernate.Session session=ds.openSession();
org.hibernate.Transaction ts=session.beginTransaction();
try{
	    		
				//设置数据库会话
		MallShopMallArticleHome home=((MallShopMallArticleHome)getObjectHome());
		home.setSessionCurrent(session);
			
		transientInstance=getObjectHome().merge(   transientInstance) ;
		  	//刷新hibernate缓存，保存最新对象
			session.flush();
			//将对象从session中逐出，即session的EntityEntries属性中逐出
			session.evict(transientInstance);
			//提交事务
		  	ts.commit();
			}catch(org.hibernate.AssertionFailure e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopMallArticle");
			log.error("dao error failed", e);
			e.printStackTrace();
			//事务回滚
			ts.rollback();
		}catch(java.lang.RuntimeException e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopMallArticle");
			log.error("dao error failed", e);
			e.printStackTrace();
			//事务回滚
			ts.rollback();
		}finally{
	    		//关闭会话
	    		ds.closeSession();return transientInstance;
		}//end try
	}

		public void setObjectHome(ObjectHome objectHome) {
			this.objectHome = objectHome;
		}

		public ObjectHome getObjectHome() {
			return this.objectHome;
		} 
		
		//id删除对象
	    public void delete(long id){
	    DaoService ds=DaoService.getIntrance();
org.hibernate.Session session=ds.openSession();
org.hibernate.Transaction ts=session.beginTransaction();
try{
	    	
	    			//设置数据库会话
		MallShopMallArticleHome home=((MallShopMallArticleHome)getObjectHome());
		home.setSessionCurrent(session);	
	    		getObjectHome().delete(id) ;
	  	  	ts.commit();
			
}catch(org.hibernate.AssertionFailure e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopMallArticle");
			log.error("dao error failed", e);
			e.printStackTrace();
			//事务回滚
			ts.rollback();
		}catch(java.lang.RuntimeException e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopMallArticle");
			log.error("dao error failed", e);
			e.printStackTrace();
			//事务回滚
			ts.rollback();
		}finally{
	    		//关闭会话
	    		ds.closeSession();
		}//end try
	
	    		
	    	}
	    	//获取对象  
	  	 public  Object get(long id){
	  	 Object object =null;
	  	 DaoService ds=DaoService.getIntrance();
org.hibernate.Session session=ds.openSession();
org.hibernate.Transaction ts=session.beginTransaction();
try{
	    	
	  			//设置数据库会话
		MallShopMallArticleHome home=((MallShopMallArticleHome)getObjectHome());
		home.setSessionCurrent(session);		
	  		object =getObjectHome().findById(id);
	  	ts.commit();
		}catch(org.hibernate.AssertionFailure e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopMallArticle");
			log.error("dao error failed", e);
			e.printStackTrace();
			//事务回滚
			ts.rollback();
		}catch(java.lang.RuntimeException e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopMallArticle");
			log.error("dao error failed", e);
			e.printStackTrace();
			//事务回滚
			ts.rollback();
		}finally{
	    		//关闭会话
	    		ds.closeSession();
			return object;
		}
	  		}
		//保存并获取包含对象ID实体对象
		
	
 public List<MallShopMallArticle> getListMax(int max, String orderByValidaty,
			String orderType) {
		// TODO Auto-generated method stub
		List<MallShopMallArticle> list=null;
		
		DaoService ds=DaoService.getIntrance();
		org.hibernate.Session session=ds.openSession();
		org.hibernate.Transaction ts=session.beginTransaction();
		try{
	    	
		
		//设置数据库会话
		
		MallShopMallArticleHome home=((MallShopMallArticleHome)getObjectHome());
		
		home.setSessionCurrent(session);
		
		MallShopMallArticleHome beanHome=(MallShopMallArticleHome)getObjectHome();
		
		list=beanHome.getListMax( max,  orderByValidaty,
				 orderType);
		
			ts.commit();
			
			
}catch(org.hibernate.AssertionFailure e){
	e.printStackTrace();
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopMallArticle");
			log.error("dao error failed", e);
			e.printStackTrace();
			//事务回滚
			ts.rollback();
		}catch(java.lang.RuntimeException e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopMallArticle");
			log.error("dao error failed", e);
			e.printStackTrace();
			e.printStackTrace();
			//事务回滚
			ts.rollback();
		}finally{
	    		//关闭会话
	    		ds.closeSession();return list;
		}//end try
	}

	public List<MallShopMallArticle> getList_qeury(String sqlCondation, int max,
			String orderBy, String orderType) {
		// TODO Auto-generated method stub
		// TODO Auto-generated method stub
		List<MallShopMallArticle> list=null;
		
		DaoService ds=DaoService.getIntrance();
		org.hibernate.Session session=ds.openSession();
		org.hibernate.Transaction ts=session.beginTransaction();
		try{
	    	
		
		//设置数据库会话
		
		MallShopMallArticleHome home=((MallShopMallArticleHome)getObjectHome());
		
		home.setSessionCurrent(session);
		
		MallShopMallArticleHome beanHome=(MallShopMallArticleHome)getObjectHome();
		
		list=beanHome.getList_qeury( sqlCondation,  max,
				 orderBy,  orderType);
		
			ts.commit();
			
			
}catch(org.hibernate.AssertionFailure e){
	e.printStackTrace();
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopMallArticle");
			log.error("dao error failed", e);
			e.printStackTrace();
			//事务回滚
			ts.rollback();
		}catch(java.lang.RuntimeException e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopMallArticle");
			log.error("dao error failed", e);
			
			e.printStackTrace();
			//事务回滚
			ts.rollback();
		}finally{
	    		//关闭会话
	    		ds.closeSession();return list;
		}//end try
	}

	public List<MallShopMallArticle> getList_qeury_Byvalidaty(String vName,
			Object vValue, String condation,int max, String orderBy, String orderType) {
		// TODO Auto-generated method stub
		// TODO Auto-generated method stub
		List<MallShopMallArticle> list=null;
		
		DaoService ds=DaoService.getIntrance();
		org.hibernate.Session session=ds.openSession();
		org.hibernate.Transaction ts=session.beginTransaction();
		try{
	    	
		
		//设置数据库会话
		
		MallShopMallArticleHome home=((MallShopMallArticleHome)getObjectHome());
		
		home.setSessionCurrent(session);
		
		MallShopMallArticleHome beanHome=(MallShopMallArticleHome)getObjectHome();
		
		list=beanHome.getList_qeury_Byvalidaty(  vName,
				 vValue, condation, max,  orderBy,  orderType);
		
			ts.commit();
			
			
}catch(org.hibernate.AssertionFailure e){
	e.printStackTrace();
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopMallArticle");
			log.error("dao error failed", e);
			e.printStackTrace();
			//事务回滚
			ts.rollback();
		}catch(java.lang.RuntimeException e){
			System.out.println("操作数据库错误，请检查表单字段是否空值，负值等错误,MallShopMallArticle");
			log.error("dao error failed", e);
			
			e.printStackTrace();
			//事务回滚
			ts.rollback();
		}finally{
	    		//关闭会话
	    		ds.closeSession();return list;
		}//end try
	}	

//your code<@YOURCODE>

 public static void main(String argv[]){
           util.DaoService.getIntrance();
	  		MallShopMallArticleDao daoMallShopMallArticleDao=new MallShopMallArticleDao();
	  		MallShopMallArticle oMallShopMallArticleDao=new MallShopMallArticle ();
	  		oMallShopMallArticleDao=daoMallShopMallArticleDao.merge(oMallShopMallArticleDao);
	  	 }
	  	 


//</autoClassCode>	  	 
}
