<%@ Page Language="C#" ContentType="text/html" Inherits="LCweb.Data.OleDbClient" %>

<%@ Register TagPrefix="Rajah" TagName="Head" src="../ctrls/head.ascx" %>
<%@ Register TagPrefix="Rajah" TagName="Foot" src="../ctrls/foot.ascx" %>

<script language="c#" runat="server">
private void Page_Load(object sender,EventArgs e)
{
	if( !Page.IsPostBack )
	{
		this.Initialize();
		
		this.DataBind();
	}
}

private void Initialize()
{
	this.BindDropDownList("select name,id,depth from [b_article_categories] order by lft", "categories", list_moving);
}

private void DataBind()
{
	string sql = " *,(select [name] from [b_article_categories] where id = a.cid) as category from [b_articles] a";
	string filter = " where id > 0";
	string order = " addtime desc";
	
	if( Request.QueryString["key"] != null && Request.QueryString["key"] != "" )
		filter += " and title like '%"+ Request.QueryString["key"] +"%'";

	if (Request.QueryString["id"] != null && Request.QueryString["id"] != "")
	{
		int cid = Int32.Parse(Request.QueryString["id"]);
		
		LCweb.Categories c = new LCweb.Categories(this, cid);

		filter += " and cid in (" + c.GetFamily() +")";

		this.BindList("select *,(select count(id) from [b_articles] where cid in (select id from [b_article_categories] where parent = c.id)) as count_1 from [b_article_categories] c where parent = " + cid, "data_categories", data_categories);

		if (this.Data.Tables["data_categories"].Rows.Count == 0)
			this.BindList("select *,(select count(id) from [b_articles] where cid = c.id) as count_1 from [b_article_categories] c where parent = (select parent from [b_article_categories] where id = " + cid + ")", "data_categories", data_categories);
			
		//this.text_title.Text = Data.Tables["data_categories"].Rows[0]["name"].ToString();	
		this.Fill("select top 1 * from [b_article_categories] where id = (select parent from [b_article_categories] where id = "+ Request.QueryString["id"] +")", "category");
		
		if( Tables["category"].Rows.Count > 0 )
		{
			System.Data.DataRow dr = Tables["category"].Rows[0];
			
			link_parent.Visible = true;
			link_parent.Text = dr["name"].ToString() + "";
			link_parent.NavigateUrl = "list.aspx?id="+ dr["id"].ToString();
		}
	}
	else
		this.BindList("select *,(select count(id) from [b_articles] where cid in (select id from [b_article_categories] where parent = c.id)) as count_1 from [b_article_categories] c where [depth] = 0", "data_categories", data_categories);

	this.BindGrid( sql, filter, order, "b_articles", data_list, 18, text_pages);
	
}

public string GetColor(object dr)
{
	if (Request.QueryString["id"] != null)
	{
		if (dr.ToString() == Request.QueryString["id"])
			return "#ff6600";
		else
			return "";
	}
	else
		return "";
}

private void data_delete_click(object sender,DataGridCommandEventArgs e)
{
	string id = ((LinkButton)e.Item.FindControl("button_delete")).CommandArgument;
	
	this.Execute( "delete from [b_articles] where id = "+ id );

	this.DataBind();
}

private void button_delete_click(object sender, EventArgs e)
{
	this.Execute("delete from [b_articles] where id in ("+ Request["ids"] +")");
	
	this.DataBind();
}

private void text_pages_clone(object sender, EventArgs e)
{
	Label lb = (Label)sender;
	
	this.text_pages1.Text = lb.Text;
}

private void list_moving_changed(object sender, EventArgs e)
{
	if( list_moving.Text != "" )
	{
		this.Execute("update [b_articles] set cid = "+ list_moving.Text +" where id in ("+ Request["ids"] +")");
	}

	this.DataBind();
}
</script>

<Rajah:Head ID="Head" Runat="Server" />
<form runat="server">
<table width="100%" align="center" border="0" cellspacing="0" cellpadding="0">
  <tr>
    <td class="title3">
		<div style="float:left">վݹ</div>
		<div style="float:right"></div>
	  </td>
  </tr>
</table>
<table width="100%" align="center" border="0" cellspacing="8" cellpadding="0">
  <tr>
    <td>
	<table width="100%" border="0" cellspacing="0" cellpadding="0" class="table3">
	  <tr>
		<td height="32">
		<asp:HyperLink ID="link_parent" runat="server" Visible="false" style="margin-right:10px;" />
		<asp:DataList ID="data_categories" BorderWidth="0" CellPadding="0" CellSpacing="0" RepeatColumns="10" RepeatLayout="Flow" runat="server">
		  <itemtemplate>
		  <span class="overflow" style="margin-right:10px;"><a href="list.aspx?id=<%# Eval("id") %>"><font color='<%# GetColor(Eval("id")) %>'><%# Eval("name") %></font></a></span>
		  </itemtemplate>
		</asp:DataList></td>
		<td align="right"><asp:Label ID="text_pages1" runat="server" /></td>
	  </tr>
	</table>
	<asp:DataGrid ID="data_list" Width="100%" BorderWidth="0" CellPadding="0" CellSpacing="0" AutoGenerateColumns="false" runat="server" 
	CssClass="autotext" HeaderStyle-CssClass="header1" ItemStyle-CssClass="item1" 
	OnDeleteCommand="data_delete_click">
	  <columns>
		<asp:TemplateColumn HeaderStyle-Width="24">
			<headertemplate><input type="checkbox" onclick="checkAll(this)"></headertemplate>
			<itemtemplate><input type="checkbox" name="ids" value="<%# Eval("id") %>"></itemtemplate>
		</asp:TemplateColumn>

		<asp:TemplateColumn HeaderStyle-Width="100">
			<headertemplate></headertemplate>
			<itemtemplate>
			  <span style="width:90px" title="<%# Eval("category") %>"><%# Eval("category") %></span>
			</itemtemplate>
		</asp:TemplateColumn>

		<asp:TemplateColumn HeaderStyle-Width="100%">
			<headertemplate></headertemplate>
			<itemtemplate>
			  <span title="<%# Eval("title") %>"><%# Eval("title") %></span></a>
			</itemtemplate>
		</asp:TemplateColumn>

		<asp:TemplateColumn HeaderStyle-Width="100">
			<headertemplate>ʱ</headertemplate>
			<itemtemplate>
			  <span style="width:90px"><%# Eval("addtime") %></span>
			</itemtemplate>
		</asp:TemplateColumn>

		<asp:TemplateColumn HeaderStyle-Width="70">
			<headertemplate></headertemplate>
			<itemtemplate>
			  <a href="edit.aspx?id=<%# DataBinder.Eval( Container.DataItem, "id" ) %>">޸</a>
			  <span onclick="return confirm('ȷҪɾ')"><asp:LinkButton ID="button_delete" Text="ɾ" CommandName="delete" CommandArgument='<%# DataBinder.Eval( Container.DataItem, "id" ) %>' runat="server" /></span>
			</itemtemplate>
		</asp:TemplateColumn>
	  </columns>
	</asp:DataGrid>	</td>
  </tr>
  <tr>
    <td>
	<table width="100%" border="0" cellspacing="0" cellpadding="0" class="table3">
	  <tr>
	    <td width="10"><asp:DropDownList ID="list_moving" AutoPostBack="true" OnSelectedIndexChanged="list_moving_changed" runat="server">
		<asp:ListItem Text="ƶ..." Value="" />
		</asp:DropDownList>
		<td width="10"><span onclick="return confirm('ȷҪɾ')"><asp:Button Text=" ȫɾ " OnClick="button_delete_click" runat="server" /></span></td>
		<td align="right"><asp:Label ID="text_pages" OnPreRender="text_pages_clone" runat="server" /></td>
	  </tr>
	</table>
	</td>
  </tr>
</table>

</form>
<Rajah:Foot ID="Foot" Runat="Server" />