// generic icons
import expandIcon from '../assets/expand.svg';
import questionIcon from '../assets/question-mark.svg';

//EIP icons
import icon_eip_aggregate from '../assets/eip/aggregate.png';
import icon_eip_bean from '../assets/eip/bean.png';
import icon_eip_choice from '../assets/eip/choice.png';
import icon_eip_circuit_breaker from '../assets/eip/circuitBreaker.png';
import icon_eip_claim_check from '../assets/eip/claimCheck.png';
import icon_eip_convert_body from '../assets/eip/convertBody.png';
import icon_eip_delay from '../assets/eip/delay.png';
import icon_eip_dynamic_router from '../assets/eip/dynamic-router.png';
import icon_eip_enrich from '../assets/eip/enrich.png';
import icon_eip_filter from '../assets/eip/filter.png';
import icon_eip_generic from '../assets/eip/generic.png';
import icon_eip_idempotent_consumer from '../assets/eip/idempotentConsumer.png';
import icon_eip_load_balance from '../assets/eip/load-balance.png';
import icon_eip_log from '../assets/eip/log.png';
import icon_eip_loop from '../assets/eip/loop.png';
import icon_eip_multicast from '../assets/eip/multicast.png';
import icon_eip_otherwise from '../assets/eip/otherwise.png';
import icon_eip_throwException from '../assets/eip/throw-exception.png';
import icon_eip_pausable from '../assets/eip/pausable.png';
import icon_eip_pipeline from '../assets/eip/pipeline.png';
import icon_eip_poll_enrich from '../assets/eip/poll-enrich.png';
import icon_eip_process from '../assets/eip/process.png';
import icon_eip_recipient_list from '../assets/eip/recipient-list.png';
import icon_eip_remove_header from '../assets/eip/removeheader.png';
import icon_eip_remove_headers from '../assets/eip/removeheaders.png';
import icon_eip_remove_properties from '../assets/eip/removeproperties.png';
import icon_eip_remove_property from '../assets/eip/removeproperty.png';
import icon_eip_resequence from '../assets/eip/resequence.png';
import icon_eip_resumable from '../assets/eip/resumable.png';
import icon_eip_rollback from '../assets/eip/rollback.png';
import icon_eip_route from '../assets/eip/route.png';
import icon_eip_sample from '../assets/eip/sample.png';
import icon_eip_script from '../assets/eip/script.png';
import icon_eip_set_body from '../assets/eip/setbody.png';
import icon_eip_set_header from '../assets/eip/setheader.png';
import icon_eip_set_headers from '../assets/eip/setheaders.png';
import icon_eip_set_property from '../assets/eip/setproperty.png';
import icon_eip_sort from '../assets/eip/sort.png';
import icon_eip_split from '../assets/eip/split.png';
import icon_eip_step from '../assets/eip/step.png';
import icon_eip_stop from '../assets/eip/stop.png';
import icon_eip_threads from '../assets/eip/threads.png';
import icon_eip_throttle from '../assets/eip/throttle.png';
import icon_eip_to from '../assets/eip/to.png';
import icon_eip_to_d from '../assets/eip/toD.png';
import icon_eip_transform from '../assets/eip/transform.png';
import icon_eip_validate from '../assets/eip/validate.png';
import icon_eip_when from '../assets/eip/when.png';
import icon_eip_wiretap from '../assets/eip/wiretap.png';

// component icons
import icon_component_activemq from '../assets/components/activemq.svg';
import icon_component_amqp from '../assets/components/amqp.svg';
import icon_component_arangodb from '../assets/components/arangodb.svg';
import icon_component_avro from '../assets/components/avro.svg';
import icon_component_aws from '../assets/components/aws.png';
import icon_component_aws2_athena from '../assets/components/aws2-athena.svg';
import icon_component_aws2_cw from '../assets/components/aws2-cw.svg';
import icon_component_aws2_ddb from '../assets/components/aws2-ddb.svg';
import icon_component_aws2_ddbstream from '../assets/components/aws2-ddbstream.svg';
import icon_component_aws2_ec2 from '../assets/components/aws2-ec2.svg';
import icon_component_aws2_ecs from '../assets/components/aws2-ecs.svg';
import icon_component_aws2_eks from '../assets/components/aws2-eks.svg';
import icon_component_aws2_eventbridge from '../assets/components/aws2-eventbridge.svg';
import icon_component_aws2_iam from '../assets/components/aws2-iam.svg';
import icon_component_aws2_kinesis from '../assets/components/aws2-kinesis.svg';
import icon_component_aws2_kinesis_firehose from '../assets/components/aws2-kinesis-firehose.svg';
import icon_component_aws2_kms from '../assets/components/aws2-kms.svg';
import icon_component_aws2_lambda from '../assets/components/aws2-lambda.svg';
import icon_component_aws2_mq from '../assets/components/aws2-mq.svg';
import icon_component_aws2_msk from '../assets/components/aws2-msk.svg';
import icon_component_aws2_redshift_data from '../assets/components/aws2-redshift-data.svg';
import icon_component_aws2_s3 from '../assets/components/aws2-s3.svg';
import icon_component_aws2_ses from '../assets/components/aws2-ses.svg';
import icon_component_aws2_sns from '../assets/components/aws2-sns.svg';
import icon_component_aws2_sqs from '../assets/components/aws2-sqs.svg';
import icon_component_aws2_step_functions from '../assets/components/aws2-step-functions.svg';
import icon_component_aws2_timestream from '../assets/components/aws2-timestream.svg';
import icon_component_aws2_translate from '../assets/components/aws2-translate.svg';
import icon_component_aws_bedrock from '../assets/components/aws-bedrock.svg';
import icon_component_aws_cloudtrail from '../assets/components/aws-cloudtrail.svg';
import icon_component_aws_config from '../assets/components/aws-config.svg';
import icon_component_aws_secrets_manager from '../assets/components/aws-secrets-manager.svg';
import icon_component_azure_cosmosdb from '../assets/components/azure-cosmosdb.svg';
import icon_component_azure_eventhubs from '../assets/components/azure-eventhubs.svg';
import icon_component_azure_files from '../assets/components/azure-files.svg';
import icon_component_azure_key_vault from '../assets/components/azure-key-vault.svg';
import icon_component_azure_servicebus from '../assets/components/azure-servicebus.svg';
import icon_component_azure_storage_blob from '../assets/components/azure-storage-blob.svg';
import icon_component_azure_datalake from '../assets/components/azure-storage-datalake.svg';
import icon_component_azure_storage_queue from '../assets/components/azure-storage-queue.svg';
import icon_component_bean_component from '../assets/components/bean.svg';
import icon_component_box from '../assets/components/box.svg';
import icon_component_brain from '../assets/components/brain.svg';
import icon_component_braintree from '../assets/components/braintree.svg';
import icon_component_cics from '../assets/components/cics.svg';
import icon_component_consul from '../assets/components/consul.svg';
import icon_component_couchbase from '../assets/components/couchbase.svg';
import icon_component_couchdb from '../assets/components/couchdb.svg';
import icon_component_cql from '../assets/components/cql.svg';
import icon_component_crypto from '../assets/components/crypto.svg';
import icon_component_cxf from '../assets/components/cxf.png';
import icon_component_datamapper from '../assets/components/datamapper.png';
import icon_component_debezium from '../assets/components/debezium.svg';
import icon_component_dhis2 from '../assets/components/dhis2.svg';
import icon_component_direct from '../assets/components/direct.svg';
import icon_component_djl from '../assets/components/djl.png';
import icon_component_docker from '../assets/components/docker.svg';
import icon_component_drill from '../assets/components/drill.svg';
import icon_component_dropbox from '../assets/components/dropbox.svg';
import icon_component_elasticsearch from '../assets/components/elasticsearch.svg';
import icon_component_email_receive from '../assets/components/email_receive.svg';
import icon_component_email_send from '../assets/components/email_send.svg';
import icon_component_etcd3 from '../assets/components/etcd3.svg';
import icon_component_exec from '../assets/components/exec.svg';
import icon_component_facebook from '../assets/components/facebook.svg';
import icon_component_fhir from '../assets/components/fhir.svg';
import icon_component_file from '../assets/components/file.svg';
import icon_component_file_watch from '../assets/components/file-watch.svg';
import icon_component_flink from '../assets/components/flink.svg';
import icon_component_freemarker from '../assets/components/freemarker.svg';
import icon_component_ftp from '../assets/components/ftp.png';
import icon_component_generic from '../assets/components/generic-component.png';
import icon_component_git from '../assets/components/git.svg';
import icon_component_github from '../assets/components/github.svg';
import icon_component_google_bigquery from '../assets/components/google-bigquery.svg';
import icon_component_google_calendar from '../assets/components/google-calendar.svg';
import icon_component_google_drive from '../assets/components/google-drive.svg';
import icon_component_google_functions from '../assets/components/google-functions.svg';
import icon_component_google_mail from '../assets/components/google-mail.svg';
import icon_component_google_pubsub from '../assets/components/google-pubsub.svg';
import icon_component_google_secret_manager from '../assets/components/google-secret-manager.svg';
import icon_component_google_sheets from '../assets/components/google-sheets.svg';
import icon_component_google_storage from '../assets/components/google-storage.svg';
import icon_component_graphql from '../assets/components/graphql.svg';
import icon_component_grpc from '../assets/components/grpc.svg';
import icon_component_hashicorp_vault from '../assets/components/hashicorp-vault.svg';
import icon_component_hazelcast from '../assets/components/hazelcast.png';
import icon_component_http from '../assets/components/http.svg';
import icon_component_https from '../assets/components/https.svg';
import icon_component_huawei from '../assets/components/huawei.svg';
import icon_component_ibm from '../assets/components/ibm.svg';
import icon_component_ignite from '../assets/components/ignite.png';
import icon_component_infinispan from '../assets/components/infinispan.svg';
import icon_component_influxdb from '../assets/components/influxdb2.svg';
import icon_component_irc from '../assets/components/irc.svg';
import icon_component_jdbc from '../assets/components/jdbc.png';
import icon_component_jetty from '../assets/components/jetty.svg';
import icon_component_jira from '../assets/components/jira.svg';
import icon_component_jms from '../assets/components/jms.png';
import icon_component_kafka from '../assets/components/kafka.svg';
import icon_component_kubernetes_generic from '../assets/components/kubernetes.svg';
import icon_component_kubernetes_config_maps from '../assets/components/kubernetes-config-maps.svg';
import icon_component_kubernetes_cronjob from '../assets/components/kubernetes-cronjob.svg';
import icon_component_kubernetes_custom_resources from '../assets/components/kubernetes-custom-resources.svg';
import icon_component_kubernetes_deployments from '../assets/components/kubernetes-deployments.svg';
import icon_component_kubernetes_hpa from '../assets/components/kubernetes-hpa.svg';
import icon_component_kubernetes_job from '../assets/components/kubernetes-job.svg';
import icon_component_kubernetes_namespaces from '../assets/components/kubernetes-namespaces.svg';
import icon_component_kubernetes_nodes from '../assets/components/kubernetes-nodes.svg';
import icon_component_kubernetes_persistent_volumes_claims from '../assets/components/kubernetes-persistent-volumes-claims.svg';
import icon_component_kubernetes_persistent_volumes from '../assets/components/kubernetes-persistent-volumes.svg';
import icon_component_kubernetes_pods from '../assets/components/kubernetes-pods.svg';
import icon_component_kubernetes_replication_controller from '../assets/components/kubernetes-replication-controller.svg';
import icon_component_kubernetes_resources_quota from '../assets/components/kubernetes-resources-quota.svg';
import icon_component_kubernetes_secrets from '../assets/components/kubernetes-secrets.svg';
import icon_component_kubernetes_service_account from '../assets/components/kubernetes-service-account.svg';
import icon_component_kubernetes_services from '../assets/components/kubernetes-services.svg';
import icon_component_kudu from '../assets/components/kudu.svg';
import icon_component_langchain4j from '../assets/components/langchain4j.svg';
import icon_component_log from '../assets/components/log.svg';
import icon_component_lucene from '../assets/components/lucene.svg';
import icon_component_mapstruct from '../assets/components/mapstruct.svg';
import icon_component_micrometer from '../assets/components/micrometer.svg';
import icon_component_milvus from '../assets/components/milvus.svg';
import icon_component_minio from '../assets/components/minio.svg';
import icon_component_mongodb from '../assets/components/mongodb.svg';
import icon_component_mqtt from '../assets/components/mqtt.svg';
import icon_component_mustache from '../assets/components/mustache.svg';
import icon_component_mybatis from '../assets/components/mybatis.svg';
import icon_component_netty from '../assets/components/netty.png';
import icon_component_nitrite from '../assets/components/nitrite.svg';
import icon_component_odata from '../assets/components/odata.svg';
import icon_component_openapi from '../assets/components/openapi.svg';
import icon_component_opensearch from '../assets/components/opensearch.svg';
import icon_component_openshift from '../assets/components/openshift.svg';
import icon_component_openstack from '../assets/components/openstack.svg';
import icon_component_pinecone from '../assets/components/pinecone.svg';
import icon_component_platformhttp from '../assets/components/platformhttp.png';
import icon_component_policy from '../assets/components/policy.png';
import icon_component_printer from '../assets/components/printer.svg';
import icon_component_pulsar from '../assets/components/pulsar.svg';
import icon_component_qdrant from '../assets/components/qdrant.svg';
import icon_component_quartz from '../assets/components/quartz.png';
import icon_component_rocketmq from '../assets/components/rocketmq.svg';
import icon_component_rss from '../assets/components/rss.svg';
import icon_component_salesforce from '../assets/components/salesforce.svg';
import icon_component_sap from '../assets/components/sap.svg';
import icon_component_servicenow from '../assets/components/servicenow.svg';
import icon_component_servlet from '../assets/components/servlet.png';
import icon_component_sftp from '../assets/components/sftp.svg';
import icon_component_slack from '../assets/components/slack.svg';
import icon_component_smooks from '../assets/components/smooks.svg';
import icon_component_snmp from '../assets/components/snmp.png';
import icon_component_splunk from '../assets/components/splunk.svg';
import icon_component_spring from '../assets/components/spring.svg';
import icon_component_sql from '../assets/components/sql_db.png';
import icon_component_stitch from '../assets/components/stitch.svg';
import icon_component_telegram from '../assets/components/telegram.svg';
import icon_component_template from '../assets/components/template.svg';
import icon_component_thymeleaf from '../assets/components/thymeleaf.svg';
import icon_component_timer from '../assets/components/timer.svg';
import icon_component_twilio from '../assets/components/twilio.svg';
import icon_component_twitter from '../assets/components/twitter.svg';
import icon_component_velocity from '../assets/components/velocity.png';
import icon_component_vertx from '../assets/components/vertx.svg';
import icon_component_wasm from '../assets/components/wasm.svg';
import icon_component_weather from '../assets/components/weather.svg';
import icon_component_webhooks from '../assets/components/webhooks.svg';
import icon_component_whatsapp from '../assets/components/whatsapp.svg';
import icon_component_wordpress from '../assets/components/wordpress.svg';
import icon_component_workday from '../assets/components/workday.svg';
import icon_component_xmpp from '../assets/components/xmpp.svg';
import icon_component_xslt from '../assets/components/xslt2.png';
import icon_component_zendesk from '../assets/components/zendesk.svg';

import { CatalogKind } from '../models/catalog-kind';
import { CamelCatalogService } from '../models/visualization/flows/camel-catalog.service';
import { EntityType } from '../models/camel/entities';

export const enum NodeIconType {
  Component = 'Component',
  EIP = 'EIP',
  Kamelet = 'Kamelet',
  VisualEntity = 'VisualEntity',
}

export class NodeIconResolver {
  static getIcon(elementName: string | undefined, type: NodeIconType): string {
    if (!elementName) {
      return this.getUnknownIcon();
    }

    if (elementName.startsWith('kamelet:')) {
      return this.getKameletIcon(elementName) ?? this.getUnknownIcon();
    }

    switch (type) {
      case NodeIconType.Kamelet:
        return this.getDefaultCamelIcon();
      case NodeIconType.Component:
        return this.getComponentIcon(elementName) ?? this.getDefaultCamelIcon();
      case NodeIconType.EIP:
        return this.getEIPIcon(elementName) ?? this.getDefaultCamelIcon();
      case NodeIconType.VisualEntity:
        return this.getVisualEntityIcon(elementName) ?? this.getDefaultCamelIcon();
    }
  }

  static getUnknownIcon(): string {
    return questionIcon;
  }

  static getPlaceholderIcon(): string {
    return expandIcon;
  }

  static getDefaultCamelIcon(): string {
    return icon_component_generic;
  }

  private static getKameletIcon(elementName: string): string | undefined {
    const kameletDefinition = CamelCatalogService.getComponent(
      CatalogKind.Kamelet,
      elementName.replace('kamelet:', ''),
    );

    return kameletDefinition?.metadata.annotations['camel.apache.org/kamelet.icon'];
  }

  private static getComponentIcon(elementName: string): string | undefined {
    switch (elementName) {
      case 'activemq':
      case 'activemq6':
        return icon_component_activemq;
      case 'amqp':
        return icon_component_amqp;
      case 'arangodb':
        return icon_component_arangodb;
      case 'avro':
        return icon_component_avro;
      case 'aws-bedrock':
      case 'aws-bedrock-agent':
      case 'aws-bedrock-agent-runtime':
        return icon_component_aws_bedrock;
      case 'aws-cloudtrail':
        return icon_component_aws_cloudtrail;
      case 'aws-config':
        return icon_component_aws_config;
      case 'aws-secrets-manager':
        return icon_component_aws_secrets_manager;
      case 'aws2-athena':
        return icon_component_aws2_athena;
      case 'aws2-cw':
        return icon_component_aws2_cw;
      case 'aws2-ddb':
        return icon_component_aws2_ddb;
      case 'aws2-ddbstream':
        return icon_component_aws2_ddbstream;
      case 'aws2-ec2':
        return icon_component_aws2_ec2;
      case 'aws2-ecs':
        return icon_component_aws2_ecs;
      case 'aws2-eks':
        return icon_component_aws2_eks;
      case 'aws2-eventbridge':
        return icon_component_aws2_eventbridge;
      case 'aws2-iam':
        return icon_component_aws2_iam;
      case 'aws2-kinesis':
        return icon_component_aws2_kinesis;
      case 'aws2-kinesis-firehose':
        return icon_component_aws2_kinesis_firehose;
      case 'aws2-kms':
        return icon_component_aws2_kms;
      case 'aws2-lambda':
        return icon_component_aws2_lambda;
      case 'aws2-mq':
        return icon_component_aws2_mq;
      case 'aws2-msk':
        return icon_component_aws2_msk;
      case 'aws2-redshift-data':
        return icon_component_aws2_redshift_data;
      case 'aws2-s3':
        return icon_component_aws2_s3;
      case 'aws2-ses':
        return icon_component_aws2_ses;
      case 'aws2-sns':
        return icon_component_aws2_sns;
      case 'aws2-sqs':
        return icon_component_aws2_sqs;
      case 'aws2-step-functions':
        return icon_component_aws2_step_functions;
      case 'aws2-sts':
        return icon_component_aws;
      case 'aws2-timestream':
        return icon_component_aws2_timestream;
      case 'aws2-translate':
        return icon_component_aws2_translate;
      case 'azure-cosmosdb':
        return icon_component_azure_cosmosdb;
      case 'azure-eventhubs':
        return icon_component_azure_eventhubs;
      case 'azure-files':
        return icon_component_azure_files;
      case 'azure-key-vault':
        return icon_component_azure_key_vault;
      case 'azure-servicebus':
        return icon_component_azure_servicebus;
      case 'azure-storage-blob':
        return icon_component_azure_storage_blob;
      case 'azure-storage-datalake':
        return icon_component_azure_datalake;
      case 'azure-storage-queue':
        return icon_component_azure_storage_queue;
      case 'bean':
      case 'bean-validator':
        return icon_component_bean_component;
      case 'bonita':
        return icon_component_generic;
      case 'box':
        return icon_component_box;
      case 'braintree':
        return icon_component_braintree;
      case 'browse':
      case 'caffeine-cache':
      case 'caffeine-loadcache':
        return icon_component_generic;
      case 'chatscript':
        return icon_component_brain;
      case 'chunk':
        return icon_component_generic;
      case 'cics':
        return icon_component_cics;
      case 'class':
      case 'cm-sms':
      case 'coap':
      case 'coap+tcp':
      case 'coaps':
      case 'coaps+tcp':
      case 'cometd':
      case 'cometds':
        return icon_component_generic;
      case 'consul':
        return icon_component_consul;
      case 'controlbus':
        return icon_component_generic;
      case 'couchbase':
        return icon_component_couchbase;
      case 'couchdb':
        return icon_component_couchdb;
      case 'cql':
        return icon_component_cql;
      case 'cron':
        return icon_component_timer;
      case 'crypto':
        return icon_component_crypto;
      case 'cxf':
      case 'cxfrs':
        return icon_component_cxf;
      case 'dataformat':
      case 'dataset':
      case 'dataset-test':
        return icon_component_generic;
      case 'debezium-db2':
      case 'debezium-mongodb':
      case 'debezium-mysql':
      case 'debezium-oracle':
      case 'debezium-postgres':
      case 'debezium-sqlserver':
        return icon_component_debezium;
      case 'dhis2':
        return icon_component_dhis2;
      case 'digitalocean':
        return icon_component_generic;
      case 'direct':
        return icon_component_direct;
      case 'disruptor':
      case 'disruptor-vm':
      case 'djl':
        return icon_component_djl;
      case 'dns':
        return icon_component_generic;
      case 'docker':
        return icon_component_docker;
      case 'drill':
        return icon_component_drill;
      case 'dropbox':
        return icon_component_dropbox;
      case 'dynamic-router':
      case 'dynamic-router-control':
      case 'ehcache':
        return icon_component_generic;
      case 'elasticsearch':
      case 'elasticsearch-rest-client':
        return icon_component_elasticsearch;
      case 'etcd3':
        return icon_component_etcd3;
      case 'exec':
        return icon_component_exec;
      case 'facebook':
        return icon_component_facebook;
      case 'fhir':
        return icon_component_fhir;
      case 'file':
        return icon_component_file;
      case 'file-watch':
        return icon_component_file_watch;
      case 'flatpack':
        return icon_component_generic;
      case 'flink':
        return icon_component_flink;
      case 'fop':
        return icon_component_generic;
      case 'freemarker':
        return icon_component_freemarker;
      case 'ftp':
      case 'ftps':
        return icon_component_ftp;
      case 'geocoder':
        return icon_component_generic;
      case 'git':
        return icon_component_git;
      case 'github':
        return icon_component_github;
      case 'google-bigquery':
      case 'google-bigquery-sql':
        return icon_component_google_bigquery;
      case 'google-calendar':
      case 'google-calendar-stream':
        return icon_component_google_calendar;
      case 'google-drive':
        return icon_component_google_drive;
      case 'google-functions':
        return icon_component_google_functions;
      case 'google-mail':
      case 'google-mail-stream':
        return icon_component_google_mail;
      case 'google-pubsub':
      case 'google-pubsub-lite':
        return icon_component_google_pubsub;
      case 'google-secret-manager':
        return icon_component_google_secret_manager;
      case 'google-sheets':
      case 'google-sheets-stream':
        return icon_component_google_sheets;
      case 'google-storage':
        return icon_component_google_storage;
      case 'grape':
        return icon_component_generic;
      case 'graphql':
        return icon_component_graphql;
      case 'grpc':
        return icon_component_grpc;
      case 'guava-eventbus':
        return icon_component_generic;
      case 'hashicorp-vault':
        return icon_component_hashicorp_vault;
      case 'hazelcast-atomicvalue':
      case 'hazelcast-instance':
      case 'hazelcast-list':
      case 'hazelcast-map':
      case 'hazelcast-multimap':
      case 'hazelcast-queue':
      case 'hazelcast-replicatedmap':
      case 'hazelcast-ringbuffer':
      case 'hazelcast-seda':
      case 'hazelcast-set':
      case 'hazelcast-topic':
        return icon_component_hazelcast;
      case 'http':
        return icon_component_http;
      case 'https':
        return icon_component_https;
      case 'hwcloud-dms':
      case 'hwcloud-frs':
      case 'hwcloud-functiongraph':
      case 'hwcloud-iam':
      case 'hwcloud-imagerecognition':
      case 'hwcloud-obs':
      case 'hwcloud-smn':
        return icon_component_huawei;
      case 'iec60870-client':
      case 'iec60870-server':
        return icon_component_generic;
      case 'ignite-cache':
      case 'ignite-compute':
      case 'ignite-events':
      case 'ignite-idgen':
      case 'ignite-messaging':
      case 'ignite-queue':
      case 'ignite-set':
        return icon_component_ignite;
      case 'imap':
      case 'imaps':
        return icon_component_email_receive;
      case 'infinispan':
      case 'infinispan-embedded':
        return icon_component_infinispan;
      case 'influxdb':
      case 'influxdb2':
        return icon_component_influxdb;
      case 'irc':
        return icon_component_irc;
      case 'ironmq':
      case 'jcache':
      case 'jcr':
        return icon_component_generic;
      case 'jdbc':
        return icon_component_jdbc;
      case 'jetty':
        return icon_component_jetty;
      case 'jgroups':
      case 'jgroups-raft':
        return icon_component_generic;
      case 'jira':
        return icon_component_jira;
      case 'jms':
        return icon_component_jms;
      case 'jmx':
      case 'jolt':
      case 'jooq':
      case 'jpa':
      case 'jslt':
      case 'json-patch':
      case 'json-validator':
      case 'jsonata':
        return icon_component_generic;
      case 'jt400':
        return icon_component_ibm;
      case 'jte':
        return icon_component_generic;
      case 'kafka':
        return icon_component_kafka;
      /** case 'kamelet': --> handled elsewhere **/
      case 'knative':
        return icon_component_generic;
      case 'kubernetes-config-maps':
        return icon_component_kubernetes_config_maps;
      case 'kubernetes-cronjob':
        return icon_component_kubernetes_cronjob;
      case 'kubernetes-custom-resources':
        return icon_component_kubernetes_custom_resources;
      case 'kubernetes-deployments':
        return icon_component_kubernetes_deployments;
      case 'kubernetes-events':
        return icon_component_kubernetes_generic;
      case 'kubernetes-hpa':
        return icon_component_kubernetes_hpa;
      case 'kubernetes-job':
        return icon_component_kubernetes_job;
      case 'kubernetes-namespaces':
        return icon_component_kubernetes_namespaces;
      case 'kubernetes-nodes':
        return icon_component_kubernetes_nodes;
      case 'kubernetes-persistent-volumes':
        return icon_component_kubernetes_persistent_volumes;
      case 'kubernetes-persistent-volumes-claims':
        return icon_component_kubernetes_persistent_volumes_claims;
      case 'kubernetes-pods':
        return icon_component_kubernetes_pods;
      case 'kubernetes-replication-controllers':
        return icon_component_kubernetes_replication_controller;
      case 'kubernetes-resources-quota':
        return icon_component_kubernetes_resources_quota;
      case 'kubernetes-secrets':
        return icon_component_kubernetes_secrets;
      case 'kubernetes-service-accounts':
        return icon_component_kubernetes_service_account;
      case 'kubernetes-services':
        return icon_component_kubernetes_services;
      case 'kudu':
        return icon_component_kudu;
      case 'langchain4j-chat':
      case 'langchain4j-embeddings':
      case 'langchain4j-tools':
      case 'langchain4j-web-search':
        return icon_component_langchain4j;
      case 'language':
        return icon_component_generic;
      case 'ldap':
        return icon_component_policy;
      case 'ldif':
        return icon_component_generic;
      case 'log':
        return icon_component_log;
      case 'lpr':
        return icon_component_printer;
      case 'lucene':
        return icon_component_lucene;
      case 'lumberjack':
        return icon_component_generic;
      case 'mapstruct':
        return icon_component_mapstruct;
      case 'master':
      case 'metrics':
        return icon_component_generic;
      case 'micrometer':
        return icon_component_micrometer;
      case 'milvus':
        return icon_component_milvus;
      case 'mina':
        return icon_component_generic;
      case 'minio':
        return icon_component_minio;
      case 'mllp':
      case 'mock':
        return icon_component_generic;
      case 'mongodb':
      case 'mongodb-gridfs':
        return icon_component_mongodb;
      case 'mustache':
        return icon_component_mustache;
      case 'mvel':
        return icon_component_generic;
      case 'mybatis':
      case 'mybatis-bean':
        return icon_component_mybatis;
      case 'nats':
        return icon_component_generic;
      case 'netty':
      case 'netty-http':
        return icon_component_netty;
      case 'nitrite':
        return icon_component_nitrite;
      case 'oaipmh':
        return icon_component_generic;
      case 'olingo2':
      case 'olingo4':
        return icon_component_odata;
      case 'opensearch':
        return icon_component_opensearch;
      case 'openshift-build-configs':
      case 'openshift-builds':
      case 'openshift-deploymentconfigs':
        return icon_component_openshift;
      case 'openstack-cinder':
      case 'openstack-glance':
      case 'openstack-keystone':
      case 'openstack-neutron':
      case 'openstack-nova':
      case 'openstack-swift':
        return icon_component_openstack;
      case 'optaplanner':
        return icon_component_generic;
      case 'paho':
      case 'paho-mqtt5':
        return icon_component_mqtt;
      case 'pdf':
      case 'pg-replication-slot':
      case 'pgevent':
        return icon_component_generic;
      case 'pinecone':
        return icon_component_pinecone;
      case 'platform-http':
        return icon_component_platformhttp;
      case 'plc4x':
        return icon_component_generic;
      case 'pop3':
      case 'pop3s':
        return icon_component_email_receive;
      case 'pubnub':
        return icon_component_generic;
      case 'pulsar':
        return icon_component_pulsar;
      case 'qdrant':
        return icon_component_qdrant;
      case 'quartz':
        return icon_component_quartz;
      case 'quickfix':
      case 'reactive-streams':
      case 'ref':
      case 'rest':
      case 'rest-api':
        return icon_component_generic;
      case 'rest-openapi':
        return icon_component_openapi;
      case 'robotframework':
        return icon_component_generic;
      case 'rocketmq':
        return icon_component_rocketmq;
      case 'rss':
        return icon_component_rss;
      case 'saga':
        return icon_component_generic;
      case 'salesforce':
        return icon_component_salesforce;
      case 'sap-netweaver':
        return icon_component_sap;
      case 'scheduler':
      case 'schematron':
      case 'scp':
      case 'seda':
      case 'service':
        return icon_component_generic;
      case 'servicenow':
        return icon_component_servicenow;
      case 'servlet':
        return icon_component_servlet;
      case 'sftp':
        return icon_component_sftp;
      case 'sjms':
      case 'sjms2':
        return icon_component_generic;
      case 'slack':
        return icon_component_slack;
      case 'smb':
        return icon_component_generic;
      case 'smooks':
        return icon_component_smooks;
      case 'smpp':
      case 'smpps':
        return icon_component_generic;
      case 'smtp':
      case 'smtps':
        return icon_component_email_send;
      case 'snmp':
        return icon_component_snmp;
      case 'solr':
      case 'solrCloud':
      case 'solrs':
        return icon_component_generic;
      case 'splunk':
      case 'splunk-hec':
        return icon_component_splunk;
      case 'spring-batch':
      case 'spring-event':
      case 'spring-jdbc':
      case 'spring-ldap':
      case 'spring-rabbitmq':
      case 'spring-redis':
      case 'spring-ws':
        return icon_component_spring;
      case 'sql':
      case 'sql-stored':
        return icon_component_sql;
      case 'ssh':
        return icon_component_exec;
      case 'stax':
        return icon_component_generic;
      case 'stitch':
        return icon_component_stitch;
      case 'stomp':
      case 'stream':
        return icon_component_generic;
      case 'string-template':
        return icon_component_template;
      case 'stub':
      case 'tahu-edge':
      case 'tahu-host':
        return icon_component_generic;
      case 'telegram':
        return icon_component_telegram;
      case 'thrift':
        return icon_component_generic;
      case 'thymeleaf':
        return icon_component_thymeleaf;
      case 'tika':
        return icon_component_generic;
      case 'timer':
        return icon_component_timer;
      case 'twilio':
        return icon_component_twilio;
      case 'twitter-directmessage':
      case 'twitter-search':
      case 'twitter-timeline':
        return icon_component_twitter;
      case 'undertow':
        return icon_component_generic;
      case 'validator':
        return icon_eip_validate;
      case 'velocity':
        return icon_component_velocity;
      case 'vertx':
      case 'vertx-http':
      case 'vertx-websocket':
        return icon_component_vertx;
      case 'wasm':
        return icon_component_wasm;
      case 'weather':
        return icon_component_weather;
      case 'web3j':
        return icon_component_generic;
      case 'webhook':
        return icon_component_webhooks;
      case 'whatsapp':
        return icon_component_whatsapp;
      case 'wordpress':
        return icon_component_wordpress;
      case 'workday':
        return icon_component_workday;
      case 'xchange':
      case 'xj':
      case 'xmlsecurity-sign':
      case 'xmlsecurity-verify':
        return icon_component_generic;
      case 'xmpp':
        return icon_component_xmpp;
      case 'xquery':
        return icon_component_generic;
      case 'xslt':
      case 'xslt-saxon':
        return icon_component_xslt;
      case 'zeebe':
        return icon_component_generic;
      case 'zendesk':
        return icon_component_zendesk;
      case 'zookeeper':
      case 'zookeeper-master':
        return icon_component_generic;

      /** Transform **/
      case 'marshal':
      case 'unmarshal':
        return icon_eip_transform;

      default:
        return undefined;
    }
  }

  private static getEIPIcon(elementName: string): string | undefined {
    switch (elementName) {
      case 'aggregate':
        return icon_eip_aggregate;
      case 'bean':
        return icon_eip_bean;
      case 'choice':
        return icon_eip_choice;
      case 'circuitBreaker':
        return icon_eip_circuit_breaker;
      case 'claimCheck':
        return icon_eip_claim_check;
      case 'convertBodyTo':
        return icon_eip_convert_body;
      case 'customLoadBalancer':
        return icon_eip_load_balance;
      case 'delay':
        return icon_eip_delay;
      case 'dynamicRouter':
        return icon_eip_dynamic_router;
      case 'enrich':
        return icon_eip_enrich;
      case 'failover': // is that used?
        return icon_eip_generic;
      case 'filter':
        return icon_eip_filter;
      case 'from':
        return expandIcon;
      case 'idempotentConsumer':
        return icon_eip_idempotent_consumer;
      // case 'kamelet': handled on top
      case 'kaoto-datamapper':
        return icon_component_datamapper;
      case 'loadBalance':
        return icon_eip_load_balance;
      case 'log':
        return icon_eip_log;
      case 'loop':
        return icon_eip_loop;
      case 'marshal':
        return icon_eip_transform;
      case 'multicast':
        return icon_eip_multicast;
      case 'onFallback': // used?
        return icon_eip_generic;
      case 'otherwise':
        return icon_eip_otherwise;
      case 'pausable':
        return icon_eip_pausable;
      case 'pipeline':
        return icon_eip_pipeline;
      case 'poll':
      case 'pollEnrich':
        return icon_eip_poll_enrich;
      case 'process':
        return icon_eip_process;
      case 'random': // used?
        return icon_eip_generic;
      case 'recipientList':
        return icon_eip_recipient_list;
      case 'removeHeader':
        return icon_eip_remove_header;
      case 'removeHeaders':
        return icon_eip_remove_headers;
      case 'removeProperties':
        return icon_eip_remove_properties;
      case 'removeProperty':
        return icon_eip_remove_property;
      case 'resequence':
        return icon_eip_resequence;
      case 'resumable':
        return icon_eip_resumable;
      case 'rollback':
        return icon_eip_rollback;
      case 'roundRobin':
        return icon_eip_load_balance;
      case 'routingSlip':
        return icon_eip_generic;
      case 'saga':
        return icon_eip_generic;
      case 'sample':
        return icon_eip_sample;
      case 'script':
        return icon_eip_script;
      case 'serviceCall':
        return icon_eip_generic;
      case 'setBody':
        return icon_eip_set_body;
      case 'setHeader':
        return icon_eip_set_header;
      case 'setHeaders':
        return icon_eip_set_headers;
      case 'setProperty':
        return icon_eip_set_property;
      case 'sort':
        return icon_eip_sort;
      case 'split':
        return icon_eip_split;
      case 'step':
        return icon_eip_step;
      case 'sticky':
        return icon_eip_generic;
      case 'stop':
        return icon_eip_stop;
      case 'langChain4j':
        return icon_component_langchain4j;
      case 'threads':
        return icon_eip_threads;
      case 'throttle':
        return icon_eip_throttle;
      case 'to':
        return icon_eip_to;
      case 'toD':
        return icon_eip_to_d;
      case 'topic':
        return icon_eip_generic;
      case 'transform':
        return icon_eip_transform;
      case 'unmarshal':
        return icon_eip_transform;
      case 'validate':
        return icon_eip_validate;
      case 'weighted':
        return icon_eip_generic;
      case 'when':
        return icon_eip_when;
      case 'wireTap':
        return icon_eip_wiretap;
      default:
        return undefined;
    }
  }

  private static getVisualEntityIcon(elementName: string): string | undefined {
    switch (elementName) {
      case EntityType.Route:
        return icon_eip_route;
      case EntityType.OnException:
        return icon_eip_throwException;
      default:
        return undefined;
    }
  }
}
