import { CatalogKind, ICamelProcessorDefinition } from '../models';

export const logModel: ICamelProcessorDefinition = {
  model: {
    kind: CatalogKind.Processor,
    name: 'log',
    title: 'Log',
    description: 'Logs the defined message to the logger',
    deprecated: false,
    label: 'eip,routing',
    javaType: 'org.apache.camel.model.LogDefinition',
    abstract: false,
    input: true,
    output: false,
  },
  properties: {
    message: {
      index: 0,
      kind: 'attribute',
      displayName: 'Message',
      required: true,
      type: 'string',
      javaType: 'java.lang.String',
      deprecated: false,
      autowired: false,
      secret: false,
      description: 'Sets the log message (uses simple language)',
    },
    loggingLevel: {
      index: 1,
      kind: 'attribute',
      displayName: 'Logging Level',
      required: false,
      type: 'enum',
      javaType: 'org.apache.camel.LoggingLevel',
      enum: ['TRACE', 'DEBUG', 'INFO', 'WARN', 'ERROR', 'OFF'],
      deprecated: false,
      autowired: false,
      secret: false,
      defaultValue: 'INFO',
      description: 'Sets the logging level. The default value is INFO',
    },
    logName: {
      index: 2,
      kind: 'attribute',
      displayName: 'Log Name',
      required: false,
      type: 'string',
      javaType: 'java.lang.String',
      deprecated: false,
      autowired: false,
      secret: false,
      description: 'Sets the name of the logger',
    },
    marker: {
      index: 3,
      kind: 'attribute',
      displayName: 'Marker',
      label: 'advanced',
      required: false,
      type: 'string',
      javaType: 'java.lang.String',
      deprecated: false,
      autowired: false,
      secret: false,
      description: 'To use slf4j marker',
    },
    logger: {
      index: 4,
      kind: 'attribute',
      displayName: 'Logger',
      label: 'advanced',
      required: false,
      type: 'object',
      javaType: 'org.slf4j.Logger',
      deprecated: false,
      autowired: false,
      secret: false,
      description: 'To refer to a custom logger instance to lookup from the registry.',
    },
    disabled: {
      index: 5,
      kind: 'attribute',
      displayName: 'Disabled',
      label: 'advanced',
      required: false,
      type: 'boolean',
      javaType: 'java.lang.Boolean',
      deprecated: false,
      autowired: false,
      secret: false,
      defaultValue: false,
      description:
        'Whether to disable this EIP from the route during build time. Once an EIP has been disabled then it cannot be enabled later at runtime.',
    },
    id: {
      index: 6,
      kind: 'attribute',
      displayName: 'Id',
      required: false,
      type: 'string',
      javaType: 'java.lang.String',
      deprecated: false,
      autowired: false,
      secret: false,
      description: 'Sets the id of this node',
    },
    description: {
      index: 7,
      kind: 'element',
      displayName: 'Description',
      required: false,
      type: 'string',
      javaType: 'java.lang.String',
      deprecated: false,
      autowired: false,
      secret: false,
      description: 'Sets the description of this node',
    },
  },
};
