# Contributing to Kaoto

Thank you for considering contributing to Kaoto! Community contributions are essential for the project's success, and we welcome bug fixes, documentation improvements, feature additions, and more.

## Getting Started

### Prerequisites

Before you start contributing, ensure that you have the following installed:

- NodeJS (>v18.x)
- yarn (>v3.x)
- Java 17+

### Setting Up the Project

1. **Fork the Repository**:
   - Fork the project to your GitHub account by clicking the 'Fork' button on the project's GitHub page.

2. **Clone Your Fork**:
   - Clone your fork using `git clone https://github.com/YOUR_USERNAME/kaoto.git`.

3. **Install Dependencies**:
   - Navigate to the cloned folder and run `yarn install` to install all necessary dependencies.

4. **Build the Project**:
   - For detailed instructions on building and running different parts of the project, refer to the [README.md](README.md).

## How to Contribute

### Find or Create an Issue

- Look for existing issues on the [GitHub Issues page](https://github.com/KaotoIO/kaoto/issues).
- If you want to work on something new, feel free to create a new issue and discuss it with the team.

### Create a Feature Branch

- Create a new branch for your work, naming it descriptively, such as `feature/new-feature-name` or `bugfix/issue-description`.

### Make Your Changes

- Work on the issue in your local environment.
- Make sure to follow the project's coding standards and guidelines.

### Commit and Push Your Changes

- Write a clear and concise commit message describing what you've done.
- Push your changes to your GitHub fork.

### Submit a Pull Request (PR)

- Create a pull request from your fork to the main Kaoto repository.
- Provide a detailed description of your changes, referencing any related issues.
- Await feedback or approval from the maintainers.

## Code Style and Guidelines

- Follow the existing code style in the project.
- If applicable, adhere to linter rules provided in the project, such as ESLint and Prettier.

## Testing

- Ensure that your changes don't break existing functionality.
- Include new tests for added features or bug fixes, and ensure all tests pass.

## Compliance with License

- By contributing, you agree that your contributions will be licensed under the Apache License 2.0.
- Make sure to review the full [Apache License 2.0](https://www.apache.org/licenses/LICENSE-2.0) to understand the terms.
- If the project includes a `LICENSE` file containing the Apache License 2.0 text, you can also link to that file in this section.

---

Your contributions make Kaoto better, and we sincerely appreciate your support and collaboration. Happy coding!

## Questions or Need Help?

If you have any questions or need assistance, feel free to create an issue on GitHub or contact the project maintainers directly.

---

Your contributions make Kaoto better, and we sincerely appreciate your support and collaboration. Happy coding!
