import axios from 'axios'
import store from '@/store'
import { getToken } from '@/utils/auth'
import Swal from 'sweetalert2'

// create an axios instance
const service = axios.create({
  baseURL: process.env.BASE_API || '',   // api base_url
  // withCredentials: true,        // send cookies when cross-domain requests
  timeout: 5000                    // request timeout
})

// request interceptor
service.interceptors.request.use(
  config => {
    // do something before request is sent

    if (store.getters.token) {
      // let each request carry token
      // ['Vue_Admin_Token'] is a custom headers key
      // please modify it according to the actual situation
      config.headers['Vue_Admin_Token'] = getToken()
    }
    return config
  },
  error => {
    // do something with request error
    console.log(error) // for debug
    return Promise.reject(error)
  }
)

// response interceptor
service.interceptors.response.use(
  /**
   * Determine the request status by custom code
   * Here is just an example
   * You can also judge the status by HTTP Status Code
   */
  response => {
     // console.log(response)
     const res = response.data;

    // if the simply flag or custom code like (res.code !== 20000) , it is judged as an error.
    if (!res.ok ) {
        Swal.fire({ type: 'error', title: 'Error', text: res.message || 'Error!!!'});

      // 50008: Illegal token; 50012: Other clients logged in; 50014: Token expired;
      if (res.code === 50008 || res.code === 50012 || res.code === 50014) {
        // to re-login
          Swal.fire({
            type: 'warning',
            title: 'Confirm logout',
            text: 'You have been logged out, you can cancel to stay on this page, or log in again',
            confirmButtonText: 'Re-Login',
            cancelButtonText: 'Cancel'
        }).then(() => {
            store.dispatch('user/resetToken').then(() => {
               location.reload()
          })
        })
      }
      return Promise.reject(new Error(res.message || 'Error'))
    } else {
      return res
    }
  },
  error => {
    console.log('err' + error) // for debug
    Swal.fire({ type: 'error', title: 'Error', text: error.message });
    return Promise.reject(error)
  }
)

export default service
