'use strict'

// see http://vuejs-templates.github.io/webpack for documentation.
const path = require('path')

module.exports = {
  build: {
    env: require('./prod.env'),
      // Template for index.html
    index: path.resolve(__dirname, '../dist/index.html'),
      // Paths
    assetsRoot: path.resolve(__dirname, '../dist'),
    assetsSubDirectory: 'static',
      /**
       * You can set by youself according to actual condition
       * You will need to set this if you plan to deploy your site under a sub path,
       * for example GitHub pages. If you plan to deploy your site to https://foo.github.io/bar/,
       * then assetsPublicPath should be set to "/bar/".
       * In most cases please use '/' !!!
       */
    assetsPublicPath: '/vue-adminLte/',  // If you are deployed on the root path, please use '/'

      // Source Maps
    productionSourceMap: true,
    // https://webpack.js.org/configuration/devtool/#production
    devtool: '#source-map',
    // Gzip off by default as many popular static hosts such as
    // Surge or Netlify already gzip all static assets for you.
    // Before setting to `true`, make sure to:
    // npm install --save-dev compression-webpack-plugin
    productionGzip: false,
    productionGzipExtensions: ['js', 'css'],
    // Run the build command with an extra argument to
    // View the bundle analyzer report after build finishes:
    // `npm run build --report`
    // Set to `true` or `false` to always turn it on or off
    bundleAnalyzerReport: process.env.npm_config_report
  },
  dev: {
    // Paths
    env: require('./dev.env'),
    assetsSubDirectory: 'static',
    assetsPublicPath: '/',
    proxyTable: {
        '/api/*': {
            // target: 'http://example.org',  //  Api server.
            target: 'http://localhost:3000',
            secure:false,
            changeOrigin: true,                              //  For virtual hosted sites.
            ws: true,                                        //  Proxy websockets.
            pathRewrite: {
                // Rewrite path localhost:8080/api to http://localhost:3000  (http://example.org)
                '^/api/*': ''
            },
            router: {
                // when request.headers.host == 'dev.localhost:3000',
                // override target 'http://www.example.org' to 'http://localhost:8080'
                // 'dev.localhost:3000': 'http://localhost:8080'
            }
        }
    },

    // Various Dev Server settings

    // can be overwritten by process.env.HOST
    // if you want dev by ip, please set host: '0.0.0.0'
    host: 'localhost',
    port: 8080,
    autoOpenBrowser: true,

    //Source Maps
    // https://webpack.js.org/configuration/devtool/#development
    devtool: '#cheap-source-map',
    // If you have problems debugging vue-files in devtools,
    // set this to false - it *may* help
    // https://vue-loader.vuejs.org/en/options.html#cachebusting
    cacheBusting: true,
      // CSS Sourcemaps off by default because relative paths are "buggy"
    // with this option, according to the CSS-Loader README
    // (https://github.com/webpack/css-loader#sourcemaps)
    // In our experience, they generally work as expected,
    // just be aware of this issue when enabling this option.
    cssSourceMap: false
  }
}
