---
layout: post
title: "Review: A Week With the Apple Watch"
description: "The Apple Watch is a smartwatch developed by Apple Inc."
date: 2019-01-04
feature_image: images/apple-watch.jpg
tags: [tips, work]
---
The **Apple Watch** is a smartwatch developed by [Apple Inc](http://www.apple.com/). It incorporates fitness tracking and health-oriented capabilities as well as integration with iOS and other Apple products and services. The device is available in four variants: Apple Watch Sport, Apple Watch, Apple Watch Hermès, and Apple Watch Edition. The Watch is distinguished by different combinations of cases and first or third party interchangeable bands. Apple Watch relies on a wirelessly connected iPhone to perform many of its default functions such as calling and texting. It is compatible with the iPhone 5 or later models running iOS 8.2 or later, through the use of Bluetooth or Wi-Fi. 

<!--more-->

Announced by Tim Cook on September 9, 2014, the device was available for pre-order on April 10 and began shipping on April 24, 2015. The Apple Watch quickly became the best-selling wearable device, with the shipment of 4.2 million smartwatches in the second quarter of 2015, according to analyst firm Canalys.

>“You can only do so many things great, and you should cast aside everything else.”
><cite>― Tim Cook</cite>

Rumors surrounded an Apple-developed wearable back as far as 2011, which conceptualized the device as a variation of the iPod that would curve around the user's wrist, and feature Siri integration. On February 10, 2013, both The New York Times and The Wall Street Journal reported that Apple was beginning to develop an iOS-based smartwatch with a curved display. On February 12, 2013, Bloomberg reported that Apple's smartwatch project was "beyond the experimentation phase in its development", and had a team of at least 100 designers were working on the project. Further reports in March 2013 indicated that Apple planned to release the device by the end of the year. In July 2013, Financial Times reported that Apple had begun hiring more employees to work on the smartwatch, and that it was targeting a possible retail release in late 2014.

## Unveiling & Release

In April 2014, Apple CEO [Tim Cook](https://en.wikipedia.org/wiki/Tim_Cook) told The Wall Street Journal that the company was planning to launch new product categories that year, but did not reveal any specifics. In June 2014, Reuters reported that production was expected to begin in July for a release in October.

Apple Watch was first unveiled after a classic and ever infamous *"We do have 'one more thing'..."* slide, which heard enormous applause, on September 9, 2014 during a press event which also saw the introduction of the iPhone 6. After the reveal video, the auditorium erupted with applause while Tim Cook rolled back his sleeve, revealing an Apple Watch on his wrist. Speaking about the device, Apple CEO Tim Cook explained that Apple Watch was "a new, intimate way to communicate from your wrist, and a comprehensive health and fitness device."

In comparison to other Apple products and competing smartwatches, marketing of Apple Watch focused more on advertising the device as a fashion accessory; a 12-page advertising spread for Apple Watch in an issue of Vogue focused primarily on the different body and band styles available, and downplayed the technological aspects of it. Apple has also, in particular, focused upon its health and fitness-oriented features, competing against dedicated activity trackers.

{% include image_full.html imageurl="/images/apple-watch-in-car.jpg" title="Apple Watch" caption="Apple watch on the wrist" %}

## Release

Pre-orders for Apple Watch began on April 10, 2015, with an official release on April 24.

On launch, Apple Watch was not available at Apple Store; beginning on April 10, 2015, customers could receive appointments for demonstrations and fitting, but the device was not in-stock for walk-in purchase, and had to be reserved and ordered online (however, sales representatives are able to assist in the process). CNET felt that this distribution model was designed to prevent Apple Store locations from having long line-ups due to high demand. Selected Apple Watch models were available in-store at certain luxury boutiques and authorized Apple resellers in limited quantities. On June 4, 2015, Apple announced that it did plan to stock Apple Watch models at its retail locations. On August 24, 2015 during an earnings call, Best Buy announced that it would begin stocking Apple Watch at its retail stores by the end of September. Both T-Mobile US and Sprint also announced plans to offer Apple Watch through its retail stores.

>“Design is a funny word. Some people think design means how it looks. But of course, if you dig deeper, it's really how it works.” <cite>― Steve Jobs</cite>

On September 9, 2015, in Apple's Special Event, Apple launched a new collection of Apple Watch in a collaboration with Hermès. This new collection of Apple Watch is named as Apple Watch Hermès, comes in stainless steel body with finely crafted leather bands in distinctive styles from Hermès, including the Single Tour, Double Tour and Cuff models. Apple Watch Hermès is available only in selected retail stores of Apple and Hermès.

The device was not branded as "iWatch" (which would put it in line with its other product lines) due to trademark conflicts in certain territories; in the United States, the iWatch trademark is owned by OMG Electronics—who was crowdfunding a device under the same name, and is owned in the European Union by Irish firm Probendi. In July 2015, Probendi sued Apple Inc. for trademark infringement, arguing that through keyword advertising on the Google search engine, it caused advertising for the Apple Watch to appear on search results pages when users searched for the trademarked term "iWatch".

Apple Watch finally goes on sale in India on Nov. 6. The device also has launched in Chile, the Philippines, and South Africa.  [ [Source](https://en.wikipedia.org/wiki/Apple_Watch) ]
