---
layout: post
title:  "Fragments of Iceland"
date:   2018-01-07
featured_image: iceland.jpg
tags: [Tips, Photography, Nature]
---

<strong>Iceland</strong> is a Nordic country between the North Atlantic and the Arctic Ocean. <em>It has a population of 325,671 and an area of 103,000 km2 (40,000 sq mi)</em>, making it the most sparsely populated country in Europe. The capital and largest city is Reykjavík; the surrounding areas in the South-West of the country are home to two-thirds of the population. Iceland is volcanically and geologically active. The interior consists mainly of a plateau characterised by sand and lava fields, mountains and glaciers, while many glacial rivers flow to the sea through the lowlands. Iceland is warmed by the Gulf Stream and has a temperate climate despite a high latitude just outside the Arctic Circle.

<!--more-->

According to Landnámabók, the settlement of Iceland began in AD 874 when the chieftain Ingólfr Arnarson became the first permanent Norse settler on the island. In the following centuries, Norsemen settled Iceland, bringing with them thralls of Gaelic origin. From 1262 to 1918, Iceland was ruled by Norway and later Denmark. The country became independent in 1918 and a republic in 1944.

{% include image_caption.html imageurl="/images/posts/iceland2.jpg" title="Apple Super" caption="Landmannalaugar Iceland" %}

> Iceland, I'm in love with that country, the people are incredible. <cite>Kit Harington</cite>

Until the 20th century, Iceland relied largely on fishing and agriculture. Industrialisation of the fisheries and Marshall Plan aid following World War II brought prosperity and Iceland became one of the wealthiest and most developed nations in the world. In 1994, Iceland became party to the European Economic Area, which supported diversification into economic and financial services. In 2008, affected by the worldwide crisis, the nation's entire banking system systemically failed, resulting in substantial political unrest. In the wake of the crisis, Iceland instituted "capital controls" that made it impossible for foreign investors to take money out of the country, leading to the Icesave dispute. The economy has since then made a significant recovery.

Iceland has a free-market economy with relatively low taxes compared to other OECD countries.[11] It maintains a Nordic social welfare system that provides universal health care and tertiary education for its citizens. Iceland ranks high in economic, political and social stability and equality. In 2013, it was ranked as the 13th most-developed country in the world by the United Nations' Human Development Index.

Icelandic culture is founded upon the nation's Norse heritage. Most Icelanders are descendants of Norse and Gaelic settlers. Icelandic, a North Germanic language, is descended from Old Norse and is closely related to Faroese and West Norwegian dialects. The country's cultural heritage includes traditional Icelandic cuisine, Icelandic literature and mediaeval sagas. Iceland has the smallest population of any NATO member and is the only one with no standing army, its lightly armed Coast Guard being in charge of defence.