---
layout: post
title:  "Grand Canyon Hike With Kids"
date:   2018-01-05
featured_image: grand-canyon.jpg
tags: [Tips, Hike, Mountains]
---

<a href="https://en.wikipedia.org/wiki/Grand_Canyon">**The Grand Canyon**</a> is a steep-sided canyon carved by the Colorado River in the state of Arizona in the United States. It is contained within and managed by Grand Canyon National Park, the Kaibab National Forest, Grand Canyon-Parashant National Monument, the Hualapai Tribal Nation, the Havasupai people and the Navajo Nation. President Theodore Roosevelt was a major proponent of preservation of the Grand Canyon area, and visited it on numerous occasions to hunt and enjoy the scenery.

The Grand Canyon is 277 miles *(446 km)* long, up to 18 miles *(29 km)* wide and attains a depth of over a mile *(6,093 feet or 1,857 meters)*. Nearly two billion years of Earth's geological history have been exposed as the Colorado River and its tributaries cut their channels through layer after layer of rock while the Colorado Plateau was uplifted. While some aspects about the history of incision of the canyon are debated by geologists, several recent studies support the hypothesis that the Colorado River established its course through the area about 5 to 6 million years ago. Since that time, the <a href="https://en.wikipedia.org/wiki/Colorado_River">Colorado River</a> has driven the down-cutting of the tributaries and retreat of the cliffs, simultaneously deepening and widening the canyon.

<!--more-->

{% include image_full.html imageurl="/images/posts/grandcanyon.jpg" title="Apple" caption="The Grand Canyon" %}

For thousands of years, the area has been continuously inhabited by Native Americans, who built settlements within the canyon and its many caves. The Pueblo people considered the Grand Canyon a holy site, and made pilgrimages to it. The first European known to have viewed the Grand Canyon was García López de Cárdenas from Spain, who arrived in 1540.

## Geography

The Grand Canyon is a river valley in the Colorado Plateau that exposes uplifted Proterozoic and Paleozoic strata, and is also one of the 19 distinct physiographic sections of the Colorado Plateau province. It is not the deepest canyon in the world (Kali Gandaki Gorge in Nepal is much deeper). However, the Grand Canyon is known for its visually overwhelming size and its intricate and colorful landscape. Geologically, it is significant because of the thick sequence of ancient rocks that are well preserved and exposed in the walls of the canyon. These rock layers record much of the early geologic history of the North American continent.

### Tips For Hiking

Uplift associated with mountain formation later moved these sediments thousands of feet upward and created the Colorado Plateau. The higher elevation has also resulted in greater precipitation in the Colorado River drainage area, but not enough to change the Grand Canyon area from being semi-arid. The uplift of the Colorado Plateau is uneven, and the Kaibab Plateau that Grand Canyon bisects is over a one thousand feet (300 m) higher at the North Rim (about 1,000 ft or 300 m) than at the South Rim. Almost all runoff from the North Rim (which also gets more rain and snow) flows toward the Grand Canyon, while much of the runoff on the plateau behind the South Rim flows away from the canyon (following the general tilt). The result is deeper and longer tributary washes and canyons on the north side and shorter and steeper side canyons on the south side.

Temperatures on the North Rim are generally lower than those on the South Rim because of the greater elevation (averaging 8,000 feet or 2,400 metres above sea level).[10] Heavy rains are common on both rims during the summer months. Access to the North Rim via the primary route leading to the canyon (State Route 67) is limited during the winter season due to road closures
