package com.junkfood.seal.ui.svg.drawablevectors

import androidx.compose.material3.MaterialTheme
import androidx.compose.runtime.Composable
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.PathFillType.Companion.NonZero
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.StrokeCap.Companion.Butt
import androidx.compose.ui.graphics.StrokeJoin.Companion.Miter
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.ImageVector.Builder
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp
import com.junkfood.seal.ui.svg.DynamicColorImageVectors

@Composable
fun DynamicColorImageVectors.videoSteaming(): ImageVector {
    return Builder(
            name = "VideoSteaming",
            defaultWidth = 766.0.dp,
            defaultHeight = 663.78.dp,
            viewportWidth = 766.0f,
            viewportHeight = 663.78f,
        )
        .apply {
            path(
                fill = SolidColor(MaterialTheme.colorScheme.surfaceContainerHighest),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(75.871f, 614.538f)
                curveToRelative(-6.979f, 23.313f, 3.852f, 47.148f, 3.852f, 47.148f)
                reflectiveCurveToRelative(22.147f, -13.963f, 29.126f, -37.276f)
                reflectiveCurveToRelative(-3.852f, -47.148f, -3.852f, -47.148f)
                reflectiveCurveTo(82.85f, 591.225f, 75.871f, 614.538f)
                close()
            }
            path(
                fill = SolidColor(MaterialTheme.colorScheme.surfaceContainerHighest),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(86.467f, 615.169f)
                curveToRelative(5.874f, 23.616f, -6.068f, 46.915f, -6.068f, 46.915f)
                reflectiveCurveToRelative(-21.465f, -14.99f, -27.339f, -38.606f)
                reflectiveCurveToRelative(6.068f, -46.915f, 6.068f, -46.915f)
                reflectiveCurveTo(80.594f, 591.553f, 86.467f, 615.169f)
                close()
            }
            path(
                fill = SolidColor(Color(0xFFffb8b8)),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(435.535f, 638.619f)
                lineToRelative(4.442f, -11.427f)
                lineToRelative(-41.96f, -22.573f)
                lineToRelative(-6.556f, 16.865f)
                lineToRelative(44.074f, 17.135f)
                close()
            }
            path(
                fill = SolidColor(Color(0xFF2f2e41)),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(459.337f, 608.81f)
                arcToRelative(15.379f, 15.379f, 0.0f, false, false, -19.915f, 8.766f)
                lineToRelative(-2.997f, 7.703f)
                lineToRelative(-4.62f, 11.89f)
                lineToRelative(-1.129f, 2.915f)
                lineToRelative(14.806f, 5.76f)
                lineToRelative(14.321f, -36.849f)
                close()
            }
            path(
                fill = SolidColor(Color(0xFF2f2e41)),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(431.806f, 616.628f)
                lineToRelative(-1.932f, 5.124f)
                lineToRelative(-4.822f, 12.788f)
                lineToRelative(-0.116f, 0.32f)
                curveToRelative(-12.285f, 1.578f, -25.752f, -1.516f, -38.209f, -6.323f)
                arcToRelative(155.312f, 155.312f, 0.0f, false, true, -14.624f, -6.526f)
                curveToRelative(-7.044f, -3.559f, -13.352f, -7.316f, -18.383f, -10.529f)
                curveToRelative(-7.576f, -4.862f, -12.26f, -8.513f, -12.26f, -8.513f)
                reflectiveCurveToRelative(-1.238f, 1.118f, -3.477f, 3.036f)
                curveToRelative(-3.002f, 2.568f, -7.798f, 6.578f, -13.873f, 11.299f)
                quadToRelative(-3.476f, 2.72f, -7.465f, 5.69f)
                curveToRelative(-19.601f, 14.539f, -44.756f, -24.256f, -44.756f, -24.256f)
                reflectiveCurveToRelative(7.075f, -4.504f, 8.923f, -5.379f)
                curveToRelative(5.951f, -2.816f, 19.932f, -9.459f, 31.994f, -15.363f)
                curveToRelative(6.214f, -3.046f, 11.912f, -5.903f, 15.737f, -7.932f)
                curveToRelative(13.546f, -7.212f, 30.384f, 6.435f, 30.384f, 6.435f)
                close()
            }
            path(
                fill = SolidColor(Color(0xFF000000)),
                stroke = null,
                fillAlpha = 0.14f,
                strokeAlpha = 0.14f,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(431.806f, 616.628f)
                lineToRelative(-1.932f, 5.124f)
                lineToRelative(-4.822f, 12.788f)
                lineToRelative(-0.116f, 0.32f)
                curveToRelative(-12.285f, 1.578f, -25.752f, -1.516f, -38.209f, -6.323f)
                arcToRelative(155.312f, 155.312f, 0.0f, false, true, -14.624f, -6.526f)
                curveToRelative(-7.044f, -3.559f, -13.352f, -7.316f, -18.383f, -10.529f)
                curveToRelative(-7.576f, -4.862f, -12.26f, -8.513f, -12.26f, -8.513f)
                reflectiveCurveToRelative(-1.238f, 1.118f, -3.477f, 3.036f)
                curveToRelative(-3.002f, 2.568f, -7.798f, 6.578f, -13.873f, 11.299f)
                quadToRelative(-3.476f, 2.72f, -7.465f, 5.69f)
                curveToRelative(-19.601f, 14.539f, -44.756f, -24.256f, -44.756f, -24.256f)
                reflectiveCurveToRelative(7.075f, -4.504f, 8.923f, -5.379f)
                curveToRelative(5.951f, -2.816f, 19.932f, -9.459f, 31.994f, -15.363f)
                curveToRelative(6.214f, -3.046f, 11.912f, -5.903f, 15.737f, -7.932f)
                curveToRelative(13.546f, -7.212f, 30.384f, 6.435f, 30.384f, 6.435f)
                close()
            }
            path(
                fill = SolidColor(MaterialTheme.colorScheme.tertiaryContainer),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(183.579f, 172.312f)
                moveToRelative(-172.312f, 0.0f)
                arcToRelative(172.312f, 172.312f, 0.0f, true, true, 344.623f, 0.0f)
                arcToRelative(172.312f, 172.312f, 0.0f, true, true, -344.623f, 0.0f)
            }
            path(
                fill = SolidColor(Color(0xFF000000)),
                stroke = null,
                fillAlpha = 0.2f,
                strokeAlpha = 0.2f,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(56.349f, 57.221f)
                arcTo(172.325f, 172.325f, 0.0f, false, false, 343.472f, 239.591f)
                arcTo(172.327f, 172.327f, 0.0f, true, true, 56.349f, 57.221f)
                close()
            }
            path(
                fill = SolidColor(Color(0xFF3f3d56)),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(184.052f, 172.311f)
                lineToRelative(0.474f, 0.0f)
                lineToRelative(8.521f, 488.532f)
                lineToRelative(-17.989f, 0.0f)
                lineToRelative(8.994f, -488.532f)
                close()
            }
            path(
                fill = SolidColor(Color(0xFF3f3d56)),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(153.557f, 401.412f)
                lineToRelative(3.97f, -7.54f)
                lineToRelative(28.484f, 14.996f)
                lineToRelative(-3.97f, 7.54f)
                close()
            }
            path(
                fill = SolidColor(Color(0xFF3f3d56)),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(765.0f, 662.788f)
                lineTo(1.0f, 662.788f)
                arcToRelative(1.0f, 1.0f, 0.0f, false, true, 0.0f, -2.0f)
                lineTo(765.0f, 660.788f)
                arcToRelative(1.0f, 1.0f, 0.0f, false, true, 0.0f, 2.0f)
                close()
            }
            path(
                fill = SolidColor(Color(0xFF2f2e41)),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(235.746f, 509.077f)
                horizontalLineToRelative(-58.0f)
                arcToRelative(4.505f, 4.505f, 0.0f, false, true, -4.5f, -4.5f)
                verticalLineToRelative(-25.0f)
                arcToRelative(33.5f, 33.5f, 0.0f, false, true, 67.0f, 0.0f)
                verticalLineToRelative(25.0f)
                arcTo(4.505f, 4.505f, 0.0f, false, true, 235.746f, 509.077f)
                close()
            }
            path(
                fill = SolidColor(Color(0xFFffb8b8)),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(290.904f, 540.478f)
                arcToRelative(9.377f, 9.377f, 0.0f, false, false, -7.186f, 12.454f)
                lineToRelative(-15.772f, 14.506f)
                lineToRelative(6.478f, 11.734f)
                lineToRelative(21.985f, -20.798f)
                arcToRelative(9.428f, 9.428f, 0.0f, false, false, -5.505f, -17.897f)
                close()
            }
            path(
                fill = SolidColor(MaterialTheme.colorScheme.surfaceVariant),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(243.448f, 606.43f)
                quadToRelative(-1.069f, 0.0f, -2.14f, -0.092f)
                arcTo(25.199f, 25.199f, 0.0f, false, true, 221.01f, 592.782f)
                lineToRelative(-25.267f, -48.633f)
                arcToRelative(13.954f, 13.954f, 0.0f, false, true, 24.13f, -13.965f)
                lineToRelative(23.311f, 52.304f)
                lineToRelative(31.719f, -25.772f)
                lineToRelative(18.366f, 7.149f)
                lineToRelative(-31.016f, 34.242f)
                arcTo(25.485f, 25.485f, 0.0f, false, true, 243.448f, 606.43f)
                close()
            }
            path(
                fill = SolidColor(Color(0xFF3f3d56)),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(336.913f, 531.285f)
                lineToRelative(-28.102f, -28.102f)
                arcToRelative(5.242f, 5.242f, 0.0f, false, false, -7.413f, 0.0f)
                lineToRelative(-25.28f, 25.28f)
                arcToRelative(5.242f, 5.242f, 0.0f, false, false, 0.0f, 7.413f)
                lineToRelative(26.256f, 26.256f)
                arcToRelative(5.242f, 5.242f, 0.0f, false, false, 7.133f, 0.26f)
                lineToRelative(27.125f, -23.435f)
                arcToRelative(5.242f, 5.242f, 0.0f, false, false, 0.54f, -7.393f)
                quadTo(337.049f, 531.42f, 336.913f, 531.285f)
                close()
            }
            path(
                fill = SolidColor(MaterialTheme.colorScheme.surfaceContainerHighest),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(332.935f, 536.213f)
                lineToRelative(-28.926f, -28.925f)
                lineToRelative(-23.871f, 23.871f)
                lineToRelative(27.803f, 27.802f)
                lineToRelative(24.994f, -22.748f)
                close()
            }

            path(
                fill = SolidColor(MaterialTheme.colorScheme.surfaceContainerHighest),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(312.209f, 533.077f)
                moveToRelative(-0.87f, 0.0f)
                arcToRelative(0.87f, 0.87f, 0.0f, true, true, 1.74f, 0.0f)
                arcToRelative(0.87f, 0.87f, 0.0f, true, true, -1.74f, 0.0f)
            }
            path(
                fill = SolidColor(MaterialTheme.colorScheme.surfaceContainerHighest),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(312.584f, 530.935f)
                moveToRelative(-0.435f, 0.0f)
                arcToRelative(0.435f, 0.435f, 0.0f, true, true, 0.87f, 0.0f)
                arcToRelative(0.435f, 0.435f, 0.0f, true, true, -0.87f, 0.0f)
            }
            path(
                fill = SolidColor(MaterialTheme.colorScheme.surfaceContainerHighest),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(306.328f, 524.277f)
                moveToRelative(-0.435f, 0.0f)
                arcToRelative(0.435f, 0.435f, 0.0f, true, true, 0.87f, 0.0f)
                arcToRelative(0.435f, 0.435f, 0.0f, true, true, -0.87f, 0.0f)
            }
            path(
                fill = SolidColor(MaterialTheme.colorScheme.surfaceContainerHighest),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(305.953f, 526.419f)
                moveToRelative(-0.87f, 0.0f)
                arcToRelative(0.87f, 0.87f, 0.0f, true, true, 1.74f, 0.0f)
                arcToRelative(0.87f, 0.87f, 0.0f, true, true, -1.74f, 0.0f)
            }
            path(
                fill = SolidColor(Color(0xFFffb8b8)),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(431.99f, 654.69f)
                lineToRelative(5.307f, -11.051f)
                lineToRelative(-40.101f, -25.73f)
                lineToRelative(-7.833f, 16.311f)
                lineToRelative(42.627f, 20.47f)
                close()
            }
            path(
                fill = SolidColor(Color(0xFF2f2e41)),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(458.012f, 626.798f)
                arcToRelative(15.379f, 15.379f, 0.0f, false, false, -20.53f, 7.21f)
                lineToRelative(-3.58f, 7.45f)
                lineToRelative(-5.52f, 11.5f)
                lineToRelative(-1.35f, 2.82f)
                lineToRelative(14.32f, 6.88f)
                lineToRelative(17.11f, -35.64f)
                close()
            }
            path(
                fill = SolidColor(Color(0xFF2f2e41)),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(429.962f, 632.478f)
                lineToRelative(-2.32f, 4.96f)
                lineToRelative(-5.79f, 12.38f)
                lineToRelative(-0.14f, 0.31f)
                curveToRelative(-12.37f, 0.63f, -25.56f, -3.49f, -37.61f, -9.24f)
                arcToRelative(155.312f, 155.312f, 0.0f, false, true, -14.08f, -7.63f)
                curveToRelative(-6.75f, -4.09f, -12.75f, -8.32f, -17.52f, -11.91f)
                curveToRelative(-7.18f, -5.43f, -11.57f, -9.43f, -11.57f, -9.43f)
                reflectiveCurveToRelative(-1.32f, 1.02f, -3.7f, 2.76f)
                curveToRelative(-3.19f, 2.33f, -8.28f, 5.96f, -14.7f, 10.2f)
                quadToRelative(-3.675f, 2.445f, -7.88f, 5.1f)
                curveToRelative(-20.66f, 12.99f, -50.04f, 28.81f, -75.03f, 32.15f)
                curveToRelative(-43.89f, 5.87f, -33.56f, -52.7f, -33.56f, -52.7f)
                lineToRelative(34.93f, -18.14f)
                lineToRelative(14.83f, 3.01f)
                lineToRelative(16.51f, 3.34f)
                lineToRelative(5.85f, 1.19f)
                reflectiveCurveToRelative(1.11f, -0.42f, 3.02f, -1.15f)
                curveToRelative(6.15f, -2.35f, 20.6f, -7.9f, 33.08f, -12.86f)
                curveToRelative(6.43f, -2.56f, 12.33f, -4.97f, 16.3f, -6.7f)
                curveToRelative(14.06f, -6.15f, 29.8f, 8.75f, 29.8f, 8.75f)
                close()
            }
            path(
                fill = SolidColor(Color(0xFFffb8b8)),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(142.145f, 663.526f)
                arcToRelative(9.377f, 9.377f, 0.0f, false, false, 6.532f, -12.809f)
                lineToRelative(15.0f, -15.302f)
                lineToRelative(-7.076f, -11.384f)
                lineToRelative(-20.88f, 21.907f)
                arcToRelative(9.428f, 9.428f, 0.0f, false, false, 6.423f, 17.588f)
                close()
            }
            path(
                fill = SolidColor(Color(0xFFffb8b8)),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(214.958f, 486.807f)
                moveToRelative(-23.386f, 0.0f)
                arcToRelative(23.386f, 23.386f, 0.0f, true, true, 46.772f, 0.0f)
                arcToRelative(23.386f, 23.386f, 0.0f, true, true, -46.772f, 0.0f)
            }
            path(
                fill = SolidColor(MaterialTheme.colorScheme.surfaceVariant),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(184.533f, 551.724f)
                lineTo(204.905f, 609.48f)
                lineToRelative(-0.122f, 0.202f)
                curveToRelative(-2.833f, 4.684f, -3.76f, 8.462f, -2.678f, 10.926f)
                arcToRelative(4.761f, 4.761f, 0.0f, false, false, 3.019f, 2.604f)
                lineToRelative(48.209f, -33.697f)
                lineToRelative(-1.688f, -13.505f)
                lineToRelative(0.094f, -0.151f)
                curveToRelative(4.66f, -7.456f, 6.168f, -14.208f, 4.485f, -20.067f)
                curveToRelative(-2.184f, -7.604f, -9.125f, -11.056f, -9.195f, -11.09f)
                lineToRelative(-0.168f, -0.132f)
                lineTo(222.815f, 515.304f)
                lineTo(190.673f, 521.014f)
                close()
            }
            path(
                fill = SolidColor(MaterialTheme.colorScheme.surfaceVariant),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(153.553f, 653.099f)
                lineTo(139.906f, 636.302f)
                lineToRelative(32.899f, -54.31f)
                lineToRelative(15.339f, -47.413f)
                lineToRelative(0.476f, 0.154f)
                lineToRelative(-0.476f, -0.154f)
                arcToRelative(19.047f, 19.047f, 0.0f, true, true, 33.964f, 16.437f)
                lineToRelative(-28.16f, 42.189f)
                close()
            }
            path(
                fill = SolidColor(Color(0xFF2f2e41)),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(248.171f, 482.077f)
                lineTo(212.706f, 482.077f)
                lineToRelative(-0.364f, -5.092f)
                lineToRelative(-1.818f, 5.092f)
                horizontalLineToRelative(-5.461f)
                lineToRelative(-0.721f, -10.092f)
                lineToRelative(-3.604f, 10.092f)
                lineTo(190.171f, 482.077f)
                verticalLineToRelative(-0.5f)
                arcToRelative(26.53f, 26.53f, 0.0f, false, true, 26.5f, -26.5f)
                horizontalLineToRelative(5.0f)
                arcToRelative(26.53f, 26.53f, 0.0f, false, true, 26.5f, 26.5f)
                close()
            }
            path(
                fill = SolidColor(Color(0xFF2f2e41)),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(212.415f, 513.743f)
                arcToRelative(4.597f, 4.597f, 0.0f, false, true, -0.796f, -0.07f)
                lineToRelative(-25.969f, -4.582f)
                lineTo(185.65f, 466.171f)
                lineTo(214.237f, 466.171f)
                lineToRelative(-0.708f, 0.825f)
                curveToRelative(-9.847f, 11.484f, -2.428f, 30.106f, 2.87f, 40.185f)
                arcToRelative(4.433f, 4.433f, 0.0f, false, true, -0.352f, 4.707f)
                arcTo(4.482f, 4.482f, 0.0f, false, true, 212.415f, 513.743f)
                close()
            }
            path(
                fill = SolidColor(MaterialTheme.colorScheme.primary),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(588.139f, 324.689f)
                moveToRelative(-114.0f, 0.0f)
                arcToRelative(114.0f, 114.0f, 0.0f, true, true, 228.0f, 0.0f)
                arcToRelative(114.0f, 114.0f, 0.0f, true, true, -228.0f, 0.0f)
            }
            path(
                fill = SolidColor(MaterialTheme.colorScheme.onPrimary),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(558.992f, 280.378f)
                verticalLineToRelative(96.991f)
                arcToRelative(2.497f, 2.497f, 0.0f, false, false, 3.74f, 2.302f)
                lineToRelative(76.883f, -48.496f)
                arcToRelative(2.748f, 2.748f, 0.0f, false, false, 0.0f, -4.571f)
                lineToRelative(-76.883f, -48.496f)
                arcToRelative(2.474f, 2.474f, 0.0f, false, false, -3.74f, 2.27f)
                close()
            }
        }
        .build()
}
