package com.junkfood.seal.ui.svg.drawablevectors

import androidx.compose.material3.MaterialTheme
import androidx.compose.runtime.Composable
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.PathFillType.Companion.NonZero
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.StrokeCap.Companion.Butt
import androidx.compose.ui.graphics.StrokeJoin.Companion.Miter
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.ImageVector.Builder
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp
import com.junkfood.seal.ui.svg.DynamicColorImageVectors

@Composable
fun DynamicColorImageVectors.videoFiles(): ImageVector {
    return Builder(
            name = "VideoFiles",
            defaultWidth = 1008.9205.dp,
            defaultHeight = 607.45.dp,
            viewportWidth = 1008.9205f,
            viewportHeight = 607.45f,
        )
        .apply {
            path(
                fill = SolidColor(MaterialTheme.colorScheme.surfaceVariant),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(1008.92f, 474.03f)
                arcToRelative(15.34f, 15.34f, 0.0f, false, true, -15.26f, 15.42f)
                lineTo(322.26f, 489.45f)
                arcToRelative(15.34f, 15.34f, 0.0f, false, true, -15.26f, -15.42f)
                lineTo(307.0f, 15.42f)
                arcToRelative(15.34f, 15.34f, 0.0f, false, true, 15.26f, -15.42f)
                lineTo(993.66f, 0.0f)
                arcToRelative(15.34f, 15.34f, 0.0f, false, true, 15.26f, 15.42f)
                verticalLineToRelative(0.0f)
                close()
            }
            path(
                fill = SolidColor(MaterialTheme.colorScheme.surfaceContainer),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(1001.0f, 466.52f)
                arcToRelative(14.91f, 14.91f, 0.0f, false, true, -14.91f, 14.91f)
                lineTo(330.29f, 481.43f)
                arcToRelative(14.91f, 14.91f, 0.0f, false, true, -14.91f, -14.91f)
                lineTo(315.38f, 23.14f)
                arcToRelative(14.91f, 14.91f, 0.0f, false, true, 14.91f, -14.91f)
                horizontalLineToRelative(655.83f)
                arcToRelative(14.91f, 14.91f, 0.0f, false, true, 14.88f, 14.91f)
                close()
            }
            path(
                fill = SolidColor(MaterialTheme.colorScheme.surfaceVariant),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(350.43f, 27.48f)
                horizontalLineToRelative(616.22f)
                arcToRelative(8.85f, 8.85f, 0.0f, false, true, 8.85f, 8.85f)
                verticalLineTo(451.61f)
                arcToRelative(8.85f, 8.85f, 0.0f, false, true, -8.85f, 8.85f)
                horizontalLineToRelative(-616.22f)
                arcToRelative(8.85f, 8.85f, 0.0f, false, true, -8.85f, -8.85f)
                verticalLineTo(36.33f)
                arcToRelative(8.85f, 8.85f, 0.0f, false, true, 8.85f, -8.85f)
                close()
            }
            path(
                fill = SolidColor(MaterialTheme.colorScheme.surfaceContainer),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(358.23f, 37.44f)
                horizontalLineToRelative(599.95f)
                arcToRelative(8.85f, 8.85f, 0.0f, false, true, 8.85f, 8.85f)
                verticalLineTo(439.41f)
                arcToRelative(8.85f, 8.85f, 0.0f, false, true, -8.85f, 8.85f)
                horizontalLineToRelative(-599.95f)
                arcToRelative(8.85f, 8.85f, 0.0f, false, true, -8.85f, -8.85f)
                verticalLineTo(46.29f)
                arcTo(8.85f, 8.85f, 0.0f, false, true, 358.23f, 37.44f)
                close()
            }
            path(
                fill = SolidColor(Color(0xFF3f3d56)),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(781.84f, 310.53f)
                arcToRelative(16.87f, 16.87f, 0.0f, false, true, -6.85f, -1.46f)
                arcToRelative(8.31f, 8.31f, 0.0f, false, true, -1.43f, -0.81f)
                lineToRelative(-43.6f, -30.69f)
                horizontalLineToRelative(0.0f)
                arcToRelative(16.87f, 16.87f, 0.0f, false, true, -7.16f, -13.79f)
                lineTo(722.79f, 221.92f)
                arcToRelative(16.87f, 16.87f, 0.0f, false, true, 7.16f, -13.79f)
                lineToRelative(43.6f, -30.69f)
                arcToRelative(8.31f, 8.31f, 0.0f, false, true, 1.43f, -0.81f)
                arcTo(16.87f, 16.87f, 0.0f, false, true, 798.71f, 192.04f)
                lineTo(798.71f, 293.66f)
                arcToRelative(16.87f, 16.87f, 0.0f, false, true, -16.87f, 16.87f)
                close()
            }
            path(
                fill = SolidColor(Color(0xFF3f3d56)),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(684.26f, 318.76f)
                lineTo(562.65f, 318.76f)
                curveToRelative(-24.81f, -0.02f, -44.92f, -16.06f, -44.94f, -35.85f)
                lineTo(517.71f, 202.79f)
                curveToRelative(0.03f, -19.79f, 20.13f, -35.83f, 44.94f, -35.85f)
                lineTo(684.57f, 166.94f)
                curveToRelative(24.63f, 0.02f, 44.6f, 15.95f, 44.62f, 35.59f)
                verticalLineToRelative(80.38f)
                curveTo(729.17f, 302.7f, 709.07f, 318.74f, 684.26f, 318.76f)
                close()
            }
            path(
                fill = SolidColor(MaterialTheme.colorScheme.surfaceVariant),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(900.88f, 386.81f)
                moveToRelative(-36.17f, 0.0f)
                arcToRelative(36.17f, 36.17f, 0.0f, true, true, 72.33f, 0.0f)
                arcToRelative(36.17f, 36.17f, 0.0f, true, true, -72.33f, 0.0f)
            }
            path(
                fill = SolidColor(MaterialTheme.colorScheme.surfaceContainer),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(919.66f, 386.17f)
                lineToRelative(-28.83f, -16.64f)
                arcToRelative(0.75f, 0.75f, 0.0f, false, false, -1.12f, 0.65f)
                verticalLineToRelative(33.29f)
                arcToRelative(0.75f, 0.75f, 0.0f, false, false, 1.12f, 0.65f)
                lineToRelative(28.83f, -16.64f)
                arcToRelative(0.75f, 0.75f, 0.0f, false, false, 0.0f, -1.3f)
                lineToRelative(-28.83f, -16.64f)
                arcToRelative(0.75f, 0.75f, 0.0f, false, false, -1.12f, 0.65f)
                verticalLineToRelative(33.29f)
                arcToRelative(0.75f, 0.75f, 0.0f, false, false, 1.12f, 0.65f)
                lineToRelative(28.83f, -16.64f)
                arcTo(0.75f, 0.75f, 0.0f, false, false, 919.66f, 386.17f)
                close()
            }
            path(
                fill = SolidColor(MaterialTheme.colorScheme.surfaceVariant),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(853.92f, 529.03f)
                arcToRelative(15.34f, 15.34f, 0.0f, false, true, -15.26f, 15.42f)
                lineTo(167.26f, 544.45f)
                arcToRelative(15.34f, 15.34f, 0.0f, false, true, -15.26f, -15.42f)
                lineTo(152.0f, 70.42f)
                arcToRelative(15.34f, 15.34f, 0.0f, false, true, 15.26f, -15.42f)
                lineTo(838.66f, 55.0f)
                arcToRelative(15.34f, 15.34f, 0.0f, false, true, 15.26f, 15.42f)
                verticalLineToRelative(0.0f)
                close()
            }
            path(
                fill = SolidColor(MaterialTheme.colorScheme.surfaceContainer),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(846.0f, 521.52f)
                arcToRelative(14.91f, 14.91f, 0.0f, false, true, -14.91f, 14.91f)
                lineTo(175.29f, 536.43f)
                arcToRelative(14.91f, 14.91f, 0.0f, false, true, -14.91f, -14.91f)
                lineTo(160.38f, 78.14f)
                arcToRelative(14.91f, 14.91f, 0.0f, false, true, 14.91f, -14.91f)
                lineTo(831.12f, 63.23f)
                arcToRelative(14.91f, 14.91f, 0.0f, false, true, 14.88f, 14.91f)
                close()
            }
            path(
                fill = SolidColor(MaterialTheme.colorScheme.surfaceVariant),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(195.43f, 82.48f)
                horizontalLineToRelative(616.22f)
                arcToRelative(8.85f, 8.85f, 0.0f, false, true, 8.85f, 8.85f)
                verticalLineTo(506.61f)
                arcToRelative(8.85f, 8.85f, 0.0f, false, true, -8.85f, 8.85f)
                horizontalLineToRelative(-616.22f)
                arcToRelative(8.85f, 8.85f, 0.0f, false, true, -8.85f, -8.85f)
                verticalLineTo(91.33f)
                arcToRelative(8.85f, 8.85f, 0.0f, false, true, 8.85f, -8.85f)
                close()
            }
            path(
                fill = SolidColor(MaterialTheme.colorScheme.surfaceContainer),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(203.23f, 92.44f)
                horizontalLineToRelative(599.95f)
                arcToRelative(8.85f, 8.85f, 0.0f, false, true, 8.85f, 8.85f)
                verticalLineTo(494.41f)
                arcToRelative(8.85f, 8.85f, 0.0f, false, true, -8.85f, 8.85f)
                horizontalLineToRelative(-599.95f)
                arcToRelative(8.85f, 8.85f, 0.0f, false, true, -8.85f, -8.85f)
                verticalLineTo(101.29f)
                arcTo(8.85f, 8.85f, 0.0f, false, true, 203.23f, 92.44f)
                close()
            }
            path(
                fill = SolidColor(Color(0xFF3f3d56)),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(626.84f, 365.53f)
                arcToRelative(16.87f, 16.87f, 0.0f, false, true, -6.85f, -1.46f)
                arcToRelative(8.31f, 8.31f, 0.0f, false, true, -1.43f, -0.81f)
                lineToRelative(-43.6f, -30.69f)
                horizontalLineToRelative(0.0f)
                arcToRelative(16.87f, 16.87f, 0.0f, false, true, -7.16f, -13.79f)
                lineTo(567.79f, 276.92f)
                arcToRelative(16.87f, 16.87f, 0.0f, false, true, 7.16f, -13.79f)
                lineToRelative(43.6f, -30.69f)
                arcToRelative(8.31f, 8.31f, 0.0f, false, true, 1.43f, -0.81f)
                arcTo(16.87f, 16.87f, 0.0f, false, true, 643.71f, 247.04f)
                lineTo(643.71f, 348.66f)
                arcToRelative(16.87f, 16.87f, 0.0f, false, true, -16.87f, 16.87f)
                close()
            }
            path(
                fill = SolidColor(Color(0xFF3f3d56)),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(529.26f, 373.76f)
                lineTo(407.65f, 373.76f)
                curveToRelative(-24.81f, -0.02f, -44.92f, -16.06f, -44.94f, -35.85f)
                lineTo(362.71f, 257.79f)
                curveToRelative(0.03f, -19.79f, 20.13f, -35.83f, 44.94f, -35.85f)
                lineTo(529.57f, 221.94f)
                curveToRelative(24.63f, 0.02f, 44.6f, 15.95f, 44.62f, 35.59f)
                verticalLineToRelative(80.38f)
                curveTo(574.17f, 357.7f, 554.07f, 373.74f, 529.26f, 373.76f)
                close()
            }
            path(
                fill = SolidColor(MaterialTheme.colorScheme.surfaceVariant),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(745.88f, 441.81f)
                moveToRelative(-36.17f, 0.0f)
                arcToRelative(36.17f, 36.17f, 0.0f, true, true, 72.33f, 0.0f)
                arcToRelative(36.17f, 36.17f, 0.0f, true, true, -72.33f, 0.0f)
            }
            path(
                fill = SolidColor(MaterialTheme.colorScheme.surfaceContainer),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(764.66f, 441.17f)
                lineToRelative(-28.83f, -16.64f)
                arcToRelative(0.75f, 0.75f, 0.0f, false, false, -1.12f, 0.65f)
                verticalLineToRelative(33.29f)
                arcToRelative(0.75f, 0.75f, 0.0f, false, false, 1.12f, 0.65f)
                lineTo(764.66f, 442.46f)
                arcToRelative(0.75f, 0.75f, 0.0f, false, false, 0.0f, -1.3f)
                lineToRelative(-28.83f, -16.64f)
                arcToRelative(0.75f, 0.75f, 0.0f, false, false, -1.12f, 0.65f)
                verticalLineToRelative(33.29f)
                arcToRelative(0.75f, 0.75f, 0.0f, false, false, 1.12f, 0.65f)
                lineTo(764.66f, 442.46f)
                arcTo(0.75f, 0.75f, 0.0f, false, false, 764.66f, 441.17f)
                close()
            }
            path(
                fill = SolidColor(MaterialTheme.colorScheme.surfaceVariant),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(701.92f, 592.03f)
                arcToRelative(15.34f, 15.34f, 0.0f, false, true, -15.26f, 15.42f)
                lineTo(15.26f, 607.45f)
                arcToRelative(15.34f, 15.34f, 0.0f, false, true, -15.26f, -15.42f)
                lineTo(0.0f, 133.42f)
                arcToRelative(15.34f, 15.34f, 0.0f, false, true, 15.26f, -15.42f)
                lineTo(686.66f, 118.0f)
                arcToRelative(15.34f, 15.34f, 0.0f, false, true, 15.26f, 15.42f)
                verticalLineToRelative(0.0f)
                close()
            }
            path(
                fill = SolidColor(MaterialTheme.colorScheme.surfaceContainer),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(694.0f, 584.52f)
                arcToRelative(14.91f, 14.91f, 0.0f, false, true, -14.91f, 14.91f)
                lineTo(23.29f, 599.43f)
                arcToRelative(14.91f, 14.91f, 0.0f, false, true, -14.91f, -14.91f)
                lineTo(8.38f, 141.14f)
                arcToRelative(14.91f, 14.91f, 0.0f, false, true, 14.91f, -14.91f)
                lineTo(679.12f, 126.23f)
                arcToRelative(14.91f, 14.91f, 0.0f, false, true, 14.88f, 14.91f)
                close()
            }
            path(
                fill = SolidColor(MaterialTheme.colorScheme.surfaceVariant),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(43.43f, 145.48f)
                horizontalLineToRelative(616.22f)
                arcToRelative(8.85f, 8.85f, 0.0f, false, true, 8.85f, 8.85f)
                verticalLineTo(569.61f)
                arcToRelative(8.85f, 8.85f, 0.0f, false, true, -8.85f, 8.85f)
                horizontalLineToRelative(-616.22f)
                arcToRelative(8.85f, 8.85f, 0.0f, false, true, -8.85f, -8.85f)
                verticalLineTo(154.33f)
                arcToRelative(8.85f, 8.85f, 0.0f, false, true, 8.85f, -8.85f)
                close()
            }
            path(
                fill = SolidColor(MaterialTheme.colorScheme.surfaceContainer),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(51.23f, 155.44f)
                horizontalLineToRelative(599.95f)
                arcToRelative(8.85f, 8.85f, 0.0f, false, true, 8.85f, 8.85f)
                verticalLineTo(557.41f)
                arcToRelative(8.85f, 8.85f, 0.0f, false, true, -8.85f, 8.85f)
                horizontalLineToRelative(-599.95f)
                arcToRelative(8.85f, 8.85f, 0.0f, false, true, -8.85f, -8.85f)
                verticalLineTo(164.29f)
                arcTo(8.85f, 8.85f, 0.0f, false, true, 51.23f, 155.44f)
                close()
            }
            path(
                fill = SolidColor(MaterialTheme.colorScheme.inversePrimary),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(474.84f, 428.53f)
                arcToRelative(16.87f, 16.87f, 0.0f, false, true, -6.85f, -1.46f)
                arcToRelative(8.31f, 8.31f, 0.0f, false, true, -1.43f, -0.81f)
                lineToRelative(-43.6f, -30.69f)
                horizontalLineToRelative(0.0f)
                arcToRelative(16.87f, 16.87f, 0.0f, false, true, -7.16f, -13.79f)
                lineTo(415.79f, 339.92f)
                arcToRelative(16.87f, 16.87f, 0.0f, false, true, 7.16f, -13.79f)
                lineToRelative(43.6f, -30.69f)
                arcToRelative(8.31f, 8.31f, 0.0f, false, true, 1.43f, -0.81f)
                arcTo(16.87f, 16.87f, 0.0f, false, true, 491.71f, 310.04f)
                lineTo(491.71f, 411.66f)
                arcToRelative(16.87f, 16.87f, 0.0f, false, true, -16.87f, 16.87f)
                close()
            }
            path(
                fill = SolidColor(MaterialTheme.colorScheme.inversePrimary),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(377.26f, 436.76f)
                lineTo(255.65f, 436.76f)
                curveToRelative(-24.81f, -0.02f, -44.92f, -16.06f, -44.94f, -35.85f)
                lineTo(210.71f, 320.79f)
                curveToRelative(0.03f, -19.79f, 20.13f, -35.83f, 44.94f, -35.85f)
                lineTo(377.57f, 284.94f)
                curveToRelative(24.63f, 0.02f, 44.6f, 15.95f, 44.62f, 35.59f)
                verticalLineToRelative(80.38f)
                curveTo(422.17f, 420.7f, 402.07f, 436.74f, 377.26f, 436.76f)
                close()
            }
            path(
                fill = SolidColor(MaterialTheme.colorScheme.outline),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(593.88f, 504.81f)
                moveToRelative(-36.17f, 0.0f)
                arcToRelative(36.17f, 36.17f, 0.0f, true, true, 72.33f, 0.0f)
                arcToRelative(36.17f, 36.17f, 0.0f, true, true, -72.33f, 0.0f)
            }
            path(
                fill = SolidColor(MaterialTheme.colorScheme.surfaceContainer),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(612.66f, 504.17f)
                lineToRelative(-28.83f, -16.64f)
                arcToRelative(0.75f, 0.75f, 0.0f, false, false, -1.12f, 0.65f)
                verticalLineToRelative(33.29f)
                arcToRelative(0.75f, 0.75f, 0.0f, false, false, 1.12f, 0.65f)
                lineTo(612.66f, 505.46f)
                arcToRelative(0.75f, 0.75f, 0.0f, false, false, 0.0f, -1.3f)
                lineToRelative(-28.83f, -16.64f)
                arcToRelative(0.75f, 0.75f, 0.0f, false, false, -1.12f, 0.65f)
                verticalLineToRelative(33.29f)
                arcToRelative(0.75f, 0.75f, 0.0f, false, false, 1.12f, 0.65f)
                lineTo(612.66f, 505.46f)
                arcTo(0.75f, 0.75f, 0.0f, false, false, 612.66f, 504.17f)
                close()
            }
        }
        .build()
}
