package com.junkfood.seal.ui.svg.drawablevectors

import androidx.compose.material3.MaterialTheme
import androidx.compose.runtime.Composable
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.PathFillType.Companion.NonZero
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.StrokeCap.Companion.Butt
import androidx.compose.ui.graphics.StrokeJoin.Companion.Miter
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.ImageVector.Builder
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp
import com.junkfood.seal.ui.svg.DynamicColorImageVectors
import com.junkfood.seal.ui.theme.FixedAccentColors

@Composable
fun DynamicColorImageVectors.coder(): ImageVector {
    return Builder(
            name = "Coder",
            defaultWidth = 717.67004.dp,
            defaultHeight = 453.96432.dp,
            viewportWidth = 717.67004f,
            viewportHeight = 453.96432f,
        )
        .apply {
            path(
                fill = SolidColor(Color(0xFF2f2e41)),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(271.986f, 71.477f)
                arcToRelative(3.827f, 3.827f, 0.0f, false, true, -4.314f, 1.257f)
                arcToRelative(5.829f, 5.829f, 0.0f, false, true, -0.679f, -0.248f)
                arcToRelative(28.826f, 28.826f, 0.0f, false, false, -0.367f, -7.989f)
                arcToRelative(21.362f, 21.362f, 0.0f, false, true, -1.64f, 6.57f)
                arcToRelative(8.911f, 8.911f, 0.0f, false, true, -1.76f, -2.513f)
                arcToRelative(22.425f, 22.425f, 0.0f, false, true, -1.603f, -6.046f)
                curveToRelative(-1.204f, -7.088f, -2.393f, -14.462f, -0.428f, -21.389f)
                curveToRelative(2.879f, -10.119f, 11.957f, -17.393f, 15.749f, -27.211f)
                lineToRelative(1.868f, -1.677f)
                curveToRelative(3.198f, 5.445f, 3.339f, 12.212f, 2.036f, 18.387f)
                curveToRelative(-1.297f, 6.187f, -3.909f, 11.994f, -5.975f, 17.96f)
                reflectiveCurveToRelative(-3.613f, 12.313f, -2.655f, 18.556f)
                curveTo(272.439f, 68.604f, 272.775f, 70.22f, 271.986f, 71.477f)
                close()
            }
            path(
                fill = SolidColor(Color(0xFFffb6b6)),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(230.469f, 157.098f)
                lineToRelative(-12.174f, 55.681f)
                lineToRelative(53.174f, 17.319f)
                lineToRelative(-7.819f, -73.0f)
                lineToRelative(-33.181f, 0.0f)
                close()
            }
            path(
                fill = SolidColor(MaterialTheme.colorScheme.surfaceContainer),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(605.699f, 452.598f)
                horizontalLineToRelative(24.096f)
                lineTo(629.795f, 342.129f)
                arcTo(107.653f, 107.653f, 0.0f, false, false, 522.264f, 234.598f)
                lineTo(298.326f, 234.598f)
                arcTo(107.653f, 107.653f, 0.0f, false, false, 190.795f, 342.129f)
                lineTo(190.795f, 452.598f)
                horizontalLineToRelative(24.096f)
                lineTo(214.89f, 377.129f)
                arcTo(108.654f, 108.654f, 0.0f, false, true, 323.421f, 268.598f)
                lineTo(497.168f, 268.598f)
                arcTo(108.654f, 108.654f, 0.0f, false, true, 605.699f, 377.129f)
                close()
            }
            path(
                fill = SolidColor(MaterialTheme.colorScheme.surfaceContainerHighest),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(312.894f, 394.806f)
                lineToRelative(-25.68f, -7.775f)
                arcToRelative(88.484f, 88.484f, 0.0f, false, true, -2.509f, -20.963f)
                arcToRelative(8.399f, 8.399f, 0.0f, false, true, 13.815f, -6.355f)
                curveToRelative(13.773f, 11.814f, 33.948f, 18.118f, 46.968f, 31.58f)
                arcToRelative(52.073f, 52.073f, 0.0f, false, true, 13.888f, 42.946f)
                lineToRelative(5.621f, 18.181f)
                arcToRelative(87.259f, 87.259f, 0.0f, false, true, -63.977f, -35.285f)
                arcToRelative(84.287f, 84.287f, 0.0f, false, true, -10.122f, -18.565f)
                curveTo(301.79f, 397.335f, 312.894f, 394.806f, 312.894f, 394.806f)
                close()
            }
            path(
                fill = SolidColor(MaterialTheme.colorScheme.surfaceContainerHighest),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(379.823f, 424.579f)
                lineToRelative(13.098f, -3.966f)
                quadToRelative(0.025f, -0.104f, 0.05f, -0.209f)
                arcToRelative(8.409f, 8.409f, 0.0f, false, false, -12.483f, -9.094f)
                curveToRelative(-5.946f, 3.532f, -12.548f, 6.573f, -17.289f, 11.476f)
                arcToRelative(26.559f, 26.559f, 0.0f, false, false, -7.083f, 21.904f)
                lineToRelative(-2.867f, 9.273f)
                arcToRelative(44.505f, 44.505f, 0.0f, false, false, 32.63f, -17.996f)
                arcToRelative(42.989f, 42.989f, 0.0f, false, false, 5.162f, -9.469f)
                curveTo(385.487f, 425.869f, 379.823f, 424.579f, 379.823f, 424.579f)
                close()
            }
            path(
                fill = SolidColor(Color(0xFF3f3d56)),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(485.849f, 153.13f)
                lineTo(434.843f, 153.13f)
                arcToRelative(2.721f, 2.721f, 0.0f, false, false, -2.717f, 2.724f)
                verticalLineToRelative(80.574f)
                horizontalLineToRelative(56.447f)
                lineTo(488.573f, 155.854f)
                arcTo(2.723f, 2.723f, 0.0f, false, false, 485.849f, 153.13f)
                close()
                moveTo(460.517f, 198.911f)
                arcToRelative(6.051f, 6.051f, 0.0f, false, true, -6.023f, -6.023f)
                verticalLineToRelative(-9.293f)
                arcToRelative(6.023f, 6.023f, 0.0f, false, true, 12.046f, 0.0f)
                verticalLineToRelative(9.293f)
                arcToRelative(6.051f, 6.051f, 0.0f, false, true, -6.023f, 6.023f)
                close()
            }
            path(
                fill = SolidColor(Color(0xFF3f3d56)),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(570.309f, 27.385f)
                lineTo(352.28f, 27.385f)
                arcToRelative(7.078f, 7.078f, 0.0f, false, false, -7.066f, 7.066f)
                lineTo(345.214f, 181.579f)
                arcToRelative(7.073f, 7.073f, 0.0f, false, false, 7.066f, 7.066f)
                horizontalLineToRelative(218.029f)
                arcToRelative(7.073f, 7.073f, 0.0f, false, false, 7.066f, -7.066f)
                lineTo(577.376f, 34.452f)
                arcTo(7.078f, 7.078f, 0.0f, false, false, 570.309f, 27.385f)
                close()
            }
            path(
                fill = SolidColor(MaterialTheme.colorScheme.surface),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(568.489f, 32.489f)
                lineTo(354.102f, 32.489f)
                arcToRelative(3.787f, 3.787f, 0.0f, false, false, -3.779f, 3.787f)
                lineTo(350.323f, 179.756f)
                arcToRelative(3.786f, 3.786f, 0.0f, false, false, 3.779f, 3.779f)
                lineTo(568.489f, 183.536f)
                arcToRelative(3.786f, 3.786f, 0.0f, false, false, 3.779f, -3.779f)
                lineTo(572.268f, 36.276f)
                arcTo(3.787f, 3.787f, 0.0f, false, false, 568.489f, 32.489f)
                close()
            }
            path(
                fill = SolidColor(Color(0xFF3f3d56)),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(431.951f, 233.851f)
                verticalLineToRelative(7.774f)
                arcToRelative(1.523f, 1.523f, 0.0f, false, false, 1.52f, 1.52f)
                horizontalLineToRelative(53.758f)
                arcToRelative(1.527f, 1.527f, 0.0f, false, false, 1.52f, -1.52f)
                lineTo(488.748f, 233.851f)
                close()
            }
            path(
                fill = SolidColor(Color(0xFF3f3d56)),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(526.73f, 245.849f)
                lineTo(399.181f, 245.849f)
                arcToRelative(2.346f, 2.346f, 0.0f, false, true, -2.296f, -2.83f)
                lineToRelative(1.979f, -9.4f)
                arcToRelative(2.356f, 2.356f, 0.0f, false, true, 2.296f, -1.863f)
                lineTo(524.752f, 231.757f)
                arcToRelative(2.356f, 2.356f, 0.0f, false, true, 2.296f, 1.863f)
                lineToRelative(1.979f, 9.4f)
                arcToRelative(2.346f, 2.346f, 0.0f, false, true, -2.296f, 2.83f)
                close()
            }
            path(
                fill = SolidColor(MaterialTheme.colorScheme.surfaceContainer),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(402.554f, 233.45f)
                lineTo(405.506f, 233.45f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 405.994f, 233.938f)
                lineTo(405.994f, 235.318f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 405.506f, 235.807f)
                lineTo(402.554f, 235.807f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 402.066f, 235.318f)
                lineTo(402.066f, 233.938f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 402.554f, 233.45f)
                close()
            }
            path(
                fill = SolidColor(MaterialTheme.colorScheme.surfaceContainer),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(410.411f, 233.45f)
                lineTo(413.363f, 233.45f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 413.851f, 233.938f)
                lineTo(413.851f, 235.318f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 413.363f, 235.807f)
                lineTo(410.411f, 235.807f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 409.923f, 235.318f)
                lineTo(409.923f, 233.938f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 410.411f, 233.45f)
                close()
            }
            path(
                fill = SolidColor(MaterialTheme.colorScheme.surfaceContainer),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(418.268f, 233.45f)
                lineTo(421.22f, 233.45f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 421.708f, 233.938f)
                lineTo(421.708f, 235.318f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 421.22f, 235.807f)
                lineTo(418.268f, 235.807f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 417.779f, 235.318f)
                lineTo(417.779f, 233.938f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 418.268f, 233.45f)
                close()
            }
            path(
                fill = SolidColor(MaterialTheme.colorScheme.surfaceContainer),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(426.124f, 233.45f)
                lineTo(429.076f, 233.45f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 429.565f, 233.938f)
                lineTo(429.565f, 235.318f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 429.076f, 235.807f)
                lineTo(426.124f, 235.807f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 425.636f, 235.318f)
                lineTo(425.636f, 233.938f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 426.124f, 233.45f)
                close()
            }
            path(
                fill = SolidColor(MaterialTheme.colorScheme.surfaceContainer),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(433.981f, 233.45f)
                lineTo(436.933f, 233.45f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 437.421f, 233.938f)
                lineTo(437.421f, 235.318f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 436.933f, 235.807f)
                lineTo(433.981f, 235.807f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 433.493f, 235.318f)
                lineTo(433.493f, 233.938f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 433.981f, 233.45f)
                close()
            }
            path(
                fill = SolidColor(MaterialTheme.colorScheme.surfaceContainer),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(441.838f, 233.45f)
                lineTo(444.79f, 233.45f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 445.278f, 233.938f)
                lineTo(445.278f, 235.318f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 444.79f, 235.807f)
                lineTo(441.838f, 235.807f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 441.35f, 235.318f)
                lineTo(441.35f, 233.938f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 441.838f, 233.45f)
                close()
            }
            path(
                fill = SolidColor(MaterialTheme.colorScheme.surfaceContainer),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(449.695f, 233.45f)
                lineTo(452.647f, 233.45f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 453.135f, 233.938f)
                lineTo(453.135f, 235.318f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 452.647f, 235.807f)
                lineTo(449.695f, 235.807f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 449.207f, 235.318f)
                lineTo(449.207f, 233.938f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 449.695f, 233.45f)
                close()
            }
            path(
                fill = SolidColor(MaterialTheme.colorScheme.surfaceContainer),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(457.551f, 233.45f)
                lineTo(460.503f, 233.45f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 460.992f, 233.938f)
                lineTo(460.992f, 235.318f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 460.503f, 235.807f)
                lineTo(457.551f, 235.807f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 457.063f, 235.318f)
                lineTo(457.063f, 233.938f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 457.551f, 233.45f)
                close()
            }
            path(
                fill = SolidColor(MaterialTheme.colorScheme.surfaceContainer),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(465.408f, 233.45f)
                lineTo(468.36f, 233.45f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 468.848f, 233.938f)
                lineTo(468.848f, 235.318f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 468.36f, 235.807f)
                lineTo(465.408f, 235.807f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 464.92f, 235.318f)
                lineTo(464.92f, 233.938f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 465.408f, 233.45f)
                close()
            }
            path(
                fill = SolidColor(MaterialTheme.colorScheme.surfaceContainer),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(473.265f, 233.45f)
                lineTo(476.217f, 233.45f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 476.705f, 233.938f)
                lineTo(476.705f, 235.318f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 476.217f, 235.807f)
                lineTo(473.265f, 235.807f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 472.777f, 235.318f)
                lineTo(472.777f, 233.938f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 473.265f, 233.45f)
                close()
            }
            path(
                fill = SolidColor(MaterialTheme.colorScheme.surfaceContainer),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(481.122f, 233.45f)
                lineTo(484.074f, 233.45f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 484.562f, 233.938f)
                lineTo(484.562f, 235.318f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 484.074f, 235.807f)
                lineTo(481.122f, 235.807f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 480.634f, 235.318f)
                lineTo(480.634f, 233.938f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 481.122f, 233.45f)
                close()
            }
            path(
                fill = SolidColor(MaterialTheme.colorScheme.surfaceContainer),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(488.979f, 233.45f)
                lineTo(491.931f, 233.45f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 492.419f, 233.938f)
                lineTo(492.419f, 235.318f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 491.931f, 235.807f)
                lineTo(488.979f, 235.807f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 488.49f, 235.318f)
                lineTo(488.49f, 233.938f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 488.979f, 233.45f)
                close()
            }
            path(
                fill = SolidColor(MaterialTheme.colorScheme.surfaceContainer),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(496.835f, 233.45f)
                lineTo(499.787f, 233.45f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 500.275f, 233.938f)
                lineTo(500.275f, 235.318f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 499.787f, 235.807f)
                lineTo(496.835f, 235.807f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 496.347f, 235.318f)
                lineTo(496.347f, 233.938f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 496.835f, 233.45f)
                close()
            }
            path(
                fill = SolidColor(MaterialTheme.colorScheme.surfaceContainer),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(504.692f, 233.45f)
                lineTo(507.644f, 233.45f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 508.132f, 233.938f)
                lineTo(508.132f, 235.318f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 507.644f, 235.807f)
                lineTo(504.692f, 235.807f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 504.204f, 235.318f)
                lineTo(504.204f, 233.938f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 504.692f, 233.45f)
                close()
            }
            path(
                fill = SolidColor(MaterialTheme.colorScheme.surfaceContainer),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(512.549f, 233.45f)
                lineTo(515.501f, 233.45f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 515.989f, 233.938f)
                lineTo(515.989f, 235.318f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 515.501f, 235.807f)
                lineTo(512.549f, 235.807f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 512.061f, 235.318f)
                lineTo(512.061f, 233.938f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 512.549f, 233.45f)
                close()
            }
            path(
                fill = SolidColor(MaterialTheme.colorScheme.surfaceContainer),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(520.406f, 233.45f)
                lineTo(523.358f, 233.45f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 523.846f, 233.938f)
                lineTo(523.846f, 235.318f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 523.358f, 235.807f)
                lineTo(520.406f, 235.807f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 519.917f, 235.318f)
                lineTo(519.917f, 233.938f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 520.406f, 233.45f)
                close()
            }
            path(
                fill = SolidColor(MaterialTheme.colorScheme.surfaceContainer),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(402.461f, 237.378f)
                lineTo(405.413f, 237.378f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 405.901f, 237.866f)
                lineTo(405.901f, 239.247f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 405.413f, 239.735f)
                lineTo(402.461f, 239.735f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 401.973f, 239.247f)
                lineTo(401.973f, 237.866f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 402.461f, 237.378f)
                close()
            }
            path(
                fill = SolidColor(MaterialTheme.colorScheme.surfaceContainer),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(410.318f, 237.378f)
                lineTo(413.27f, 237.378f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 413.758f, 237.866f)
                lineTo(413.758f, 239.247f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 413.27f, 239.735f)
                lineTo(410.318f, 239.735f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 409.83f, 239.247f)
                lineTo(409.83f, 237.866f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 410.318f, 237.378f)
                close()
            }
            path(
                fill = SolidColor(MaterialTheme.colorScheme.surfaceContainer),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(418.175f, 237.378f)
                lineTo(421.127f, 237.378f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 421.615f, 237.866f)
                lineTo(421.615f, 239.247f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 421.127f, 239.735f)
                lineTo(418.175f, 239.735f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 417.687f, 239.247f)
                lineTo(417.687f, 237.866f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 418.175f, 237.378f)
                close()
            }
            path(
                fill = SolidColor(MaterialTheme.colorScheme.surfaceContainer),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(426.032f, 237.378f)
                lineTo(428.984f, 237.378f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 429.472f, 237.866f)
                lineTo(429.472f, 239.247f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 428.984f, 239.735f)
                lineTo(426.032f, 239.735f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 425.543f, 239.247f)
                lineTo(425.543f, 237.866f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 426.032f, 237.378f)
                close()
            }
            path(
                fill = SolidColor(MaterialTheme.colorScheme.surfaceContainer),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(433.888f, 237.378f)
                lineTo(436.84f, 237.378f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 437.329f, 237.866f)
                lineTo(437.329f, 239.247f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 436.84f, 239.735f)
                lineTo(433.888f, 239.735f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 433.4f, 239.247f)
                lineTo(433.4f, 237.866f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 433.888f, 237.378f)
                close()
            }
            path(
                fill = SolidColor(MaterialTheme.colorScheme.surfaceContainer),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(441.745f, 237.378f)
                lineTo(444.697f, 237.378f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 445.185f, 237.866f)
                lineTo(445.185f, 239.247f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 444.697f, 239.735f)
                lineTo(441.745f, 239.735f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 441.257f, 239.247f)
                lineTo(441.257f, 237.866f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 441.745f, 237.378f)
                close()
            }
            path(
                fill = SolidColor(MaterialTheme.colorScheme.surfaceContainer),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(449.602f, 237.378f)
                lineTo(452.554f, 237.378f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 453.042f, 237.866f)
                lineTo(453.042f, 239.247f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 452.554f, 239.735f)
                lineTo(449.602f, 239.735f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 449.114f, 239.247f)
                lineTo(449.114f, 237.866f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 449.602f, 237.378f)
                close()
            }
            path(
                fill = SolidColor(MaterialTheme.colorScheme.surfaceContainer),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(457.459f, 237.378f)
                lineTo(460.411f, 237.378f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 460.899f, 237.866f)
                lineTo(460.899f, 239.247f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 460.411f, 239.735f)
                lineTo(457.459f, 239.735f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 456.97f, 239.247f)
                lineTo(456.97f, 237.866f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 457.459f, 237.378f)
                close()
            }
            path(
                fill = SolidColor(MaterialTheme.colorScheme.surfaceContainer),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(465.315f, 237.378f)
                lineTo(468.267f, 237.378f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 468.756f, 237.866f)
                lineTo(468.756f, 239.247f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 468.267f, 239.735f)
                lineTo(465.315f, 239.735f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 464.827f, 239.247f)
                lineTo(464.827f, 237.866f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 465.315f, 237.378f)
                close()
            }
            path(
                fill = SolidColor(MaterialTheme.colorScheme.surfaceContainer),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(473.172f, 237.378f)
                lineTo(476.124f, 237.378f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 476.612f, 237.866f)
                lineTo(476.612f, 239.247f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 476.124f, 239.735f)
                lineTo(473.172f, 239.735f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 472.684f, 239.247f)
                lineTo(472.684f, 237.866f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 473.172f, 237.378f)
                close()
            }
            path(
                fill = SolidColor(MaterialTheme.colorScheme.surfaceContainer),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(481.029f, 237.378f)
                lineTo(483.981f, 237.378f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 484.469f, 237.866f)
                lineTo(484.469f, 239.247f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 483.981f, 239.735f)
                lineTo(481.029f, 239.735f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 480.541f, 239.247f)
                lineTo(480.541f, 237.866f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 481.029f, 237.378f)
                close()
            }
            path(
                fill = SolidColor(MaterialTheme.colorScheme.surfaceContainer),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(488.886f, 237.378f)
                lineTo(491.838f, 237.378f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 492.326f, 237.866f)
                lineTo(492.326f, 239.247f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 491.838f, 239.735f)
                lineTo(488.886f, 239.735f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 488.398f, 239.247f)
                lineTo(488.398f, 237.866f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 488.886f, 237.378f)
                close()
            }
            path(
                fill = SolidColor(MaterialTheme.colorScheme.surfaceContainer),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(496.742f, 237.378f)
                lineTo(499.694f, 237.378f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 500.183f, 237.866f)
                lineTo(500.183f, 239.247f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 499.694f, 239.735f)
                lineTo(496.742f, 239.735f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 496.254f, 239.247f)
                lineTo(496.254f, 237.866f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 496.742f, 237.378f)
                close()
            }
            path(
                fill = SolidColor(MaterialTheme.colorScheme.surfaceContainer),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(504.599f, 237.378f)
                lineTo(507.551f, 237.378f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 508.039f, 237.866f)
                lineTo(508.039f, 239.247f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 507.551f, 239.735f)
                lineTo(504.599f, 239.735f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 504.111f, 239.247f)
                lineTo(504.111f, 237.866f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 504.599f, 237.378f)
                close()
            }
            path(
                fill = SolidColor(MaterialTheme.colorScheme.surfaceContainer),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(512.456f, 237.378f)
                lineTo(515.408f, 237.378f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 515.896f, 237.866f)
                lineTo(515.896f, 239.247f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 515.408f, 239.735f)
                lineTo(512.456f, 239.735f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 511.968f, 239.247f)
                lineTo(511.968f, 237.866f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 512.456f, 237.378f)
                close()
            }
            path(
                fill = SolidColor(MaterialTheme.colorScheme.surfaceContainer),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(520.313f, 237.378f)
                lineTo(523.265f, 237.378f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 523.753f, 237.866f)
                lineTo(523.753f, 239.247f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 523.265f, 239.735f)
                lineTo(520.313f, 239.735f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 519.825f, 239.247f)
                lineTo(519.825f, 237.866f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 520.313f, 237.378f)
                close()
            }
            path(
                fill = SolidColor(MaterialTheme.colorScheme.surfaceContainer),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(440.174f, 242.092f)
                lineTo(470.624f, 242.092f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 471.113f, 242.58f)
                lineTo(471.113f, 243.961f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 470.624f, 244.449f)
                lineTo(440.174f, 244.449f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 439.686f, 243.961f)
                lineTo(439.686f, 242.58f)
                arcTo(0.488f, 0.488f, 0.0f, false, true, 440.174f, 242.092f)
                close()
            }
            path(
                fill = SolidColor(MaterialTheme.colorScheme.surfaceContainer),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(536.523f, 68.508f)
                verticalLineToRelative(75.52f)
                arcToRelative(19.073f, 19.073f, 0.0f, false, true, -19.07f, 19.07f)
                horizontalLineToRelative(-94.52f)
                arcToRelative(19.081f, 19.081f, 0.0f, false, true, -17.51f, -11.49f)
                arcToRelative(17.984f, 17.984f, 0.0f, false, true, -1.13f, -3.51f)
                arcToRelative(17.367f, 17.367f, 0.0f, false, false, 6.3f, 1.17f)
                horizontalLineToRelative(94.52f)
                arcToRelative(17.605f, 17.605f, 0.0f, false, false, 17.58f, -17.58f)
                verticalLineToRelative(-75.52f)
                arcToRelative(17.368f, 17.368f, 0.0f, false, false, -1.17f, -6.3f)
                arcToRelative(17.988f, 17.988f, 0.0f, false, true, 3.51f, 1.13f)
                arcTo(19.081f, 19.081f, 0.0f, false, true, 536.523f, 68.508f)
                close()
            }
            path(
                fill = SolidColor(Color(0xFFffb6b6)),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(183.897f, 368.973f)
                lineToRelative(-9.375f, 5.805f)
                lineToRelative(-27.619f, -33.95f)
                lineToRelative(13.836f, -8.566f)
                lineToRelative(23.158f, 36.711f)
                close()
            }
            path(
                fill = SolidColor(Color(0xFF2f2e41)),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(191.991f, 381.099f)
                lineToRelative(-7.541f, 3.367f)
                lineToRelative(-4.524f, -6.519f)
                lineToRelative(-0.269f, 8.659f)
                lineToRelative(-20.001f, 8.929f)
                arcToRelative(4.924f, 4.924f, 0.0f, false, true, -6.214f, -7.056f)
                lineToRelative(11.048f, -18.162f)
                lineToRelative(-3.213f, -7.198f)
                lineToRelative(17.248f, -6.497f)
                close()
            }
            path(
                fill = SolidColor(Color(0xFF2f2e41)),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(157.635f, 362.442f)
                lineToRelative(15.834f, -15.344f)
                curveToRelative(-11.764f, -29.029f, -12.704f, -47.022f, -29.012f, -82.131f)
                curveToRelative(38.693f, 7.914f, 66.356f, 7.433f, 98.356f, 0.337f)
                curveToRelative(10.833f, -2.365f, 38.786f, -23.956f, 36.487f, -35.027f)
                quadToRelative(-0.161f, -0.776f, -0.381f, -1.538f)
                curveToRelative(-3.435f, -11.711f, -1.016f, -29.646f, -8.451f, -42.642f)
                curveToRelative(-13.755f, -5.186f, -34.653f, 12.326f, -51.0f, 23.0f)
                curveToRelative(-7.883f, 5.147f, -2.112f, 12.161f, -8.0f, 14.0f)
                lineToRelative(-22.569f, 7.326f)
                lineToRelative(-55.373f, -8.943f)
                arcToRelative(20.511f, 20.511f, 0.0f, false, false, -23.376f, 17.359f)
                quadToRelative(-0.141f, 0.902f, -0.204f, 1.813f)
                curveToRelative(2.548f, 14.103f, 5.204f, 27.837f, 8.063f, 40.873f)
                curveToRelative(0.923f, 4.208f, -0.635f, 12.275f, 2.836f, 12.395f)
                reflectiveCurveToRelative(2.073f, 8.464f, 3.154f, 12.543f)
                curveTo(130.654f, 331.579f, 134.863f, 343.733f, 157.635f, 362.442f)
                close()
            }
            path(
                fill = SolidColor(Color(0xFFffb6b6)),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(127.329f, 429.745f)
                lineToRelative(-9.767f, -5.098f)
                lineToRelative(15.453f, -40.936f)
                lineToRelative(14.415f, 7.524f)
                lineToRelative(-20.101f, 38.51f)
                close()
            }
            path(
                fill = SolidColor(Color(0xFF2f2e41)),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(125.701f, 399.184f)
                lineToRelative(15.661f, 10.783f)
                curveToRelative(19.195f, -27.76f, 31.658f, -64.854f, 40.939f, -106.36f)
                curveToRelative(36.139f, -15.765f, 67.761f, -33.801f, 89.796f, -57.993f)
                arcToRelative(20.915f, 20.915f, 0.0f, false, false, -1.209f, -29.095f)
                quadToRelative(-0.578f, -0.542f, -1.196f, -1.039f)
                curveToRelative(-9.545f, -7.603f, -30.743f, -3.228f, -44.292f, -9.583f)
                lineToRelative(-24.204f, 33.5f)
                lineToRelative(2.782f, 7.803f)
                lineToRelative(-8.42f, 4.099f)
                lineToRelative(-7.109f, 3.461f)
                lineToRelative(-8.138f, 3.962f)
                lineTo(153.633f, 271.708f)
                arcToRelative(20.484f, 20.484f, 0.0f, false, false, -9.089f, 27.629f)
                quadToRelative(0.404f, 0.818f, 0.878f, 1.6f)
                lineToRelative(-9.908f, 49.36f)
                reflectiveCurveToRelative(2.726f, 8.593f, -1.563f, 7.789f)
                reflectiveCurveToRelative(-1.952f, 9.725f, -1.952f, 9.725f)
                close()
            }
            path(
                fill = SolidColor(Color(0xFF2f2e41)),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(121.414f, 452.305f)
                lineToRelative(-7.321f, -3.821f)
                lineToRelative(2.301f, -7.594f)
                lineToRelative(-6.955f, 5.165f)
                lineToRelative(-19.418f, -10.135f)
                arcToRelative(4.924f, 4.924f, 0.0f, false, true, 1.673f, -9.252f)
                lineToRelative(21.096f, -2.616f)
                lineToRelative(3.647f, -6.988f)
                lineToRelative(15.802f, 9.486f)
                close()
            }
            path(
                fill = SolidColor(Color(0xFFffb6b6)),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(334.892f, 237.703f)
                lineToRelative(-11.423f, -27.606f)
                lineToRelative(-9.0f, 5.0f)
                lineToRelative(5.435f, 28.082f)
                arcToRelative(10.001f, 10.001f, 0.0f, true, false, 14.988f, -5.476f)
                close()
            }
            path(
                fill = SolidColor(Color(0xFFffb6b6)),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(143.208f, 19.407f)
                lineToRelative(17.381f, 24.3f)
                lineToRelative(7.633f, -6.909f)
                lineTo(156.565f, 10.677f)
                arcToRelative(10.001f, 10.001f, 0.0f, true, false, -13.357f, 8.73f)
                close()
            }
            path(
                fill = SolidColor(FixedAccentColors.tertiaryFixedDim),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(221.697f, 173.421f)
                curveToRelative(-11.274f, 17.486f, 30.028f, 55.586f, 51.772f, 46.677f)
                curveToRelative(3.807f, -1.56f, 16.904f, -6.713f, 7.952f, -13.856f)
                reflectiveCurveToRelative(1.038f, 0.851f, 1.274f, -3.799f)
                curveToRelative(0.158f, -3.109f, -2.249f, -9.929f, 0.262f, -9.637f)
                reflectiveCurveToRelative(3.953f, -6.971f, -1.517f, -8.822f)
                arcToRelative(10.618f, 10.618f, 0.0f, false, true, -7.0f, -9.0f)
                curveToRelative(-0.523f, -19.167f, 5.968f, -39.177f, 5.968f, -39.177f)
                lineToRelative(26.498f, 67.735f)
                reflectiveCurveToRelative(-0.196f, 11.719f, 3.183f, 8.137f)
                reflectiveCurveToRelative(3.133f, 8.009f, 3.133f, 8.009f)
                reflectiveCurveToRelative(5.025f, 3.507f, 2.135f, 5.458f)
                reflectiveCurveToRelative(3.111f, 7.952f, 3.111f, 7.952f)
                lineToRelative(14.0f, -1.0f)
                reflectiveCurveToRelative(-0.219f, -10.4f, -2.61f, -12.7f)
                reflectiveCurveToRelative(-1.216f, -5.919f, -1.216f, -5.919f)
                reflectiveCurveToRelative(-4.928f, -4.584f, -2.051f, -9.983f)
                reflectiveCurveToRelative(-20.951f, -101.961f, -20.951f, -101.961f)
                arcToRelative(25.72f, 25.72f, 0.0f, false, false, -18.366f, -19.62f)
                lineToRelative(-15.121f, -4.163f)
                lineToRelative(-2.685f, -10.653f)
                lineTo(248.177f, 67.098f)
                lineToRelative(-3.709f, 7.0f)
                lineToRelative(-34.0f, -3.0f)
                reflectiveCurveToRelative(-33.643f, -30.61f, -32.0f, -33.0f)
                reflectiveCurveToRelative(-3.573f, -7.986f, -3.573f, -7.986f)
                reflectiveCurveToRelative(-4.454f, -1.458f, -1.941f, -2.236f)
                reflectiveCurveToRelative(-2.237f, -2.578f, -2.237f, -2.578f)
                reflectiveCurveToRelative(-4.4f, -1.156f, -2.325f, -2.678f)
                reflectiveCurveToRelative(-6.925f, -2.522f, -6.925f, -2.522f)
                lineToRelative(-11.677f, 9.528f)
                lineToRelative(2.36f, 4.002f)
                reflectiveCurveToRelative(-1.439f, 5.449f, 0.439f, 3.46f)
                reflectiveCurveToRelative(2.232f, 3.784f, 2.232f, 3.784f)
                reflectiveCurveToRelative(0.959f, 6.322f, 6.646f, 8.227f)
                reflectiveCurveToRelative(10.0f, 20.0f, 10.0f, 20.0f)
                lineToRelative(48.0f, 40.0f)
                curveToRelative(-7.311f, 8.391f, -5.57f, 17.166f, 0.906f, 26.142f)
                close()
            }
            path(
                fill = SolidColor(Color(0xFFffb6b6)),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(258.343f, 36.964f)
                moveToRelative(-23.056f, 0.0f)
                arcToRelative(23.056f, 23.056f, 0.0f, true, true, 46.111f, 0.0f)
                arcToRelative(23.056f, 23.056f, 0.0f, true, true, -46.111f, 0.0f)
            }
            path(
                fill = SolidColor(Color(0xFF2f2e41)),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(278.469f, 30.098f)
                curveToRelative(-0.59f, 0.17f, -9.25f, 1.3f, -13.0f, 2.0f)
                curveToRelative(-3.68f, 0.69f, -4.32f, -4.0f, -7.33f, -3.12f)
                arcToRelative(0.127f, 0.127f, 0.0f, false, false, -0.01f, -0.06f)
                arcToRelative(28.344f, 28.344f, 0.0f, false, false, -2.37f, -7.17f)
                arcToRelative(21.178f, 21.178f, 0.0f, false, true, 0.17f, 6.6f)
                arcToRelative(0.984f, 0.984f, 0.0f, false, true, -0.02f, 0.17f)
                curveToRelative(-0.01f, 0.1f, -0.03f, 0.19f, -0.04f, 0.29f)
                curveToRelative(-3.18f, -1.4f, -5.2f, -0.15f, -7.4f, 0.29f)
                curveToRelative(-2.46f, 0.49f, -4.38f, 1.57f, -3.0f, 10.0f)
                curveToRelative(2.83f, 17.34f, 17.55f, 23.53f, 15.0f, 35.0f)
                curveToRelative(-0.5f, 2.27f, -1.76f, 5.11f, -3.34f, 5.82f)
                arcToRelative(28.344f, 28.344f, 0.0f, false, false, -2.37f, -7.17f)
                arcToRelative(21.178f, 21.178f, 0.0f, false, true, 0.17f, 6.6f)
                curveToRelative(-2.45f, -2.65f, -4.22f, -11.91f, -12.46f, -19.25f)
                curveToRelative(-2.03f, -1.8f, -12.2f, -12.48f, -13.42f, -15.0f)
                arcToRelative(32.136f, 32.136f, 0.0f, false, true, 0.54f, 6.11f)
                arcToRelative(29.416f, 29.416f, 0.0f, false, true, -0.28f, 4.1f)
                arcToRelative(1.151f, 1.151f, 0.0f, false, true, -0.03f, 0.26f)
                curveToRelative(-0.01f, 0.16f, -0.04f, 0.3f, -0.06f, 0.45f)
                curveToRelative(-0.02f, 0.17f, -0.05f, 0.33f, -0.08f, 0.5f)
                curveToRelative(-3.33f, -0.48f, -6.28f, -1.06f, -7.67f, -2.42f)
                curveToRelative(-6.76f, -6.58f, 1.49f, -19.4f, 6.0f, -31.0f)
                curveToRelative(6.45f, -16.61f, 25.18f, -18.82f, 27.0f, -19.0f)
                curveToRelative(8.02f, -0.81f, 21.57f, 0.91f, 26.0f, 10.0f)
                curveTo(283.569f, 20.468f, 281.589f, 29.198f, 278.469f, 30.098f)
                close()
            }
            path(
                fill = SolidColor(Color(0xFF2f2e41)),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(229.854f, 33.847f)
                lineToRelative(16.701f, -25.98f)
                arcToRelative(25.612f, 25.612f, 0.0f, false, false, -13.188f, -3.46f)
                arcToRelative(16.419f, 16.419f, 0.0f, false, false, -12.109f, 5.711f)
                curveToRelative(-3.411f, 4.239f, -3.996f, 10.232f, -2.718f, 15.521f)
                curveTo(218.981f, 27.466f, 227.385f, 21.039f, 225.385f, 24.039f)
                curveToRelative(-1.642f, 2.349f, -4.327f, 12.222f, -5.0f, 15.0f)
                curveToRelative(-1.084f, 4.472f, -4.063f, 9.062f, -1.409f, 12.821f)
                curveToRelative(3.139f, 4.444f, 8.74f, 6.654f, 14.177f, 6.878f)
                reflectiveCurveToRelative(10.788f, -1.282f, 15.954f, -2.989f)
                close()
            }
            path(
                fill = SolidColor(MaterialTheme.colorScheme.inversePrimary),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(236.271f, 32.822f)
                arcToRelative(1.0f, 1.0f, 0.0f, false, true, -0.273f, -1.962f)
                curveToRelative(0.262f, -0.433f, 0.155f, -2.253f, 0.068f, -3.725f)
                curveToRelative(-0.325f, -5.524f, -0.87f, -14.769f, 8.106f, -21.01f)
                arcToRelative(1.0f, 1.0f, 0.0f, false, true, 1.142f, 1.642f)
                curveToRelative(-8.055f, 5.601f, -7.571f, 13.815f, -7.251f, 19.25f)
                curveToRelative(0.183f, 3.107f, 0.315f, 5.352f, -1.57f, 5.779f)
                arcTo(0.994f, 0.994f, 0.0f, false, true, 236.271f, 32.822f)
                close()
            }
            path(
                fill = SolidColor(Color(0xFF000000)),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(0.0f, 451.951f)
                arcToRelative(1.186f, 1.186f, 0.0f, false, false, 1.183f, 1.19f)
                lineTo(716.48f, 453.141f)
                arcToRelative(1.19f, 1.19f, 0.0f, false, false, 0.0f, -2.38f)
                horizontalLineToRelative(-715.29f)
                arcToRelative(1.186f, 1.186f, 0.0f, false, false, -1.19f, 1.183f)
                close()
            }
            path(
                fill = SolidColor(MaterialTheme.colorScheme.inversePrimary),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(442.535f, 94.849f)
                lineTo(427.403f, 94.849f)
                arcToRelative(1.513f, 1.513f, 0.0f, false, true, 0.0f, -3.026f)
                horizontalLineToRelative(15.132f)
                arcToRelative(1.513f, 1.513f, 0.0f, false, true, 0.0f, 3.026f)
                close()
            }
            path(
                fill = SolidColor(MaterialTheme.colorScheme.inversePrimary),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(469.772f, 94.849f)
                lineTo(454.64f, 94.849f)
                arcToRelative(1.513f, 1.513f, 0.0f, true, true, 0.0f, -3.026f)
                horizontalLineToRelative(15.132f)
                arcToRelative(1.513f, 1.513f, 0.0f, true, true, 0.0f, 3.026f)
                close()
            }
            path(
                fill = SolidColor(MaterialTheme.colorScheme.inversePrimary),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(483.391f, 106.955f)
                lineTo(468.259f, 106.955f)
                arcToRelative(1.513f, 1.513f, 0.0f, true, true, 0.0f, -3.026f)
                horizontalLineToRelative(15.132f)
                arcToRelative(1.513f, 1.513f, 0.0f, true, true, 0.0f, 3.026f)
                close()
            }
            path(
                fill = SolidColor(MaterialTheme.colorScheme.inversePrimary),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(456.237f, 106.955f)
                lineTo(427.403f, 106.955f)
                arcToRelative(1.513f, 1.513f, 0.0f, false, true, 0.0f, -3.026f)
                lineTo(456.237f, 103.929f)
                arcToRelative(1.513f, 1.513f, 0.0f, false, true, 0.0f, 3.026f)
                close()
            }
            path(
                fill = SolidColor(MaterialTheme.colorScheme.inversePrimary),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(510.713f, 94.849f)
                lineTo(481.878f, 94.849f)
                arcToRelative(1.513f, 1.513f, 0.0f, false, true, 0.0f, -3.026f)
                horizontalLineToRelative(28.834f)
                arcToRelative(1.513f, 1.513f, 0.0f, true, true, 0.0f, 3.026f)
                close()
            }
            path(
                fill = SolidColor(MaterialTheme.colorScheme.inversePrimary),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(452.895f, 71.925f)
                lineTo(424.06f, 71.925f)
                arcToRelative(1.513f, 1.513f, 0.0f, true, true, 0.0f, -3.026f)
                horizontalLineToRelative(28.834f)
                arcToRelative(1.513f, 1.513f, 0.0f, true, true, 0.0f, 3.026f)
                close()
            }
            path(
                fill = SolidColor(MaterialTheme.colorScheme.inversePrimary),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(455.265f, 80.766f)
                arcToRelative(1.355f, 1.355f, 0.0f, false, true, -0.832f, -2.425f)
                lineToRelative(7.383f, -5.739f)
                arcToRelative(2.714f, 2.714f, 0.0f, false, false, 0.328f, -3.984f)
                lineToRelative(-6.199f, -6.711f)
                arcToRelative(1.355f, 1.355f, 0.0f, true, true, 1.99f, -1.839f)
                lineToRelative(9.205f, 9.965f)
                arcToRelative(1.355f, 1.355f, 0.0f, false, true, -0.163f, 1.99f)
                lineToRelative(-10.881f, 8.458f)
                arcTo(1.351f, 1.351f, 0.0f, false, true, 455.265f, 80.766f)
                close()
            }
            path(
                fill = SolidColor(MaterialTheme.colorScheme.inversePrimary),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(422.601f, 80.766f)
                arcToRelative(1.355f, 1.355f, 0.0f, false, false, 0.832f, -2.425f)
                lineToRelative(-7.383f, -5.739f)
                arcToRelative(2.714f, 2.714f, 0.0f, false, true, -0.328f, -3.984f)
                lineToRelative(6.199f, -6.711f)
                arcToRelative(1.355f, 1.355f, 0.0f, false, false, -1.99f, -1.839f)
                lineToRelative(-9.205f, 9.965f)
                arcToRelative(1.355f, 1.355f, 0.0f, false, false, 0.163f, 1.99f)
                lineToRelative(10.881f, 8.458f)
                arcTo(1.351f, 1.351f, 0.0f, false, false, 422.601f, 80.766f)
                close()
            }
            path(
                fill = SolidColor(MaterialTheme.colorScheme.inversePrimary),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(467.801f, 132.906f)
                lineTo(438.966f, 132.906f)
                arcToRelative(1.513f, 1.513f, 0.0f, false, true, 0.0f, -3.026f)
                horizontalLineToRelative(28.834f)
                arcToRelative(1.513f, 1.513f, 0.0f, false, true, 0.0f, 3.026f)
                close()
            }
            path(
                fill = SolidColor(MaterialTheme.colorScheme.inversePrimary),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(472.882f, 140.391f)
                arcToRelative(1.355f, 1.355f, 0.0f, false, true, -0.832f, -2.425f)
                lineToRelative(7.383f, -5.739f)
                arcToRelative(2.714f, 2.714f, 0.0f, false, false, 0.328f, -3.984f)
                lineToRelative(-6.199f, -6.711f)
                arcToRelative(1.355f, 1.355f, 0.0f, false, true, 1.99f, -1.839f)
                lineToRelative(9.205f, 9.965f)
                arcToRelative(1.355f, 1.355f, 0.0f, false, true, -0.163f, 1.99f)
                lineToRelative(-10.881f, 8.458f)
                arcTo(1.351f, 1.351f, 0.0f, false, true, 472.882f, 140.391f)
                close()
            }
            path(
                fill = SolidColor(MaterialTheme.colorScheme.inversePrimary),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(422.601f, 140.391f)
                arcToRelative(1.355f, 1.355f, 0.0f, false, false, 0.832f, -2.425f)
                lineToRelative(-7.383f, -5.739f)
                arcToRelative(2.714f, 2.714f, 0.0f, false, true, -0.328f, -3.984f)
                lineToRelative(6.199f, -6.711f)
                arcToRelative(1.355f, 1.355f, 0.0f, true, false, -1.99f, -1.839f)
                lineToRelative(-9.205f, 9.965f)
                arcToRelative(1.355f, 1.355f, 0.0f, false, false, 0.163f, 1.99f)
                lineToRelative(10.881f, 8.458f)
                arcTo(1.351f, 1.351f, 0.0f, false, false, 422.601f, 140.391f)
                close()
            }
            path(
                fill = SolidColor(MaterialTheme.colorScheme.inversePrimary),
                stroke = null,
                strokeLineWidth = 0.0f,
                strokeLineCap = Butt,
                strokeLineJoin = Miter,
                strokeLineMiter = 4.0f,
                pathFillType = NonZero,
            ) {
                moveTo(425.174f, 136.151f)
                lineToRelative(6.061f, -13.865f)
                arcToRelative(1.513f, 1.513f, 0.0f, false, true, 2.773f, 1.212f)
                lineToRelative(-6.061f, 13.865f)
                arcToRelative(1.513f, 1.513f, 0.0f, true, true, -2.773f, -1.212f)
                close()
            }
        }
        .build()
}
