


module.exports = {
  mode: "jit",
  content: ["**/*.{html, js}", "**/**/*.{html, js}", "./index.html"],
  darkMode: "class",
  theme: {
    screens: { md: { max: "900px" }, sm: { max: "550px" } },
    extend: {
      colors: {
        white: { A700: "#ffffff" },
        light_blue: { 900: "#0a549c" },
        black: { 900: "#000001", "900_01": "#000000" },
        gray: { 700: "#676767", "500_01": "#a9a8a8" },
        blue_gray: { 100: "#d9d9d9" },
        green: { 400: "#4cca79" },

        primary: {
          50: "#eff6ff",
          100: "#dbeafe",
          200: "#bfdbfe",
          300: "#93c5fd",
          400: "#60a5fa",
          500: "#3b82f6",
          600: "#2563eb",
          700: "#1d4ed8",
          800: "#1e40af",
          900: "#1e3a8a",
          950: "#172554",
        },
      },
      boxShadow: {},
      fontFamily: {
        button: ["Arial", "sans-serif"],
        body: [
          "Inter",
          "ui-sans-serif",
          "system-ui",
          "-apple-system",
          "system-ui",
          "Segoe UI",
          "Roboto",
          "Helvetica Neue",
          "Arial",
          "Noto Sans",
          "sans-serif",
          "Apple Color Emoji",
          "Segoe UI Emoji",
          "Segoe UI Symbol",
          "Noto Color Emoji",
        ],
        sans: [
          "Inter",
          "ui-sans-serif",
          "system-ui",
          "-apple-system",
          "system-ui",
          "Segoe UI",
          "Roboto",
          "Helvetica Neue",
          "Arial",
          "Noto Sans",
          "sans-serif",
          "Apple Color Emoji",
          "Segoe UI Emoji",
          "Segoe UI Symbol",
          "Noto Color Emoji",
        ],
        roboto: "Roboto",
      },
    },
  },
  plugins: [require("@tailwindcss/forms")],
};
