/**
 * Licensed to JumpMind Inc under one or more contributor
 * license agreements.  See the NOTICE file distributed
 * with this work for additional information regarding
 * copyright ownership.  JumpMind Inc licenses this file
 * to you under the GNU General Public License, version 3.0 (GPLv3)
 * (the "License"); you may not use this file except in compliance
 * with the License.
 *
 * You should have received a copy of the GNU General Public License,
 * version 3.0 (GPLv3) along with this library; if not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.jumpmind.metl.ui.persist;

import java.util.List;

import org.jumpmind.metl.core.model.FlowName;
import org.jumpmind.metl.core.model.HierarchicalModelName;
import org.jumpmind.metl.core.model.ProjectVersionDepends;
import org.jumpmind.metl.core.model.RelationalModelName;
import org.jumpmind.metl.core.model.ResourceName;

public interface IUICache {
    
    public void init();

    public List<ProjectVersionDepends> findProjectDependencies(String projectVersionId);

    public List<FlowName> findFlowsInProject(String projectVersionId);

    public List<RelationalModelName> findRelationalModelsInProject(String projectVersionId);
    
    public List<HierarchicalModelName> findHierarchicalModelsInProject(String projectVersionId);

    public List<ResourceName> findResourcesInProject(String projectVersionId);

}
