/**
 * Licensed to JumpMind Inc under one or more contributor
 * license agreements.  See the NOTICE file distributed
 * with this work for additional information regarding
 * copyright ownership.  JumpMind Inc licenses this file
 * to you under the GNU General Public License, version 3.0 (GPLv3)
 * (the "License"); you may not use this file except in compliance
 * with the License.
 *
 * You should have received a copy of the GNU General Public License,
 * version 3.0 (GPLv3) along with this library; if not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.jumpmind.metl.ui.common;

import com.vaadin.server.FontAwesome;

final public class Icons {

    private Icons() {
    }
    
    public static final FontAwesome UPDATE = FontAwesome.CLOCK_O;
    
    public static final FontAwesome UPLOAD = FontAwesome.UPLOAD;
    
    public static final FontAwesome REFRESH = FontAwesome.REFRESH;
    
    public static final FontAwesome FOLDER_OPEN = FontAwesome.FOLDER_OPEN;
    
    public static final FontAwesome FOLDER_CLOSED = FontAwesome.FOLDER;

    public static final FontAwesome SEARCH = FontAwesome.SEARCH;
    
    public static final FontAwesome DELETE = FontAwesome.TRASH_O;

    public static final FontAwesome CANCEL = FontAwesome.STOP;
    
    public static final FontAwesome PROJECT = FontAwesome.CUBES;
    
    public static final FontAwesome PROJECT_VERSION = FontAwesome.CUBE;
    
    public static final FontAwesome DEPENDENCY = FontAwesome.HAND_O_RIGHT;
    
    public static final FontAwesome AGENT = FontAwesome.CLOUD;
    
    public static final FontAwesome DEPLOYMENT = FontAwesome.SUITCASE;
    
    public static final FontAwesome GENERAL_RESOURCE = FontAwesome.LINK;
    
    public static final FontAwesome WEB = FontAwesome.GLOBE;

    public static final FontAwesome FLOW = FontAwesome.SHARE_ALT;
    
    public static final FontAwesome MODEL = FontAwesome.SITEMAP;
    
    public static final FontAwesome VERSION = FontAwesome.FILE_TEXT;
    
    public static final FontAwesome DATABASE = FontAwesome.DATABASE;
    
    public static final FontAwesome QUEUE = FontAwesome.BARS;
    
    public static final FontAwesome FILE_SYSTEM = FontAwesome.FILES_O;
    
    public static final FontAwesome RUN = FontAwesome.PLAY;
    
    public static final FontAwesome EXECUTION = FontAwesome.ROCKET;
    
    public static final FontAwesome LOG = FontAwesome.FILE_TEXT_O;

    public static final FontAwesome COMPONENT = FontAwesome.PUZZLE_PIECE;

    public static final FontAwesome USER = FontAwesome.USER;
    
    public static final FontAwesome GROUP = FontAwesome.USERS;
    
    public static final FontAwesome EMAIL = FontAwesome.ENVELOPE_O;
    
    public static final FontAwesome REST = FontAwesome.WRENCH;
    
    public static final FontAwesome SETTINGS = FontAwesome.GEARS;
    
    public static final FontAwesome LOGGING = FontAwesome.PENCIL;
    
    public static final FontAwesome NOTIFICATION = FontAwesome.COMMENT;
    
    public static final FontAwesome LIST = FontAwesome.LIST;
    
    public static final FontAwesome BOOK = FontAwesome.BOOK;
    
    public static final FontAwesome TAG = FontAwesome.TAG;
    
    public static final FontAwesome LOCK = FontAwesome.LOCK;
    
    public static final FontAwesome CLOUD = FontAwesome.CLOUD;
    
}
