# this is part of the DYGtube Downloader project.
#
#
# Copyright ©  2022 - 2024  Juan Bindez  <juanbindez780@gmail.com>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
#  
# repo: https://github.com/juanBindez


"""site to encode images in base64 https://base64.guru/converter/encode/image"""

BANNER_LOGO = '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'
ICON_LOGO = 'iVBORw0KGgoAAAANSUhEUgAAAKoAAACWCAYAAABOzhNUAAAgAElEQVR4Xux9B4BkVZX2qdTVOYdJPTmSQSS6AgYw4CKyJkBQDIthXd1/XQMmVtdd8yqoYFhzYA1rAkUWXSXDwMAgk2NPT3dP51BdXbn+7zvn3Kpm11FRVAwFPfWq6r37bvjud+K9L1IulyPyl9dfeuAx3gORvwD1MT5Cf6me9sBfgPrIgBCfPLj3iOzszJtKuexTS7lMazGfi0akFMmnpqVcLonEoiKloiTqGqVQyEkxn5WG9gX4Ol6M1iQHahrbrm2pbf6IdHXNPrJb/3mf/Reg/uLxj+XGx9dNT468L5eeeXJ+ejyZT80AiGUpF3NSKhQER7iyJBF91zkvehjBP5ESzg3f4pxyVKL4PoL/YgByNBqTaLxGIrGYJBvbyzWtHSPJlq4ranuWfA1XpfEXCv3zRue81v+5A7UuO50+Kzs385bMbGpVpFTsyKWn47MDe6VcKkmpVJZouSiRaFwSDY14j0kkngBrxqSUzwtYVYoA7mQ2J7kyfgO+YmDVMhi1IZKVBI6DAQDaNbACguBclAXYRvAHRCcSKL+2XqKJGonW1Eq0vkVi9c35eGvH7kht4xU1dY0/wCWZP2fU/rkBtXF2evq03MzM+/PpuQ35uXS8XChCUgOMAGQJACOIitmMxOJxMF9UwVnGuwBECixFXNQpLyIjcwV5/5as/LxQoziqkYJkJSara+akFsxKFiW9RiNFWVBTlMZoUY6Mp6UrmpGmcl5iQG5HoijxWEJieg/Vx3ALsi8mBSYG2Tfa2TuYaF/w3HhT2924TeHPDbR/6kCN5tPpY+Zm02/MptPPzM/ONhayWSlDdJPZiCG+FwDSTD4ns5k5KUbLsnNkUEahc07PpQDMqCxuaJHe5mbpbG6XhmSt1Nc2SKQmAfxFJJ8qyl27s/K+uTrZEquVYikigD0KdqWAzIl7lMmmzqId8aLUx0rSEilIA+53Vu2E9MZzcnJtWprxXQtAHcdU0InBecHrUY9osl5ibT35WPuSWxL1zZdKXd3BPxfA/ikCNZLPp0+Ym868e2587Mm59Fy8mAcBuRguY+TzxYLMzqWlf3pMto4ckM0D+2TbaL9MZGYlg98ms7MQ6dBDAQ7gTmrAqs01SWmur5eO2kZ5fPdy2dDVKycuXCPNY0mZ2p6WGyCyr+nokUmcmwWAYVbZTCBFU20lsSp+8QX1AX7higEnQ01cZEm8IAtr8nJUIiMd0bwcF0/hb1qBm6Q+rHou/mJgWEyWaEv3XLmt53PJjoVXorDhP2XQ/ikBNZrJZJ44MzR87dzUxGoALSIFDC5ZDP/lId7HZ2dk08Ae+fHOzbJlaK8Mz04pKMsxIohA4plEFUS+4gginsyoiqXRr1o5EM01kZj01rfLsZFeOWl0oXR3rJT7epbIT9pa5SDYNoNr+VdyQJp1ZHUxfFpZCmCoCiybINbPwDInSXO0JL2xrJxam5Izk9NyQmJGOiN5aQBn+zSQaCwukeZOiSxafVuiq/0FIn+aLPsnAdRsNrs2dWjsO1NDg2uhd0aiCep1GHwgIguRvm90UL774J1y8+775VBqQrIALcFAcoMN5MxnoppgUeZTYBJEOIms6AAjq2mIxI18Umf9ZFGOm2mXM+pOkObVp8qPe3ulrzYmY4mYpFBCAQUQsCVlWquXQ97VD+VJA7CrJMbGRsVUAWpw3AvGPb12Rp5dNy4nxGekBfpuLV1ilBYw8AjYctfSB2s6l5wrtbUH/pQY9o8dqL3jB/q/NN43cHounYoWYanTEIHdLWP5jNx+YLvctOM+2TF8UMbnZmCt06HkUpfeTx7HHTQOCGNOY1c9DtSlbBsuNj409nNdNFeUupGMPC5ytDx16QWyZcky2doalwM1UbV8CMQizqf+WgBgi5wQ1D3NB6D/6QQgNlWnnQdc1RZUbwAgo9IWL8mGRFbOrJ+Q08CytWjJ8dEZaSzl7LqmdpFF636aWLziQpQ4+KcA2D9WoHaPDwy9Z3Jg4JL0+IRa7mTCLPTKvukRuWXvVrlh90bZNzUCFuPIY6houbvOSEAQg9Q/FW0u+hVOPI8iGMclBa2JfAWJgzaQnnpG/Tf1BMCdFcsWZNVYp1zc+VwpLlgjP1jQKNsb4TnARWRV9b4qYDmhAFiCFmBV7dOj2Qpa1wvIpmGy2M+YbfRGsA2oamMiIp3wJjyrZkLOjQ3JqZFxeB5Mly11Li7LglXXJRYsuxwXTv8xA/aPDag9E0OHPjJx4OCzU8MjanZzSDKFvGwbPyjf3HKX3DmwXSbAnoGBqH/qMZkvgMpFd9BFKeYf/hs/0xWlvKmiV1Ea9FX+FrwGJMEAYmdOwcRZNtkgL2g5Xzq7jpevLmyWXQ3m0irphQSq/bFovhOkZFcybhl6Ce+s6oC/ogpyVxG0TqY/6wRC/etjZVmSzMvTakbkr+MjcqpMSBLeDKK51L2sJMvW/Uu8dcG/org/Sn/sHwtQY/B/Pndwy7ZrZkdGmzg4YMpICv7OOw/slG/tuEt+PnoAFnu+ShrOhipNlSQZ6HQRGkS6i/lgwChglTzxzmsc0CaWnV2dmMsorMKmDiljPAdXoSwLh0tg1oulqedEuaGrQbY1RSUfylcrnmxq2qpeS3XTVYA8DTGCVwHsxQaWNRGhwCaoVdnGpKLflz81w/V1Qd2wPCd+SP4qMgbjKwfXRY2UFq7ISM+68+PtXTfZ3f54Xo99oGakd+DAnu+N7dp9ZDGXxdhGo3OICN28f6t87aFbZef4APQ99/+w39XwcapSQAbQBTFuoDWDyJiS48zrKJr1UJnT2coZMOiiJomD8VOxfAg1Y1792cBXBOrbJkrysvIzpK33TPlZT7vc00qdlRGqoFLYfUs0isL1RJERL9pG9cBsLJ5X+U+bHJMc/ghmm0yMjtlE46sWLHtZ04BcHD8gR5fGoBIUJZZMSmHdqfcmFq9/Bk4Z+WOB6mMaqKlU6oyhh7Z9Y+rgYGsMdJEp5CI/279F/mv7Rtl0aC+6HYPrxoxZ6W65K+tRJLrPUtFIF1Ow6J018TUByNNVH+XpBFDwBLjLSAczTIAwsuFeWjZx6rqwHhuY1VjDh66xvLwodoF0Lj5DvtLbLPvqwyWMWDmbqjoBvZL5BKy3GoUVJ5a2x8CL0C6ByetcVWDlyMB0c7E1iGlVWJgAboBL6xm1Q3J5zW45LTouCbi9ygtWF4rLjnltom3xp1HoYz7S9VgFasPEoeEPDDy49cXZmZk4MBrrmxyV99z2Ldl4aI9ZxkFMu39Ts5YUH86SCgAmgLgFTTTN85cqQAI45+meBKTqpQpaAtSQV9FVK985YpW8nP4IIMWYJaCoqkE2hHg+cTAplzRfIg8uP0q+saQOwKKc5+QoIQqliPZEFruX+m9ZbgC9MzvBypbydzKtvajb2iTkTYsIOoA78QElV9oBNxoA+4JEn7wquUeOjk9KHFGGwtITdsZXn/JEnHwolPZYfH/MARVO++XDew58d2T3nvUwSiKT6VTsM5tukh/CBzoDl5MOKEEZjBkV4+ARDpIzKX2jzFgy9c1YVaVhEPkVpsX3NLaUnYLRRD+pqQb6veLe9NHg6zTohhMMqIpXk7imNvjHYL0jRitPGlwi5y9/uXxx7VLZ0sDCjTMTVDEVltYo+9aASnzSO0AjjFxZZdmg25pebZjlMRJmaEABsIVoAqoDO4Ns7eWhD7rKWfm3hp/L82v3S320IMWlJ+bKi499Zryh4cd668fg67EE1MjszMylfQ/u+NDM0EhDAVlJW4b3Jz5z741y3+Ae088wthwEZUmiwhRKQ6j60V0MK8viPBXhfg5FJ3+nd4dikuDwdz1HwV21/qtgdMD6xFAmVjAaaxLJWi8HqXkDrB56SFFOIGFCxKYzcqmcI2t6zpZPLlsoYzGYUgQg/mrBrApy/BkYA/D+NyDNAFNDjv+7Pmx6KlnZ9FW2lSybR+ZXvozoVXDPqW4bkTr8+qyaIXln/f2yLoHoXF1bubDi5OsSi9a+BMVkH2tYfawAtWlob//VQ7v3viCXSkemM6n4p+/6oXwf1nwOlrzqnwqmENI0ILDzQxSJOibdSeZyMpeNinpnvkq0KYBbCZGGlgpSAyojSAoCd/8QMgo6gw2hqQqG6pHGtAFcWoajWMsNlD9vxFlK81xcroi8SH628ji5pa3B7o1iagDapIKbwHagK8JZJ3NradAA/1rQgicrUlV9oBdCr3U258RhOeqrReMKkSRUBc7SMIFsgq2PTcqHGh6QJ9UMQxVISn7hUfcn1p72ZNxi4rEE1scCUBcN7Rv4Tv/Wncfks5lo38Sh2Edv+6bce3C7MQcGqmKlI0xotGHMqNTKdxXzdM9Q7BmAQwg0sK6CTFUDspvH8h38RowGwuBiMq/AfDZ18a+MZNUILBpY1VSICq7VJ0q2VJFs9AczviRn5o6Qs1svkI+tWC4z8bJGrGrxewMiToFRgwBWH6teb56A4NJisfabTaxgyykbK0iNyVm21pVgRWpLjnlZdH1Z8/TVGc3J2xq2yEvr9kk9InWlhUcMRdc9/hTUqu+xAtY/KFBzudwRgzv33zK6v78lm8vJ/+y4N3rNHd+RofSkiVYdAAy2M6lZOOg6BZqLaaJPjSL+RgCH6JIBWcHjHgEFngLcEBh006DbBkDRPaUQcADbgKoDyIAeGNMnTRhwE/fhPFKXAU9VCsvV03KbMnH5x9jz5bblJ8tdrY06IeMwrlqR/kchYAAkME1XNmufHgH7Xuup5xkYleHZHj20fgkROQLWrra+zAOouQgdVXFMNAtCsLn1yNB6ZnIQuusDsrwmK6X25fly74lPird13fZYAOsfCqiRdCr1sgPb931wami0rlDMR79x/82Rz975fUnRYKoAi4AyIOow0IhSxiRkHIT6HYHgxhDdTSEkStUgnO80WGHaeWqBAcwZJkwQRR+NEEWaAdTPUijOv8YHO4jsClU5QJRPXZyrNoFQ70lzy+S8pZfJ1QvAqqgjgdWKBGrmp/KWBkJj0gBcJWUC2KaRARZvqho4mhS3qia4V4E6MMpheXqJqgNR9b/ORaCpemSDP5H9n5wYlqua7pO1iZRgnUypuPbJb4t39b7Pq/EHw+wfAqiJQwcPvW9w94FX5WZnIyNT4/Ev3n29/HDr7TKLhXBmHJEhXWZx+UdgRgWti20FIwFD8e8MyXfVVcP1BLBhvUzLiiB0UAf/pQI8DHIAs37m0JsD3TjJfLYBvAoUva2ByWBu3/FlMDI0B8+B058ir362JH/feJHcuuKJcl890kpQt3roml0JT6xRJiWo3J9KQOp3VYAq7rRm7tLyexmM/TtyqeoxVs58sBegs2YjCYCW97e6RnGTY+IT8sHm++UJtWMSR/5tceER34uvOPGFuJrruf4gr983UBuGB0c/0b9j3wtys3OxHQN7I5/82Tdk44Gfqy5lfk0zZJQ51SpX8wVLQyzjKBg6ahSQTcO5VAcAVHNVWTkVP6kzsQHGkqEjVBGC75H3DmgNmCPMCOzgCfDhccFuxoxDVCV6xewP42gi2MBKADsFE0xMywOrPiVzpKxbdJF8YVGvtj+JOvUmC+quRwTW8wHM0U8RznNM/BvTF1W1sPuo4aRVMjVAAa3/V+ugBpaDVVnZ2TgLVSADLZn9G6ytLuTBXgEX1ivq96BecSkuO/Gu+IrHMZr1BzGyfp9AbR/cP3DTwL7Bo3LpbOz2HfdFP/qjL8hgasTEqIMsLNeo6JxBn1TDiQgzsPJYgcg8TH3374PaoH1u5xHAynTBCiKIVacLAHIdUk9z3ZduHh9V01U5hGYUBUy7JA3cWWXSAOJgmc+/QstECVgOszjdKC9tfYl8YdWJMoIFfrzhytqsNEJfZaiIeQF85/IWXlZRB1yKB5GvjIoPAYiql84HpTbTLjIVIeixVB0M7FznpaqALoIhipG4DdPrBbV75d3NP5cOGHqlnvVjsZWnPw65rr93I+v3AlQ48XsP7Oq/cfzQxJpivhi5Y8fG6Id/8DkZSo3aBObIE1AqnindTaTbBKdLhT0dAIl3ilsAU11S9E+SeR3EqscqYxr4zTNAw8yYucK0OnA80RmnAkG6nghSA3EwRhR7lZcbLm7R29cGpnBahW+VUP0eboSpyovv4umivC5ynuxafY78uLlFcqji0mROFkJX5TVMsckCWQW4MngcrHzVd8mw+C7opkjFtRwC/gTarUwiB7XuOaD3t8mm/7MiVGXxHSdBASBNIyMgLwn1EvCcGlz3puat8ubGbfptqbU3FX/ceetx64H5PfK7Pv59ALW1b8/ALQO7D26grN3Zv0feft2H5MDkkLOiEZ2yZWBN1TONIWmZEox0PZlV74COuw+VTOpWv7JkEPNq3RPUSg52nbNqxfVk+NKXssh8IFa+918Ut2a82DXGWq6AWhnKul5odR7oubpwWq9DPTTBG+9Yy/WU6Q1yXO8L5fPLV8kMgMOVqmuT9LfDQsfNcjgvQ2sdx0y4pkgPC1F4rKxKDOI9H+rE73BSUGeUcRW5XmdvNL9iMkxQAfi5gM6i3prhKi3osJwUzVhJcGXLQ/Kq2p0qpDI9x25rOOr0k3E6stF/P6/fNVAbh/qHf3Rg9+BJ+UIRYzgrn/jeh+Wrd9z78KUgAYAKQmNHZgYRt4xb0z2lHAZwqjHlwOTyC2U/11c1+uKGFcPcqt86u5oq4YCcR3tVgPoRwV4Rlc4+rl8GSW54m6cEhHINhg5VQ7QqCvMBQh3SsV7OF2XFVK28uulS+dqRJ8sOpOIxe//o+pyGVKmPklEJW6oBORwTsBWRT7DjPCZf8ztmaynZusFv0iBkZlk1VGtVb0JVYqjP1XGsZfO+YNY0ggSlEv2uEWkD3366/V7560Q/mB85Ar2P629c+7g1OP33EsX6XQK1dvDg2A19ew6dwXXz5XIxkp68Tj7w7a/ITdvc70fWc7+mhjSdHQ1wAKEypIn8qj6KC0iuysAMDRrLqs5aYVce8ztjQQUrymxONkhDolbqsFZeIzjuY5wtZrE6IC+pQgbAwFp7Dr97xDUEyut1JPGH+5GhqI0oWF2c2ufAzAagSv7rfDJTqWuTIgKg1s+V5LWFC2TTsefInViSTf30cY1wy8OvyaSTHFCTRwUUpLgGi01UFQgRKos+GbgCc4aqchMN85+y3u6H1aiBncuGsS4WWLH2hWt57wyZtVyrKgEvW4nVsZ9s2yQnx0ZUTStueNoHmxYufiNv/7vm1d8VUBMDA2PXHeifeHYea4kohwqzP5Hc2Efk3380KzduI4IIRuqR6AFlUoKPYt5Y0/5czCvoDLDctcQYFJ8ZqdLrycL4Etkdavm7XsrOq8fmDUe19coTuo6QMxYeIQvqW2HFYrOIoHSiaLrF5uC/fWimX7ZPHZSbDj0kfTOHdGlLhXxtXH2QHbjhxwpHqi7ghlowvPykMC+or+ox2gKDKpbOycXlJ0nX6vPkC12L0ZSynNiUQyweySIEKsGJAz3Wz6YGKDBRBkGmuirrR6OLkyfoqMqmNmFMvPOkKpOGKVOJcJGJ3cuh53OCQLLNlpHtVcZmGCinHfsOvK1pq7ysfpeU69vLsXVnvaS2o+uLPo1/Z3j9nQB1fDx15Y4dQ28tamgFFmxmh+QPvRUumQH5xE+T8q0HXHeEy0mBFpz0aqHTJRWYFMCjuFdjKQqsGsD1HIKXeioByzw57GxS5rmqHpTgk6yRE9pXyAuXnSZ/1bVBOuEPVHeXZl4ZqwSdUXtXAUSxWJb+1Lj8aGiz3DBwnzww2SdpJMhUEetik0LecGlGiYrhoFoYMkxF4Hd+s8CmAbuQNMgCl6cXjpInL/gbuWrFkar0HdOQk+44tgzC+XRTmci3Y8pZgg8ZELrlEMO0BDGPQ3xfmRT3oErAd/O9mp7KI6M/5gf45yAJAsB5kuvVWgcw6kypHqmJdJxFZWEkJ//ZfbccHzskpYbuomw45+zGlsaf/M5Qym58tLednJ2dPWfXrvHr07NZpkpge5w+KYy8V6K5B2BElOX7Wxrkoz8hK6CXCFQwiIY1CVIFrgNRs59UHzCmxfJnVQloVDmgA1CxlljKSXQiV5SiiDaI99eteZo8HyBtiSPxw3GibA0gxxqS2OOJOjCu4eBQtCMGXwRwmI5XJDLAdlx79dPhrfLdoftk49RemcAeAOYuNXe6vXhxhajMAJw3DxS8iuOAak48A02UhgxCx8em2uXyrhfLF9afLLtQmfUNeelNoB7KnGZEZXF+nmqA6qT0BJgXgO4rZVafBEzvsyiUAdeYlwLEgao6rgcDwjX+7ppQmLem97o+Q0ZNITDAd6yokVPqZ+WNDZvllPhBSbdsKMaPOm1tSzK593cF1kcVqJjtK3dtObh1emouwUYXC2NSGPuQRGZ/BlBYz964o0s++KOc7lZSRkKG4E8ZkXooQeRiXMGpIpzApYuKRhX+OOBcs+9gLSRxMUGaNKZc0tQh/7j+XDl/4fGSoEuLegJ8lLHmOkm0ILUe53LNv6mutNGNZsJKkDIBiw3QimC64gxi3jNzksHSl4emD8i1+2+W28d2yUQhbW4rBy1tfYUty3TWctK0cQvmt98u5EwrXGD5L0wn5M1NL5afrvsruR3O9WW1RVlVB0iiUgQrQZlDhQlUsmqB7EkVgJ8dTGpIOaiNOW1i6Pc+tXT1QGDV4J4LakRl4hkDhwWG6q3gWMKIyEFnnYXO2oM+rMcQHI+9Bd7deCd2conI3IJTHug9YuVpuNXc7wKsjyZQ63fsGtw2PpZZYuvrsVnY2FVwYHwL0t3FIKb4Xfu75crvY58nMIkwXMiMISz51UiUg0/ZU/VPA6q6ppRRyYJkXXzG5g4Ea7EOIh8gpUjvqmuQDxx3sTyl40gHdEQSTXUS72iUWF2yymo00gIbutUUAKa4ms9A2bzkx2akMJGSDPat+vn0QfnCwVvlx6MPySQB6+xkPkpiVenTJgBngxplRKjxsN5Z76lUaDv/YaO11yeeJ1OYYN+urZXuZFHW11EbJUirrEo2VbJXsYy1VwpcA68ZU9UVrSGaxXsaq4alLSbUdWL5P/a7GV78zhjXMqwqxpoGHWKY80lphHfClnZH5Wn1Y/Kquq0Qaq3l+vWPO7+np+l7oeRHE7CPGlAnJlLv3r5j9C3mlytJbvoGkfGPQ11MoTnQxdQ0jUnfRLP8v2/FZQhsFUG2UBl+QxX5DMwQhNQxA4u6zhklMwKotrseTvTvywBrqQ7nI5GzPlEnbzvyfLmw93RzAmBbnUR3i8TBomp8ee9VmM5dTuxMh1VIO3XABWCx3pgQAGlxYlby47OCrC95YLpPvnTwdrkJgJ0CYHUZNEbc9pZSBCjDBdY2iNoEUUgQHTwGUOuycPyXniwdR14sn2howC6ABTmmMQ8HEfR7ZVVjURpWNO8MvAZOjWBxi0wHqeYHOAubZ8NAWlntqrc1lwbrFwBO34H6ZxWQ7i0I+q+WabnALfCcRFQE4t4YlxiSst/Vfrsci6uLbev7F61Y/YTWVun3mzxqWH1UgIqBO2rrtkMPpOaw3xM7JXULRP4HJFbC+np6o7G+PIaGFgq1yI5qlXffWCd37h4Da6Lra9HVYFQlnYrlTmC6jkpGVYMJ1r56CvyPhhTYVIGK479ecoJ86OhLpA7LL4jU2oWtEkVicjUmP08Y6+F8q9zkYZDkyowqxquaqPU4QAJVID88JaV0Hl6BrNwzuVs+0/dTuX1qj8wUIPWCa0DT+oLPlIBxkCp4Tak1zJQkgW2HLh1dIcc9/gq5qrkVREWgwvJnKNWBSrAy1p93X6r6TtnXQdyjNLqvSNYKbG2S3UOXsuj9gm5qKoDqsX6OAZqAd9ca9V41tsLarKiyaR3+uDKWpMNw6+LYPvlkz8vBFX8jU7kzy/WLV17d2dv1vvY6jVzZbHwUXo8GUOPbdgz1jU1kFqjzObNF8iPvklhusBIrp05WKjWibY0Yr7h8Z3ONfOLmCXQmvILYvQ5xOk0SoXEVAUua4WRgJctGoWPqZmAOVP5exnfleoC/NgJRVCufPfFyOa1jrQIz3lEvyW4MOEHNrnafaTVK70hkcohHm9ijii2lV+O9inpQ6WhnIlrbcCvlDo0BsFkYGAXZOLFfrtr333L7xC6wHK3u6hgpr4YMfN5aMWwzg0ZcBD7cCwZ75eknXCEf6WiXNPpiXV1WOpD1z8STADyCkj5VFfecaAA5QWPhU3oGTKSrJ0DldlXkG3MSoObCUuXDwWyTJri1LEgRdFuWzUnBla21NXWQasxjhdoFoFL9eHvj38vzF/+nzEVPlr2jb5FSctlc1/Llb2hZlPwyRmDqUcCoUcRva/WPj8+8d8fu8Tdow/JTkh99u0TSP1eLli/qp7lSEzqnURmJek3fuMgbvp6W0VnknmJ3j0gyeABwBn2hFPNqMFFXpTeAm+pCzKjFT30VbEpLvwGdBrF/dMdS+drjX4t8Toj52oTULgabYv16BSwhsuRTPLhQK3znAK0CiK4nZzziyTGnRBLolmXBYV8Yn9Y/bis0mUtDHbhTPtb/U5nKc3s0lIOmzYsteB9UGQ0bZgEIeXnmyGJ5ydFvwdaVHbIfTVxaU5DeGmzDTtZzo4kuKhpQ6jt1S5+gDPpngSoAgezMGTKojF3JstYQi+3zQDVYa5OC2MHt5yhju281AU9KDXzSDCkWYPlzEeGz4t+Ut3f+ozQtwncY38HJi2Ri5jxJ9qzd1d7T9MpFHXEmXT8qO7P8VkDFLnorH9x2aHsmW4pRxGcPXQWQfhcg1T08zA1TakDDWjx2r30jkJ7y1v/KyIMH0Qa4YaQO/EAd1XVPZVSKfhf/EbAp8vwUqJrtD+CWaEDVY/Zj17zXrH26vGHNM7HmB7s2dzZJojGpYLeEa7unDZX5PkNo0QDro+gQcjPHBaANbPCQVlP+qlzLskvQXwvDkBAzaeiPBdk01eqNjKoAACAASURBVC//0X+b/PfYNkS7zAi2RBRTN3wfahO6RAKuOaO/UV6z+s3yhRUrZQua2wA23QCDKgGklxTMPJWpfiaKNUmFsRSCFseqr6roVm1CWZXH1Gf54hv3QVBrXpts7Ms/s/LdrYb7Ub0IhhU9DpQwdSABjRYCpFBWpC0yJV9sOE9WLhqQErba1DLyMTk4drmM58/Nti9bcntLS+2VC1qFYLX0hN/i9dsANXLgwPgP+4amn8pIfG76HikNXwGQAnRGTagWkm5LzQaBsGCJFjd+++RPc/LVu5BFDsd2pB7tSOB8inrqq0H8u36qOipdU2pkEbTobAAUo6keg6uOe7Gc13uSxGDdR+EjTQCwETJusL5VxgasGmCpFKjJYB+N/djZfqp9WWUg02kDxKzHTUjygOIXIJmFwTU2jfeUGknbUofk0323y3eHNwvDtJXlIQpc0xejdM5j76zHjSTln5a8Sb66Yr1sRl9QazkKMX8GMDUXNbAbR53HfIc6oYYTyskDzObcd6+A+1NNPyVAzSuhwQHtCk9GYTPpfVDAEtx2bsHDWbw+huBJArq/Jp8jWSUPsP9T7F3ystZrpbyyG5MHG8IXsdUnwhHpuRWyc/gdUt+6KtOyoOOhhd3xy+sTcu9vgVHr699U9KfT+RMf2nHormwOcxyRm+LwlVJO3wnmRNOoj8HfVixDS1FXEOnShjYM8K078vIv351GLBkDUYdravFHNxXBSiblYndlVNvrNOYOf7P60WG1ACJ2yauHlfyZ4/9WntB7hEQBVPpf49gfVc/hkATrviJ/A7O6qHO+DEjWZGeyHwe4YlCZrqtXejIKW1Ih5DAPnM6KKexYPYr84gyMRbD6dgD2I7t/ItePb9VQrYlZM1rIqGUw6oLpvLyt9Q1y5+oT5VYNRpRkLXypbTCs6MKq5KRSFVB29ORqHjsQVSVQgFo+AtlUo1MKbJtmFaNKmdWjWfyNxE7dle8EszMsVbU4Qs5x6KUlTQGskXWyU75c80xpWwpjr7MVIEUgoAhVy5Ni+6ECzGSfWW5atLzQ0Za8bUlX5Hw0+rfSV39ToEZ37hvZOTSSXqGgnPm2lMeuNgZimLJUh5Y26Ay0pBDbYsaHRgdoAnvfv/nrM7J9KAN9Ez82gBeS1FFNL43yHX8U/2TTGJmUIKWLij5UADXalJCerm755plvlOXYlpxhVDW+sAOIRqGCWHelVAWvGhMuitV68qmjbEpWnT+n7PwA08C2CjIn3AqEtSgW7E4oPjVlalqK0wiKwhfL153jffKuXT+Qu6b2kcasv/goIBx3pPLyzobXy9b1p8iP0OYsCl4O3b0XiSBqNKmQUr4z/ZSAwjGNK2VKBaWBkQyrNoMHBhSk4Tdtb9W9Rf2X1bYdBV1FUAY3/ZpLrJPxWjQLvlPoZ1wceEXp7XJp++ckuhogxbgU8s2oB32rMK9APKVyUg5OvlxSsadLx4KeuZ7W8t+1t8Q+z2r+psz6GwF1YiZ97s49E9/JZbE9WXFYyn2vRCunPM8Du3OASY1FLT1PbWiGRI1QLQEFnXLNzSn5yh0wOkCA0ggeSKJzAVoFpxtUMdVboXsquzKtD7oqQQjRX2iOyZLuhXL9OW+X7sY2ZS/eLEZG9ax+Lmwz0W64dTg5O1qFVMIrkzqCOXbuDfATjU9VfTAVgC3TtlDcGvXqVLTJ6qfiMIoIXGkWgYFJuLQA2BQe9XP35F754sA98uORrZKGAVaCItg+m5cra14pzUc9Qd4BKTKMQnogYU6sT6vObyCySJUyqoLJ3FB8WfofAUrjyHa5VkDSI6CTyPMCXGe1PAAHsE6CeW4sNd5st5UowJnAQzRsp+y4nFy8TT7a8DJpXI3PjVBMivWSLUC9g+8MolWxSLVmLr9Udk+8VVoXbCjXNdeOLeuMPAH27Y7fJ1CT2/aMjIyOzzEjDUz6KWD06y7ZmT5Xr2LfAvhhjZMPIkaVkSXuUMJuuXtPTq74z3FEqfA79NRIE6NUuBRuqjiXZmCgaO3z2U5mWMH616gVGBPGVL4V++h3L5Dvn/0O6UJWFIEa4z345AaGZCti/eHdY+Ld2Y9iUzGHujrIKmcrgmkW2r7Q/GSOnErw1SWFYdR8Po5e41d7EQhg2EgKuusEdFgcF6CX/hjG1vu23ygPTA1KUzojbwVQN2x4orw5WSO7MOat6IeT6jPwp1L8G0DVolcXFcSuOvrNCKJFX1kM6CAO+qgaW2pg2Uu/V2Ab2C0fNazNMrHP+xSRQpyIwSUF4wnrEbB9ZUaujV4ij1u4SUpLm3B9UrK5DpyHQQskgLpG8Mek64OTF0gm/iJp6uopLWgvf6mrNfpy3H7e3qC/PmwfMaNmMoUnPLD90E9zkDmR3F6JDP4TegnqB8V7FC4ogJSuC9tCxpjJ1jhxyBkOdfCiZSn4IP/pqxNybx8GkW1thjeQ+ipFPg0pTdszZ38UoOVzl/SBDNyjvwEXNMVkRedi+eY5b5X2OmybilsyFyCa5HmcKK5ZugGnfelsRwqxdVNmidvJ81hVqVIJ1NQBZ+UQQzeD0dSIcLkxrt2jQsCOW4UCy5vLSGlsQiJ4L+MRlBNzU3Ldwfvlqj3/IyfJ0+TFvWfLx/BwtDsQ8amBVDi6NieL8GgfhqXVIa/saMA0F5WxrS4GJJiVJT0VUNUDa0NVjzWQWrK1+VM1JqOMymMDLY0pOvRrkIhC6cj+fEbh2/Lelv8nsbXNCLRgBWu+U/J5qHhso05q/unm7zgsSiq3Sg5M/4M0LDhBWhriueULC09MJBJ8TtYjfj1ioO4/OLG5b2j2KOpY0dFroSJ/xx3xutcHKsjFYQQjRTwjTgSq5ZJaYj4BbGpAGYnKX/zphFx1MwaNhhSt/yaLVClzAqgxOvupBqjV79Y/jauGGom1JGRl2yK57mlXSFstxA+ZkgCH1W+6IjFjgHTU2ruCz78PwFJGDJZ/cEixGEOGQ/n/gLDyhRbroA8gDpjVyWGTQMshMqAOlEYQncNmxGWoBxvH+uRtdz4o3YV10gg99Xo8SzWJTjqirig9Ebq4DKRqDKk4t0wqUwMMZAQqX3QvIZvVGdZ+rwCRJVE1cFWhUqafw+QTTogCxjEKxoxRF4P47yqNymfLz5GVaycl0pOAqlEHW7ELdTFCCPKGD5ZToOr9E9I/dZHMNVwqzY2N5aXdxe+3tcaeoz8+wtcjAup0Nrtq6/bxHdk8VoEXBiU68Gb0CLK9oWhHo/VqFapeij+KYFtSQoASZA6cYGzwe2TT7x1Myd99aQYNYoQKzW2E6GjEoDpYCVQ1psiqwV3FbKhGWKItNbKiZYF89ZwrpB2PZWRnBaBWfKQOV5PDYdabLlll00CzDtTQiap3MlGAlFrtWfO+GdUqeWoyAYXwfNQbMykdz3M+VIomYBAkkNlZiUyOIy91Dv7ltOw7lJWfFRfLZ6NtiFDFZR2WT7fjKX8U/SETn+yqflUdcXPKWxCAlbFsKzOgHMQUDn4cdldRNsXEVP1VmdpEvxpjaqzBLoBzLAZRVwPwvT37Fjl/8X9JfHWz7mOVLXRC5NvTAtivnCic/ExGYim6XTHKTefXyL7sW6Wx/QjpaSnPLV0U3YAT+h4hTh+Ze2rvwOSP+gdTT1HrbvTz2J3u256VX4eqQi9VJqWf0x5OW1mDr2AlaBkSrY45G1bIzcpHbkzJl26b0X2jMFGhnEGVR2hUGVVdUwCmZ1TRqNLPTUmJNydkeetC+erZxqi6KS//kIamWqQzqUOGXWnuJdUlA/jM0leIuXgPkSiLbPHL+UizCaclVMS+0nHVAPPBU4xW5oCdozF/3s/o3qUlvscqg+jYiESnpwGComzPJOX6XLtsKeGxk8zrJwNSLKsuaoZRNdb/cL3T8lM9ouXuNMtb9T/1BlQt/KA6BLdUkZEn3DcGAuJ4HlV8QD4fe540HgkXVEst6tcq+QJ0VNtIYF5D2D5mzmlaN9pInyw8AHOXyVzyYmlvTpaXLyi9qaEh+gG/8NfG6yNh1I6NWw4Nzc7lY+Ucdi0eeCuSTgaQpQSQYj04lUwCUZ3yzqom9i1er5iZ5wXQj/ynOCfb+ufkNZ8fx/JpzEI6/JswM1swFDTeCUoyKBzOqqequwqWKICaaEnK8paF8uVz3iKttdBR2WyuBKDDXxVLi8K4wA24NSs/dHClrwN7Ppz+HqbDKriDGoE6qmegAtsK7sJpJoiD2uDs6gaa1qkCdJ7ECYQss5lpiU7AkwIddg6W9AO5Wvn+HMKTWGSnFr6CzFmUEx1fmRin6Hdm1GMPClD1UfYNXgE3pJRB/Tf+rq4oWjrwlxKkEPm0KWqRzf+e4uvlWct+IqXFeLQ7QqXZQpst+tMJbrNbgalSynieOqpOXvyWzi+Q/tK7pLb5eOluK40sXxjlosBH9JSWXxuoI2Ppd23bP/kWzOpIZPpWSY4jO4p+yzhELlmUa5nUBaUWjRtNxqpKbioGzVrmOxupljQSU3J4tOPHbpyRz92WsswcsmpnHqxqBhXdTfSjUleN08cKVSABsZ9oqZMVTQvli+e8WdqSzCfAXcjmqqNWMVVBi7Kb0ZlKSceOVmneFDePltGhsmwgjTD/9WT70nDruqki8/8CN5RtwK2YY6anuxGiE8LBE0VQIDo1IeXpSSnNZZGoLXIXjJbbcg0yAEucOiiXQ6tTn6BVMW+J1MaU5hVQ9cDLr+ixyqom5sMKAqbwqReA15XgzAajquGL/55Z/IF8oPXVElnTLsWaRs3byGNZivqjtRP1H3tXyaNTRicUrX9WqIhgwIHsK8HGF+ExnVJcubR4Sn0i8YiiVb8uUOM79o73D43NIV42JzVD/ybx0iaACCCN4ZmcwREPwNqTOdyIUngyLQ//uoWsdrZOQt1QR2dgIZ8WlC1v+PKE3N/PhGrM6nYsfGuBioEoTUKDALT8mZhi6kC8OSlJiKEVTQvkCxT9sPrtvpgAdPirNWfAUFQGcYzfKbIMTgahoK0Gkq0C2FQFs+5tMOyKatm2r1NgzYBkK9FAHnwK86eCg7tC0KFcKzuikSbUDupAZBIRrrFRuLOyMlaMy0/zTXJLtl5G8ibeTVcNDOtGVQAhgayAtbi/ErJa+OG6KpOWoXfZOn6ocFRPwKxdxTH5rFwsR2zYI5l2DH25ASBt0PN4joaE1UsQutpByhrRqApBDfw+mT9FRpLvxQOPm2T1ouIH2lricBf9+q9fC6h8hOPmnZNb5uYK0fLk7dIw9e9gN4ip2m4AE+xVAaozKcHpLKqZ+sqe7KxgXHkFldHQkUjcKGMgfrhxRt72rXFJc+00tg6PdCGPFewaI0A11Y+MSobF56ZaADUpK5oJVDiWsXiPLxptKvqp77ID3cUUQGuJJfOQ5cd8s/oFlnB91lEY4GisWAWnBjEUjAbO+b/pT8Fn6/NFJ4EzuaUnO2h5pc2JSuxAb83VEhnsTTaKLfanxtFXJdkL1rsl3ygb8/UyiO1V6HoyP+o8yx/XVgwqMrAKCPpGqz5TE/e+OJBbqkPcR9SKRx/j/IsKX5YrO98qhbWdkothZX+RW/5AT1VjwtxbpjuHlEgDqu6tpWKfE86mSLbUKQfkamBmvSzqKE6vXBTrxg/MBf+1Xr8WUEfG0/+8fd/0W4twUsuhz0pzAS6pZAsYrsOWiWio1JhTN45wxlE+5YYSxi82jBilMECm4+ETV3kWM5Kazcl7vzcu39qIWDlYMdoKRu0gqzJ+bw5/BgICoybAqisVqNBR65qtfDr9XfQrBFx0P1wge98EYiTMKozP36Dr6Y7ADksyqRZQdftX4VqF8Pxo1sPcYjoLvAyXJsbyzkVKnxaTt67zMvWj0y5TpfBY9vIoHiI9M6lPv95XqpX/zjTLrRkwrO4yZ2FUjUIpeI1hdYUqIURQUk2gCqmsaxa+iX6ob9A79YkqkDjryzvlmsQrZNmaQUF2CVQMZMEhps/olBlRRL/1o46hqgBBP1XuNt+qqgM2Aw8VXyLTta/B4+RF1iyOHoEVLdt+LZRyHH+dpJQ9/VND/UPp7jLEfi2ST+rKWzEzGFtHEogvugtRKEut4yCbw1+DqBol8uP/Y1pzuKDLcDkHWHVgIiNv+vKY3NOHgVVdFZlEbYiLUFf1mH8cjKo6anOtrGxZJJ8jUKGjqpeBEVeAXD0AzmI6+BUmtYEP8OIR/Ya2EsBEr7qCAAzb8x/ubh+XcE4gZL1iHiMrG1IUGi2bsaWdbMOhLpzqjPExqgjOKnCVqaoTusLVuJabeUSg05cOHQRgJ5Qpd2DlxA1zHXJTtllGAdgoxG4NMpk0F4quLB5VXFaecaWZVwQrmZT5GVxewoRoPJIdz1S9IvIeeUn3ZyW7sgMldUF3pV7KPFRG8MwgU3AqUxsolf0VrKpfGEh5gjJsEcvOj5GBmqslWdsqRy2Tf4D1/++PJlAjm7aN5qZnYO1n9uL59O9ExGRGovVL0K5a10/JpG7tq8h3oPqo2AC7kHPQ2ACzEfZXxpM6ymDVPPSy+/em5B++OCEjczipGeVi6XgcqkDClzjzPQ6QEqhrWuFzfOqb1epXQOJeBKolFjhSA7IqUDQqNVKbBypnNo5gbmcfXdYSXboAjA6RCMmgU0/ZNQB9HrasNHsFNFa+qoKxYnypvmtMo1VQQgyQ1BtVy3M9eP6gMjWwPAkfNh5ILNk5NULvgDX+sdQi+flcHYwe7MISyYD/4CpihhraYnsABIBSTeBn6qVkUapoBGpEzojcIh9u/Ds8F2ta0u0LkRkFQwq6q+qmqt+bmmFM6ozJmVAR98aoFVZ1sBbKbdIf/zhiQkfIyoXl7y/qij3bT/yVeP2VjIrcn46H7j80kkF6eWLmJ9KS+hBEK4youkWWDE39lLypADXHvgkvz5wyBVVT/3QwnGmtZmQOHxT43hAEhw4GsOYycuP90/Kv35uBAYGyoX7GevA8JjxPNA73FMU/xT6NqTUtS+QzYNQWMKoBlTksvtWP6oeOxYChCgRMVFq3B9Fu3UvD75b/+qashrXauXyRZHu6JNLaBn0ZK1rdP8y6+7MtHGBVaM0X3bpvgeLbJ6rejXKmCkQ7MqZXMlKw86OfEwy2oILMlxSzWF0A/TUyg2UTWNadAjRvnGuX/0p3yiYw7AzXZMHFVMPd+/Guzn0CVPVTW05i0SVKkri05Mbk2vpXy+mdt0lhSQuCDgtgQGG8i5YBp5ljakCZrkuXWmDNAEzTS41VK7nJzLvFvUYify8zyZcIMqqm1y2LLseJk78SpazdrxL9B4dT1+w6kHoFs8wbpr4ljdkvYMAWwYPRbstEYOmHnfds73sT9RYmtR33whhUeMgw4vqYtl6tRN3hgwnGUDHyyDL62u1T8m83IJGDGVRdSI3oKeORnmRMHMOYigOo61qXyH/Qj6ruKSNSC7kGytRWKiADNvTWihtHcaiPy3GWc+nbXgRje0T+7sinyKlLV0H9aJHCgsVSh8ebx7CkWYc2EKVjbL6O+TASr5TvmkL4sUq0DlwzOC0NxqobQrhqiTOOrz1bBbMCjJ2ZgltyaD/e4SXA51mAcFOuVa4cXSYPFWgEQYXCA9Fqsey+Bu8EnCZea+4wjSP8QQN7RvHb8r6uK6SptyCZpjawabdmSOkDPVT/JQbxr1v76p3V8TMDSvV7t/Y1UsWAA981EFCSqcizZLj23dKEpwwfuTT6TGRU/fDRACryTqcG+scy3ZH8hLSP/QsauU+ijUshJermxfEpFhnP9xnngNWdSBwUYVAtCmS5ADawzi8EqqoByLyBClDCkuTJVFbeeN2I/M8uRGaQBBEjWDsQaYV/NfhRDahvBqMyIcbyCegV0D2oKmCqIkoZNABLe4idaOEyjfrwK9Tp4n97hfwkOSWtcAmt2zUi6+GeedFJT5HV64+V6LL1UkzWWaYWAeDQMc601/xoWLDkdZj1JEPuPJwas8//wueRPuFaUesSydnfBBGBoJ2uenEZua0yhfyB0UF42ad14eDefFI+MbtMfpBuxRKRhBpYcWidcTwJxba/JObIjFFZVD4gn2p6qRzTuROTsgXbT3bALdYKQOvWiDo7NF9L7Si6n6yd6txXcCqKbRwrvlRWz8LLBG5GVsrB5KdhiHfL8s7SXUsWxE/Xi37F61cxasPGLeMT03OFeDJ1q7RPfRDhyXoAtVf3fFKtjYzKRnhcXysUIlCqy5kOpkYLKhPyOBVRagm76GV7qfNw7kMFAFKxtU5Wdg/NyWs/f0j2QECUm2D1t2MxRA+WQ3dC9GNt1LrWpfLps99kjEoI0JjScKvqGdXmz4+TGlQcGOqU0vPUOe6G0IXvf438pCGlmVvFCeSS7uqTJYkGufDxT5ULjzxVGlYeJVlsvpvgLoHoCwY6DWc6WlqmMqAW6ayHY222M7cZdW6U+OTVceef4dJ+d3Br9RTsjuhK++ZPC1r5AOw0MrRGkI8BhuV+VXsQ8vxmqlu+MNml6hRZT3P2QQwxHCdKWXll4sPy2s5PSnwhFIX6dmzO1gZVjGxarb+ZFBw3y3tVplQ/DtFLtcI7NujgWl+COJzXJgPJT0kuvkFa66Vw9Cr4vbgf6W8D1Kl0/oQHd03dk88VIvXjn5aW7A0wojrBbrD4PSvKOtuyozjGOugKVEuaDgwShrGy87NXzIbVG+dOdQ3+gR1KUAPo6IZrTN77nUm5exQdggU48QVRaVgVl/rmGlnbAqCCUVtrqjqqeQccpP9LBtOXqABwctP7O3h07ylWGQ256P2vlf9pQv8BiEUYK4X+AcThZ6W1p1dW9SyXc3rWydnHnCn1i5eou6wJ0qMZ5yaCDs5ylFnsXho1UzHoxONg1qZ7F1hV53+yH4Ie/XDCDd8aeIMn05tjFwKwERhcxcH92OMKfQkx/yD01q9OdiMs2yKjBfNxc4HJk6M3y0daXyetbTDMsHFHDjuiFotNmLzUYY1UtGrUcdEIi6qRPWmi8TdjUmVT9V0bg5Jtbe4H1SAqE4nXy0TyMsGCYTl6WWwJVP9fuXv1L2XUwdHZD+w4kHl9pJiKtI68TWrL+2DYLELkCD5L+kcZMg0iX3VS4wD+WRKKHTuvkmt1wKjfuYnhGDWQa0+wI7RdDMMxYRgL5mBgTUym5fJPDsrmGYihRiyJXl4jLSsSsq6rF1b/Fb6Dh6JMXVmWD2t3eVisVDu7Uk27P8cUf0WusWdFcOmLP/g6+e8GABUL9TJD2LUOsfeGRUukfsUaLbM0Mi2v3FuUk09/qnQ86SxJ4MkmtRi9FuTMNqBfuOTLmIhzep6fljdTcW4TycnS2L1SmwBOvVM4q1LtSvX9gHxmupS1xtQIgsmkVRnGaXl8SErjSHrBZCzCW/Pz2Yhcvmeh7MYK4ebiuLyv7nVyXufNUl4IXTyJpSUQ+QwAUKITo9zpRrMMVMQHKVh17usU86QZNkbBrOqNTSGNUpnpJrPxp8tg3QehfiCNcVnsCW1Ncnto/eHefylQ9w+kD+wbySyO5kal7dAbsL8Q3FLNSyFb4ZaioUQwUMnXZGjewlhUjSllLH7puanOWqoWmNLlw2Jnmf6GY3d5mO5D9HBtO9YfYcnGfqQEvuf6abn1ADyvbUlpXVEjjztmmTJqM3RUY3AmrpAIzY9rFWG5js95DGvjbGKT3ciMeUNPRP72X18lP2jBZm7b8RxWqCLJpUulbsVKlJ2Qzv3D0nvHLnnapn1YjQH/4qsulyWnnCyda9cAoDFk5EeliSzLBJrg/gqynPWo7HRh7TbGsZpYXTmhDRAG56r4r1Iy2+otdPYOqpXPBaVy7WU/jyCNwjsQQYSLqwxevbVJvj7dKhdkr5UrF39ImrtiWDXRDpsKidEwoMyqd92Z5biFrxPDdVIuTDQyIGgJavvNhKP5BriLlfawTh64/mInyMEGrAyJNMj6RZF3dLdH3/XbADW6dX8qNTKZr02k7pbW8feqfzLa1AsUWKaUyXpLPNGHQ3gnB/Gp4lW/995ScWEACuA0lWB+lpMNHJcba4ewu7gKE6xKVWByMiPv/Pq43IhHANRjcd+zTl0t773obdII48bct+B4T/ezmwQXVGBt/crEVSAhJS3u6qybLGpbPvjKi+SjR+IJdwcGJd7dLTWrYfmj7BUPHZBnffMe6RnDUm8OhnWBdC1ok4a/fZW0nPvXUI2wWQPUj3b8NTLsSwmjVXHmc/AF/d10UrYzMKyD1nspTPmQdqgGUAV/BuKH5xz4vgqVng60wNmI/KhhbA2VmpRbRmJy1UO75Yrm18vaXqRZdvdIId4Egwspkyru6Rmokoop3EaxtqzaLHntB33XTBlrnZKRZ1Q5MRGsZNRSrEMGmr4O3XmxLG4vb16zOH7cbwPUxk07ZyZm50qx5NT3pWniGuSfwCVV36PRqMpSjyDiFX9mKmkGlbpTTOgrMHFsnVsVUYRQhfecFagTUu9RS1b7yCxGGghktiICAqmZnHz2Z7OyAtb/6ccukkUnvEYamxcbk+Pe1E91AaCztrGp18O/s2pYDYLbhQvk9L6o6+3nPlXet7pGDi3okXQTd16pkYXjU/Kcr90uXRNzGrXiWHIDuHXYCK4D9WMqYvrY42T4WedL89+8QOqgfDWgPQRrA0O71RnqTF6pobJf5VWZXAGirBYllaXxhXmv52unurhwdUM9lvMdyCY6KuOATpTogb2SGh2Tz238tpzb8znpXAV9FAski0gILiGXwD1MrpJgAhsh2g1d6pU0lc9vr/5Z5WBzV7Gf1YUV3FckINdnI61ysOnLkomula4mSR+9Ans9/YrXYUU/ElFWb9qT3Z7LZSL1g1chvn8rEkEWSAlGC2PuFSphByhYbRRUxWOYzdnWpZkCtPKYRe81c3vbAFXsVk5adHjIVjeIuaKuYEWHwNDiHqZMgcshy7xx/d9Le9dqHZwY10oRFIx7as+GEfKBMvmodw3jq/yKjub++LZ8I8OasAAAIABJREFUOCrjT36iZB/cjIhiScbBiRMQ8cN1LZLMFZCTaTFzLrpZm52WRXD10ElFgO+qb5QHG1uhP6+SFRc8T8onPR5+yLIswiLE7lpu5MAtWiNQo0wdsfrpLK36aFTIkNHMg2KZW9ZL3ssPZ+cAbG9qaJxJB5deKkAqJq2Us2lJ7d4hP7rjWvmr1TdLYvEClUYlOvZdDSGrmo/U911R7NlYkBmLrgoYobiHQ489mSBMfK0Q2ZSgJbjrZaD5M1gSflIZaX/lE9bG4Fr45QkqhwXqTLr4rC3709/JZyelsf9KhOP2YvnHAixn5np9uqQ4nuwFZ00FZpjt5CkX8f67iafAnzzVU1O0Aw2OLql10EyUGCsGnUhFHmZlGQNP1YD7PaUy2IRi+auxvn+p751qoj9uip+VG9iK+hY/azWC8DRAk7c1nxMdSbacecoZUrNpk15L5txSAxaAesGtFgsaTsUeprkZWQFjj4NZBGtOwJC6qb1HUsqeZemCAbavoV6G6hvkb658nyw+EaCF9d0/OydL8bDeNfU1Clrf6SLUtsL+Acb67kxvU6/qjrJZjlZRElHHnh8NCH2rAJ43aVkC2jWDXQk3f/etsuq4B6W2leuAaBCZD8FjpKYSB9eSG1TGqsaW6qLyiU5jSrfTdICGrCrNpXBm1e0xsPPKSPN7YFQ9p1yLjZyPWxlfhRjKPqOSX/w6LFAHRjPv3Hso9/ZIbkKa+9+MFNFR+E+R1gdfooZB1eLnjEXDqBOyA9XKdNGvHWpT3MCiJ5tnQDvQLWEW5cwy3xOgINPZycvYgabA6Yz2zuDvM8UGSS58uSxqR5iTG6m52CdYbTi1AOci7wTVpQOTm4XMBuSRQqcpFbhH6ulnSc3m+zAZyrIdIN2HTYJ1JRDazXPWQNwfnaOeSiAz1S4qD8Kvuq2hWf2SdchuWo7kkW6IWQaZs6c9UeSq/5AkghF7JlPYU7UsSwHUk7kNkSftWJ0enoxiXUhxqnD1uhrbBmHhjlb7HRJAc38rLbZrgrpgIQodLMlgk7pN33iLLDvqfrj6GO8nJZjFbiQYsvYt2mRVsb0FjGltgCxQo3RrZfsYUX9VQtH7B5MVsgcnpeoukNHG96u/++je8jntLfGbDg9TnajzveLVU/cMpjcOjBVOqMnulcbBf4YTfQ5AhX7KHd2UkoxBK5JLPwdh7ta/4ayiFrADwxoi87M6GE1vqA4E+0gBZoNkjGf8qOyhs5mHzHNMYi/Uy6W9rUeNHVr7uoUqw65qOBsgHfGhui5m57EuzsjSdeOdXXjxOTK36T7ZMVErQ8h15dbkBGke7yuKs3JCEbv4EYIe9+a24d9cuESasdX5ksycLM4j0yxYxKhtDv02+9LLpeFVr9fFjtsmsXcs7vnEnibsQsgdOCo9YP3g7Q/BEu0B1f2NXdmp5nj3fjM60HZVSNXPC2zsPWiSDwVji1e582dfRtTtC1LbWNU9K8ALYJwPSvPoO4kYsFXHJ5vqeQS3gVU9OAS7GljGqpQ0fJ+tO0+GWz7KSVVet7T8oQWt8TdU0fd/jw4L1N2D6eHBiWJn7ch/Sv34l2BINSIpBMtjmYTCZctaGadDj+2brmoA0yfTsTP1RHaMewm0onwZI6suOs+QqPiVbSwqbODquX127LFjCvD11XW/SBo74DoiUDGYtmNlYJIqGL1AE1VaSYewl5fjrnlkFFQqd8lTZfs9W6UPCRncpJx6aRYzAI8Ik2OLCJMBbCl8V4MKkyH2N7bI9di1pQ2i/YKRAenJYYkzdeYwT1BGBvu45k89Q2KXvUJSRx8v/dj9D6aLrMEeBV1YkFgL11cNE8Tdg+Iz9X+NWkhYDv3jjZj3ZvPbbmx7F9hn8zK4OoTen8Oaltvv+j5UkKulEat/zYIK9oBSqhG3EgXHlb9xUEIkSoWVgZHXOiCDEWXrtIMVZsfUU2lLzNWdI8PNn2R55UVt5fvWLU2cpDPgMK/DAnV7f2Z6eCrfWD/yeamfwD78tHwRVtO9n6jgV6hUlU9nAV9e4sYV8xyrYGN3VZmzwh8669mPZlxQPzRl3kKbxh7WBO0UHsBFlRjEIA8gweL+Yclf/k6JH38iAGrbp+vW6CHNL+hnOnFs/Fz7sG5Rn6XVRoFKcYUfhs87W+56qA/7J2GDcpSla7lQwZWFlDTB+2CGIScf8pkRZr1hwVIZTdRIL56c8sJDB6TeDQ3LKzXpE7aCLLVgy6O/OksmHn+apNqQlYVQ5xFnny1xuLXiqH8dFDZs1KDhWX1pu8PLG+HtMeK1Rmk3OUBDn1VEiLbVJ6ZLMLoKN977Y1kg/wqgcpcAFmai2qR51WI3qHKA7HsdcddZA6Nq6cHpz/Pp7lMCNmvf9qYyL85s4lQZbvs8urC+vLhdDq5bGl+uM+ORAnXjnnQ6M5evbRz6hCSnb5ZoCzL6kfBqER9aotb5KqboA9ROoKFirKpOa2aOh98otTyxQfsygG+emNPrnUV9fLAVDhp4CBGiPqzOfAA7Mg0gkW1wVhomstivgkDGvqzXIsfxrCeqAUU2IkjJqMabbqbNm6uB0w21YfxoTNk2Ofx+4wXPloe27vWJA/cj2LQbWV1Li1gW4mWpqMXx/a2dcjd05DoMyHljA7J2lmLddHA+ItP6ygY5zBtlJeS56sLINaul5epPwFitemk44erxO11cqtfb/y5WbWZVJpxXSD+714K/B/qooj2wakBDVO7d9DNpS79L2tqRD0x6mGexm1hX/cnBa2yrU0MBaP1rm2LojDFicRXAFmgZMNXGcKMqhr5Iw+l/qPMrwEszgFoeW9cbX4wSD7vdz2EZ9Z6dc5lsPl3T3P9vUpPZDEc/chKx/CTsfGJkZOLdmMnAF9whmhYWQOCKf2VSK8s4FJ3VOJCqDDDePoo1VIP4ewihy93YnGHnpMTw5JBYFuv9cb5qyCgDudTK7oVPYpCffKbG2Vk/fVxV2BY9DG5lbhj7VLZ91OE3/S+He+chrtim6y55sUxvvK9CTGTRldBNaSipYeBljEKc37hgiUyDTY+cnZLzAVS6rYzY9DEbul8Bd7xn4rE+dEPrj0Fn/ekC2rBeGq/5FGwARtccjJx0qFczPAa1tVzqMN/UNIKoei4CiB1ElQkfjNjQ5gpk/SAi9z1whzTPvF3a27kdphlNwRZgaUzvZCjUfCS+pVDQWdU54PcMeqqC0sCqoKUx5XptRfSjrEJsuQx2fxMq1cLSoo7y5BEG1MM+V/WwQL17RzpbyM8mmvohVnO7AdQObI7L9fsW4w/LMowiLLIUejk8H9SIxwwfQ3EwgoxgTLRj2PE4cLJm+UEw5m4sr9g6JmWsn4rCZ0l3BwdXk5S9vHAz3WcJjNV6zTWSfNJZtiM1TtIHq4R81HlMGkT/fK6p6KvUd3GfLDOKceIXL71M0vfeaxMDZa7MTUsbMrrUKNCCqA7E5KfQS7dCLarBgDxndEDWp+EJ0CHFmWrNmx+UADdLkktFOJA29PyLrsc2PgpUW05jrGiIbaqrl4Z6AtVeClft6wDU8L2zmd6PlxvD2Xk+EorXcL2Nyf333yX1k1dKZzfT00zAq1tJx4oT2nVMYs6BqkUTfEq2BkoCOripXG+osij3gNU6mDFFxbEQXSgHF3wXgF1S6m2LTG/ojWLJCJ7CfpjXYYF61650ppBL1TT1YelJfp9EmtsAVO7SR76wRlbmODs3fFZXEv5cXNmM026zB90SB9hoIjIO/yNEeHkLgAnWLA0g8TcFILgbSq1I73A+ByBEZPL+8FndeIH3BXMu+fgnpfGMszTJgS8603Vz5ApIOULUPRwcrlObJGBdrXfIplkND0bkKy96icxsulfT91oQvu3Fmi5sTaxMGLwe+xqbwaa9uh/p8UinO3t8GJa+Wb0agQxiHzeK0/fLG+K7uD4JQrtFz42vXy91n0B6XZMtUFQPM9uOHxvgFmuA7mpVJHAql/rg64na/8G9VV16a+eGcapglNjSvo3I5gfukSSeu9DVM2mGVkWMu0jXAgyMOnxBrLON7jfV/tN2s0FukGmOAI9ppNn1ClR8x6EpxHqkf8H1AOyS0tI2md2wNEagHvax6ocF6p270nOFfCrZ0vfP2GZ/jwJV8OgW3bUvuKfYVRWQqh6tjgACUlUYnXroDvpBxhG92TYqkb0A5C5svTiSxiI1ZEeRNTmLnUQUXYpte3evn3Z2Gv2QQeE0bMjEYbXrsquvleaznlRJZE5wHwE9xwZKARGIxOaNDaCG/PyYflQC1bcY//IlL5UpuKe6kHm0pDCrj9IhEPQPd56CqP9J9xLZ39AkC5EG+IKRPgDacwVwBheF6o1URbDkcIUMOihKI0MH10AWW7dO6sGoMQI11M3hpYwK0R/kkvWNdQ/fder5scLVgyTWMFvgaNOiMmurfYLft+/cJuV9r5FuApUeHc2xYN1M/zRXFXEWXFHWbzrHXZ8Pk4dWfrhGpYKyLlMnVUfQdwKVfuU8lrj0L7xBGXVpWzkN0Y8kksPvSv1LgZrPzwCo75Kawj7sssfH4dg+7jpznLKCu0OzxD1rCiOO3Zbh6D6ALPMd2PFj84gIrPQSYvTUQaspE9rcyoxXQGHwLC2OItb6l+enASQCNYi1mB5YoKEXQG0968m2WhR/tqu6Wm9u6Cl9KCubBRJyJI1VghDmI8fnCDa048sXv1gK990jqzIT0IXdm8FJR74DGDa1dcltCIuy3KeODctJWBEa08Ew6976ogoOTRohYJ3WDPDW/vjadZK4+hqpwZPE9BGbvM4nWlM9gcrdSxxq1pSHQy9Mcr1FOIETy+6gc4Lvbtjqbq/4kt6jvX37kSH2cunqHlGgGgvyfw+sOGjDtukGWp82lD7aDuLR2hP0U0uqtihiYFm+05CqAWCzsUUA6vWSj/eWlmE/uCN7Y0tRzGHXTx1e9O+chTGVqmk58G5kf/dhQwgsxtaNJkDc6ETPMrSNzdjdFM8Q52UkOUdv65fIdmxPOAlggk0r693ZEDKMM4INoze6Mq7mQbBzYImDEuivzAcvNucImVYH03yxvR/7lLSe+SQYU1Yi9xVVW+p/vQJudPCqN7GboZvpnpqj8o//vnnxi2TuvntlRTaFpDeKYkMKB2MSkuV7i5fLKJhuKTaHeD5WgtZzGXMFFizSPgXT3Py/ZDj6EU1Mh/Mjq1ZJ4cPYnKG5GaCsgS+Vy5JNN26C1V+P0K2eG8Af0Ke95x1XmdXsONOzK2hWwJrFr9JL3+2J1Xv27ZfCjldITzcMV90sxEjC8MljPdA72f7/hjv7zs9h6XqeAsHVAAeoillLAeTSlyjqVgOjIwdG7QOjFqO91FFnkEC9HFcfdp//XwJUbOKdm000H3wPqBpApeWJGG0In+oeBOQX0vsYssc3YUbetF+ih7CVNyx04yobHBtepwQFqon6QA3e/AoQgmOaUaAp/DEqZBEN63zqrBYbs2+WfvxT0nLGk5xRy7qvqC2GdbD4rK+OaVUcV+LVuCaHRqUpDXDpt1/yIsncfbeswm6D3FAz6H/0n2zq6JZ7sIaKa6bOxfqkI5FcbW4bZzMdUPdrWjUMeMrINA511HAMhYA3Qwph/iN4BgKsfuazNoNFVUfFH4/rk9RRDYA22azHglGnMse71yaHdpO+2fl65AZwVYJx84nde/skvxVAXTCo+cUGSYKtGkq1Mui1sAJtAwpnVgWmAVXBGIDuiFZfasWTwPVaBbQRAZVoD4D6QymCUXtbypNHL08sR5G0RH/h67BAvWNnKpfPzcabh5CHWtqDVacwpOD81qxkVnsa7LkNm3htRg7AplHsooxtE6lQOxOG7gx5ktXeM8MoRKy021yJ9+YrG82hc1P4gqslNMqlYDO9k8o4RYgOPN7JqASq5qGiPBX9GpRw5rRutY50MPl4G4PoONrGYimP93//kgul4a7bpQeJ25wYOilRrwFkUd24aCkc1jWyHv7SZ4wNgU1df1NA+HTCoWkCPLD7KyniSP9oWatLDr+vWi3Zf8czupqQmYY2NEMvtZ25RVpwXI8AgEHN6hFCp/wUcrDt93kv7y/rAwcRSyCbe3Wwza3s6T8o+YdeCkbF86Jc2mlrWF3V4Y1Uwj5TvFRJ0u1BrZXqorzGGq3OLPar5wqQUTXbH78lYtBRMeFyyTXS1/MdwL+7DEYdOGZ5nDv8HfbhaYfXUXdP5zLZuXjLyIfxKKitmG3cAxIBREQG89smJHr9fpHtU1ja4LNcRbMBx7SWqu7n/etdGXyoAaB6auXFDprFYE2jPMv3xHmqtxKw89iUx+x0fN97tYl+ez4AlXVsVhEu4F11tHyYldVcZKqHwkGs9S3LdA6btuGCb7/4Qum5+1bp4Ga7PrBpiMYfLVwqfXAjtSEB+YLhAVmAh6FpwEPpmidWG6OSkHWkJHYYccLFKRH0z9pXXr1Gsh/9GOQ8/KioH91RCYphFNWmxhTyQ7US1q8aLAh3Yr8ohIN8cVUqnGCz0FqsEsa9A/iagq/v4EHJPQig9hyEGmf6VXhAWthcgsuqiT3rKhtvS0UlOG0CapjV1QE9R49xhRpYIcEabYfYjyMDLlP/eNkPP2ok0lBe0xX98dpFWJ9iT8r8ha/DAvXevTPZqblMomXiWknM3o1dOfA48PtmJH8XDKO+tCTwRGR1N+lg6Ny2Dzp7TQ/VLnQFfh4WnQaCaCIL269cyjuDQtPOhvyOA2klQ5yjMxg759m2ZYKBrheiX4GqRk9RQappfn5TE13+ChXxcnQI/QT6H6ZySM7G529ddrEsveMWteQ5MrTiN7d1yh092NMA9XsiDKhTsNJTXWdB56yAohrssJwfMoz5T/nYBr7HwTbh8fClNWtk7qpPYLdt5FNAYimDOrt1IE2wsYaPy9SO9p6Y16BKG6tArPpo2UkO1HntDUWNYyeaQ9gaqPBzbAjR069ZYAZU7RQHpktA1z/1J3ZJYF2X+ZaAYlNCM61UJXCAuo7LE+J4ImEMYzxbd5b0dX9N23vCouhbFnbE36s3P8zrsEDdNjA7d3Ayl2zd9RWJ/uxzUrwDO8kdQODAB1Wz1UPj3TCpjBM6x6xMu3Owg0KGQMVvpIxmXMOdkiapuzjAgy3EopVHOLjOBhSXprPaTZZR9MPq5zVcAkx/qrGts7uKQXv5WD/sQzAeSBLjcJmRQK6/7EJZcvstUq+MWpYhGDQ/7F0pKWT6d2Mbc7JpKzeNc+iEvgjAMJ9ihfdscmGgEuiYBEWhuqhMlSmBUdOw+pEChmc6YZVtWIMG4HQ0wo/K3QlD/XVyVlGnI/uLJqLLDVV3FJnVurD/OBkZmR4f65fZ+14mS5f2mUqmBMl/TPyr0axi3Zhaz9FMIv3gri+cRZDyPG02r+d3LMCOgxIbxwPeYlHkEdc9BX7Ur8EejstJSyNnInvqZ4cDqQ7z4dL8tg+lpg6M55rqbvpPSXzoSs3a16CNd5KG/hSQHpFgBUlibJBGrrxjlNisYxV08zrV8kwttXsE4FLR4iqEGUvmAWDX6bojBxzvYXsG2j2W0Zg6E0DFPSj6EzS+eL+qcjZvnFzHc9DqHNOOtO29xvEsKNb/h5c+VxbdeZsk0WgmSv+4Z4nsau+AC6ok5xwakmPm4JsOYs9rYtgwBquKWAMWVDOAFJuX0fLVkKIxfhnsKc96puRe/f/gq27WVtljXJGcAuu/FVZ/gi4ru8KljxmpYUtL/c37W0Wwk6ghuPJBjxXwOCeLKozA3zc9elAm7r5MViyHwUx1S4Fqfe5k6fqqATAs9qukAipeDdh6VQiXUr9VgJuaogYkGRUg5ZKUqdpny8Diz2nizZkrYhugnm//jYC6e3hm297R7NrERrDKu/8Rj5vhkzmq2pBSv3dCSJg2ndI60JZO8xJrecVbVAEqfwcI8C/CAML90FRaK6btWg6GxsHwv+3ayUPGnk0/VfzjbdnHsefAmWeZ6FdfHX2pVqD7G2zAtDNZb04kAydfTMRgjiiJgkDN4bzbLrpAOjfikZn4fWNbt2zuWghLNSobsBM0I1B1agxpcZW6hl38fJz1R0IsDr0hgUTqGp1opk2WwZKFVdBNL7pIypxkeFSmthl/ZNBW7HXTAPa2Z3JVqmoNDsaZnx/IO/R58G1WMOr1nKcFyAye7TWRicgschPG7niJrFq539jQhy08fcXnoqlzSoxmFJkkZFvCphPakwpUbZ+HYXXxu6o97C/qp9zwoizjzS+VwZ4PqSvx3KN0E4pf+gjKwzLqvtHUx3cNzV4u0GGa3nAZUtHgZyNTKiuSNb31jGerMWEw0koGjJoQcdgFEAbSMeNlDL9rCrGC3Aaeg2tApE5qhZmqYeBQo0p1XxtE1VEp+vEbRT+vZRjVHOdVXuHF8/NZQ301Y127mUAtKFAfeOGzJQmH/xj0wxuWrMTDEpJShyjaXx/ql2WIVlXcZYb9eTexUpUDQdG1BCg8CWR6rQxSAnNYAJh/7vMld/oTEY1qMj2XgEadO6GTtjLdT/X0eYw4b2La3J3PlubAr/Q/26Pt5omhZWH623RAYFBmYRSkwKiTt4NRV+/XOui8064nG5Ji7dhUVALQpGAQ7wpLd09VXAF6rTGoEr3rqGTSBP5iEPcHez4q440X4UF2ZTljDTrFp58O6C94HRaoI1OZyzYfnPx0aXxUWt/yCons3auzuZJ15BNbs6nYCMOavwzEgXB07j2MSWnRw3GOi+gnDRfS3WQLwKpuHJNo877HOXaJ+SH5WvaxT6sxxe/xPHZuiaEzNayNrwwpr1UatmoG+58PadBlvPhmFEDNgloffOH5kth0l9za3Ss74DMlI5wycUhOBqPyQdgsgtczYcYjoSp+LQeXLArHNnTYuMtSus6KCENnXvhCyV54CbYnsodjEPCsb3NdEg91g3OfOxGyv9i/LjHUm+KVNiiFH6wharg4cVg/m34eAM2vLISrJzNwKEMAKv2oKSTSTNz6Ylm1Zq+C0RjQ5x63S3dLvgJS12N1mYnei+f4chOdiw5SdW2xqqafso6qlkFHlWidHFj8NZlOnilLEE05ZaU+YfmXvg4L1NRc7oK79o1dV0jPRTuufrdEb75BoafuHAKWYHGQGQYdluwzDV/iROKIeq1/DDXhQDBWNqoMbaOug06m9JMqqdksxkV4RW+tDJsNwFIV/Wc6owIkKE93KmF9w2wJE2W+3qodyX5U5VuPx2BMpfFxy4XPluzmTfKjpetkGnmhnVi1+UwkRNNdRX1r/i4wXojhB/8k8HscK2UTOkhoCXyuubPPkcyFL5LS0cfqwPFk6ruN2Cuhu6nBABpmuksN1kmH22V7Re/n1d4eY87QSG+GEmnQ76u9Hhh3GiGpUfVYIsCBgMXoTy6VVRt2u8ptSp2pnQzo2BS2maOGPD77EnOVRCQvdQO4fsoKKf/qTLMNRVxPV48MDFBsILZ3yQ+x4mE9drqJDB+5KI5Y9G8I1HQ+f+Lde8fvyGRysZYvXyu1X8HOFrrSke0LepOxoU1ih2tV7luFCTKlNOc1NA6rr2QY19FmNmayF11P1bUDLj75vepkBKx3Pi4IigZBTKC2IXuKv6tOSKDOn0Q+GQy1hgICSmP/HBSlLqvHCIA6CzbceuH5smnvfnlowTI8wqYop2LThuNmpuADZT11lgbaqUwbGkkJhFLpelKpAAueYj59yWVSOv0JyD7jSk8b0DqQyCJsndkElcLUmaAyhWlPAHjHBOAatgxElPaq+xkoFfoV4LA9Dl8XdcrJxA7OOzQHFyD9m7hxZmRIxn94oSw7dp9LBCvHgGo7vXDff764gNEiVpQBviTaK1QNCPBC7dWHrUjViYlramJw/yVXyf5FiEolFsgpyyLv7G6N//NvDFRcWH9P39jk0EQ63nL9ddL0qQ/pikxW2dIq2VMGMf1Wx9yZxjGprXUGC3mQTM3DYxN0+zZjSPtH8005uDxWFvXy/Dw910eOZZkdbP7K5dBR2xCZYjmmoyLer5PJ9EKLfDm4bFrZaDvV2yNu7P4U/dPQKbdeeIHcNXBIBts7ZRGeV3o6gNoDNo3rE0HckFSd2bwRcYi/GH7nMr1SbYPkjjnGGBR6aIRPaXFWrIEF31FXI+0NpodaM72f5jGjzQKbPbooUlnO1Z7wU9Ad2RMBhfSeBEubZVM1I9BcbZvMYZ+CgqlwvEcWy2BG//m50n16n9Rt8LxincScwP70k0CQrIxKcp9EOjGq/WmqqOeyKtBN5NtFDJ/iURUxbCDSegl8qNfAm1GW01ZGntLREP+xDcrhX4cV/bxkx9D0oa2HJrsaD+6XjiteKSXsrKFjrOhCo4LHPxgpNAC03jabA1NanxjIsfORTDjA1QJWscAXdUsLG4a4urqYCF42XsszEVLV2KweKz5xrbmn8ElDq3hHvpFXwEGlY+6WqrKXUpHWtZqlDtGPcM00ftp00d/I/UPDeDhtnRw/vB/JJ1j6wgmkl5l2TCMiRoD6O5drF5/yNMm9/GVSOOp4k5O8hevABGgnNwHmMhnXO6tPB9QCvdJhpod5HsDAn0mpKg/02Fpk/aQvHQvNaLUcFmU8m7JzIJrhLDeOsAnAv/z2hyTziotw7ojUvwW5sl06FOam0qVDbkBxWRG/U9+XlVlRmTSRh985MIMo8NxcHVNKG7imauMFGWv9RznY/g48ur5cOH5tDR6zJogi/fLXLwXq1FzuOXftHflGbmxMlrzj1UDuLlNVWH8e6Oxl3wRd0EGkDOYk613JgYU3BPsLMnbEgfItHs2hVWHXoIdSvDrE1NjgTOWZKvKducPugcs/hnxUjUzxnpaUoil/FeaxvnVdvzKgOroqwczXx/uNzhVlAqJ/46UvlC1DI3jWRVaOnBhCXio6WgcCPlo0WrOg+MdjXrtsueRe9w9SPPOp8I1CxCu92CRsgsLcg93+ajTzbB6oOLzsuwBPZ+rAUvq9aVlaThhrm8UGAAAgAElEQVR/fXfVxoSZW+t0GXGiGo6qY4APWEQhIwBpXj0lxnD5rQ9J/u1vlOTme/W5tcXzElL/XAN5WJRoe1DZeOvu1CzXVTGth9bFQ6ahgg5Ms/iJdQNwIpqVZE297Ov6kqSbnyqnrZCtPc3xY3CWx6kPD9ZfClRc1nr7nuGx0cmZyIpP/SvCNdfrbNTsJ6VBS9QwqWozinWrzOTKEBhT4NEIMqUz32a0zU3rWNVNFZwEmes3PtQEhFn+xmhagk8QFrKcaX5InA5J1szOYWa+VpF96eAIt9bBrfxIRvV8BXw5MpdX0XjHZS+UQeyJ2puZlBV4PmkH1AHTlU1P1lg9j7n7HVxN+eddKLIQW3I6SHhmI2ZLB3TQej5sOPh1XcwbC1pjgr45v36hjaZWVVWEsL1PxQvg1n0wAQzRBg42nAiYgvE0Cb8pQar3Tacl91VEGz/3SakZHrSkG7R9Ctve1r0WbrjlZgApS8IHzJ/5kArbdZoqgbMqfQQV8W5g1Dbou9sT3lesVDKG5wjU9squHmT21y4vn7pcXt/TmvioD9MvfftVQI1sHZqa2zEyVbP4huuk4ar3w0HvC9YCszpYdVar4RRYwmatsgrOZfRpAMdqQDnItXPVQW+o0W0rtM+MPXl98J8y8zQwjeWbOOPi2hXB4a9lMzLFzWmtg6sRMp1CBjTW1fQXfWmqot6uLCOzeTyzSeS+l10s0/t2yFLsjb8SO4rUMzGY4lod2rgGUarSuedK4XkvlNLKVbiP+SsIkDos2mqFFc8/27hY4WEz01/h2/CTzz//1SST1YgVs5lmxtLDy2Bt6IZTrYG+Y94J/6ioRzsmAFK+69oD9FXuvrulgHFM3HMnFktiXZreg1lqMRlDMkzsryLS/QK6BKz/zIDncfVhE5ZwYuOti/dYW+UiD5u6OLVNKQIhleDZwONEW54nfR0fk+aGZO7UVTXH/brPmvpVQJWBydn77+4fP6Z57zZZ+OZXI3Mfy0hQcZCO+h3tIW42w/zNZhQbyb5jp+Fnc0fxHOcCB4rtnWngVReVixXLRg9sa52lCSrz6NGiYFh45/mo9qBesil0VBeZwTVSjRqFSeHziPXTzlaYydj/b+9LwCStynNP7VW9b7P0TM++wACyiGzq1aiIUaJGo5hE1OAyJubCzaNXcx+NuIIajVxBhasSDYEQwUdBEVB2BI2o7DgswzD79PS+VXVXVVf1fd9v+f8aRWYGRhk1BT1dXfX/5z/Le95vOd/5DgK9d2M2Pbz+LaHjvrvCYjBsnhvXXE+GJV879rhQOfMfQv3oo1Fv+qoVSHSJdecyEPU4ot0bZSXvGfRstGew078E/obpBmkgQMW3QmYGeCEDw7/fK5cpMEgKw1BVijy+SyQdgIoj1meuvDSEr18YMv39MP50EhPAZbRpCinvS8zY0oGEbu+ZDLl5yqp+HCdZVG0qDrw9XKqroBUC9z4ySSGkZaDl76Yslk67PxD6294fFnWmHjxuVY5JJ35jaF/DnGQ5DdTS+I29p556+5bBK+tjo4mVH/r7kH54g4h7RhpxDVwibkwnVcTZDHTmUv4K/YAZI/VFB40MGQWoRr2rT1WKMDAKcG0I9TuOlgZz6IoV5QqMKWzu63gRHf7aaTl8lbUJEXkkDBTWbzb4CvS6eDO03AEAtX8Gg/w3bwrdd/805Bw7vPHQdaH2rneH2Re/LNSROUZfuqLExL1dsO5zDM/jy3RIZUEVrfJLvuPjZWZa7+jkkQsMi796rQbY+Mva3nCtGFGoawksNgwWRRNEXHOCVh95EIHZnwqpO29XFrVOqEMKTGJn8RQ2bdZMNamDWbpeOR06X4rwRWNTyW/CZ9mGvchwM6kmTeLqlNRfyUJaxOEREFNNwrlXha6wq+8KTIgjw5FLMh/v68l+TK/a+2uvQEUR2Vs2DUwNFUvpJZfCDXQZ/KmoBnUfrn0zCt8NAn2iuoOkzlZbnt6+A1X1YEMfFmHTyOmvEVHCHpGIVmaJjK0IyBx3Yx1hVDj84UcVrQp/M3qTS6huffjzfBI5D3iHczzkyBncNwirfxdGOfHW00LrPT+TdtS7u8LcqaeG+pvPCHNLlgrzq4sMeigOZ+vMAaB4nionhh6C0HCnn7BuSvNuDDpMtde0w9QgVzXDUSv96kqoFBb3r5SIPxG2jsRrdRyOa5YJPpsdGw7V//y3EL51eUjt3Cb1VvcR/Kdg0QkYNmWsXvoGTTGKCK0e5M96ZzFku3R/mPib0ff6m483IHoXC4NaYwUdMVCVbTEe2I2a6GTEFE9EaQ7Hr8ghJXp6rynRo6m5N0blhY8MTgzeOzje3b5za1j2v98dkjiPk3VDOljsfcFcEbBqt0qnSmeyuio+RvHdiBgEyiyKX43LFMC5jiqd4G4XLdP1Utk4RwjzZl6Cma87UQHUi74WWl/0J3o9LivgN/VU7yTfzCaf2DX6rVrscn4on42/d09X8EOgvik0P3hfqB9zVKif9d4QjjxGHPZq8WK/PdiTYh5HXmn95X/V0bXt/MuCjA3Usb9U28+6iK4qnad3qNTUCRf1pQDVekLYiUypwGAM7zgYYAz9I8ejs3sg5qev+s+QuuqbIbkBx4Eil6xvoxLdFXu+xnM425QriFZvNe51slQgFOa/Zjp0nIgkIKKf2gSTtqsdIXWT8ZT/1RVn7gDdFsM2GJsSqLio1PtPSONzJoJuQjhpVfMyeOq2STH78NoXRg2j0zPn3rZ99APV4lRy5WfODm233ywVYb1mANSyxE+qGBWwChlETYGDn9tKVIjL9gsfDBlTbalY9OyG6D6Ckp1CwaMAdCCyeOkcvGiI0eqne0quxcXMCsskFNHMMcC7Lt3ItOpIV6CyXv0A6gBWp6pfPD80r10dEs8/CemMOtV3ip8mFNwCZbQFol6NQIGXD5tWSipndCN9YaMZ6R02xtYQd743dJuWoXOzobUKJNYZcylMwSLn7xmyHWuBjYazv/hpqH39KyH84schPaNGEcUyi6lhDCaw/6qInRo1jpk/hGMjY6dGJtW6wrpy6D2dp8JwKPklActS1KEvFGFkEKk3AnT/mEDVa2WPW2ZeGFn2TQT3rAt9nZnykctxyvJTpPD5VezuE1Cx22L1Twd337NjaqbQe9sNyUXnfDgkebyONX4ajWZKxshrIWOjleaiSD++4x4oG1ddhbLBjcV8w2qUsJ5CMdJb2TWi+9g+Izzcw9pWXKh7pvhATodmXKdAVas5AoCpAw5yRwNdLMw5Re1yFCtT9KXOIa9pAsaF5LLCDXlYR7Tim2gliVRQJHn5zjExTlUNUBi7qFTGVDeOzU4bXLmPeBDrWQEZodU6joCYAehGAdCi1Fm4Fz9Il7l5c6hc/KWQuv57QPCU+pT5MJNEVWx1n4AuWmKgktU/UlOEFn1vlLakDrHU+7bJkF+mS6WeL6CR5VUQWNukHVqiOMHE7uB9IA3WteXkMLz0Ivhrm+tH9BUu6OvGGT778donoKK87KPDE/f8fGDs0NzEcOLQfzwz5B59RDqdhhVnKvcTyUnc+JG+NjqgBboLf/GaSNxZAyK5gXJ0FYqsHLum2A5V/HVN23VV61eBCoGgQKWOqte04GLN52JwamS4hs6RKwQTjChS7wNTMQ5hmw3bQMYs0FCCfC/wGPaYg7SUCPEyYvKRONyt9Vq+slDkuTdWdcLUm+wfn8kNwOZ3xBp89WECmJlAUdT1PVi5tn1bmL36ylD73pUhtQ2HSHAVTKsigKnCKzGFjZnTmGRkURkf7VIz6LzuGsonjn58xPFqOWk6zDsVFGPl6ZyykbUy4k/0IuUnjUaL2BQLyxMLzwnTXdgwmc3MHrsq98JCIXNXw1Ds9e2+AjUMFaf/1607hj9fqVYTq/7twtB96dd1cAhUVL4MC3Ia2ZR9OVJ1Kqwlo9FwKccrWDYIzhfRb2MRVfhdd5VWi+hnD9B1pfqsqw8qjpfR6gejqmpQx+FkcBW5MqpTXJ/qyGRnOxMonuXYc9cLuZOBH8sRkiQ+U2v4YVxfIyveHuPUUMeKOMeqripQRJ3U8NTgYptLNkiOequQgXEGqJmAWJqiSJZJJQWFyubHQ+VbyIZ3yw9DEmyaRNyr8LexGncpFDM50UerEopJW0LZz6YUyrKpR4vd0MjveBUDUBILa6HvHRM8rUlUtpiBeZHp4+L00bt8XMQkM/00zcUU7IQeWXpZqOeW1RZ15oaOWNF8CC5Gypx9f+0zUFFk1w+39O8enK6kuu7/eVj7gTNDAklrOSIcBvrrxmFJyhn3rJyNA70Cu9DoWbNaZaBlwLXL3Hp3S7fRX8iiRD+1rlVW1ZduYebfXOtXHVX/rod2/IgfU55FpGtl5A7FkEtEqwvH3jyCDXqk1DEqR2+WWsfWhNXGht+eo1NUX6rNMcrTQxr12hiOXq7qh6wQf5dRjzE4qxl34FuUeFd9185Que6qULv6WyG18VFdgGCdrU/Z3zPw4xYB0JpkXWF9VeXwrSvWA4RTZFwqDOMJxvezXFl7LU4rPIrjrDWW8bOJ6YajytAYsGJE4foUKs5xKHW+LUwu/CgDpqurFjWdvXxB/p+tQOulvf/aH6AmNgyP3Xv3wMQRqZlSYt2/fDy0YTar+OfAK1BnJbJeRR07hor5TlPQpTFu/dtIuX3sABZkWrynb34j+FTnUtByIOO41RCWU/QjKEWt+LnQIcHTvF4NvBg4cWdHQLJyHVYCLgO1kLdD0VDeCEKViX6Ra6MKvEgvNbjGcDQw4gOxjtkmm9R8X0GFx3iUKfpARLzeiPNYR0Pl2qtDEmI+8dD9IeHbuK1+tOBnsKWdLFqRjCdquEbtsWp6jaPFA4WYTlRhzbg9XIUMS2ph2VvAqgUVMzp5G6eholZdkrxAS9Dt4PjBLpOxvotCtfnEubZCauiIdZ2HwwM9tHdo7nnF/gA1TExXT7hh58Cdpepssufeu8Laj30gJMex1YUb/1C9cXRQmcHa0midg+xsOvvpS9WoI2WUyBdns1iAKu/NyterdAbT9weAi76KTyRHqQyEwmT5hXBPidVP8qyHTinDO9NYohFoDR0u3CbGhSFU9AR1kbkppAyoDdJhVEmwx1aXXwO3tdPuFRg3VMnZTa+C5Q72mYCSP0k3k+SW5YREBmzEwM4i4171Cribbr8FDnvu11XGogJRgQ5aAntSB6VBq810VDY+UCvfyOWxqReDQsbN+opuxwr8fEvePo7jNfWEPvvKdFGKeJ+ULE3HToCLX4wvrrX9aRhf/DlApLm+al7hwpV9LWd5MfsD1v0CKifKf/WPDD42OtWZwil6a887J8y79ntmQDFpRAruKm6S04GWFSxUejdme1kc+7pNw+VNFGDig2/AFH1UGqwspT/qb5LZSrEiwTGqGiwDUNU9pdd2McmBdZjsubfyFWYKdvnXyaOR1vxapeKGEeT1zjgNAIgmhAFY7nBlxYDBdrPuak/qy6pCsE1iNg/jh3EQsuyAi2YRY1DFunz9sq+FNHYaJCdgyZPU8B2N1jL2HU1BeZyGNc88rNEuVGmhqTHiGTFwSd9ovcyhEo2DtApfSF8JULWdMn6wPXpeWQydJ2CCyIK+v2yCs1xpkzjILI5YGTUBNp1cemGoNZ8wh92mtaNWt53Y3pS5u6GQfX67v0DFEmNp/a07Rr6ME0SSHQ/dF4744FnoROjFFP0AaQl6kUZUaacwM/xuNHYGkFI21QHl29hvaoA05OiSm790EDR+U0dZc08RSOoNWBbpqCr6uxCRT6DKoAjL6mi5wSBAMqAojNVPoe/0GWKtc1HBdlvKMGs0d2SIRWA3ptcpYK+G8l2s+pThV1zZm0bZowBokY563oxG13GiyuRD94baxf8vtGDPVgYiX5Yu8V8VRFAEMItIrVQWLwuRrw+yqonojfTRhinaaEbZNI0SZ8QCnzqtJwTRPuIybH5dNfT9FdJC2ThEU0EaqyW7hPQgFzlko+WUMLX0X8ims90tma1Hru44FJ/+xmwo0ZA/yZv9BirKaPvZwMiGDcOTC1O1auLwT50dum+6XhBRwiyfgOinnirMgBYoUNMAqmqVMvuULs2NYuKdDY4GVzlJDgb2jrBZr+LdimBReNBy5BZtYeC0fFcPXYCBOuMdOj5MjRQptVHQNVi8+qmKaSlC9GVnIWNZMk6ESn+OQ10nhK8ECeylzZwpBAI8IXg7WgWTMqrJWBonJIbK9i2h9p3LQgZSqhm5A5ikgqXOIvKHh16MYkfsjOX+imkxlgxqVGkIZmOOKVXDYqmkk83aYgwasW0DSDzUL9FeD0vfBT21TfVYX522aUvuVYkhP1pSMtUVZpZ9NVQKz61hQW/28L6213e25a57KjAeaKCG4WL5ZTf3j1xfKldTrY9vCMefdUZIFouy3jyGPekzEPWSX4SiA5XeBaBWJHjF5ZACUYwjwY6xpg2qzFD5WLuC/2qeJv1cHcrWKXi7AkBtBVBZJqcDTvTUmFZruWJKuzF+caCEc+U/VTP0Fa/FO8piMOonbjg1qhUxn8ZXKzuLfMBbWvKih+JHlzuRLAxWexE7WycuuzjMh7HUvGNLSOGsKt7AJeoJnE81AZCWmJvW4lJVPHirtP9iWaD9LnZC1I9a5z0Y36Druq58a8anXGjtFFYFMnv/cjI0H0JLg4VqD+gMdJBqHTy6ba7t1FBeCt00kZ2Z357deNiyzpNwAXcgPa3X02FUPih9/8DII78YnlzBWX/c+9aHjrt/Lj5UOv5HsKIjR9WggQRsP0R/SeI1HSrx/PXgDhaq4h7fRUSoKoCTsEf98DNJ9ktVGP+tQFrxtpecLOKHgS1kVAJVJwDHLO5WGwF9mNNd5B3QAVZDihNJjcJY6dDhs1raex8wNW5EBAsj22TCcxhsToCOoTNm8Z6Tl301gqQeo9jd2w1/aBei7LnkyWcyhJLupSHooJRSarjFk9a3Z3s36QRzlncFiZKAOzD0N8tlSGak80gd2VQFtKM46ivjFF7DdjU/F0uqcFWpT9lULypK8nBKR/UNyxgm28PMkvPDbNsLa0gEUlzXV3htT0fLbU8LoXbT0wVqGCkWX37jrtHrirO1ZBPyMD33g/8Qmh9BCCDE2xBYdZI+PKoAaGg/OrsoSXnYMzKOpoCrWFX/qHa3smwsQrxxzqbOth4TwM8Z5tf80pOlk6i/zpNsHAZw6XAH1x6+ANuloM/n43UzasxUjQPopUg9BcBWX4VIBGAlGpsY+D0lq0nwbWJS0fXEyNca1uRnNjwYypd9PXTdfG3II4hEjBncOgXmHMZK0iQzJ1pZKmp1Alkl5ZkCGmFWnzo6WaSKxpDeX94+mYBW91jtUdA6XrU4M7xowKGQ9ILZsOLdE7pZUHbUaJvj3zqGKbB+bd4ZobzgAygiXe1szVz3nOWdf4GL97rd5KmA/LSBSkw8PDT+Xz8ZGj+WM6zv+qvD4eeeDd2sBhGXDgOILCqTUdHI3QDpJAZAHcQm9k10uEEVRSDFWI6YlZ3tQFUc2ey1a+nwb+JWFPQo15V7sHfc04pFPGTMEkHKWMZhuec+eGNUkwDqsrHZZc/0Jfk9LHm5XicnV5TGxd1E1xzX5TWeoI7MM8nzPhHyP7o55MeQOp5Mh+9pxQ9kCjgbgADVSaDi27U+n2y2fErAyGTkP646cdVfRUUkMNhOY1s3cFXMm4pgk1h/absdhvGkQH2QdaPvXZOhsBBuKptAcOZKEJCuuKnNMYd0ktVlF2BNf/50NpusHrK07X90NmcfeCoQ7st3zwSoOMSksu7mHUP3DJdns0kkaDjurLeHjoceEGag83+E68to1SAE8hjzq5oQdXETAVD0TfUJsBNUaps1KQsAzrQOcteRdI/9si/DQn7py2WAuO9+QaKKKH8dWDEIfIuGPV+0UvPRxHVxcOqzxPoXMMcDrUxlvCPsJk2KJo6KSbQdR4kPIANxkUdV4rNZRI8kkJEki9wIrT+4OmS3b9VBBXi59DwGBh1CADOXOiOQSGsMhPZIYUW5wuJG/fFSV9VaBLQoXLvQrvTv9Oto0sl0iACqz9MtPvYy1UcvwRaVU+GmOg7RGzQ3WBM+0HyM2k+pUO37NNYwX09PW6mvO3/+isVtH/Wn7Asgf9M1zwioKDS5faz04ZsGhs7mlqKOB+8OR5/93pDfjWMfUe2d2NjGEMBRDMYQ0qqLOBFmMwNJOooda78FGy5OuF8q4kPpUOlY/CMKuzmX+W7pZ88Lra9+rfpVcd1CBOkWRPfyLncd1ZlKRlEK0yfoiDlpyp8NgyvfCWtoNwqT+R9yt1aOBtKuMkGqYp5HC4XJsZC79juh7V+/gMM3tqhOWGMQOVfyskhn2YS+Yvo+FqN18pfU38S91lHEkQHVjcPYsPFruI2dbjVtnNZPr+JCgi6WRBoDQc32eF8IaXif6O2U2bQJmg7FMUZ/jSAVt/ypaAiwtR/rzSeG2eVfQtRZx+7WfHLHMat7mJx3r1uhowY/xZtnClQW3XT79sHHHpsq9bJvFt/2g3DkR/4RcQBVZOhLht3YOjwMNu0HUN0IMI6Kcpy6zuRDpH5TLg5oJJDwjBsTxrgaI6DLdK0nnxIWA6wJ7MHnxV1QP7okWp1o01UtHyqDlXS2wFPKJ0WoMiZQkdtUf/ZB1neNLx1OfkaWK8IC2oklcS5/0hiam54J2btuDS3f/Hoo3Hmz1JMByDOoywgMpTEYStwh4QxHU9N9uDpJlOHjZQ57us0mlRS8TnVOF79aSZ90pjYIM8Z2v84HNxgVpNq9Lvit32TXKre1qxcn0V0Ja9bjiM9mJZtoYuFtPYOY3ZUXITzwecggmhhZ3de2vrcj/6N9AeG+XHMggIr0hTMvuHbb4O3T2AmWqs6Ewz57dui75hpRcbgA8DjSe+9IcF9OPNoyv2Vvv65W2XyXTnPj1E9m1pBrm7cy48304swGSvI4S3TZJche3NUl3/BM0gXi3BEZpQhj3ztr6J8RCHWMCDcztnCbHgjhOlsM0pjvtLwZXLYLCQu425MsGpAYLX/nLSF/4WdC/pf3mauIR9KBaaGDTjBwh3vN+Hh3I0mhXLkTXrIq27OF7exlE8e9IuoYcrbX1mkRDt6GNtgEl6vMGHSbQRg16iOTasw5JZPcsrSwXLDGsjMmQ8ty6qnOzHxmJlQXfSgkFvwVrK3UQG9X01fWLGo9D3c8IwNqD1rYl60o+4D4xCPD41/7yfDYGQxFS05PhcM/f07oheOaW5H74ajewP05wiCCGHnpBlwXqQZWs259XV/6RxhWRZlrUI3B1xnkuF9y3vkwqKCnokiqDAuROKJZ/V2mkxlYRZfiyxlXECPlauQX/9QtNHqzVNTq7KinTxSZ/5AeewgsCt99qMP3mXjontD0rxeE1jtuDrUKDoDD52UM+BAYdBQRTVW47qTpspysosJPNjRCU3b059o1ezC5VNGkgU9YhumpXyySHN7HaiTa4cneIHm0T0KW5bEF6nZyQ1E6SkIAbb6jrPYXl8KSk3WLitoT8Am3nxpml51bTmUKWzvy2QeOXNm9HneOaAcemNcBYVSrSuudOwceeHiytJQzvbDtiXDM+94TWqCXlQDQXzS1hilYtrK8Kmzq6/k2g41LVexzMDU8TmGlooiuDxWHvIC/zcJFWW0vfHHo/fRnQ6pnvtxB023hXAXHQjqrKNgiIIgPUIHpDOXDr2B1oMasxHqTNYdw6NUIzAWmp5TX1s0hf9XloflSRLDDF8pJxIDxUag7I4wJRZyuywQjroj5tG3+DG2rGkxsqb5TN5R+Jj0ingLtFlE8RE3a09CSdrHJfo1UFP0lbKtqCBseaaQ+U3iZPUtbZ/WTshCUfkQlLP9LPWVHjDUkPJtdfTF2VPY9noNd+JwlXWc0N2cf1I45cK8DCVRu0F5yy9adj+6YqeTYsfN/dFM44px/CnOIBbgficMGYd1SFqhwE2EnoIvEusxQZU/RP30m81qxwKV31KlM5vZOlfFNht63vz10n/neMId8+/yOu1HnAzL8rXowxRRu9EFkMYIRfsbvjDENTQZVcdCXkTBsEoM7CIDOwGriNpDEww+ElqsvxzZdBC/D7cRTCbl8PAp33AjaWoKYFx3UQK9Gi7JWxJp8J8/WNilwDB+KBlWfo2+0U7QsrbsaRspwGlDC9tqqu80ldZ7YH1KAPaOBtX3CmvouFeJ7mRQG3sLKclj5DgTIcEJBL60u+79YVH/B4/Bfj67qbT23t7v1u/KoA/w6oEBl3YZLpdfc1D/ynfEqHFM4OnzNV84PSy/7RhhA1X+Zb5G1arqsfDDYy6qvEoz6cRwgTbCq1uoYEouTfRw5MqlPcvDgHEGe0eUfPTc0/emroCpBAUCZ3JLSDp21E4Eq0cKMIsIYyRAiIFYE6FcKqQko1lMAaBEiHIsboQoRX9+0MTRhl0P6x7eEHNI2qmXMSKNk2Il9SXTN6Sq9As+f4ODS0Dh+qW6myASX9qsfVrjT8CQgsT/cM6HgNF00moi2HmCGjkuMqKmGU//bYevqgfG09Lk800jDcc3P0vPKYc3/xOmM2ZZQX/rxUOt8DY5pTO5a0Ja74tAlXUzP4ydwHFCoHnCgEmebRycuuG1w9G9xwFgihUPDDgGrzrv5xrAVG8s2FlrFuR2ZDGi8bPkwcLBTNJpMB8G0Ohk0dUtpB8pv+cygYPSa65mHhG7nhPzLoK82WPvd6L9OADaDwlV8OtNFHBYxk2SCQfljSGNDhz2d9yX8lBE0krvhmlD41iUhu2UTUIF4UTyjavkNJuHdGMTCBo1G0eHEclejg+1yt2u8Pdqpx4AhwHQd0SeMMaOxpbM8Gy8TwPrCSFX7zZOZ0U0lXemqg4pv0wekD5V/zUAVBFvfmi4v0k5YV/f1Z9tnwpozK6G+9v2h3vOWO+CLGm1ryjxxzIp5H8HdT5mH/5kg97cBVNan6exXfPEAABU8SURBVI4dg3dunCoexf1H+e0bw5qPfig0b7gfYM2FTdgpK6lm7MV3xFkEVmOhKHRMpbYMuC4LKMzlxzvXwM4y8ouXhO53viu0vPLVIcGtzqYD5nFfG8AKLpAwQInnMvagukl32jQ+LYNBGeFEg4nGYXUAeQy+jcDl678dMpseRdAI15oAXAEVmVSzxowwBI+nbwsDsppkadWzLRGkAEXjAMwFYoaiNMMYVJvEQpj8QQW2mXvaY4LQ2IWyB0PyNn7ND2VVwaWXvldmNnNM6qIli2Tjj+zQsMdY3cy3IHXINCFA5ZPvCdlD3rQLR+/c3pLLbT180fwvwDO485kAcW/3/raAyuf23Llj4IHHJkoLyGGZTY+FNYgHSMPw2JhvDYPQIyVDXKwQyfKnDpAxrCj7NJmsE+VzNSbiAGxlVTnA10QehyYFT0Pb818Qutb/fcisXovcj8yZrzCnOkBjS3eqKigY2M1DbLnkqzYSln9HhkPlFz9HbCgO1H3gHiTqZVIxnSZkRyoTbAJZlaKebCpXRNhw+1w/YLHCaKbBeZ5VfmFmkzIwOU7QpsPnjCfX8f5IJ7BrTLkU/hSgypM03jQu3IsTySQ8GnW/PSi6Qioq+504qZREMLmxLN78hreGztPeNoz8kT/LJ9JPHNLX9YWe1tyjewPaM/3+twlUME555R1bRzdsKU3DeYhsbht+GRaf/2kZ9M25ljACfU6DrE30sEOgoIkU98E2IInpZewnB/KayHd3VbS/Ct95EDHHM9XaFpoOOyK0/vkbQtNRx4TsosXIeIJ05NGg2GgZSOvYE1955NFQve3GMHvbTWEOEytZmgKYCSVOGA6ZDrKYRQSqsCoMLag0PGBY5567fxxMCjnqnxEXNrBbxJqCQwWOwk3/iXYXmPGjBpgzZny9G1QKDLXstThd0Gh8xZPB+5/lGSNzWrMv8QEVtWw+HfKnvTW0vv5vtiYzmduzqdTEqoUdF/V1Nh9wC//JQP1bBSofODQ18+JbBgZvHK/Mwn+fCC13/Tgs/dSHYCXvhn+1CcusTZoPQDqIosmP7DEeaRg0fq9HS6ruJeTC38SaY9tEmWoWOjhyHfLHZDs6QtPxJ4XmY44JTcccK2cSyNHuSDZR2bk9zN57H855fSiU7707JBAjKmdbcbAaWEppyDlL68z6V2SZmKqCOW/l+WyY+WsFMNomUQZoFCouIlmtO1Vdj9Thck6OL9SGu54bDaqzakSOeo2rT1KWkbF1tjzX9WjpJ/lP+1YnDjwnMELzLei7vzg9tLzu9BvTudw9mURqaO2irpt625vusUufDFsH9LPfOlDZ3m0TU3/7k4HRL05UsbgISmn74ffC4i99PiSHB8MAgjF2Is1MVYKCY72rsbOIDd8UyCCURjaMVrVEHdC7GhcDIlALaBQoKWZAaWqWFSIm2OWW4zlsmkvjOHOGAzGWlRsIuXCgsPLhiJ8tw8ki8UNwsv7DEn9rOp5NHrf0xfSxlR7eGwHQwKig1fbLdzYZTIgYag18dpWU4sA0eLmLTcw40elFDkR+WKdMnf8GRwGsGV58rrF+HhcV8kiXfvKrQuv69z6EvDyfy2fTs6vnd94PJn3GEVH7g+TfBVBZn+TW8cn33Ts68ZmBGbjCAYzWH98eFp/3qZDduSMMQ7fbjuPFZ/BbZ3mDKOPNMnRq5cq/gkcdag04UuaIPADGBjFI4zKlMvIM1Qt91YvsyYN+JVTQciaJcUd8SXkKClVLnG80nwGDSuiTGaXxY2XHdRSYG9AMhjIpIx+APYAAUYr1bSS+y1VvdpPGe8LoOK6K1tMA7gjWensdeIVN6BjhKnGkD10NY3p5JJvraA3Z17wxFP7stO+lW5q/htMNp4/snf/Ywo78lv0B2YG49ncFVOnpwVLpg7f1D31iFA5zHnXTfuN1YeFFF4Tsju0I1FCw0nUVb8JTUKjIUsEkL9PTHC9ilJA9NOQ/smQV2PFSbWOeJJZFbZP38T8aDtQEGF8guwNQFA+uUDHtjCOed+MuvQ+LVALWGbDqmBlXOtkcWsryws2OLZ+M6hoQWnaGdue+NNOnp4FR1QRHJutocscmUwyIBmByQttE9u8jvV6K0+9VYdE+Yea9LHT7/DveEwovPuVzqXTupmw6ObW2p33n0vntTxwI4O1vGb9LoEpPbB4ff/9dI+OfnkB+J4rX3H33hN7PfiLkNm2SLSz9UAW45yoaZmEIFYVxQgkbRmcvA7Ayg+mlBlIZMhlI/1zLc32MIpdMyuS/uuig2ef4ckVET9cT5Gg59jxJkosfArUEsE3GD/NL/OFyh2mre1j0PmD6RG01XxTb8l6w6KqCATu6ig3Tyal1c72eH+n9rnp4e+JJbnq+3KrXciGiBVE+2fnzQ/rN60P2BS95WzqbfyKfT8+s6+npX9RVwPKbVXB/kfYMr/9dA1X664mJqb/DTtYLiljlkcPBsH+965KvArT3YstKIvTD18oEs3Lktgy+DaO8N60LnUofoyxH2mBywERNaBhks8WUicyw4t4hYVobXGan5nE/1Ek5eXxriueIohvLcxAoHFQ887fkiCWj4j3rrpPC9D0xvMjwqn2q48lwZVJC4Mt6UXIQMBHgbGSl2nGwSDTehuGId00K0IsibjqFqRJwA6uaGm/GnAKf99Bd14lkE/kTsAfvtDNCYtUhV+BU6y925ZvGVq9c8ARO9XnaG/OeIUbl9mcDqPLgwWLxFT8fHPv+QHEGqiVcIEP9oeOSi0PzD68JVZzwPMyII8tl5W4Y6X6NslZ/ojCgcZAMnA24iVjVJwUpEURkaMziVgbmwRS0bvEe5ET9lf5cwRzVCWFY/imnhBqX0nfKBA0AKhcH8KAKl1kbvndAS610jshL2mDgU0tbP/X402hQ/XqZo1ZRtiJqi5UlVBq7oTRBmfOydYTdz+c27v/nI6jXU1oUEDjTdtLzQ+IdyNOwYNGH06nkTT2FbPnEZb0P42seLf6svp41oLLV2Mpy2L39Q3c/MV7Mii91CntyYGS1IVNgats2gBXbWbhujo6XtXOhAzcqHDQm98xnqONOJhF6jdxeKuAiqBgQNd0lktXpgGEgmamaA+qnsbAM3aptTMriDQgELlenaPGTUXFyo7yieooK4fXTetl2BvWnmv6ty1hWt0jMK5NKebLC5X4CF+m+RKD1adQnhEmjx3q7LV+XqTUaM6EejmxbO3TRl4b8G0+fTffM57bmsKCtqXTC0oWP4y0DwZ7117MKVLaeEVc/3bzjru1TpQVyHDlPeGNU0lexpeGhXyJqCfvekSFkUtjV4yYNTQ1sov5NVxKMRX38XV+T39TpNB6Ug0mg8kCJLFldilD6o16qDG4rMxaX6WFBdENJbibcw/clMqsDD3/rztFYX5aS5fvYxSWPYifYhHKOFMgKixs4IzZmoRqsovfuydaq0yrD6hRxkMbvdRJqm7JgUS6G5E5fH5KHHHpFOpP7ZDqdmZvf3jx+3KIuLoke8Ciop4v4Zx2oVvGWDYMj39g0Nvm6sQoyqnIwx0ZC6obrQuGyb0iYIA0sZguZAWjZexTfMWsI76hrxlhNrWj7wx6ifKzMpeaaBsTkcFkBpUpSL/nOXWF+rXoHWBozm/DBZHiyqcQs4P9JRKJIegYBkYlqcaHpeymRf3sF5TMaTQAet5YT0y7hHak6rUx/1bq4DtG4H1+1IG2vqzM6A/TF50TZn6HfKIu2hcIrXh2yrz1tKtHR/dfJVGrr/EJ+dO3K3pFnWx99MjAfLECV/hybnv7zu3cNXT4wPc2dgMIeKSS2yPzHJaH+4L2IokccKNiwiBA+GjCyoiVMFVvy8bZmfGZBGQ0mjIFGYC2sRyOiGawtu1YFWFpmipFH4jDXPFYU1bq+r4CgEcUNemRUlsNM0PxMuMvFK/+K2FIxJqASwJp+Spb1HDlK4Q2ANuA7o4oJb4A03Oqgum90D06WupBbWSsug8pKG9O7H7YudLzlHaF+yHO21LPZd6cT6bG1nR3963o7ePjDnrP7yVDzLHx2MAFVml8ul1fcMzB61fapqSMkuyS7G4nDwuX/HhJIXjs3OSU9SQu6BHale4g/en6A5nYSkSg2V2R/K7MIsNVv4EHbrbiGUd6SrwmfUyzyELAkgArFmbmyRWQTqJpoRw+DI2aoiiC3ifhbx3GtMGpEeip2I0eYqRpePweY1jmWsO5SkptNxO+BSfvMbEltl7RNJ5oztydIJkAJVkqOTFtLaHnDm8Gkr5oIbZ0PY1v1R3PJbGl1V+e2NfPbNx+sIJU2HqA9Uwd6juW3jE188P5dQ/+nUkc2C4rJOlxZSL9Y+fL5IbkJOj7iB6kjzgIgjKon084CgWKNk9UEqO664gDGehsNphyQRzbN4z2tBUZOESQ83IygRBqI0CQiFc8RUCogKPLJpIQWxX5F7oJhSADbJBDik6t16OUd6qP7o/xjd8Qr8vQbAzcDcywXQcTQVpw0K8J1w2SQ1TSVFKwRd2oz9lYOm4N+nz30sNC+/qyQXrn6rrlM9iM4KaXels2PrV3YtrGvrQ0pAw/u18EKVOm10WLlOQ8ODl4zOF3uI+qY3a82Ohxql18a6tdfC3k7ISAi46lhA3VAWJYM6el7bIQFDCpu6TPlET80qDSrsyBLWZZ6nolLJAcR8Og5WnqN6sc2QfCewOVPUfAWmy/q3Bd5IG2R3ZwEoKkpomIIA9K1ZCtqQuv6XglVfQ3ihzXPgJRogBcVRbwBNEL1UQSyHgWvJ8Pk+paE9nch1PHQw8YTre3vA5xH0qnM8MK21v7jF/fQqj9oDKanmioHNVCt4unNYxN/t3Fo9HPF2TlgB8fpkG2247ia714VKt/HFh0A1gEkbObLmhJ9b1tIBWiKAAGk/Elnu4FClkx5mJrt4xIQOcwUsKpy6A+zE/Je6skZRGaNwfcbHawmCovpoaINmApCwDOaSuiepUT+M2HuCKGsE9UWuZ5/eH21R5Q5Wb7MAJQSY42ZYhJYXWpatjy0veZ1If+84+up+Qs+OZdIPQbRVFzY0bRjZV/fw12w/54KGAfbd78PQPU+69k4NHbx42PFV1XrNahcurxU2wbAfufKULnl5jA3NChWu1rXJppheFURgieGkLClwo+A0b1ber0wkcGHK1UZfJYWY0rdVkq6KlYZ348Nw2bE4Rqsi4/BB+ziXleEOClMoJvh5JwubGtAZONkYUIfodNBsanAtfwC6k7jh/G+f7HBjE1V70Y2k1WrQxtOvW550Uu2pprbrsJkvIPaTXu+dfToNUsexClkB72Yf7JJ8vsEVKn/ZLm85uGB8esGy9UVggNNPR1qO3eG6e9fFaq33BBmt22FBIV9LpQD0W0imbmduLmQaoEEP5uVrzSlQBX3FMVzlIDCLH+UwZgALrPKAWoaPaI6Ic5KnRgZixYClAUF/wY/UwL4PKJL0kvH4PT5El1t90rZqvCqcSguLZ2EMt0E7NC1sVui48QTQufLXxHyxxw7Wk9n7sc3X8jOZUbac8nSos7WbcvnzRuwyjwZDg76z37vgGo9mtw1OfnqXVOVL4zOVJcgS55lBcIIIufoNM6in7nmu6GK1O31oSEZXFkeVW1UTg2pIbkwz8CiCOfKUhxKqIPvuz6V5wyQBLGgSbnVtx/PzZsXSkOjeyyTGvZjoDq6jC0jqMaYNT+q0rerHe6pUPeHfUfs4n1u0aLQ8bzjAdBTQmHNmjIm4AAm2NnpbHpqXnN+6/P6+hh9/6wvfx6IWfD7ClRve2KiVDp24/j0jSMzlVYFFSBGBZSHyA4MhjIO3p245qpQ/+VD2G4wJNn+RKfjJRhsHo85xUUEgJcb+Zh8WMlUFw90W4iiyRcJ1DySZ2FbC9LZLO4L05u3ozxLmGFM7QaYaJSmPkRyXVRSLYPi27xpAlD3pdJBq8/ipWB2WEf5vr7QhYOEua2mgIOEQ3PztpBKXYIm35dOJEut+fzk2tbujT09TbsOBEAOljJ+34Hq/ZjcMVk8fevE1GeL1XqXSEoaGWZnzGFT3tzoWCjfd3eo3vSDMId9+WUcx1hHVL9Y7ebeoptKDw/T1SmqAhV8R+ZV/6SCK9rcifd5bG9JrFgbBrCNJTaIVFzb5XKPagGx3ipC3NnVDLfoa7PwkzgPIdfTHTLtHaH7+ONCy1HPDflDDg1zhUI9lUhtqqfmTkeMQgb7l7Jd+baRvsXzHu+hp+wP8PWHAlQfmuymoYk3DFfLnyzN1nqRhpwuU6iFQl1YYALjcatzeTrMPrE5VB97JMz85MehjG3cZezhYrJdIoouKuqjoh6iAKYkouvL0+lQTfAEZc29C0PqkCPDjttv1e89RpCxARHvKiNLCJ6aPxGURHsVfy+vAWPO6w4tq9eE9qOPDs2rV4fCipXYNlPA9pkc8rElN8Irem4qkbkNNcjlM6n0vLb8FGJFmdrxgCUkOxhx/ocGVO/jxPT09OKhau29w8XK64u16rwqglvRWE3GkkhgxdREN1m1f0coPYJotsHBMHnHrWEWoE1UK6E8Nhpq5Yosm9INxfO01TWkIX/UUTsPPzrM9S0PW274gW1PVtYUkOoj5CVhfFxqExmv0l1TseOnkA8ty5aGruOOCwtPOQW6Zy9OFWGazmQJQTrbE4nMOyvJ2l2FdDoxv7S8PnBYqP+J+rd0BvwRvP5QgfqrQ5fePlpcNzAz8/6Z2uwrANqCRO9xZZFezUQiL2JYNvlN46wnhJvAa1DbiZObiyVhQGYlrHN1TIhPtVUe/FZfuDjsvvrbYde3rhBAq9R2NlU3mCAKLrJcd4ekGspBXUgjFWcL0mW2rV0bsgsWhpYVy+WzRDq9mZwOPfq1iWz2kbB8+ewfGyifbN79sQD114C7cWzs+ePF2bNnavXDAbhm0G0yUZuDy1TpTpYClAR5SgaC/JXA6KxXMY3VKSzjTkOV2H3pJWH4lhtpiEHZyNST+Wylbfnir841t/57orVruL23dyrdOTtTWHlCHVS/MJHL3JnCRkZsPQYwoQ0n0+9MrFnzAwLySuPgNypb/tEw5t6Ewh8rUH8NuFtKpZ7idOV4BMW8GphdORtqHSBVxFTPlQHaYay9k06HAV+sls7lIcRXIS6gWqlVvjs8OvCj2VJ1S3NLS3G8WKy3N2tm1lpT0+z81eP1yXDsHJTICHT/DcK9wfLXv/9voP7mPostnvgad2/yE76X9dlbgcnbwIYfaQDjxyLtNITGz72oyA1lH8TH8Oz/IB5sd3iq+99Ur6fT1v8P9YAlDDw6WtgAAAAASUVORK5CYII='
ICON_QUALITY_VIDEO = 'iVBORw0KGgoAAAANSUhEUgAAABoAAAAgCAYAAAAMq2gFAAAABHNCSVQICAgIfAhkiAAAABl0RVh0U29mdHdhcmUAZ25vbWUtc2NyZWVuc2hvdO8Dvz4AAAAmdEVYdENyZWF0aW9uIFRpbWUAc2V4IDMwIGp1biAyMDIzIDEyOjAwOjEwlD1n3AAAA5pJREFUSIntls9uI0UQxn9VPR5kJ5aQEOAsrJBQyMYrLlyQuPICvATHPXOEl+AVOCIOvALij8QJCa03oOUCm8R74c96sumZruLQPWNn7eyNCCF6ZI810+6vvq++qm4BnBsYehMgNwpU9T9mHJEAcATBcRSw8l7KxxEUwTAEwXB8D2QFAWjHTrhQlpxcARoY5YWEgCDliZVFQwEwwHEcQxG8LBBWYGMnASEpMjKeHQMjB756+AVBla6NaKVIEL79+gdi2xLbhHaKjwy/hNOzU9qnl9hlS9N1pKcdlzGy/9ILfPbpl1tAUjB4lbcAGeTKd8eLjFLYdfuOJkAcbcAK/03JmcCy+Wk3I3q9y2RHoBY8Osu0GMAcp1MnmHAwPoZIET1LKwjabBHaAKrhuwefgzqjUCFJeOeNDzhPi5x2BxPAhSoJiPNbs+B2dZdfuu/h0qDOahyO3r1eulc4LBH338qv6UfEBQkwk3kRyfHaefTkJNsswa36TlmK4lbh/DrXgWa5ACY5P4jgGO7rnFkthKhocFwNCUDdB+dFwue6LuF7iq6EJBBwXtfjweJeA1EgZglcoGqVVDkSrcBkkrajDwxPfE8JK2DihBV0Y8cHQQyL2V82NR6lBRhYMA50XryaZ6Z6d/McGOlKeNh8g1kkteCdYWakugQiwtsvvs/j30+yAxXMDNkziIq0QO1o6NlfB4Tz5uS9LEtpP1mOLF4aG8tugakhBjO9mztAm8sCBKJi60zvlq4d+0Zfkw36igABRVQgCaY5q9bqlbm59chOqAEoXCgycfqLOve4CkgkPvrkXo47wG2Zl3AsX+PSAdsCW28zGuroZQ6p0Gc6eB6255z/uRhmH4R5ERgCQpokQpPLw6ZZ2uXq5905konkyl+B1KV+Ys6UruC1MCfVIBGYONr0LQtohFTyyl+CT7d9t25BjZSADWJfegwWT4BEx/YFeSLFND2bgAKph7bn1NE6hcU5tQ97lE2dU7vPmZ1w/sd97n38IX2JVk1ACzOb5v6v7bYZNraJo6FPbXZqLxPO0gNcQMVwV2Z6By3mt7ETLqREnSVdcnWbuMpxAgnHa+nVp98CDsIxag4Gt/QILaIKUF3k+3oH3s7RwMgt4TgzndO7juGPgo4cHwneZLMQ8wbnjaAYitIVyT0Kj69j5A7uApNc54bTTfOpQGuBVvGmHEhGJe5mfWCBbHWJMgS5k9E/Pf57B8j/gf79QH8DArPbcDUdl/IAAAAASUVORK5CYII='
