﻿<%@ Page Language="C#" Inherits="Jokul.Forum.MvcApp.Pages.HomeViewPage<Jokul.Forum.MvcApp.Home.Models.HomeMainModel>" MasterPageFile="../Shared/home.master" %>

<asp:Content ContentPlaceHolderID="TitleContent" runat="server">首页</asp:Content>
<asp:Content ContentPlaceHolderID="HeadContent" runat="server">
    <link rel="alternate" type="application/rss+xml" title="RSS订阅" href="<%=Url.Action("RSS","Home") %>" />
</asp:Content>
<asp:Content ContentPlaceHolderID="MainContent" runat="server">
    
    <div class="globalInfo sp">
        <div class="forumInfo">
            <%=Html.Lang("ui.main.today_post_count")%>:<cite><%=Model.Statistic.TodayPost%></cite>,
            <%=Html.Lang("ui.main.yesterday_post_count")%>:<cite><%=Model.Statistic.YesterdayPost%></cite>,
            <%=Html.Lang("ui.main.total_post_count")%>:<em><%=Model.Statistic.TotalPost%></em>,
            <%=Html.Lang("ui.main.total_user_count")%>:<em><%=Model.Statistic.TotalUser%></em>
            <%if (Model.Statistic.LastUserId > 0){%>
                ,
                <%=Html.Lang("ui.main.new_user")%>:<a href="<%=Url.SiteAction("Show", "User", new { uid = Model.Statistic.LastUserId }) %>" title="最新注册的会员"><%=Model.Statistic.LastUserNickname %></a>
            <%} %>
        </div>
    </div>

    <%=Html.Partial("An", Model.Announcements, null) %>
    
    <%foreach(var MainBoard in Model.Boards){ %>
        <div class="box_panel list_panel sp board_panel">
            <input type="hidden" name="cookie_board_id" value="<%=MainBoard.Id %>" />
            <div class="box_panel_title">
                <a href="<%=Url.SiteAction("Show","Board",new{bid=MainBoard.Id}) %>"><%=MainBoard.Name %></a>
            </div>
            <div class="box_panel_context" id="board_<%=MainBoard.Id %>">
                <div class="list_panel_cut">
                    <%=Html.Partial("BoardList", MainBoard, null) %>
                </div>
            </div>
        </div>
    <%} %>
    
    <%if (Model.OnlineState!=null){ %>
        <div class="box_panel box_panel__color_easy sp online_panel">
            <div class="box_panel_title">
                <%=Html.ActionLink(Html.Lang("ui.online.panel.title"), "OnlineUsers", "User")%>
                在线 <%=Model.OnlineState.All %> 人,最高记录 <%=Model.Statistic.HighestOnline %> 于 <%=Html.FriendlyTime( Model.Statistic.HighestOnlineDateTime,"yyyy-MM-dd") %>.
            </div>
        </div>
    <%} %>

</asp:Content>