﻿<%@ Page Language="C#" Inherits="Jokul.Forum.MvcApp.Pages.HomeViewPage<Jokul.Forum.MvcApp.Home.Models.BoardShowModel>" MasterPageFile="../Shared/home.master" %>

<asp:Content ContentPlaceHolderID="TitleContent" runat="server">
    <%=Model.Board.Name %>
</asp:Content>
<asp:Content ContentPlaceHolderID="MainContent" runat="server">
    <div class="box_panel box_panel__color_easy board_rule_panel">
        <div class="board_rule_panel_title">
            今日：<strong><%=Model.Board.TodayTopicCount %></strong>
            <samp>|</samp>
            主题：<cite><%=Model.Board.TopicCount %></cite>
            <samp>|</samp>
            回复：<cite><%=Model.Board.PostCount %></cite>
        </div>
        <%if (Model.Board.Moderators.Count > 0){%>
            <div class="sp">
                版主:
                <%for (int i = 0; i < Model.Board.Moderators.Count; i++){ %>
                    <%if (i > 0){ %>,<%} %>
                    <a href="<%=Url.SiteAction("Show", "User", new { uid = Model.Board.Moderators[i].UserId })%>"><%=Model.Board.Moderators[i].Username %></a>
                <%} %>
            </div>
        <%} %>
    </div>

    <%if (Model.Boards.Count>0){ %>
        <div class="box_panel list_panel sp board_panel">
            <div class="box_panel_title">
                <%=Model.Board.Name %> 子版块
            </div>
            <div class="box_panel_context">
                <div class="list_panel_cut">
                    <%=Html.Partial("BoardList", Model.Board, null) %>
                </div>
            </div>
        </div>
    <%} %>

    <%if (Model.ShowTopic) { %>
        <div class="clearfix">
            <%if(Model.CanCreateTopic){ %>
                <div class="button_panel fl">
                    <ul>
                        <li>
                            <a href="<%=Url.Action("Create","Topic",new{bid=Model.Board.Id}) %>"><img src="<%=ResolveUrl("../../images/post_button.png")%>" /></a>
                        </li>
                    </ul>
                </div>
            <%}else{ %>
                <div class="no_ct">
                    您所在分组(<strong><%=Group.Name %></strong>)无法在此版发表主题
                    <%if (User.Id == 0) { %>
                        <br />您可以进行<a href="<%=Url.Action("Login","Account") %>">登录</a>或<a href="<%=Url.Action("Register","Account") %>">注册</a>
                    <%} %>
                </div>
            <%} %>
        </div>
        <%if(Model.Audited>0){ %>
            <div class="gginfo sp">
                <a href="<%=Url.Action("WTopics", "My", new {bid=Model.BoardId })%>">您在本版中有 <strong><%=Model.Audited %></strong> 条等待审核的主题</a>
            </div>
        <%} %>
        <div class="box_panel sp topic_list_panel">
            <div class="box_panel_title clearfix">
                <%=Model.Board.Name%>
            </div>
            <div class="topic_list_type clearfix">
                <ul>
                    <li<%if (Model.Type==0) {%> class="current"<%} %>><a href="<%=Url.SiteAction("Show", "Board", new { bid = Model.BoardId }) %>">全部</a></li>
                    <li<%if (Model.Type==1) {%> class="current"<%} %>><a href="<%=Url.SiteAction("Show", "Board",new { bid = Model.BoardId, type = 1}) %>">最新</a></li>
                    <li<%if (Model.Type==2) {%> class="current"<%} %>><a href="<%=Url.SiteAction("Show", "Board",new{ bid = Model.BoardId, type = 2 }) %>">精华</a></li>
                    <%if (Model.TopicTypes.Count > 0){ %>
                        <%foreach (var t in Model.TopicTypes) { %>
                            <li<%if (Model.Type==3 && Model.TopicType==t.Id) {%> class="current"<%} %>>
                                <a href="<%=Url.SiteAction("Show", "Board",new { bid=Model.BoardId,type=3,topicType=t.Id}) %>">
                                    <%=t.Name%>
                                </a>
                            </li>
                        <%} %>
                        <li<%if (Model.Type==3 && Model.TopicType==0) {%> class="current"<%} %>>
                            <a href="<%=Url.SiteAction("Show", "Board", new { bid = Model.BoardId, type = 3, topicType = 0 })%>">其它</a>
                        </li>
                    <%} %>
                </ul>
            </div>
            <div class="box_panel_context">
                <form method="post" name="moderate" action="admintopic.aspx">
                    <input type="hidden" name="bid" value="<%=Model.Board.Id%>" />
                    <input type="hidden" name="url" value="<%=Request.RawUrl%>" />
                    
                    <%if(Model.TopTopics.Count>0 || Model.Topics.Count>0){ %>
                            <div class="list_panel">
                                <table>
                                    <tbody>
                                        <%foreach (var topic in Model.TopTopics) { %>
                                            <tr>
                                                <td class="icon">
                                                    <a href="<%=Url.SiteAction("Show","Topic",new{tid=topic.Id}) %>" target="_blank">
                                                        <img src="<%=ResolveUrl("../../images/topic_state_"+topic.IconKey+".gif") %>" title="<%=Html.Encode(Html.Lang("topic.list.icon."+topic.IconKey)) %>" alt="<%=Html.Encode(Html.Lang("topic.list.icon."+topic.IconKey)) %>" />
                                                    </a>
                                                </td>
                                                <td class="title clearfix">
                                                    <%if (topic.Ban > 0) { %>
                                                        <del>
                                                            <a href="<%=Url.SiteAction("Show", "Topic", new { tid=topic.Id})%>">
                                                                <%if (Model.IsAdmin){ %>
                                                                        <%if (string.IsNullOrEmpty(topic.HighLight)) { %>
                                                                            <%=Html.Encode(Html.InterceptStr(topic.Title, 30 * 2, "..."))%>
                                                                        <%}else{ %>
                                                                            <span style="<%=topic.HighLight%>">
                                                                                <%=Html.Encode(Html.InterceptStr(topic.Title, 30 * 2, "..."))%>
                                                                            </span>
                                                                        <%} %>
                                                                <%}else{ %>
                                                                    此主题已经被管理人员屏蔽
                                                                <%} %>
                                                            </a>
                                                        </del>
                                                    <%}else{ %>
                                                        <a href="<%=Url.SiteAction("Show", "Topic", new { tid=topic.Id})%>">
                                                            <%if (string.IsNullOrEmpty(topic.HighLight)) { %>
                                                                <%=Html.Encode(Html.InterceptStr(topic.Title, 30 * 2, "..."))%>
                                                            <%}else{ %>
                                                                <span style="<%=topic.HighLight%>">
                                                                    <%=Html.Encode(Html.InterceptStr(topic.Title, 30 * 2, "..."))%>
                                                                </span>
                                                            <%} %>
                                                        </a>
                                                    <%} %>
                                                    <%if (topic.Rate != 0) { %>
                                                        <span class="topic_row_rate" title="评分">[<%=topic.Rate>=0?"+":"-" %><%=Math.Abs(topic.Rate).ToString("0.##") %>]</span>
                                                    <%} %>
                                                    <%if (topic.Attachment == (int)EAttachmentType.File) { %>
                                                        <span class="attachment_file" title="附件">[附件]</span>
                                                    <%}else if (topic.Attachment== (int)EAttachmentType.Image){ %>
                                                        <span class="attachment_image" title="图像">[图]</span>
                                                    <%} %>
                                                    <%if (topic.IsReplyNew) { %>
                                                        <span class="topic_new" title="新">[新]</span>
                                                    <%} %>
                                                    <br />
                                                    <span class="topic_row_ex">
                                                        <%if (topic.PostUserId>0){ %>
                                                            <a href="<%=Url.SiteAction("Show","User",new {uid=topic.PostUserId}) %>">
                                                                <%=topic.PostUsername %>
                                                            </a>
                                                        <%}else{ %>
                                                            <%=topic.PostUsername %>
                                                        <%} %>
                                                        (<%=Html.FriendlyTime(topic.PostDatetime, "yyyy-MM-dd HH:mm") %>)
                                                        <%if (topic.ReplayCount>0){ %>
                                                            回:<%=topic.ReplayCount %>
                                                        <%} %>
                                                    </span>
                                                </td>
                                            </tr>
                                        <%} %>
                                        <%if (Model.Topics.Count > 0 && Model.TopTopics.Count > 0){ %>
                                            </tbody>
                                            <tbody class="sptitle">
                                            <tr>
                                                <td colspan="5">版块主题</td>
                                            </tr>
                                            </tbody>
                                            <tbody>
                                        <%} %>
                                        <%foreach (var topic in Model.Topics) { %>
                                            <tr>
                                                <td class="icon">
                                                    <a href="<%=Url.SiteAction("Show","Topic",new{tid=topic.Id}) %>" target="_blank">
                                                        <img src="<%=ResolveUrl("../../images/topic_state_"+topic.IconKey+".gif") %>" title="<%=Html.Encode(Html.Lang("topic.list.icon."+topic.IconKey)) %>" alt="<%=Html.Encode(Html.Lang("topic.list.icon."+topic.IconKey)) %>" />
                                                    </a>
                                                </td>
                                                <td class="title">
                                                    <%if(topic.Board!=null){ %>
                                                        [<a href="<%=Url.SiteAction("Show","Board",new{bid=topic.BoardId}) %>"><%=topic.Board.Name%></a>]
                                                    <%} %>
                                                    <a href="<%=Url.SiteAction("Show","Topic",new{tid=topic.Id}) %>">
                                                        <%=Html.Encode(topic.Title) %>
                                                    </a>
                                                    <%if (topic.Rate != 0) { %>
                                                        <span class="topic_row_rate" title="评分">[<%=topic.Rate>=0?"+":"-" %><%=Math.Abs(topic.Rate).ToString("0.##") %>]</span>
                                                    <%} %>
                                                    <%if (topic.Attachment == (int)EAttachmentType.File) { %>
                                                        <span class="attachment_file" title="附件">[附件]</span>
                                                    <%}else if (topic.Attachment== (int)EAttachmentType.Image){ %>
                                                        <span class="attachment_image" title="图像">[图]</span>
                                                    <%} %>
                                                    <%if(topic.IsReplyNew){ %>
                                                        <span class="topic_new" title="新">[新]</span>
                                                    <%} %>
                                                    <br />
                                                    <span class="topic_row_ex">
                                                        <%if (topic.PostUserId>0){ %>
                                                            <a href="<%=Url.SiteAction("Show","User",new {uid=topic.PostUserId}) %>">
                                                                <%=topic.PostUsername %>
                                                            </a>
                                                        <%}else{ %>
                                                            <%=topic.PostUsername %>
                                                        <%} %>
                                                        (<%=Html.FriendlyTime(topic.PostDatetime, "yyyy-MM-dd HH:mm") %>)
                                                        <%if (topic.ReplayCount>0){ %>
                                                            回:<%=topic.ReplayCount %>
                                                        <%} %>
                                                    </span>
                                                </td>
                                            </tr>
                                        <%} %>
                                    </tbody>
                                </table>
                            </div>
                    <%}else{ %>
                        <div class="noitem">
                            本版块或指定的范围内尚无主题。
                        </div>
                    <%} %>
                </form>
            </div>
        </div>
        <div class="sp clearfix">
            <div class="page_panel fl">
                <%=Html.PagePartial(Model.PageState.PageIndex, Model.PageState.PageCount)%>
            </div>
        </div>

    <%} %>
</asp:Content>