﻿<%@ Page Language="C#" Inherits="System.Web.Mvc.ViewPage<Jokul.Forum.MvcApp.Home.Models.GroupUserModel>" MasterPageFile="../Shared/home.master" %>

<asp:Content ContentPlaceHolderID="TitleContent" runat="server"><%=Model.Username %> 的资料</asp:Content>

<asp:Content ContentPlaceHolderID="MainContent" runat="server">

    <%ExtendInfo[] extendInfo = ViewData["ExtendInfo"] as ExtendInfo[]; %>

    <div class="box_panel sp user_info_panel">
        <div class="box_panel_title"><%=Html.Lang("user.show.title",Model.Username) %></div>
        <div class="box_panel_context clearfix">
            <div class="user_info">
                <div class="ava">
                    <img src="<%=Url.Avatar120(Model.Id) %>" onerror="this.onerror=null;this.src='<%=ResolveUrl("../../images/avatar_none_120.jpg")%>'" />
                </div>
                <ul>
                    <li><%=Model.Username%></li>
                    <%if(!string.IsNullOrEmpty(Model.Group.Image)){ %>
                        <li><img src="<%=Model.Group.Image.StartsWith("http://",StringComparison.OrdinalIgnoreCase)?Model.Group.Image: ResolveUrl("../../../../static/images/group/" + Model.Group.Image)%>" alt="<%=Model.Group.Name %>" title="<%=Model.Group.Name %>" /></li>
                    <%} %>
                    <li>
                        <label>用户组:</label><%=Model.Group.Name%></li>
                    <li>
                        <label>UID:</label><%=Model.Id%>
                    </li>
                    <li>
                        <label>在线:</label><%=Model.Online%> 小时
                    </li>
                    <li>
                        <label>主题:</label><%=Model.TopicCount%>
                    </li>
                    <li>
                        <label>帖子:</label><%=Model.PostCount%>
                    </li>
                    <li>
                        <label>精华:</label><%=Model.PostDigestCount%>
                    </li>
                    <li>
                        <label>积分:</label><%=Model.Credit.ToString("0.####")%>
                    </li>
                    <%for (int i = 0; i < extendInfo.Length; i++) {%>
                    <%if (extendInfo[i].Enabled) { %>
                    <li>
                        <label><%=extendInfo[i].Name%>:</label>
                        <%=Model.Credits[i].ToString("0.####")%> <%=extendInfo[i].Unit%>
                    </li>
                    <%}//if%>
                    <%}//for%>
                </ul>
            </div>
            <div class="info">
                <ul>
                    <li>
                        <label>注册日期:</label><%=Html.FriendlyTime(Model.CreateDateTime, "yyyy-MM-dd HH:mm")%>
                    </li>
                    <li>
                        <label>注册 IP:</label><%=Model.CreateIP%>
                    </li>
                    <li>
                        <label>最后访问(登录):</label><%=Html.FriendlyTime(Model.LastDateTime, "yyyy-MM-dd HH:mm") %>
                    </li>
                    <li>
                        <label>最后访问IP(登录):</label><%=Model.LastIP%>&nbsp;
                    </li>
                </ul>
                <ul>
                    <li>
                        <label>性别:</label>
                        <%if (Model.Gender == 1) { %>
                        男
                        <%} else if (Model.Gender == 2) { %>
                        女
                        <%} else { %>
                        保密
                        <%} %>
                    </li>
                    <li>
                        <label>QQ:</label><%=Model.QQ%>&nbsp;
                    </li>
                    <li>
                        <label>MSN:</label><%=Model.MSN%>&nbsp;
                    </li>
                    <li>
                        <label>主页:</label><%=Model.Site%>&nbsp;
                    </li>
                    <li>
                        <label>来自:</label><%=Model.Address%>&nbsp;
                    </li>
                    <li>
                        <label>个人简介:</label><br />
                        <%=Model.Bio%>&nbsp;
                    </li>
                    <li>
                        <label>个性签名:</label><br />
                        <%=Model.Signature%>&nbsp;
                    </li>
                </ul>
            </div>
        </div>
    </div>



</asp:Content>