﻿<%@ Page Language="C#" Inherits="System.Web.Mvc.ViewPage<Jokul.Forum.MvcApp.Home.Models.UserPageModel>" MasterPageFile="../Shared/home.master" %>

<asp:Content ContentPlaceHolderID="TitleContent" runat="server">会员列表</asp:Content>

<asp:Content ContentPlaceHolderID="MainContent" runat="server">

    <div class="sp clearfix">
        <div class="page_panel fr">
            <%=Html.PagePartial(Model.PageIndex, Model.PageCount)%>
        </div>
    </div>

<div class="box_panel list_panel sp">

	<div class="box_panel_title">会员列表</div>
	<div class="box_panel_context">
	    <div class="list_panel_cut">
	        <table>
	            <thead>
                    <tr>
                        <td>用户名</td>
                        <td>组</td>
                        <td>性别</td>
                        <td>注册日期</td>
                        <td>上次访问</td>
                        <td>帖子</td>
                        <td>积分</td>
                    </tr>
	            </thead>
                <tbody>
                    <%foreach(var user in Model.UserItems){ %>
                    <tr>
                        <td>
                            <%=Html.ActionLink(user.Username,"Show","User",new{uid=user.Id},null) %>
                        </td>
                        <td>
                            <%=user.Group.Name %></td>
                        <td>
                            <%if (user.Gender==1){ %>
                                <img src="<%=ResolveUrl("../../images/sex_male.gif") %>" title="男" />
                            <%}else if(user.Gender==2){ %>
                                <img src="<%=ResolveUrl("../../images/sex_female.gif") %>" title="女" />
                            <%}else{ %>
                                保密
                            <%} %>
                        </td>
                        <td><%=Html.FriendlyTime(user.CreateDateTime, "yyyy-MM-dd HH:mm")%></td>
                        <td><%=Html.FriendlyTime( user.LastDateTime,"yyyy-MM-dd HH:mm") %></td>
                        <td><%=user.PostCount %></td>
                        <td><%=user.Credit.ToString("0.####") %></td>
                    </tr>
                    <%} %>
                </tbody>
            </table>
        </div>
    </div>
</div>

    <div class="sp clearfix">
        <div class="page_panel fr">
            <%=Html.PagePartial(Model.PageIndex, Model.PageCount)%>
        </div>
    </div>


</asp:Content>