﻿<%@ Page Language="C#" Inherits="System.Web.Mvc.ViewPage<Jokul.Forum.MvcApp.Home.Models.RatePageModel>" MasterPageFile="../Shared/home.master" %>

<asp:Content ContentPlaceHolderID="TitleContent" runat="server">会员列表</asp:Content>

<asp:Content ContentPlaceHolderID="MainContent" runat="server">

    <div class="sp clearfix">
        <div class="page_panel fr">
            <%=Html.PagePartial(Model.PageIndex, Model.PageCount)%>
        </div>
    </div>

<div class="box_panel list_panel sp">

	<div class="box_panel_title">评分列表</div>
	<div class="box_panel_context">
	    <div class="list_panel_cut">
	        <table>
	            <thead>
                    <tr>
                        <td style="width:160px;">已有<em><%=Model.Rate.UserCount %></em>人评分</td>
                        <%for (int i = 0; i < Model.Points.Length; i++) {%>
                            <%if (Model.Points[i].Enabled && Model.Rate.Credits[i]!=0) { %>
                                <td style="width:60px;"><%=Model.Points[i].Name%></td>
                            <%}//if%>
                        <%}//for%>
                        <td>理由</td>
                    </tr>
	            </thead>
                <tbody>
                    <%foreach(var rate_user in Model.Items){  %>
                        <tr>
                            <td>
                                <a href="<%=Url.SiteAction("Show", "User", new { uid=rate_user.UserId})%>" target="_blank"><%=rate_user.Username %></a>
                            </td>
                            <%for (int i = 0; i < Model.Points.Length; i++) {%>
                                <%if (Model.Points[i].Enabled && Model.Rate.Credits[i] != 0) { %>
                                    <td><%=rate_user.Credits[i]!=0?rate_user.Credits[i].ToString("0.####"):"-"%></td>
                                <%}//if%>
                            <%}//for%>
                            <td class="description"><%=Html.Encode(rate_user.Reason) %></td>
                        </tr>
                    <%} %>
                </tbody>
            </table>
        </div>
    </div>
</div>

    <div class="sp clearfix">
        <div class="page_panel fr">
            <%=Html.PagePartial(Model.PageIndex, Model.PageCount)%>
        </div>
    </div>


</asp:Content>