﻿<%@ Page Language="C#" Inherits="System.Web.Mvc.ViewPage<Jokul.Forum.MvcApp.Home.Models.TopicManageModel>" MasterPageFile="../Shared/home.master" %>

<asp:Content ContentPlaceHolderID="TitleContent" runat="server">高亮主题</asp:Content>
<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" runat="server">
    <link href="<%=this.ResolveUrl ("../../scripts/easydialog/easydialog.css") %>" rel="stylesheet" type="text/css" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="FootContent" runat="server">

    <script src="<%=this.ResolveUrl ("../../scripts/easydialog/easydialog.js") %>" type="text/javascript"></script>
    <script src="<%=this.ResolveUrl ("../../scripts/jquery.form.js") %>" type="text/javascript"></script>
    <script type="text/javascript">
        $(document).ready(function () {
            $.each($('select[name="color"] option'),function(i,n){
                $(this).css({ color: $(this).val(), background: $(this).val() });
            });

            $("#reson").change(function () {
                var me = $(this);
                var c = $("form textarea");
                c.val(me.val())
                c.text(me.val());
            });

            var options = {
                beforeSubmit: function(formData, jqForm, options) {
                    easyDialog.open({container : {content : '正在提交。。。'}});
                    return true;
                },
                success: function(responseText, statusText) {
                    if (!responseText.error)
                    {
                        top.location.href=responseText.url;
                        return;
                    }
                    easyDialog.open({container : {header : '提示',content : responseText.description,noFn : true}});
                },
                error: function() {
                    easyDialog.open({container : {header : '提示',content : "服务器通讯失败",noFn : true}});
                },
                complete:function(){
                },
                url: "<%=Url.Action("Topic_HighLight","Handler") %>",
                type: 'post',
                dataType: 'json'
            };
            $("#post").ajaxForm(options);
        });
    </script>
</asp:Content>
<asp:Content ContentPlaceHolderID="MainContent" runat="server">

    <div class="box_panel manage_panel">
        <div class="box_panel_title">高亮主题</div>
        <div class="box_panel_context form_panel_b">
            <form id="post" method="post" action="<%=Html.Encode(Request.Url.AbsoluteUri) %>">
                <input name="url" type="hidden" value="<%=Model.ResultUrl %>" />
                <input name="bid" type="hidden" value="<%=Model.BId%>" />

                <dl>
                    <dt>
                        高亮
                    </dt>
                    <dd>
                        <label>
                            <input type="checkbox" value="1" name="highlight_style_b" />
                            <strong>粗体</strong>
                        </label>
                        <label>
                            <input type="checkbox" value="1" name="highlight_style_i" />
                            <em>斜体</em>
                        </label>
                        <label>
                            <input type="checkbox" value="1" name="highlight_style_u" />
                            <u>下划线</u>
                        </label>
		                <select name="color">
			                <option value="">颜色未选择</option>
			                <option value="#EE1B2E">#EE1B2E</option>
			                <option value="#EE5023">#EE5023</option>
			                <option value="#996600">#996600</option>
			                <option value="#3C9D40">#3C9D40</option>
			                <option value="#2897C5">#2897C5</option>
			                <option value="#2B65B7">#2B65B7</option>
			                <option value="#8F2A90">#8F2A90</option>
			                <option value="#EC1282">#EC1282</option>
			                <option value="#000000">#000000</option>
		                </select>
                        <div class="description">设置主题标题的显示样式</div>
                    </dd>
                </dl>
                <dl>
                    <dt>
                        原因
                    </dt>
                    <dd>
                        <%if (Model.ManageReason.Length > 0){ %>
                            <div>
                            快捷原因：
                            <select id="reson">
                                <option value="">自定义</option>
                                <option value="">-----</option>
                                <%foreach (var reason in Model.ManageReason){ %>
                                    <option value="<%=Server.HtmlEncode(reason) %>"><%=string.IsNullOrEmpty(reason)?"-----":reason %></option>
                                <%} %>
                            </select>
                            </div>
                        <%} %>
                        <div class="text_area">
                            <textarea cols="50" rows="5" name="reason"></textarea>
                        </div>
                    </dd>
                </dl>
                <dl>
                    <dt>通知</dt>
                    <dd>
                        <input id="send_short_message" type="checkbox" name="send_message" value="1" checked="checked" />
                        <label for="send_short_message">操作后将以站内信方式通知作者</label>
                    </dd>
                </dl>
                <dl>
                    <dt>
                        相关主题
                    </dt>
                    <dd class="ul_list">
                        <ul>
                            <%foreach (var topic in Model.Topics){ %>
                                <li>
                                    <input id="topic_<%=topic.Id %>" type="checkbox" name="tids" value="<%=topic.Id %>" checked="checked"/>
                                    <label for="topic_<%=topic.Id %>"><%=Html.Encode(topic.Title) %></label>
                                </li>
                            <%} %>
                        </ul>
                    </dd>
                </dl>
                <div class="control button_bar clearfix">
                    <ul>
                        <li>
                            <button type="submit" name="ok" value="ok" class="button skyblue">确认</button>
                        </li>
                        <li>
                            <button type="button" name="cancel" value="cancel" onclick="javascript: history.go(-1);" class="button">返回</button>
                        </li>
                    </ul>
                </div>
            </form>
        </div>
    </div>


</asp:Content>