﻿<%@ Page Language="C#" Inherits="Jokul.Forum.MvcApp.Pages.HomeViewPage<Jokul.Forum.MvcApp.Home.Models.MyMainModel>" MasterPageFile="../Shared/home.master" %>

<asp:Content ContentPlaceHolderID="TitleContent" runat="server">我的</asp:Content>

<asp:Content ContentPlaceHolderID="MainContent" runat="server">


<div class="box_panel sp clearfix my_area">
    <%Html.RenderPartial("Menu", "My", ViewData);%>
    <div class="content">
        <%=RenderPluginPoint("my.main.content.top") %>
        <div class="my_info clearfix">
            <div class="my_info_side">
                <div class="ava">
                    <img src="<%=Url.Avatar120( Model.UserInfo.Id) %>" />
                </div>
            </div>
            <div class="my_info_context">
                <ul class="clearfix">
                    <li><label>帐号:</label><%=Model.UserInfo.Username%></li>
                    <li><label>UID:</label><%=Model.UserInfo.Id%></li>
                    <li><label>用户组:</label><%=Model.UserInfo.Group.Name%></li>
                    <li>
                        <label>积分:</label><%=Model.UserInfo.Credit.ToString("0.####")%>
                    </li>
                    <li>
                        <label>注册日期:</label><%=Html.ForumTime(Model.UserInfo.CreateDateTime)%>
                    </li>
                    <li>
                        <label>注册IP:</label><%=Model.UserInfo.CreateIP%>
                    </li>
                    <li>
                        <label>最后访问:</label><%=Html.ForumTime(Model.UserInfo.LastDateTime)%>
                    </li>
                </ul>
            </div>
        </div>
        <%if (Config.Module.MyPassword || Config.Module.MyEmail || Config.Module.MyQA){ %>
        <div class="box_panel list_panel topic_list_panel sp">
            <div class="box_panel_title">帐号安全</div>
	        <div class="box_panel_context form_panel_b">
                <dl>
                    <%if (Config.Module.MyPassword){ %>
                    <dt>帐号密码</dt>
                    <dd>
                        <%if(Model.SafeState.HasPassword){%>
                            [<a href="<%=Url.Action("Password","My") %>">更改登录密码</a>]
                        <%}else{ %>
                            [<a href="<%=Url.Action("Password","My") %>">创建一个帐号独立登录密码</a>]
                        <%} %>
                        <div class="description">英文加数字或符号的组合密码，安全性更高，建议您定期更换密码。</div>
                    </dd>
                    <%} %>
                    <%if (Config.Module.MyQA){ %>
                    <dt>密保问答</dt>
                    <dd>
                        <%if(Model.SafeState.HasQA){%>
                            已经设置<br />
                            [<a href="<%=Url.Action("QA","My") %>">更改密保问答</a>]
                        <%}else{ %>
                            未设置密保问答，您现在可以[<a href="<%=Url.Action("QA","My") %>">创建一个密保问答</a>]
                        <%} %>
                        <div class="description">当密码丢失或记不住密码时，可以通过回答设置好的密保问题来重新更改密码。</div>
                    </dd>
                    <%} %>
                    <%if (Config.Module.MyEmail){ %>
                    <dt>密保信箱</dt>
                    <dd>
                        <%if(Model.SafeState.HasEmail){%>
                            <%=Model.SafeState.Email %><br />
                            [<a href="<%=Url.Action("Email","My") %>">更改密保信箱</a>]
                        <%}else{ %>
                            未设置密保信箱，您现在可以[<a href="<%=Url.Action("Email","My") %>">绑定一个密保信箱</a>]
                        <%} %>
                        <div class="description">忘记密码时，您的绑定邮箱可以帮您找回密码。</div>
                    </dd>
                    <%} %>
                </dl>
            </div>
        </div>
        <%} %>
        <%if(Model.BindList.Any()){ %>
        <div class="box_panel list_panel topic_list_panel sp">
            <div class="box_panel_title">登录绑定</div>
	        <div class="box_panel_context form_panel_b">
                <dl>
                    <%foreach(var b in Model.BindList){ %>
                    <dt><%=b.OAuthName %></dt>
                    <dd>
                        <%if(b.Bind){%>
                        成功绑定[<a href="<%=Url.Action("OAuthUnbind", "Account", new {key=b.OAuthKey,url=Request.Url.AbsoluteUri })%>">解除绑定</a>]
                        <%}else{ %>
                        未绑定[<a href="<%=Url.Action("OAuthLogin", "Account", new {key=b.OAuthKey,url=Request.Url.AbsoluteUri,act="bind" })%>">现在绑定</a>]
                        <%} %>
                    </dd>
                    <%} %>
                </dl>
            </div>
        </div>
        <%} %>
        <%=RenderPluginPoint("my.main.content.bottom") %>
    </div>
</div>



</asp:Content>