﻿<%@ Page Language="C#" Inherits="Jokul.Forum.MvcApp.Pages.HomeViewPage<Jokul.Forum.MvcApp.Home.Models.MyFavoriteBoardsModel>" MasterPageFile="../Shared/home.master" %>

<asp:Content ContentPlaceHolderID="TitleContent" runat="server">我收藏的版块</asp:Content>

<asp:Content ContentPlaceHolderID="MainContent" runat="server">

<div class="box_panel sp clearfix my_area">
    <%Html.RenderPartial("Menu", "FavoriteBoards", ViewData);%>
    <div class="content">
        <div class="box_panel">
            <div class="box_panel_title">我收藏的版块</div>
	        <div class="box_panel_context">
                <div class="list_panel list_panel_cut">
                    <table>
                        <thead>
                            <tr>
                                <td class="title">版块</td>
                                <td class="topic">主题</td>
                                <td class="reply">帖数</td>
                                <td class="manage">管理</td>
                            </tr>
                        </thead>
                        <tbody>
                            <%if(Model.DataItem.Length>0){ %>
                                <%foreach(var favorite in Model.DataItem){ %>
                                    <tr>
                                        <td class="title"><a href="<%=Url.SiteAction("Show","Board",new{bid=favorite.BoardId}) %>"><%=favorite.Name%></a></td>
                                        <td class="topic">
                                            <%=favorite.TopicCount%>
                                        </td>
                                        <td class="reply">
                                            <%=favorite.PostCount%>
                                        </td>
                                        <td class="manage"><a href="<%=Url.Action("FavoriteDelete", "My", new { id=favorite.Id})%>" onclick = "javascript:return window.confirm('确定要删除吗?');">删除</a></td>
                                    </tr>
                                <%}//foreach %>
                            <%}else{ %>
                                <tr>
                                    <td colspan="4">无记录</td>
                                </tr>
                            <%}//if %>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>



</asp:Content>