﻿<%@ Page Language="C#" MasterPageFile="../Shared/home.master" Inherits="Jokul.Forum.MvcApp.Pages.HomeViewPage<Jokul.Forum.MvcApp.Home.Models.MyEmailModel>" %>


<asp:Content ContentPlaceHolderID="TitleContent" runat="server">安全邮箱</asp:Content>
<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" runat="server">
    <link href="<%=this.ResolveUrl ("../../scripts/easydialog/easydialog.css") %>" rel="stylesheet" type="text/css" />
</asp:Content>
<asp:Content ContentPlaceHolderID="FootContent" runat="server">
    <script src="<%=this.ResolveUrl ("../../scripts/easydialog/easydialog.js") %>" type="text/javascript"></script>
    <script src="<%=this.ResolveUrl ("../../scripts/jquery.form.js") %>" type="text/javascript"></script>
    <script type="text/javascript">
        $(document).ready(function () {

                var options = {
                    beforeSubmit: function (formData, jqForm, options) {
                        easyDialog.open({container : {content : '正在提交。。。'}});
                        return true;
                    },
                    success: function (data, statusText) {
                        if (data.error) {
                            easyDialog.open({container : {header : '提示',content : data.description,noFn : true}});
                            return;
                        }
                        easyDialog.close();
                        easyDialog.open({container : {content : '更改成功'},autoClose : 2000,overlay : false});
                    },
                    error: function () {
                        easyDialog.open({container : {
                                header : '提示',
                                content : "服务器通讯失败",
                                noFn : true
                            }});
                    },
                    url: "<%=Url.Action("My_UpdatePassword","Handler") %>",
                    type: 'post',
                    dataType: 'json',
                    clearForm: false
                };
                $("#post1").ajaxForm(options);
        });
    </script>
</asp:Content>
<asp:Content ContentPlaceHolderID="MainContent" runat="server">

<div class="box_panel sp clearfix my_area">
    <%Html.RenderPartial("Menu", "Email", ViewData);%>
    <div class="content">
        <div class="box_panel list_panel">
            <div class="box_panel_title">安全邮箱</div>
	        <div class="box_panel_context form_panel_b">
                <form id="post" method="post" action="<%=Html.Encode(Request.Url.AbsoluteUri) %>">
                    <%if(Model.Validated){ %>
                        <dl>
                            <dt>Email信箱</dt>
                            <dd>
                                <%=Model.Email %>
                                <%if (Model.Validated) { %>
                                    (已验证)
                                <%}else{ %>
                                    (未验证)
                                <%} %>
                            </dd>
                        </dl>
                    <%} %>
                    <dl>
                        <%if(Model.Validated){ %>
                            <dt>当前安全邮箱</dt>
                            <dd>
                                <input type="text" name="current_email" />
                            </dd>
                        <%} %>
                        <dt>新安全邮箱</dt>
                        <dd>
                            <input type="text" name="email" />
                        </dd>
                    </dl>
                    <div class="control button_panel clearfix">
                        <ul>
                            <li><button type="submit" name="Ok" class="button skyblue">确认</button></li>
                        </ul>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>



</asp:Content>