﻿<%@ Page Title="" Language="C#" MasterPageFile="../Shared/AdminInside.Master" Inherits="System.Web.Mvc.ViewPage<Jokul.Forum.MvcApp.Admin.Models.AdminUser_List_Model>" %>
<asp:Content ID="Content1" ContentPlaceHolderID="TitleContent" runat="server">
    用户管理
</asp:Content>
<asp:Content ID="Content4" ContentPlaceHolderID="FeaturedContent" runat="server">
    <%Html.SetString("menu.a", "user"); %>
    <%Html.SetString("menu.b", "user"); %>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="FootContent" runat="server">
    <script type="text/javascript">
        function page(p) {
        }
        $(function () {
            $('.sync-pagination').empty();
            $('.sync-pagination').twbsPagination({
                totalPages: <%=Model.PageCount%>,
                visiblePages: 7,
                startPage:<%=Model.PageIndex%>,
                first:'首页',
                prev:'上一页',
                next:'下一页',
                last:'尾页',
                onPageClick: function (event, page) {
                    if(page==<%=Model.PageIndex%>)
                        return;
                    $.jokul.wait("请稍候...",false);
                    setTimeout(function(){
                        $("#form_page input[name='page']").val(page);
                        $("#form_page").submit();
                    },1000); 
                }
            });
        });
    </script>
</asp:Content>
<asp:Content ID="Content3" ContentPlaceHolderID="MainContent" runat="server">

        <div class="alert area">
            如果要管理用户帐号基本信息请到 <a href="<%=Url.Action("Passport","Admin",new{key="user"}) %>" target="_blank">Jokul Passport</a> 中进行。
        </div>
        <div class="area">
            <a href="<%=Url.Action("Activate","User") %>" class="btn btn-primary">通过 Jokul Passport 中的帐号激活论坛的用户</a>
        </div>
        <form id="form_page" method="get" action="<%=Html.Encode(Request.Url.AbsoluteUri) %>">
            <%=Html.Hidden("act", "search")%>
            <%=Html.Hidden("page",Model.PageIndex) %>
            <%=Html.Hidden("userId",Model.UserId) %>
            <%=Html.Hidden("username",Model.Username) %>
            <%=Html.Hidden("usernameCheck",Model.UsernameCheck) %>
            <%=Html.Hidden("groupId",Model.GroupId) %>
            <%=Html.Hidden("createIp", Model.CreateIp)%>
            <%=Html.Hidden("lastIp", Model.LastIp)%>
            <%=Html.Hidden("email", Model.Email)%>
        </form>
        <div id="div_search" class="panel panel-form area">
            <form id="form_search" method="get" action="<%=Html.Encode(Request.Url.AbsoluteUri) %>" class="form-horizontal form-jokul-horizontal">
                <%=Html.Hidden("act", "search")%>
                <div class="control-group">
                    <label class="control-label">UID</label>
                    <div class="controls">
                        <%=Html.TextBoxFor(m => m.UserId, new {@class="text",size="50" })%>
                    </div>
                </div>
                <div class="control-group">
                    <label class="control-label">用户名</label>
                    <div class="controls">
                        <%=Html.TextBoxFor(m => m.Username, new { @class = "text", size = "50" })%>
                        <label class="checkbox inline">
                        <%=Html.CheckBoxFor(m => m.UsernameCheck)%>
                            模糊
                        </label>
                    </div>
                </div>
                <div class="control-group">
                    <label class="control-label">组别</label>
                    <div class="controls">
                        <%=Html.DropDownListFor(m => m.GroupId, new SelectList(Model.Group, "Id", "Name", Model.GroupId), "全部", null)%>
                    </div>
                </div>
                <div class="control-group">
                    <label class="control-label">注册IP</label>
                    <div class="controls">
                        <%=Html.TextBoxFor(m => m.CreateIp, new { @class = "text", size = "50" })%>
                    </div>
                </div>
                <div class="control-group">
                    <label class="control-label">最后登录IP</label>
                    <div class="controls">
                        <%=Html.TextBoxFor(m => m.LastIp, new { @class = "text", size = "50" })%>
                    </div>
                </div>
                <div class="control-group">
                    <label class="control-label">Email</label>
                    <div class="controls">
                        <%=Html.TextBoxFor(m => m.Email, new { @class = "text", size = "50" })%>
                    </div>
                </div>
                <div class="control-group">
                    <div class="controls">
                        <button type="submit" value="Search" class="btn btn-primary">查询</button>
                    </div>
                </div>

            </form>
        </div>
        <div id="div_search_list" class="area">
            <form id="form_search_list" method="post" action="<%=Html.Encode(Request.Url.AbsoluteUri) %>">
                <table class="table table-bordered table-hover">
                    <thead>
                        <tr>
                            <th class="span1 center" style="width:50px;">头像
                            </th>
                            <th class="span1 center">UID
                            </th>
                            <th class="span2 center">分组
                            </th>
                            <th>帐号
                            </th>
                            <th class="span2 center">创建
                            </th>
                            <th class="span2 center">最后
                            </th>
                            <th class="span3 center">操作
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                        <%if (Model.List.Count > 0){ %>
                            <%foreach (var user in Model.List){ %>
                                <tr>
                                    <th>
                                        <img src="<%=Url.Avatar50( user.Id) %>" onerror="this.onerror=null;this.src='<%=ResolveUrl("../../images/avatar/none_50.jpg")%>'" alt="头像" style="width:100%;" />
                                    </th>
                                    <th class="center middle">
                                        <%=user.Id%>
                                    </th>
                                    <td class="center middle">
                                        <%=user.GroupName %>
                                        <%if (!string.IsNullOrEmpty(user.GroupImage)){ %>
                                            <br /><img src="<%=user.GroupImage.StartsWith("http://",StringComparison.OrdinalIgnoreCase)?user.GroupImage: ResolveUrl("../../../../static/images/group/" + user.GroupImage)%>" alt="group" />
                                        <%} %>
                                    </td>
                                    <td class="middle">
                                        <%=user.Username%>
                                        <%if (user.Inactivate){ %>
                                            [等待管理员验证]
                                        <%} %>
                                        <br />
                                        <%=user.Email%>
                                    </td>
                                    <td class="center middle">
                                        <%=user.CreateIp%><br />
                                        <%=Html.ForumTime( user.CreateDateTime).ToString("yyyy-MM-dd HH:mm:ss") %>
                                    </td>
                                    <td class="center middle">
                                        <%=user.LastIp%><br />
                                        <%=Html.ForumTime(user.LastDateTime).ToString("yyyy-MM-dd HH:mm:ss") %>
                                    </td>
                                    <td class="center middle">
                                        <div class="btn-group">
                                            <button type="button" class="btn btn-small" data-act="go" data-redirect="<%=Url.Action("Update", "User", new { id = user.Id })%>">编辑</button>
                                            <button type="button" class="btn btn-small" data-act="go" data-redirect="<%=Url.Action("Medal", "User", new { uid = user.Id })%>">勋章</button>
                                        </div>
                                        <button type="button" class="btn btn-small btn-danger" data-act="delete" data-redirect="<%=Url.Action("Delete", new { id = user.Id })%>" data-confirm-message="您确定要删除吗?">删除</button>
                                    </td>
                                </tr>
                            <%} %>
                        <%}else{ %>
                            <tr>
                                <td colspan="5">
                                    无相关数据
                                </td>
                            </tr>
                        <%} %>
                    </tbody>
                </table>
            </form>
        </div>
        <div class="pagination area sync-pagination">pages loading</div>
</asp:Content>
