﻿<%@ Page Title="" Language="C#" MasterPageFile="../Shared/AdminInside.Master" Inherits="System.Web.Mvc.ViewPage<Jokul.Forum.MvcApp.Admin.Models.AdminSetting_Attachment_Model>" %>
<asp:Content ID="Content1" ContentPlaceHolderID="TitleContent" runat="server">
附件设置
</asp:Content>
<asp:Content ID="Content4" ContentPlaceHolderID="FeaturedContent" runat="server">
    <%Html.SetString("menu.a", "setting"); %>
    <%Html.SetString("menu.b", "setting.attachment"); %>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="FootContent" runat="server">
<script type="text/javascript">
    $(document).ready(function () {

        $("input[name=\"WaterMarkType\"]").change(function () {
            var control = $(this);
            if (!control.is(":checked"))
                return;
            var val = parseInt(control.val());

            $(".water").hide();
            switch (val) {
                case 1:
                    $(".water_text").show();
                    break;
                case 2:
                    $(".water_image").show();
                    break;
            }
        }).change();
        
        $("input[name=\"thumb\"]").change(function(){
            var control=$(this);
            if(!control.attr("checked"))
                return;
            var val=parseInt(control.val());
            if(val>0)
                $(".thumb_size").show();
            else
                $(".thumb_size").hide();
        }).change();

        //提交
        {
            var options = {
                beforeSubmit: function (formData, jqForm, options) {
                    $('button[name=\"ok\"]').button('loading');
                    return true;
                },
                success: function (data, statusText) {
                    if (data.error) {
                        $.jokul.alert(data.description);
                        return;
                    }
                    $.jokul.alert("保存成功");
                },
                error: function () {
                    $.jokul.alert("服务器通讯失败");
                },
                complete: function () {
                    $('button[name=\"ok\"]').button('reset');
                },
                url: "<%=Url.Action("Setting_Attachment","Handler") %>",
                type: 'post',
                dataType: 'json'
            };
            $("#main_form").ajaxForm(options);
        }
    });
</script>
</asp:Content>
<asp:Content ID="Content3" ContentPlaceHolderID="MainContent" runat="server">


        
<div class="area area-form">
<form id="main_form" action="<%=Html.Encode(Request.Url.AbsoluteUri) %>" method="post" class="form-horizontal form-jokul-horizontal">
    <div class="control-group">
        <label class="control-label">
            下载附件来路检查
        </label>
        <div class="controls">
            <label class="radio"><%=Html.RadioButtonFor(m => m.AttachmentRefCheck, 1)%>启用</label>
            <label class="radio"><%=Html.RadioButtonFor(m => m.AttachmentRefCheck, 0)%>关闭</label>
        <span class="help-block">
            选择“启用”将检查下载附件的来路，来自其他网站或站点的下载请求将被禁止。<br />
            注意: 本功能在开启“帖子中显示图片附件”时，会加重服务器负担
        </span>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">
            图像缩略
        </label>
        <div class="controls">
            <label class="radio"><%=Html.RadioButton("thumb",0,Model.Thumb==0)%>关闭</label>
            <label class="radio"><%=Html.RadioButton("thumb", 1, Model.Thumb==1)%>转换图片附件不超过指定大小</label>
            <label class="radio"><%=Html.RadioButton("thumb", 2, Model.Thumb==2)%>生成不超过指定大小的比例缩放缩略图</label>
        <span class="help-block">
            您可以设置自动为用户上传的 JPG/PNG/GIF 图片附件添加缩略图或将图片附件缩到指定的大小。不支持动画 GIF 格式
        </span>
        </div>
    </div>
    <div class="control-group thumb_size" style="display:none;">
        <label class="control-label">
            图像缩略大小
        </label>
        <div class="controls">
            宽&nbsp;<%=Html.TextBox("thumb_width",Model.ThumbWidth, new { @class = "text input-mini", size="4"})%>&nbsp;像素
            x
            高&nbsp;<%=Html.TextBox("thumb_height",Model.ThumbHeight, new { @class = "text input-mini", size="4"})%>&nbsp;像素
        <span class="help-block">
            设置缩略图的大小，小于此尺寸的图片附件将不生成缩略图
        </span>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">
            帖中显示图片附件
        </label>
        <div class="controls">
            <label class="radio"><%=Html.RadioButtonFor(m => m.AttachmentImagePost,1)%>是</label>
            <label class="radio"><%=Html.RadioButtonFor(m => m.AttachmentImagePost,0)%>否</label>
        <span class="help-block">
        此功能用于是否在帖子中直接将图片或动画附件显示出来, 而不需要点击附件链接。选择否，则帖子中不显示附件图片。
        </span>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">
            图片延时加载
        </label>
        <div class="controls">
        <label class="radio"><%=Html.RadioButton("lazy_load",1,Model.LazyLoad)%>开启</label>
        <label class="radio"><%=Html.RadioButton("lazy_load", 0,!Model.LazyLoad)%>关闭</label>
        <span class="help-block">帖子中解析图像附件显示时是否使用延时加载方式
        </span>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">
           附件JPG图像质量
        </label>
        <div class="controls">
            <%=Html.TextBoxFor(m => m.AttachmentImageQuality, new { @class = "input-mini text", size = "5" })%>
            <span class="help-block">此功能只适用于JPG格式图片。取值范围 1-100，1质量最低，100质量最高。</span>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">
            图像附件水印
        </label>
        <div class="controls">
            <label class="radio"><%=Html.RadioButtonFor(m => m.WaterMarkType, 0)%>关闭</label>
            <label class="radio"><%=Html.RadioButtonFor(m => m.WaterMarkType, 1)%>文字</label>
            <label class="radio"><%=Html.RadioButtonFor(m => m.WaterMarkType, 2)%>图像</label>
        <span class="help-block">
            选择图片水印类型方式
        </span>
        </div>
    </div>
    <div class="control-group water water_image water_text">
        <label class="control-label">
            水印条件
        </label>
        <div class="controls">
            宽&nbsp;<%=Html.TextBox("water_mark_limit_width",Model.WaterMarkLimitWidth, new { @class = "input-mini text", size = "5" })%>&nbsp;像素
            x
            高&nbsp;<%=Html.TextBox("water_mark_limit_height",Model.WaterMarkLimitHeight, new { @class = "input-mini text", size = "5" })%>&nbsp;像素
        <span class="help-block">
            水印添加的条件，对超过设定值的图片附件加水印
        </span>
        </div>
    </div>
    <div class="control-group water water_text">
        <label class="control-label">
            水印文字
        </label>
        <div class="controls">
            <%=Html.TextBoxFor(m => m.WaterMarkText, new { @class = "text", size="50"})%>
        <span class="help-block">
            注：如果水印方式为“文字”此设置才会生效。
        </span>
        </div>
    </div>
    <div class="control-group water water_image">
        <label class="control-label">
            水印图像
        </label>
        <div class="controls">
            <%=Html.TextBoxFor(m => m.WaterMarkImage, new { @class = "text", size = "50" })%>
        <span class="help-block">
            请写入文件所在位置相对路径<br />
            如果水印方式为“图像”此设置才会生效。
        </span>
        </div>
    </div>
    <div class="control-group water water_text water_image">
        <label class="control-label">
            水印图像透明度
        </label>
        <div class="controls">
            <%=Html.TextBoxFor(m => m.WaterMarkTransparency, new { @class = "input-mini text", size = "5" })%>
            <span class="help-block">设置水印图片与原始图片的透明度，范围为 1～10 的整数，数值越大水印图片透明度越低。<br />
	        注：PNG 类型水印本身具有真彩透明效果，此设置对 PNG 类型的水印图不生效。
        </span>
        </div>
    </div>
    <div class="control-group water water_text water_image">
        <label class="control-label">
            水印位置
        </label>
        <div class="controls cl">
            <div class="fl">
            <table class="table table-bordered">
                <tr>
                    <td><label class="radio"><%=Html.RadioButtonFor(m => m.WaterMarkStatus, 1)%>左上</label></td>
                    <td><label class="radio"><%=Html.RadioButtonFor(m => m.WaterMarkStatus, 2)%>上方</label></td>
                    <td><label class="radio"><%=Html.RadioButtonFor(m => m.WaterMarkStatus, 3)%>右上</label></td>
                </tr>
                <tr>
                    <td><label class="radio"><%=Html.RadioButtonFor(m => m.WaterMarkStatus, 4)%>左侧</label></td>
                    <td><label class="radio"><%=Html.RadioButtonFor(m => m.WaterMarkStatus, 5)%>中间</label></td>
                    <td><label class="radio"><%=Html.RadioButtonFor(m => m.WaterMarkStatus, 6)%>右侧</label></td>
                </tr>
                <tr>
                    <td><label class="radio"><%=Html.RadioButtonFor(m => m.WaterMarkStatus, 7)%>左下</label></td>
                    <td><label class="radio"><%=Html.RadioButtonFor(m => m.WaterMarkStatus, 8)%>下方</label></td>
                    <td><label class="radio"><%=Html.RadioButtonFor(m => m.WaterMarkStatus, 9)%>右下</label></td>
                </tr>
            </table>
            </div>
        </div>
    </div>
    <div class="control-group">
    <div class="controls">
        <button type="submit" name="ok" value="save" id="Button_Login" class="btn btn-primary" data-loading-text="保存中..." disabled="disabled" data-cw="保存">加载中...</button>
    </div>
    </div>
    </form>
</div>


</asp:Content>
