﻿<%@ Page Title="" Language="C#" MasterPageFile="../Shared/AdminInside.Master" Inherits="System.Web.Mvc.ViewPage<Jokul.Forum.MvcApp.Admin.Models.AdminLog_ManageList_Model>" %>
<asp:Content ID="Content1" ContentPlaceHolderID="TitleContent" runat="server">
    管理日志
</asp:Content>
<asp:Content ID="Content4" ContentPlaceHolderID="FeaturedContent" runat="server">
    <%Html.SetString("menu.a", "other"); %>
    <%Html.SetString("menu.b", "log.manage"); %>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="FootContent" runat="server">
    <script type="text/javascript">
        function page(p) {
        }
        $(function () {
            $('.sync-pagination').empty();
            $('.sync-pagination').twbsPagination({
                totalPages: <%=Model.Pages%>,
                visiblePages: 7,
                startPage:<%=Model.Page%>,
                first:'首页',
                prev:'上一页',
                next:'下一页',
                last:'尾页',
                onPageClick: function (event, page) {
                    if(page==<%=Model.Page%>)
                        return;
                    $.jokul.wait("请稍候...",false);
                    setTimeout(function(){
                        $("#form_page input[name='page']").val(page);
                        $("#form_page").submit();
                    },1000); 
                }
            });
        });
    </script>
</asp:Content>
<asp:Content ID="Content3" ContentPlaceHolderID="MainContent" runat="server">
    
        <form id="form_page" method="get" action="<%=Html.Encode(Request.Url.AbsoluteUri) %>">
            <%=Html.Hidden("act", "search")%>
            <%=Html.Hidden("page",Model.Page) %>
            <%=Html.Hidden("userId",Model.UserId) %>
            <%=Html.Hidden("username",Model.Username) %>
        </form>

            <div class="panel panel-form area">
            <form method="get" action="<%=Html.Encode(Request.Url.AbsoluteUri) %>" class="form-horizontal form-jokul-horizontal">
                <div class="control-group">
                    <label class="control-label">
                        <%=Html.LabelFor(m => m.UserId)%>
                    </label>
                    <div class="controls">
                        <%=Html.TextBoxFor(m => m.UserId, new { @class = "text", size = "50" })%>
                    </div>
                </div>
                <div class="control-group">
                    <label class="control-label">
                        <%=Html.LabelFor(m => m.Username)%>
                    </label>
                    <div class="controls">
                        <%=Html.TextBoxFor(m => m.Username, new { @class = "text", size = "50" })%>
                        <label class="checkbox inline">
                        <%=Html.CheckBoxFor(m => m.UsernameCheck)%>模糊
                        </label>
                    </div>
                </div>
                <div class="control-group">
                <div class="controls">
                    <button type="submit" name="SearchUser" value="search" id="Button_Login" class="btn btn-primary" >查询</button>
                </div>
                </div>
                </form>
                </div>
                    <div class="area">
    <table class="table table-bordered">
        <thead>
            <tr>
                <th style="width:140px;" class="center">
                    时间
                </th>
                <th style="width:120px;" class="center">
                    帐号
                </th>
                <th style="width:80px;" class="center">
                    动作事件
                </th>
                <th style="width:200px;" class="center">
                    原因
                </th>
                <th style="width:120px;" class="center">
                    版块
                </th>
                <th class="center">
                    主题/回复
                </th>
            </tr>
        </thead>
        <tbody>
            <%if (Model.List.Count > 0)
              { %>
        <%foreach (var user in Model.List)
          { %>
            <tr>
                <td class="center">
                    <span title="<%=Html.ForumTime(user.DateTime).ToString("yyyy-MM-dd HH:mm:ss") %>"><%=Html.FriendlyTime(user.DateTime,"yyyy-MM-dd HH:mm") %></span>
                </td>
                <td class="center"><%=user.Username %>
                </td>
                <td class="center"><%=ManageLogManager.GetActionName( user.Action) %>
                </td>
                <td>
                    <%=user.Description %>
                </td>
                <td class="center">
                    <%if(string.IsNullOrEmpty(user.BoardName)){ %>
                        &nbsp;
                    <%}else{ %>
                        <a href="<%=Url.SiteAction("Show", "Board", new { area = "ForumHome",bid=user.BoardId})%>" target="_blank"><%=user.BoardName %></a>
                    <%} %>
                </td>
                <td>
                    <%if(string.IsNullOrEmpty(user.TopicTitle)){ %>
                        &nbsp;
                    <%}else{ %>
                        <%if(user.PostId>0){ %>
                            <a href="<%=Url.Action("Jump", "Topic", new { area = "ForumHome",tid=user.TopicId,pid=user.PostId})%>"><%=user.TopicTitle %></a>
                        <%}else{ %>
                            <a href="<%=Url.Action("Show", "Topic", new { area = "ForumHome",tid=user.TopicId})%>" target="_blank"><%=user.TopicTitle %></a>
                        <%} %>
                    <%} %>
                </td>
            </tr>
        <%} %>
            <%}
              else
              { %>
            <tr>
                <td colspan="6">
                    无管理日志
                </td>
            </tr>
            <%} %>
        </tbody>
    </table>
                    </div>
        <div class="pagination area sync-pagination">pages loading</div>
</asp:Content>
