﻿<%@ Page Title="" Language="C#" MasterPageFile="../Shared/AdminInside.Master" Inherits="System.Web.Mvc.ViewPage<Jokul.Forum.MvcApp.Admin.Models.AdminEmotion_List_Model>" %>
<asp:Content ID="Content1" ContentPlaceHolderID="TitleContent" runat="server">
    <%=Model.Category.Name %> 表情管理
</asp:Content>
<asp:Content ID="Content4" ContentPlaceHolderID="FeaturedContent" runat="server">
    <%Html.SetString("menu.a", "view"); %>
    <%Html.SetString("menu.b", "emotion"); %>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="FootContent" runat="server">
<script type="text/javascript">
    $(document).ready(function () {

        $("#main_form").ajaxForm({
            beforeSubmit: function (formData, jqForm, options) {
                $('button[name=\"ok\"]').button('loading');
                return true;
            },
            success: function (data, statusText) {
                if (data.error) {
                    $.jokul.alert(data.description);
                    $('button[name=\"ok\"]').button('reset');
                    return;
                }
                window.location.href = "<%=Url.Action("EmotionList",new { category_id=Model.Category.Id}) %>";
            },
            error: function () {
                $.jokul.alert("服务器通讯失败");
                $('button[name=\"ok\"]').button('reset');
            },
            url: "<%=Url.Action("Emotion_Manage","Handler") %>",
            type: 'post',
            dataType: 'json'
        });

    });
</script>
</asp:Content>
<asp:Content ID="Content3" ContentPlaceHolderID="MainContent" runat="server">

            <div class="area">
                <a href="<%=Url.Action("CategoryList", "Emotion")%>" class="btn">返回表情分类</a>
            </div>
            <form id="main_form" action="<%=Html.Encode(Request.Url.AbsoluteUri) %>" method="post">
                <input type="hidden" name="category_id" value="<%=Model.Category.Id %>" />

                    <div class="area">
                        <table class="table table-bordered table-hover">
                            <thead>
                                <tr>
                                    <th style="width:30px;">
                                        启用
                                    </th>
                                    <th style="width:30px;">
                                        次序
                                    </th>
                                    <th style="width:60px;">
                                        表情图像
                                    </th>
                                    <th>
                                        简码
                                    </th>
                                    <th>
                                        文件
                                    </th>
                                    <th style="width:60px;">
                                        管理
                                    </th>
                                </tr>
                            </thead>
                            <tbody>
                                <%if (Model.List.Count > 0)
                                    { %>
                            <%foreach (var user in Model.List)
                                { %>
                                <tr>
                                    <td>
                                        <input type="hidden" name="ids" value="<%=user.Id %>" />
                                        <input type="checkbox" name="enabled_<%=user.Id %>" value="1"<%=user.Enabled>0?" checked=\"checked\"":"" %> />
                                    </td>
                                    <td><input type="text" name="order_<%=user.Id %>" value="<%=Html.Encode(user.Order) %>" size="2" />
                                    </td>
                                    <td>
                                        <img src="<%=user.Image.StartsWith("http://",StringComparison.OrdinalIgnoreCase)?user.Image: ResolveUrl("../../../../static/images/emotion/"+Model.Category.Key+"/" + user.Image)%>" />
                                    </td>
                                    <td><input type="text" name="code_<%=user.Id %>" value="<%=Html.Encode(user.Code) %>" size="20" />
                                    </td>
                                    <td><%=user.Image %>
                                    </td>
                                    <td>
                                            <a href="#" data-redirect="<%=Url.Action("DeleteEmotion", new {emotion_id=user.Id })%>" data-act="delete">删除</a></td>
                                </tr>
                            <%} %>
                                <%}
                                    else
                                    { %>
                                <tr>
                                    <td colspan="6">
                                        无数据
                                    </td>
                                </tr>
                                <%} %>
                            </tbody>
                        </table>
                    </div>
                <div class="area">
                    <button name="ok" value="update" class="btn btn-primary" data-loading-text="保存中..." disabled="disabled" data-cw="保存">加载中...</button>
                </div>
            </form>
</asp:Content>
