﻿<%@ Page Title="" Language="C#" MasterPageFile="../Shared/AdminInside.Master" Inherits="System.Web.Mvc.ViewPage<Jokul.Forum.MvcApp.Admin.Models.AdminEmotion_CategoryList_Model>" %>
<asp:Content ID="Content1" ContentPlaceHolderID="TitleContent" runat="server">
    表情管理
</asp:Content>
<asp:Content ID="Content4" ContentPlaceHolderID="FeaturedContent" runat="server">
    <%Html.SetString("menu.a", "view"); %>
    <%Html.SetString("menu.b", "emotion"); %>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="FootContent" runat="server">
<script type="text/javascript">
    $(document).ready(function () {

        $("#main_form").ajaxForm({
            beforeSubmit: function (formData, jqForm, options) {
                $('button[name=\"ok\"]').button('loading');
                return true;
            },
            success: function (data, statusText) {
                if (data.error) {
                    $.jokul.alert(data.description);
                    return;
                }
                $.jokul.alert("保存成功");
                //window.location.reload();
            },
            error: function () {
                $.jokul.alert("服务器通讯失败");
            },
            complete: function () {
                $('button[name=\"ok\"]').button('reset');
            },
            url: "<%=Url.Action("Emotion_Category_Manage","Handler") %>",
            type: 'post',
            dataType: 'json'
        });

    });
</script>
</asp:Content>
<asp:Content ID="Content3" ContentPlaceHolderID="MainContent" runat="server">

            <div class="alert alert-block alert-info area">
                <h4>表情安装说明</h4>
                1.请将包含表情文件的文件夹通过ftp上传至 /static/images/emotion 目录下。<br />
                2.在“未安装表情”列表里安装该分类。<br />
                3.“管理”该该分类下的表情，“添加”需要启用的表情。<br />
                4.在“启用”列表里启用该分类。
            </div>
            <div class="area">
                <a href="<%=Url.Action( "SystemCategoryList", "Emotion")%>" class="btn btn-primary">查找新的表情包</a>
            </div>
            <form id="main_form" action="<%=Html.Encode(Request.Url.AbsoluteUri) %>" method="post">
            <div class="area">
                    <table class="table table-bordered table-hover">
                        <thead>
                            <tr>
                                <th class="span1">
                                    启用
                                </th>
                                <th>
                                    次序
                                </th>
                                <th>
                                    文件夹名
                                </th>
                                <th>
                                    分类名称
                                </th>
                                <th class="span3">
                                    操作
                                </th>
                            </tr>
                        </thead>
                        <tbody>
                            <%if (Model.List.Count > 0){ %>
                                <%foreach (var user in Model.List){ %>
                                    <tr>
                                        <td>
                                            <input type="hidden" name="ids" value="<%=user.Id %>" />
                                            <label class="checkbox">
                                            <input type="checkbox" name="enabled_<%=user.Id %>" value="1"<%=user.Enabled>0?" checked=\"checked\"":"" %> />
                                                </label>
                                        </td>
                                        <td><input name="order_<%=user.Id %>" type="text" value="<%=user.Order %>" class="input-mini" size="2" /></td>
                                        <td><%=user.Key %></td>
                                        <td><input type="text" name="name_<%=user.Id %>" value="<%=Html.Encode(user.Name) %>" size="20" /></td>
                                        <td>
                                            <a href="<%=Url.Action("EmotionList", new {category_id=user.Id })%>">管理</a>
                                            |
                                            <a href="<%=Url.Action("SystemEmotionList", new {category_id=user.Id })%>">安装新表情</a>
                                            |
                                            <a href="#" data-redirect="<%=Url.Action("DeleteCategory", new {category_id=user.Id })%>" data-act="delete">删除</a>
                                        </td>
                                    </tr>
                                <%} %>
                            <%}else{ %>
                                <tr>
                                    <td colspan="6">
                                        无数据
                                    </td>
                                </tr>
                            <%} %>
                        </tbody>
                    </table>
                </div>
            <div class="area">
                <button type="submit" name="ok" value="update" class="btn btn-primary" data-loading-text="保存中..." disabled="disabled" data-cw="保存">加载中...</button>
            </div>
            </form>
</asp:Content>
