﻿
(function ($) {
    $.fn.CheckBoxEx = function () {
        var class_name_arr = new Array("cb3_null", "cb3_allow", "cb3_ban");

        return this.each(function () {
            var c = $(this);

            (function (c) {

                var state = c.get(0).selectedIndex;

                var dv = $("<div />").addClass("cb3")
                .addClass(class_name_arr[state])
                .insertAfter(c);


                c.change(function () {
                    var index = $(c).get(0).selectedIndex;

                    $.each(class_name_arr, function (ii, nn) {
                        dv.removeClass(nn);
                    });
                    dv.addClass(class_name_arr[index]);
                });

                dv.bind("onselectstart", function (event) {
                    event.returnValue = false;
                    return false;
                });

                dv.click(function () {
                    var index = c.get(0).selectedIndex;
                    index = (index + 1) % 3;
                    c.get(0).selectedIndex = index;
                    c.change();
                });
            })(c);

            c.hide();

        });
    }
})(jQuery);

(function ($) {
    $.fn.ExPanel = function () {

        return this.each(function () {
            $(this).mouseover(function (e) {
                var el = e.srcElement ? e.srcElement : e.target;
                if (!el) return;

                var content = "#" +  $(this).attr("data-pop-id");
                $(content).hover(function (over) {
                    $(this).show();
                },
                function (out) {
                    $(this).hide();
                });

                var cX =
                (
                    $(this).position().left
                    +
                    $(content).outerWidth(true)
                    >
                    document.documentElement.scrollLeft
                    +
                    document.documentElement.clientWidth
                )
                ?
                $(this).position().left - $(content).outerWidth(true)
                :
                $(this).position().left
                ;

                //var cY = ($(this).position().top - $(content).outerHeight(true) - document.documentElement.scrollTop < 0) ? $(this).position().top + $(this).outerHeight(true) : $(this).position().top - $(content).outerHeight(true);
                var cY =
                (
                    document.documentElement.scrollTop
                    +
                    $(this).position().top
                    +
                    $(this).outerHeight(true)
                    +
                    $(content).outerHeight(true)
                    >
                    document.documentElement.scrollHeight
                )
                ?
                $(this).position().top - $(content).outerHeight(true)
                :
                $(this).position().top + $(this).outerHeight(true)
                ;


                $(content).css({ left: cX, top: cY });
                $(content).show();

            });

            $(this).mouseout(function () {
                var content = "#" + $(this).attr("data-pop-id");
                $(content).hide();

            });
        });
    };

    $.fn.UserInfoPanel = function () {

        var currentText = null;

        return this.each(function () {
            $(this).hover(
				function (over) {
				    var id = $(this).attr("exid");
				    currentText = $("#" + id);
				    currentText.hover(
                            function (over) {
                                $(this).show();
                            },
                            function (out) {
                                $(this).hide();
                            }
                        );
				    currentText = $("#" + id);
				    currentText.show();
				},
				function (out) {
				    var id = $(this).attr("exid");
				    currentText = $("#" + id);
				    currentText.hide();
				}
			);
        }); // end this.each
    }; // end fn.linkControl
})(jQuery);


//tip提示功能
$(document).ready(function() {
	var tempInfo = "";
	var panel = $("<div></div>").css({ color: "black", overflow: "hidden", position: "absolute", border: "1px solid #EAD9B9", "background-color": "lightyellow", padding: "5px", "white-space": "nowrap" });
	panel.hide();
	$("body").prepend(panel);

	$("a[title]").mouseover(function(e) {
		var el = e.srcElement ? e.srcElement : e.target;
		if (!el) return;


		tempInfo = $(this).attr("title");
		if (tempInfo.length <= 0)
			return;
		$(this).attr("title", "");
		$(panel).empty();
		$(panel).append(tempInfo);

		var cX = ($(this).position().left + $(panel).outerWidth(true) > document.documentElement.scrollLeft + document.documentElement.clientWidth) ? $(this).position().left - $(panel).outerWidth(true) : $(this).position().left;

		var cY = ($(this).position().top - $(panel).outerHeight(true) - document.documentElement.scrollTop < 0) ? $(this).position().top + $(this).outerHeight(true) : $(this).position().top - $(panel).outerHeight(true);


		panel.css({ left: cX,
			top: cY
		});
		$(panel).show();

	});
	$("a[title]").mouseout(function() {
		$(panel).hide();
		if (tempInfo.length > 0) {
			$(this).attr("title", tempInfo);
			tempInfo = "";
		}
	});

});


/*密码强度提示*/
$.fn.passwordStrength = function(options) {
	return this.each(function() {
		var that = this; that.opts = {};
		that.opts = $.extend({}, $.fn.passwordStrength.defaults, options);

		that.div = $(that.opts.targetDiv);
		that.defaultClass = that.div.attr('class');

		that.percents = (that.opts.classes.length) ? 100 / that.opts.classes.length : 100;

		v = $(this)
		.keyup(function() {
			if (typeof el == "undefined")
				this.el = $(this);
			var s = getPasswordStrength(this.value);
			var p = this.percents;
			var t = Math.floor(s / p);

			if (100 <= s)
				t = this.opts.classes.length - 1;

			this.div
				.removeAttr('class')
				.addClass(this.defaultClass)
				.addClass(this.opts.classes[t]);

		});
		/*
		.after('<a href="#">Generate Password</a>')
		.next()
		.click(function() {
		$(this).prev().val(randomPassword()).trigger('keyup');
		return false;
		});
		*/
	});

	function getPasswordStrength(H) {
		var D = (H.length);
		if (D > 5) {
			D = 5
		}
		var F = H.replace(/[0-9]/g, "");
		var G = (H.length - F.length);
		if (G > 3) { G = 3 }
		var A = H.replace(/\W/g, "");
		var C = (H.length - A.length);
		if (C > 3) { C = 3 }
		var B = H.replace(/[A-Z]/g, "");
		var I = (H.length - B.length);
		if (I > 3) { I = 3 }
		var E = ((D * 10) - 20) + (G * 10) + (C * 15) + (I * 10);
		if (E < 0) { E = 0 }
		if (E > 100) { E = 100 }
		return E
	}

	function randomPassword() {
		var chars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789!@#$_+";
		var size = 10;
		var i = 1;
		var ret = ""
		while (i <= size) {
			$max = chars.length - 1;
			$num = Math.floor(Math.random() * $max);
			$temp = chars.substr($num, 1);
			ret += $temp;
			i++;
		}
		return ret;
	}

};
$.fn.passwordStrength.defaults = {
	classes: Array('is10', 'is20', 'is30', 'is40', 'is50', 'is60', 'is70', 'is80', 'is90', 'is100'),
	/*targetDiv: '#passwordStrengthDiv',*/
	cache: {}
}



