﻿<%@ Page Title="" Language="C#" MasterPageFile="../Shared/Inside.Master" Inherits="System.Web.Mvc.ViewPage" %>
<asp:Content ID="Content1" ContentPlaceHolderID="TitleContent" runat="server">
    重新启动
</asp:Content>
<asp:Content ID="Content4" ContentPlaceHolderID="FeaturedContent" runat="server">
    <%Html.SetString("menu.a", "other"); %>
    <%Html.SetString("menu.b", "main.restart"); %>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="FootContent" runat="server">
<script type="text/javascript">
    $(function () {

        $("#main_form").ajaxForm({
            beforeSubmit: function (formData, jqForm, options) {
                $('button[name=\"ok\"]').button('loading');
                return true;
            },
            success: function (data, statusText) {
                if (data.error) {
                    $.jokul.alert(data.description);
                    return;
                }
                $.jokul.alert("重新启动成功");
            },
            error: function () {
                $.jokul.alert("服务器通讯失败");
            },
            complete: function () {
                $('button[name=\"ok\"]').button('reset');
            },
            url: "<%=Url.Action("Tool_Restart","Handler") %>",
            type: 'post',
            dataType: 'json'
        });
    });
</script>
</asp:Content>
<asp:Content ID="Content3" ContentPlaceHolderID="MainContent" runat="server">
    
<form id="main_form" action="<%=Html.Encode(Request.Url.AbsoluteUri) %>" method="post">

            <div class="area area-form">
                <ol>
                    <li>本功能并不是重新启动服务器或者IIS，本功能只重启 Jokul Passport 应用程序.</li>
                    <li>本功能不会导致任何数据丢失，但会清空在线列表.</li>
                    <li>和重新启动服务器的情况一样，在本页面重启后，每个页面的第一次访问速度较慢（2-3秒才能打开），这是因为asp.net页面首次运行需要编译.</li>
                    <li>和重新启动服务器的情况一样，刚重启后因为没有任何缓存，服务器cpu会有轻微上浮，过一小段时间.</li>
                </ol>
                <p>
                    <strong>适用情况：</strong></p>
                <ul>
                    <li>缓存数据不正确，例如发表帖子后帖子数统计并未增加.</li>
                    <li>人为修改了数据库中的值，但由于数据缓存，这些改变没有体现到程序当中.</li>
                    <li>保存了某些设置但并未生效.</li>
                    <li>其他不正常的情况均可以尝试重启.</li>
                </ul>
                <button type="submit" value="restart" name="ok" class="btn btn-primary" data-loading-text="请稍候..." >立即重新启动</button>
            </div>
</form>
</asp:Content>
