﻿<%@ Page Title="" Language="C#" MasterPageFile="../Shared/Inside.Master" Inherits="System.Web.Mvc.ViewPage<Jokul.Passport.MvcApp.Admin.Models.Notes_List_Model>" %>

<asp:Content ID="Content1" ContentPlaceHolderID="TitleContent" runat="server">
	通知管理
</asp:Content>
<asp:Content ID="Content4" ContentPlaceHolderID="FeaturedContent" runat="server">
    <%Html.SetString("menu.a", "run"); %>
    <%Html.SetString("menu.b", "note"); %>
</asp:Content>

<asp:Content ID="Content3" ContentPlaceHolderID="FootContent" runat="server">
    <script type="text/javascript">
        function page(p) {
            $("#form_page input[name='page']").val(p);
            $("#form_page").submit();
        }
    </script>
</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">

        <form id="form_page" method="get" action="#">
            <%=Html.Hidden("act", "search")%>
            <%=Html.Hidden("page",Model.PageIndex) %>
            <%=Html.Hidden("state",Model.State) %>
            <%=Html.Hidden("app_id",Model.AppId) %>
        </form>
        <div id="div_search" class="panel panel-form area">
            <form id="form_search" method="get" action="<%=Html.Encode(Request.Url.AbsoluteUri) %>" class="form-horizontal form-jokul-horizontal">
                <%=Html.Hidden("act", "search")%>
                <div class="control-group">
                    <label class="control-label">
                        状态
                    </label>
                    <div class="controls">
                        <%=Html.DropDownList("state", new SelectList(Model.States, "Value", "Name",Model.State), "未选择")%>
                    </div>
                </div>
                <div class="control-group">
                    <label class="control-label">
                        应用
                    </label>
                    <div class="controls">
                        <%=Html.DropDownList("app_id", new SelectList(Model.Apps, "Id", "Name",Model.AppId), "未选择")%>
                    </div>

                </div>
                <div class="control-group">
                    <div class="controls">
                        <button type="submit" value="Search" class="btn btn-primary">查询</button>
                    </div>
                </div>

            </form>
        </div>

        <div id="div_search_list" class="area">
            <form id="form_search_list" method="post" action="<%=Html.Encode(Request.Url.AbsoluteUri) %>">
                <table class="table table-bordered table-hover">
                    <thead>
                        <tr>
                            <th style="width:140px;" class="center">
                                应用
                            </th>
                            <th style="width:60px;" class="center">
                                状态
                            </th>
                            <th>
                                数据
                            </th>
                            <th width="120" class="center">
                                更新时间
                            </th>
                            <th width="80" class="center">
                                操作
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                        <%if (Model.Users.Count > 0)
                          { %>
                    <%foreach (Note user in Model.Users)
                      { %>
                        <tr>
                            <td class="center"><%=user.App.Name %>
                            </td>
                            <td class="center">
                                <%if (user.State != (int)ENoteState.OK){ %>
                                    <font color="red"><%=EnumHelper.GetEnumDescription<ENoteState>(user.State, "未知")%></font>
                              <%}else{ %>
                                    <font color="green"><%=EnumHelper.GetEnumDescription<ENoteState>(user.State, "未知")%></font>
                              <%} %>
                            </td>
                            <td><%=user.Operation %>:<%=user.Paramers %>
                            </td>
                            <td class="center"><%=Html.PassportTimeFromUtcTime( user.UpdateDatetime) %>
                            </td>
                            <td class="center">
                            <%if (user.State!=0){ %>
                                <%=Html.ActionLink("重试", "Send", new { id = user.Id }, null)%>
                            |
                            <%} %>
                            <a href="#" data-redirect="<%=Url.Action("Remove", new { id = user.Id })%>" data-act="delete" data-confirm-message="您确定要删除吗?">删除</a>
                            </td>
                        </tr>
                    <%} %>
                        <%}
                          else
                          { %>
                        <tr>
                            <td colspan="5">
                                无用户数据
                            </td>
                        </tr>
                        <%} %>
                    </tbody>
                </table>
            </form>
        </div>
        <div class="pagination area">
            <%
            int tabPageSize=3;
            int pageIndex = (int)Model.PageIndex;
            int pageCount = (int)Model.PageCount;
            int tabPageMin=0;
            int tabPageMax=0;
    
            if (pageCount>tabPageSize*2+1)
            {
                if (pageIndex-tabPageSize>0)
                {
                    if (pageIndex+tabPageSize<pageCount)
                    {
                        tabPageMin = pageIndex-tabPageSize;
                        tabPageMax = tabPageMin+tabPageSize*2;
                    }
                    else
                    {
                        tabPageMin = pageCount-tabPageSize*2;
                        tabPageMax = pageCount;
                    }
                }
                else
                {
                    tabPageMin=1;
                    tabPageMax = tabPageSize*2+1;
                }
            }
            else
            {
                tabPageMin=1;
                tabPageMax=pageCount;
            }
            %>
            <ul>
                <li><a href="javascript:void(0);" onclick="page(1)">«</a></li>
            <%for (var i = tabPageMin; i <= tabPageMax; i++){ %>
                <%if (pageIndex == i){ %>
                <li class="active"><a href="#"><%=i %></a></li>
                <%}else{ %>
                <li><a href="javascript:void(0);" onclick="javascript:page(<%=i %>)"><%=i %></a></li>
                <%} %>
            <%} %>
                <li><a href="javascript:void(0);" onclick="javascript:page(<%=pageCount %>)">»</a></li>
            </ul>
        </div>

</asp:Content>
