set(PUGIXML_SOURCE_DIR ${CMAKE_SOURCE_DIR}/external/pugixml)
set(PUGIXML_PREFIX_DIR ${CMAKE_SOURCE_DIR}/build/external/pugixml)
set(PUGIXML_BUILD_DIR ${PUGIXML_PREFIX_DIR}/build)

set(PUGIXML_DEBUG_POSTFIX "_d")
set(PUGIXML_DEBUG_LIB ${CMAKE_STATIC_LIBRARY_PREFIX}pugixml${PUGIXML_DEBUG_POSTFIX}${CMAKE_STATIC_LIBRARY_SUFFIX})
set(PUGIXML_LIB ${CMAKE_STATIC_LIBRARY_PREFIX}pugixml${CMAKE_STATIC_LIBRARY_SUFFIX})

set(PUGIXML_INSTALL_DIR ${PUGIXML_PREFIX_DIR}/install)

ExternalProject_Add(pugixmllib
    PREFIX ${PUGIXML_PREFIX_DIR}
    SOURCE_DIR ${PUGIXML_SOURCE_DIR}
    BINARY_DIR ${PUGIXML_BUILD_DIR}
    TMP_DIR ${PUGIXML_PREFIX_DIR}/tmp
    STAMP_DIR ${PUGIXML_PREFIX_DIR}/stamp
    CMAKE_ARGS
        -DSTATIC_CRT=${MSVC_STATIC_RUNTIME}
        -DUSE_POSTFIX=ON
        -DCMAKE_POSITION_INDEPENDENT_CODE=ON
        -DCMAKE_BUILD_TYPE=${CMAKE_BUILD_TYPE}
        -DCMAKE_INSTALL_PREFIX=${PUGIXML_INSTALL_DIR}
)

file(MAKE_DIRECTORY ${PUGIXML_INSTALL_DIR}/include)

include(GNUInstallDirs)

add_library(pugixml STATIC IMPORTED)
set_target_properties(pugixml PROPERTIES IMPORTED_LOCATION_DEBUG ${PUGIXML_INSTALL_DIR}/${CMAKE_INSTALL_LIBDIR}/${PUGIXML_DEBUG_LIB})
set_target_properties(pugixml PROPERTIES IMPORTED_LOCATION_RELEASE ${PUGIXML_INSTALL_DIR}/${CMAKE_INSTALL_LIBDIR}/${PUGIXML_LIB})
set_target_properties(pugixml PROPERTIES INTERFACE_INCLUDE_DIRECTORIES ${PUGIXML_INSTALL_DIR}/include)

add_dependencies(pugixml pugixmllib)