set(LIBEVENT_SOURCE_DIR ${CMAKE_SOURCE_DIR}/external/libevent)
set(LIBEVENT_PREFIX_DIR ${CMAKE_SOURCE_DIR}/build/external/libevent)
set(LIBEVENT_BUILD_DIR ${LIBEVENT_PREFIX_DIR}/build)

set(LIBEVENT_DEBUG_LIB ${CMAKE_STATIC_LIBRARY_PREFIX}event${CMAKE_DEBUG_POSTFIX}${CMAKE_STATIC_LIBRARY_SUFFIX})
set(LIBEVENT_CORE_DEBUG_LIB ${CMAKE_STATIC_LIBRARY_PREFIX}event_core${CMAKE_DEBUG_POSTFIX}${CMAKE_STATIC_LIBRARY_SUFFIX})
set(LIBEVENT_EXTRA_DEBUG_LIB ${CMAKE_STATIC_LIBRARY_PREFIX}event_extra${CMAKE_DEBUG_POSTFIX}${CMAKE_STATIC_LIBRARY_SUFFIX})
set(LIBEVENT_PTHREADS_DEBUG_LIB ${CMAKE_STATIC_LIBRARY_PREFIX}event_pthreads${CMAKE_DEBUG_POSTFIX}${CMAKE_STATIC_LIBRARY_SUFFIX})

set(LIBEVENT_LIB ${CMAKE_STATIC_LIBRARY_PREFIX}event${CMAKE_STATIC_LIBRARY_SUFFIX})
set(LIBEVENT_CORE_LIB ${CMAKE_STATIC_LIBRARY_PREFIX}event_core${CMAKE_STATIC_LIBRARY_SUFFIX})
set(LIBEVENT_EXTRA_LIB ${CMAKE_STATIC_LIBRARY_PREFIX}event_extra${CMAKE_STATIC_LIBRARY_SUFFIX})
set(LIBEVENT_PTHREADS_LIB ${CMAKE_STATIC_LIBRARY_PREFIX}event_pthreads${CMAKE_STATIC_LIBRARY_SUFFIX})

set(LIBEVENT_INSTALL_DIR ${LIBEVENT_PREFIX_DIR}/install)

ExternalProject_Add(libevent
    PREFIX ${LIBEVENT_PREFIX_DIR}
    SOURCE_DIR ${LIBEVENT_SOURCE_DIR}
    BINARY_DIR ${LIBEVENT_BUILD_DIR}
    TMP_DIR ${LIBEVENT_PREFIX_DIR}/tmp
    STAMP_DIR ${LIBEVENT_PREFIX_DIR}/stamp
    CMAKE_ARGS
        -DEVENT__DISABLE_BENCHMARK=ON
        -DEVENT__DISABLE_OPENSSL=ON
        -DEVENT__DISABLE_SAMPLES=ON
        -DEVENT__DISABLE_TESTS=ON
        -DEVENT__LIBRARY_TYPE=STATIC
        -DEVENT__DISABLE_MBEDTLS=ON
        -DEVENT__MSVC_STATIC_RUNTIME=${MSVC_STATIC_RUNTIME}
        -DCMAKE_DEBUG_POSTFIX=${CMAKE_DEBUG_POSTFIX}
        -DCMAKE_POSITION_INDEPENDENT_CODE=ON
        -DCMAKE_BUILD_TYPE=${CMAKE_BUILD_TYPE}
        -DCMAKE_INSTALL_PREFIX=${LIBEVENT_INSTALL_DIR}
)

file(MAKE_DIRECTORY ${LIBEVENT_INSTALL_DIR}/include)

add_library(event STATIC IMPORTED)
set_target_properties(event PROPERTIES IMPORTED_LOCATION_DEBUG ${LIBEVENT_INSTALL_DIR}/lib/${LIBEVENT_DEBUG_LIB})
set_target_properties(event PROPERTIES IMPORTED_LOCATION_RELEASE ${LIBEVENT_INSTALL_DIR}/lib/${LIBEVENT_LIB})
set_target_properties(event PROPERTIES INTERFACE_INCLUDE_DIRECTORIES ${LIBEVENT_INSTALL_DIR}/include)
if(MSVC)
set_target_properties(event PROPERTIES INTERFACE_LINK_LIBRARIES "ws2_32;iphlpapi")
endif()

add_library(event_core STATIC IMPORTED)
set_target_properties(event_core PROPERTIES IMPORTED_LOCATION_DEBUG ${LIBEVENT_INSTALL_DIR}/lib/${LIBEVENT_CORE_DEBUG_LIB})
set_target_properties(event_core PROPERTIES IMPORTED_LOCATION_RELEASE ${LIBEVENT_INSTALL_DIR}/lib/${LIBEVENT_CORE_LIB})
set_target_properties(event_core PROPERTIES INTERFACE_INCLUDE_DIRECTORIES ${LIBEVENT_INSTALL_DIR}/include)

add_library(event_extra STATIC IMPORTED)
set_target_properties(event_extra PROPERTIES IMPORTED_LOCATION_DEBUG ${LIBEVENT_INSTALL_DIR}/lib/${LIBEVENT_EXTRA_DEBUG_LIB})
set_target_properties(event_extra PROPERTIES IMPORTED_LOCATION_RELEASE ${LIBEVENT_INSTALL_DIR}/lib/${LIBEVENT_EXTRA_LIB})
set_target_properties(event_extra PROPERTIES INTERFACE_INCLUDE_DIRECTORIES ${LIBEVENT_INSTALL_DIR}/include)

add_library(event_pthreads STATIC IMPORTED)
set_target_properties(event_pthreads PROPERTIES IMPORTED_LOCATION_DEBUG ${LIBEVENT_INSTALL_DIR}/lib/${LIBEVENT_PTHREADS_DEBUG_LIB})
set_target_properties(event_pthreads PROPERTIES IMPORTED_LOCATION_RELEASE ${LIBEVENT_INSTALL_DIR}/lib/${LIBEVENT_PTHREADS_LIB})
set_target_properties(event_pthreads PROPERTIES INTERFACE_INCLUDE_DIRECTORIES ${LIBEVENT_INSTALL_DIR}/include)
if (UNIX)
set_target_properties(event_pthreads PROPERTIES INTERFACE_LINK_LIBRARIES "pthread")
endif()

add_dependencies(event libevent)
add_dependencies(event_core libevent)
add_dependencies(event_extra libevent)
add_dependencies(event_pthreads libevent)
